/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.Complex;
import org.javia.arity.EvalContext;
import org.javia.arity.Function;

public abstract class ContextFunction
extends Function {
    private static EvalContext context = new EvalContext();
    private static final double[] NO_ARGS = new double[0];
    private static final Complex[] NO_ARGS_COMPLEX = new Complex[0];

    public abstract double eval(double[] var1, EvalContext var2);

    public abstract Complex eval(Complex[] var1, EvalContext var2);

    Complex[] toComplex(double[] dArray, EvalContext evalContext) {
        Complex[] complexArray;
        switch (dArray.length) {
            case 0: {
                complexArray = NO_ARGS_COMPLEX;
                break;
            }
            case 1: {
                complexArray = evalContext.args1c;
                complexArray[0].set(dArray[0], 0.0);
                break;
            }
            case 2: {
                complexArray = evalContext.args2c;
                complexArray[0].set(dArray[0], 0.0);
                complexArray[1].set(dArray[1], 0.0);
                break;
            }
            default: {
                complexArray = new Complex[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    complexArray[i] = new Complex(dArray[i], 0.0);
                }
            }
        }
        return complexArray;
    }

    public double eval() {
        return this.eval(NO_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double eval(double d) {
        EvalContext evalContext = context;
        synchronized (evalContext) {
            return this.eval(d, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double eval(double d, double d2) {
        EvalContext evalContext = context;
        synchronized (evalContext) {
            return this.eval(d, d2, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double eval(double[] dArray) {
        EvalContext evalContext = context;
        synchronized (evalContext) {
            return this.eval(dArray, context);
        }
    }

    public double eval(double d, EvalContext evalContext) {
        double[] dArray = evalContext.args1;
        dArray[0] = d;
        return this.eval(dArray, evalContext);
    }

    public double eval(double d, double d2, EvalContext evalContext) {
        double[] dArray = evalContext.args2;
        dArray[0] = d;
        dArray[1] = d2;
        return this.eval(dArray, evalContext);
    }

    public Complex evalComplex() {
        return this.eval(NO_ARGS_COMPLEX);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Complex eval(Complex complex) {
        EvalContext evalContext = context;
        synchronized (evalContext) {
            return this.eval(complex, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Complex eval(Complex complex, Complex complex2) {
        EvalContext evalContext = context;
        synchronized (evalContext) {
            return this.eval(complex, complex2, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Complex eval(Complex[] complexArray) {
        EvalContext evalContext = context;
        synchronized (evalContext) {
            return this.eval(complexArray, context);
        }
    }

    public Complex eval(Complex complex, EvalContext evalContext) {
        Complex[] complexArray = evalContext.args1c;
        complexArray[0] = complex;
        return this.eval(complexArray, evalContext);
    }

    public Complex eval(Complex complex, Complex complex2, EvalContext evalContext) {
        Complex[] complexArray = evalContext.args2c;
        complexArray[0] = complex;
        complexArray[1] = complex2;
        return this.eval(complexArray, evalContext);
    }
}

