/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.MoreMath;

public class Complex {
    public double re;
    public double im;

    public Complex() {
    }

    public Complex(double d, double d2) {
        this.set(d, d2);
    }

    public Complex(Complex complex) {
        this.set(complex);
    }

    public Complex set(double d, double d2) {
        this.re = d;
        this.im = d2;
        return this;
    }

    public Complex set(Complex complex) {
        this.re = complex.re;
        this.im = complex.im;
        return this;
    }

    public String toString() {
        return this.im == 0.0 ? "" + this.re : "(" + this.re + ", " + this.im + ')';
    }

    public double asReal() {
        return this.im == 0.0 ? this.re : Double.NaN;
    }

    public final Complex conjugate() {
        return this.set(this.re, -this.im);
    }

    public final Complex negate() {
        return this.set(-this.re, -this.im);
    }

    public final boolean isInfinite() {
        return Double.isInfinite(this.re) || Double.isInfinite(this.im) && !this.isNaN();
    }

    public final boolean isFinite() {
        return !this.isInfinite() && !this.isNaN();
    }

    public final boolean isNaN() {
        return Double.isNaN(this.re) || Double.isNaN(this.im);
    }

    public final boolean equals(Complex complex) {
        return (this.re == complex.re || this.re != this.re && complex.re != complex.re) && (this.im == complex.im || this.im != this.im && complex.im != complex.im);
    }

    public final double arg() {
        return Math.atan2(this.im, this.re);
    }

    public final double abs() {
        double d = Math.abs(this.re);
        double d2 = Math.abs(this.im);
        if (d == 0.0 || d2 == 0.0) {
            return d + d2;
        }
        boolean bl = d > d2;
        double d3 = bl ? d2 / d : d / d2;
        return (bl ? d : d2) * Math.sqrt(1.0 + d3 * d3);
    }

    public final double abs2() {
        return this.re * this.re + this.im * this.im;
    }

    public final Complex add(Complex complex) {
        double d = Math.ulp(this.re);
        this.re += complex.re;
        this.im += complex.im;
        if (Math.abs(this.re) < d * 1024.0) {
            this.re = 0.0;
        }
        return this;
    }

    public final Complex sub(Complex complex) {
        double d = Math.ulp(this.re);
        this.re -= complex.re;
        this.im -= complex.im;
        if (Math.abs(this.re) < d * 1024.0) {
            this.re = 0.0;
        }
        return this;
    }

    Complex mul(double d) {
        this.re *= d;
        this.im *= d;
        return this;
    }

    public final Complex mul(Complex complex) {
        double d = this.re;
        double d2 = this.im;
        double d3 = complex.re;
        double d4 = complex.im;
        if (d2 == 0.0 && d4 == 0.0) {
            return this.set(d * d3, 0.0);
        }
        double d5 = d * d3 - d2 * d4;
        double d6 = d * d4 + d2 * d3;
        if (!this.set(d5, d6).isNaN()) {
            return this;
        }
        if (this.set(d, d2).isInfinite()) {
            this.normalizeInfinity();
            d = this.re;
            d2 = this.im;
        }
        if (complex.isInfinite()) {
            this.set(d3, d4).normalizeInfinity();
            d3 = this.re;
            d4 = this.im;
        }
        if (d2 == 0.0) {
            if (d4 == 0.0) {
                return this.set(d * d3, 0.0);
            }
            if (d3 == 0.0) {
                return this.set(0.0, d * d4);
            }
            return this.set(d * d3, d * d4);
        }
        if (d == 0.0) {
            if (d3 == 0.0) {
                return this.set(-d2 * d4, 0.0);
            }
            if (d4 == 0.0) {
                return this.set(0.0, d2 * d3);
            }
            return this.set(-d2 * d4, d2 * d3);
        }
        if (d4 == 0.0) {
            return this.set(d * d3, d2 * d3);
        }
        if (d3 == 0.0) {
            return this.set(-d2 * d4, d * d4);
        }
        return this.set(d5, d6);
    }

    public final Complex div(Complex complex) {
        double d = complex.re;
        double d2 = complex.im;
        if (this.im == 0.0 && d2 == 0.0) {
            return this.set(this.re / d, 0.0);
        }
        if (complex.isInfinite() && this.isFinite()) {
            return this.set(0.0, 0.0);
        }
        if (d2 == 0.0) {
            if (this.re == 0.0) {
                return this.set(0.0, this.im / d);
            }
            return this.set(this.re / d, this.im / d);
        }
        if (d == 0.0) {
            return this.set(this.im / d2, -this.re / d2);
        }
        if (Math.abs(d) > Math.abs(d2)) {
            double d3 = d2 / d;
            double d4 = d + d2 * d3;
            return this.set((this.re + this.im * d3) / d4, (this.im - this.re * d3) / d4);
        }
        double d5 = d / d2;
        double d6 = d * d5 + d2;
        return this.set((this.re * d5 + this.im) / d6, (this.im * d5 - this.re) / d6);
    }

    public final Complex sqrt() {
        if (this.im == 0.0) {
            if (!(this.re < 0.0)) {
                this.set(Math.sqrt(this.re), 0.0);
            } else {
                this.set(0.0, Math.sqrt(-this.re));
            }
        } else {
            double d = Math.sqrt((Math.abs(this.re) + this.abs()) / 2.0);
            if (this.re >= 0.0) {
                this.set(d, this.im / (d + d));
            } else {
                this.set(Math.abs(this.im) / (d + d), this.im >= 0.0 ? d : -d);
            }
        }
        return this;
    }

    public final Complex mod(Complex complex) {
        double d = this.re;
        double d2 = this.im;
        if (d2 == 0.0 && complex.im == 0.0) {
            return this.set(d % complex.re, 0.0);
        }
        return this.div(complex).set(Math.rint(this.re), Math.rint(this.im)).mul(complex).set(d - this.re, d2 - this.im);
    }

    public final Complex gcd(Complex complex) {
        if (this.im == 0.0 && complex.im == 0.0) {
            return this.set(MoreMath.gcd(this.re, complex.re), 0.0);
        }
        Complex complex2 = new Complex(complex);
        double d = this.abs2();
        double d2 = complex2.abs2();
        while (d < d2 * 1.0E30) {
            double d3 = complex2.re;
            double d4 = complex2.im;
            complex2.set(this.mod(complex2));
            this.set(d3, d4);
            d = d2;
            d2 = complex2.abs2();
        }
        if (Math.abs(this.re) < Math.abs(this.im)) {
            this.set(-this.im, this.re);
        }
        if (this.re < 0.0) {
            this.negate();
        }
        return this;
    }

    public final Complex log() {
        if (this.im == 0.0 && !(this.re < 0.0)) {
            return this.set(Math.log(this.re), 0.0);
        }
        double d = Math.atan2(this.im, this.re);
        return this.set(Math.log(this.abs()), d);
    }

    public final Complex exp() {
        double d = Math.exp(this.re);
        if (this.im == 0.0) {
            return this.set(d, 0.0);
        }
        return this.set(d * MoreMath.cos(this.im), d * MoreMath.sin(this.im));
    }

    public final Complex square() {
        return this.set(this.re * this.re - this.im * this.im, 2.0 * this.re * this.im);
    }

    public final Complex pow(Complex complex) {
        if (complex.im == 0.0) {
            double d;
            if (complex.re == 0.0) {
                return this.set(1.0, 0.0);
            }
            if (this.im == 0.0 && (d = Math.pow(this.re, complex.re)) == d) {
                return this.set(d, 0.0);
            }
            if (complex.re == 2.0) {
                return this.square();
            }
            if (complex.re == 0.5) {
                return this.sqrt();
            }
            d = Math.pow(this.abs2(), complex.re / 2.0);
            double d2 = this.arg() * complex.re;
            return this.set(d * MoreMath.cos(d2), d * MoreMath.sin(d2));
        }
        if (this.im == 0.0 && this.re > 0.0) {
            double d = Math.pow(this.re, complex.re);
            return this.set(0.0, complex.im * Math.log(this.re)).exp().set(d * this.re, d * this.im);
        }
        return this.log().set(complex.re * this.re - complex.im * this.im, complex.re * this.im + complex.im * this.re).exp();
    }

    public final Complex lgamma() {
        double d = 0.9999999999999971;
        double d2 = 0.0;
        double d3 = this.re * this.re + this.im * this.im;
        double d4 = this.re;
        double[] dArray = MoreMath.GAMMA;
        for (int i = 0; i < dArray.length; ++i) {
            double d5 = dArray[i];
            d += d5 * d4 / (d3 += (d4 += 1.0) + d4 - 1.0);
            d2 -= d5 * this.im / d3;
        }
        double d6 = this.re + 0.5;
        double d7 = this.re + 5.2421875;
        double d8 = this.im;
        this.re = d7;
        this.log();
        double d9 = d6 * this.re - d8 * this.im + 0.9189385332046728 - d7;
        double d10 = d6 * this.im + d8 * this.re - d8;
        this.set(d, d2).log();
        this.re += d9;
        this.im += d10;
        return this;
    }

    public final Complex factorial() {
        return this.im == 0.0 ? this.set(MoreMath.factorial(this.re), 0.0) : this.lgamma().exp();
    }

    public final Complex sin() {
        return this.im == 0.0 ? this.set(MoreMath.sin(this.re), 0.0) : this.set(MoreMath.sin(this.re) * Math.cosh(this.im), MoreMath.cos(this.re) * Math.sinh(this.im));
    }

    public final Complex sinh() {
        return this.im == 0.0 ? this.set(Math.sinh(this.re), 0.0) : this.swap().sin().swap();
    }

    public final Complex cos() {
        return this.im == 0.0 ? this.set(MoreMath.cos(this.re), 0.0) : this.set(MoreMath.cos(this.re) * Math.cosh(this.im), -MoreMath.sin(this.re) * Math.sinh(this.im));
    }

    public final Complex cosh() {
        return this.im == 0.0 ? this.set(Math.cosh(this.re), 0.0) : this.swap().cos().conjugate();
    }

    public final Complex tan() {
        if (this.im == 0.0) {
            return this.set(MoreMath.tan(this.re), 0.0);
        }
        double d = this.re + this.re;
        double d2 = this.im + this.im;
        double d3 = MoreMath.cos(d) + Math.cosh(d2);
        return this.set(MoreMath.sin(d) / d3, Math.sinh(d2) / d3);
    }

    public final Complex tanh() {
        return this.im == 0.0 ? this.set(Math.tanh(this.re), 0.0) : this.swap().tan().swap();
    }

    public final Complex asin() {
        if (this.im == 0.0 && Math.abs(this.re) <= 1.0) {
            return this.set(Math.asin(this.re), 0.0);
        }
        double d = this.re;
        double d2 = this.im;
        return this.sqrt1z().set(this.re - d2, this.im + d).log().set(this.im, -this.re);
    }

    public final Complex acos() {
        if (this.im == 0.0 && Math.abs(this.re) <= 1.0) {
            return this.set(Math.acos(this.re), 0.0);
        }
        double d = this.re;
        double d2 = this.im;
        return this.sqrt1z().set(d - this.im, d2 + this.re).log().set(this.im, -this.re);
    }

    public final Complex atan() {
        if (this.im == 0.0) {
            return this.set(Math.atan(this.re), 0.0);
        }
        double d = this.re * this.re;
        double d2 = this.im * this.im;
        double d3 = d + d2 - this.im - this.im + 1.0;
        return this.set(-(d + d2 - 1.0) / d3, -(this.re + this.re) / d3).log().set(-this.im / 2.0, this.re / 2.0);
    }

    public final Complex asinh() {
        if (this.im == 0.0) {
            return this.set(MoreMath.asinh(this.re), 0.0);
        }
        double d = this.re;
        double d2 = this.im;
        return this.set(this.re * this.re - this.im * this.im + 1.0, 2.0 * this.re * this.im).sqrt().set(this.re + d, this.im + d2).log();
    }

    public final Complex acosh() {
        if (this.im == 0.0 && this.re >= 1.0) {
            return this.set(MoreMath.acosh(this.re), 0.0);
        }
        double d = this.re;
        double d2 = this.im;
        return this.set(this.re * this.re - this.im * this.im - 1.0, 2.0 * this.re * this.im).sqrt().set(this.re + d, this.im + d2).log();
    }

    public final Complex atanh() {
        if (this.im == 0.0) {
            return this.set(MoreMath.atanh(this.re), 0.0);
        }
        double d = this.re * this.re;
        double d2 = this.im * this.im;
        double d3 = d + 1.0 - this.re - this.re;
        return this.set((1.0 - d - d2) / d3, (this.im + this.im) / d3).log().set(this.re / 2.0, this.im / 2.0);
    }

    public final Complex combinations(Complex complex) {
        if (this.im == 0.0 && complex.im == 0.0) {
            return this.set(MoreMath.combinations(this.re, complex.re), 0.0);
        }
        double d = this.re;
        double d2 = this.im;
        this.lgamma();
        double d3 = this.re;
        double d4 = this.im;
        this.set(complex).lgamma();
        double d5 = this.re;
        double d6 = this.im;
        this.set(d - complex.re, d2 - complex.im).lgamma();
        return this.set(d3 - d5 - this.re, d4 - d6 - this.im).exp();
    }

    public final Complex permutations(Complex complex) {
        if (this.im == 0.0 && complex.im == 0.0) {
            return this.set(MoreMath.permutations(this.re, complex.re), 0.0);
        }
        double d = this.re;
        double d2 = this.im;
        this.lgamma();
        double d3 = this.re;
        double d4 = this.im;
        this.set(d - complex.re, d2 - complex.im).lgamma();
        return this.set(d3 - this.re, d4 - this.im).exp();
    }

    private final Complex swap() {
        return this.set(this.im, this.re);
    }

    private final Complex normalizeInfinity() {
        if (!Double.isInfinite(this.im)) {
            this.im = 0.0;
        } else if (!Double.isInfinite(this.re)) {
            this.re = 0.0;
        }
        return this;
    }

    private final Complex sqrt1z() {
        return this.set(1.0 - this.re * this.re + this.im * this.im, -2.0 * this.re * this.im).sqrt();
    }
}

