/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import java.util.Random;
import org.javia.arity.Complex;
import org.javia.arity.ContextFunction;
import org.javia.arity.EvalContext;
import org.javia.arity.Function;
import org.javia.arity.IsComplexException;
import org.javia.arity.MoreMath;
import org.javia.arity.VM;

public class CompiledFunction
extends ContextFunction {
    private static final IsComplexException IS_COMPLEX = new IsComplexException();
    private static final Random random = new Random();
    private static final double[] EMPTY_DOUBLE = new double[0];
    private static final Function[] EMPTY_FUN = new Function[0];
    private final double[] constsRe;
    private final double[] constsIm;
    private final Function[] funcs;
    private final byte[] code;
    private final int arity;

    CompiledFunction(int n, byte[] byArray, double[] dArray, double[] dArray2, Function[] functionArray) {
        this.arity = n;
        this.code = byArray;
        this.constsRe = dArray;
        this.constsIm = dArray2;
        this.funcs = functionArray;
    }

    static Function makeOpFunction(int n) {
        if (VM.arity[n] != 1) {
            throw new Error("makeOpFunction expects arity 1, found " + VM.arity[n]);
        }
        CompiledFunction compiledFunction = new CompiledFunction(VM.arity[n], new byte[]{38, (byte)n}, EMPTY_DOUBLE, EMPTY_DOUBLE, EMPTY_FUN);
        if (n == 29) {
            compiledFunction.setDerivative(new Function(){

                public int arity() {
                    return 1;
                }

                public double eval(double d) {
                    return d > 0.0 ? 1.0 : (d < 0.0 ? -1.0 : 0.0);
                }
            });
        }
        return compiledFunction;
    }

    public int arity() {
        return this.arity;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        if (this.arity != 0) {
            stringBuffer.append("arity ").append(this.arity).append("; ");
        }
        for (int i = 0; i < this.code.length; ++i) {
            byte by = this.code[i];
            stringBuffer.append(VM.opcodeName[by]);
            if (by == 1) {
                stringBuffer.append(' ');
                if (this.constsIm == null) {
                    stringBuffer.append(this.constsRe[n]);
                } else {
                    stringBuffer.append('(').append(this.constsRe[n]).append(", ").append(this.constsIm[n]).append(')');
                }
                ++n;
            } else if (by == 2) {
                ++n2;
            }
            stringBuffer.append("; ");
        }
        if (n != this.constsRe.length) {
            stringBuffer.append("\nuses only ").append(n).append(" consts out of ").append(this.constsRe.length);
        }
        if (n2 != this.funcs.length) {
            stringBuffer.append("\nuses only ").append(n2).append(" funcs out of ").append(this.funcs.length);
        }
        return stringBuffer.toString();
    }

    public double eval(double[] dArray, EvalContext evalContext) {
        if (this.constsIm != null) {
            return this.evalComplexToReal(dArray, evalContext);
        }
        this.checkArity(dArray.length);
        System.arraycopy(dArray, 0, evalContext.stackRe, evalContext.stackBase, dArray.length);
        try {
            this.execReal(evalContext, evalContext.stackBase + dArray.length - 1);
            return evalContext.stackRe[evalContext.stackBase];
        }
        catch (IsComplexException isComplexException) {
            return this.evalComplexToReal(dArray, evalContext);
        }
    }

    private double evalComplexToReal(double[] dArray, EvalContext evalContext) {
        Complex[] complexArray = this.toComplex(dArray, evalContext);
        Complex complex = this.eval(complexArray, evalContext);
        return complex.asReal();
    }

    public Complex eval(Complex[] complexArray, EvalContext evalContext) {
        this.checkArity(complexArray.length);
        Complex[] complexArray2 = evalContext.stackComplex;
        int n = evalContext.stackBase;
        for (int i = 0; i < complexArray.length; ++i) {
            complexArray2[i + n].set(complexArray[i]);
        }
        this.execComplex(evalContext, n + complexArray.length - 1);
        return complexArray2[n];
    }

    private int execReal(EvalContext evalContext, int n) throws IsComplexException {
        int n2 = n + 1;
        if ((n = this.execWithoutCheck(evalContext, n)) != n2) {
            throw new Error("Stack pointer after exec: expected " + n2 + ", got " + n);
        }
        evalContext.stackRe[n - this.arity] = evalContext.stackRe[n];
        return n - this.arity;
    }

    private int execComplex(EvalContext evalContext, int n) {
        int n2 = n + 1;
        if ((n = this.execWithoutCheckComplex(evalContext, n, -2)) != n2) {
            throw new Error("Stack pointer after exec: expected " + n2 + ", got " + n);
        }
        evalContext.stackComplex[n - this.arity].set(evalContext.stackComplex[n]);
        return n - this.arity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int execWithoutCheck(EvalContext var1_1, int var2_2) throws IsComplexException {
        if (this.constsIm != null) {
            throw CompiledFunction.IS_COMPLEX;
        }
        var3_3 = var1_1.stackRe;
        var4_4 = var2_2 - this.arity;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = this.code.length;
        var8_8 = -2;
        block48: for (var11_9 = 0; var11_9 < var7_7; ++var11_9) {
            var12_11 = this.code[var11_9];
            switch (var12_11) {
                case 1: {
                    var3_3[++var2_2] = this.constsRe[var5_5++];
                    continue block48;
                }
                case 2: {
                    var13_12 = this.funcs[var6_6++];
                    if (var13_12 instanceof CompiledFunction) {
                        var2_2 = ((CompiledFunction)var13_12).execReal(var1_1, var2_2);
                        continue block48;
                    }
                    var14_15 = var13_12.arity();
                    var2_2 -= var14_15;
                    var17_17 = var1_1.stackBase;
                    try {
                        var1_1.stackBase = var2_2 + 1;
                        switch (var14_15) {
                            case 0: {
                                var15_16 = var13_12.eval();
                                ** break;
lbl29:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                var15_16 = var13_12.eval(var3_3[var2_2 + 1]);
                                ** break;
lbl33:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                var15_16 = var13_12.eval(var3_3[var2_2 + 1], var3_3[var2_2 + 2]);
                                ** break;
lbl37:
                                // 1 sources

                                break;
                            }
                            default: {
                                var18_18 = new double[var14_15];
                                System.arraycopy(var3_3, var2_2 + 1, var18_18, 0, var14_15);
                                var15_16 = var13_12.eval(var18_18);
                                break;
                            }
                        }
                    }
                    finally {
                        var1_1.stackBase = var17_17;
                    }
                    var3_3[++var2_2] = var15_16;
                    continue block48;
                }
                case 8: {
                    var3_3[++var2_2] = CompiledFunction.random.nextDouble();
                    continue block48;
                }
                case 3: {
                    var13_13 = var3_3[--var2_2];
                    var15_16 = var13_13 + (var8_8 == var11_9 - 1 ? var3_3[var2_2] * var3_3[var2_2 + 1] : var3_3[var2_2 + 1]);
                    if (Math.abs(var15_16) < Math.ulp(var13_13) * 1024.0) {
                        var15_16 = 0.0;
                    }
                    var3_3[var2_2] = var15_16;
                    continue block48;
                }
                case 4: {
                    var13_14 = var3_3[--var2_2];
                    var15_16 = var13_14 - (var8_8 == var11_9 - 1 ? var3_3[var2_2] * var3_3[var2_2 + 1] : var3_3[var2_2 + 1]);
                    if (Math.abs(var15_16) < Math.ulp(var13_14) * 1024.0) {
                        var15_16 = 0.0;
                    }
                    var3_3[var2_2] = var15_16;
                    continue block48;
                }
                case 5: {
                    v0 = --var2_2;
                    var3_3[v0] = var3_3[v0] * var3_3[var2_2 + 1];
                    continue block48;
                }
                case 6: {
                    v1 = --var2_2;
                    var3_3[v1] = var3_3[v1] / var3_3[var2_2 + 1];
                    continue block48;
                }
                case 7: {
                    v2 = --var2_2;
                    var3_3[v2] = var3_3[v2] % var3_3[var2_2 + 1];
                    continue block48;
                }
                case 10: {
                    var3_3[--var2_2] = Math.pow(var3_3[var2_2], var3_3[var2_2 + 1]);
                    continue block48;
                }
                case 9: {
                    var3_3[var2_2] = -var3_3[var2_2];
                    continue block48;
                }
                case 11: {
                    var3_3[var2_2] = MoreMath.factorial(var3_3[var2_2]);
                    continue block48;
                }
                case 12: {
                    var3_3[var2_2] = var3_3[var2_2] * 0.01;
                    var8_8 = var11_9;
                    continue block48;
                }
                case 17: {
                    var3_3[var2_2] = MoreMath.sin(var3_3[var2_2]);
                    continue block48;
                }
                case 18: {
                    var3_3[var2_2] = MoreMath.cos(var3_3[var2_2]);
                    continue block48;
                }
                case 19: {
                    var3_3[var2_2] = MoreMath.tan(var3_3[var2_2]);
                    continue block48;
                }
                case 20: {
                    var9_10 = var3_3[var2_2];
                    if (var9_10 < -1.0 || var9_10 > 1.0) {
                        throw CompiledFunction.IS_COMPLEX;
                    }
                    var3_3[var2_2] = Math.asin(var9_10);
                    continue block48;
                }
                case 21: {
                    var9_10 = var3_3[var2_2];
                    if (var9_10 < -1.0 || var9_10 > 1.0) {
                        throw CompiledFunction.IS_COMPLEX;
                    }
                    var3_3[var2_2] = Math.acos(var9_10);
                    continue block48;
                }
                case 22: {
                    var3_3[var2_2] = Math.atan(var3_3[var2_2]);
                    continue block48;
                }
                case 15: {
                    var3_3[var2_2] = Math.exp(var3_3[var2_2]);
                    continue block48;
                }
                case 16: {
                    var3_3[var2_2] = Math.log(var3_3[var2_2]);
                    continue block48;
                }
                case 13: {
                    var9_10 = var3_3[var2_2];
                    if (v3 < 0.0) {
                        throw CompiledFunction.IS_COMPLEX;
                    }
                    var3_3[var2_2] = Math.sqrt(var9_10);
                    continue block48;
                }
                case 14: {
                    var3_3[var2_2] = Math.cbrt(var3_3[var2_2]);
                    continue block48;
                }
                case 23: {
                    var3_3[var2_2] = Math.sinh(var3_3[var2_2]);
                    continue block48;
                }
                case 24: {
                    var3_3[var2_2] = Math.cosh(var3_3[var2_2]);
                    continue block48;
                }
                case 25: {
                    var3_3[var2_2] = Math.tanh(var3_3[var2_2]);
                    continue block48;
                }
                case 26: {
                    var3_3[var2_2] = MoreMath.asinh(var3_3[var2_2]);
                    continue block48;
                }
                case 27: {
                    var3_3[var2_2] = MoreMath.acosh(var3_3[var2_2]);
                    continue block48;
                }
                case 28: {
                    var3_3[var2_2] = MoreMath.atanh(var3_3[var2_2]);
                    continue block48;
                }
                case 29: {
                    var3_3[var2_2] = Math.abs(var3_3[var2_2]);
                    continue block48;
                }
                case 30: {
                    var3_3[var2_2] = Math.floor(var3_3[var2_2]);
                    continue block48;
                }
                case 31: {
                    var3_3[var2_2] = Math.ceil(var3_3[var2_2]);
                    continue block48;
                }
                case 32: {
                    var3_3[var2_2] = var3_3[var2_2] > 0.0 ? 1.0 : (var3_3[var2_2] < 0.0 ? -1.0 : 0.0);
                    continue block48;
                }
                case 33: {
                    var3_3[--var2_2] = Math.min(var3_3[var2_2], var3_3[var2_2 + 1]);
                    continue block48;
                }
                case 34: {
                    var3_3[--var2_2] = Math.min(var3_3[var2_2], var3_3[var2_2 + 1]);
                    continue block48;
                }
                case 35: {
                    var3_3[--var2_2] = MoreMath.gcd(var3_3[var2_2], var3_3[var2_2 + 1]);
                    continue block48;
                }
                case 36: {
                    var3_3[--var2_2] = MoreMath.combinations(var3_3[var2_2], var3_3[var2_2 + 1]);
                    continue block48;
                }
                case 37: {
                    var3_3[--var2_2] = MoreMath.permutations(var3_3[var2_2], var3_3[var2_2 + 1]);
                    continue block48;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    var3_3[++var2_2] = var3_3[var4_4 + var12_11 - 37];
                    continue block48;
                }
                default: {
                    throw new Error("Unknown opcode " + var12_11);
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int execWithoutCheckComplex(EvalContext var1_1, int var2_2, int var3_3) {
        var4_4 = var1_1.stackComplex;
        var5_5 = var2_2 - this.arity;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = this.code.length;
        block48: for (var9_9 = 0; var9_9 < var8_8; ++var9_9) {
            var10_10 = this.code[var9_9];
            switch (var10_10) {
                case 1: {
                    var4_4[++var2_2].set(this.constsRe[var6_6], this.constsIm == null ? 0.0 : this.constsIm[var6_6]);
                    ++var6_6;
                    continue block48;
                }
                case 2: {
                    var11_11 = this.funcs[var7_7++];
                    if (var11_11 instanceof CompiledFunction) {
                        var2_2 = ((CompiledFunction)var11_11).execComplex(var1_1, var2_2);
                        continue block48;
                    }
                    var12_13 = var11_11.arity();
                    var2_2 -= var12_13;
                    var14_15 = var1_1.stackBase;
                    try {
                        var1_1.stackBase = var2_2 + 1;
                        switch (var12_13) {
                            case 0: {
                                var13_14 = new Complex(var11_11.eval(), 0.0);
                                ** break;
lbl28:
                                // 1 sources

                                break;
                            }
                            case 1: {
                                var13_14 = var11_11.eval(var4_4[var2_2 + 1]);
                                ** break;
lbl32:
                                // 1 sources

                                break;
                            }
                            case 2: {
                                var13_14 = var11_11.eval(var4_4[var2_2 + 1], var4_4[var2_2 + 2]);
                                ** break;
lbl36:
                                // 1 sources

                                break;
                            }
                            default: {
                                var15_16 = new Complex[var12_13];
                                System.arraycopy(var4_4, var2_2 + 1, var15_16, 0, var12_13);
                                var13_14 = var11_11.eval(var15_16);
                                break;
                            }
                        }
                    }
                    finally {
                        var1_1.stackBase = var14_15;
                    }
                    var4_4[++var2_2].set(var13_14);
                    continue block48;
                }
                case 8: {
                    var4_4[++var2_2].set(CompiledFunction.random.nextDouble(), 0.0);
                    continue block48;
                }
                case 3: {
                    var4_4[--var2_2].add(var3_3 == var9_9 - 1 ? var4_4[var2_2 + 1].mul(var4_4[var2_2]) : var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 4: {
                    var4_4[--var2_2].sub(var3_3 == var9_9 - 1 ? var4_4[var2_2 + 1].mul(var4_4[var2_2]) : var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 5: {
                    var4_4[--var2_2].mul(var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 6: {
                    var4_4[--var2_2].div(var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 7: {
                    var4_4[--var2_2].mod(var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 10: {
                    var4_4[--var2_2].pow(var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 9: {
                    var4_4[var2_2].negate();
                    continue block48;
                }
                case 11: {
                    var4_4[var2_2].factorial();
                    continue block48;
                }
                case 12: {
                    var4_4[var2_2].mul(0.01);
                    var3_3 = var9_9;
                    continue block48;
                }
                case 17: {
                    var4_4[var2_2].sin();
                    continue block48;
                }
                case 18: {
                    var4_4[var2_2].cos();
                    continue block48;
                }
                case 19: {
                    var4_4[var2_2].tan();
                    continue block48;
                }
                case 23: {
                    var4_4[var2_2].sinh();
                    continue block48;
                }
                case 24: {
                    var4_4[var2_2].cosh();
                    continue block48;
                }
                case 25: {
                    var4_4[var2_2].tanh();
                    continue block48;
                }
                case 20: {
                    var4_4[var2_2].asin();
                    continue block48;
                }
                case 21: {
                    var4_4[var2_2].acos();
                    continue block48;
                }
                case 22: {
                    var4_4[var2_2].atan();
                    continue block48;
                }
                case 26: {
                    var4_4[var2_2].asinh();
                    continue block48;
                }
                case 27: {
                    var4_4[var2_2].acosh();
                    continue block48;
                }
                case 28: {
                    var4_4[var2_2].atanh();
                    continue block48;
                }
                case 15: {
                    var4_4[var2_2].exp();
                    continue block48;
                }
                case 16: {
                    var4_4[var2_2].log();
                    continue block48;
                }
                case 13: {
                    var4_4[var2_2].sqrt();
                    continue block48;
                }
                case 14: {
                    var4_4[var2_2].pow(new Complex(3.3333333333333335, 0.0));
                    continue block48;
                }
                case 29: {
                    var4_4[var2_2].set(var4_4[var2_2].abs(), 0.0);
                    continue block48;
                }
                case 30: {
                    var4_4[var2_2].set(Math.floor(var4_4[var2_2].re), 0.0);
                    continue block48;
                }
                case 31: {
                    var4_4[var2_2].set(Math.ceil(var4_4[var2_2].re), 0.0);
                    continue block48;
                }
                case 32: {
                    var11_12 = var4_4[var2_2].re;
                    var4_4[var2_2].set(var11_12 > 0.0 ? 1.0 : (var11_12 < 0.0 ? -1.0 : 0.0), 0.0);
                    continue block48;
                }
                case 33: {
                    --var2_2;
                    if (!(var4_4[var2_2 + 1].re < var4_4[var2_2].re)) continue block48;
                    var4_4[var2_2].set(var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 34: {
                    --var2_2;
                    if (!(var4_4[var2_2].re < var4_4[var2_2 + 1].re)) continue block48;
                    var4_4[var2_2].set(var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 35: {
                    var4_4[--var2_2].gcd(var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 36: {
                    var4_4[--var2_2].combinations(var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 37: {
                    var4_4[--var2_2].permutations(var4_4[var2_2 + 1]);
                    continue block48;
                }
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    var4_4[++var2_2].set(var4_4[var5_5 + var10_10 - 37]);
                    continue block48;
                }
                default: {
                    throw new Error("Unknown opcode " + var10_10);
                }
            }
        }
        return var2_2;
    }
}

