/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import android.content.Context;
import com.android.calculator2.Calculator;
import com.android.calculator2.History;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

class Persist {
    private static final int LAST_VERSION = 1;
    private static final String FILE_NAME = "calculator.data";
    private Context mContext;
    History history = new History();

    Persist(Context context) {
        this.mContext = context;
        this.load();
    }

    private void load() {
        try {
            BufferedInputStream is = new BufferedInputStream(this.mContext.openFileInput(FILE_NAME), 8192);
            DataInputStream in = new DataInputStream(is);
            int version = in.readInt();
            if (version > 1) {
                throw new IOException("data version " + version + "; expected " + 1);
            }
            this.history = new History(version, in);
            in.close();
        }
        catch (FileNotFoundException e) {
            Calculator.log("" + e);
        }
        catch (IOException e) {
            Calculator.log("" + e);
        }
    }

    void save() {
        try {
            BufferedOutputStream os = new BufferedOutputStream(this.mContext.openFileOutput(FILE_NAME, 0), 8192);
            DataOutputStream out = new DataOutputStream(os);
            out.writeInt(1);
            this.history.write(out);
            out.close();
        }
        catch (IOException e) {
            Calculator.log("" + e);
        }
    }
}

