/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;

class PanelSwitcher
extends FrameLayout {
    private static final int MAJOR_MOVE = 60;
    private static final int ANIM_DURATION = 400;
    private GestureDetector mGestureDetector;
    private int mCurrentView = 0;
    private View[] mChildren = new View[0];
    private int mWidth;
    private TranslateAnimation inLeft;
    private TranslateAnimation outLeft;
    private TranslateAnimation inRight;
    private TranslateAnimation outRight;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private int mPreviousMove;

    public PanelSwitcher(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                int dx = (int)(e2.getX() - e1.getX());
                if (Math.abs(dx) > 60 && Math.abs(velocityX) > Math.abs(velocityY)) {
                    if (velocityX > 0.0f) {
                        PanelSwitcher.this.moveRight();
                    } else {
                        PanelSwitcher.this.moveLeft();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    void setCurrentIndex(int current) {
        this.mCurrentView = current;
        this.updateCurrentView();
    }

    private void updateCurrentView() {
        for (int i = this.mChildren.length - 1; i >= 0; --i) {
            this.mChildren[i].setVisibility(i == this.mCurrentView ? 0 : 8);
        }
    }

    public void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.mWidth = w;
        this.inLeft = new TranslateAnimation((float)this.mWidth, 0.0f, 0.0f, 0.0f);
        this.outLeft = new TranslateAnimation(0.0f, (float)(-this.mWidth), 0.0f, 0.0f);
        this.inRight = new TranslateAnimation((float)(-this.mWidth), 0.0f, 0.0f, 0.0f);
        this.outRight = new TranslateAnimation(0.0f, (float)this.mWidth, 0.0f, 0.0f);
        this.inLeft.setDuration(400L);
        this.outLeft.setDuration(400L);
        this.inRight.setDuration(400L);
        this.outRight.setDuration(400L);
    }

    protected void onFinishInflate() {
        int count = this.getChildCount();
        this.mChildren = new View[count];
        for (int i = 0; i < count; ++i) {
            this.mChildren[i] = this.getChildAt(i);
        }
        this.updateCurrentView();
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mGestureDetector.onTouchEvent(event);
        return true;
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.mGestureDetector.onTouchEvent(event);
    }

    void moveLeft() {
        if (this.mCurrentView < this.mChildren.length - 1 && this.mPreviousMove != 1) {
            this.mChildren[this.mCurrentView + 1].setVisibility(0);
            this.mChildren[this.mCurrentView + 1].startAnimation((Animation)this.inLeft);
            this.mChildren[this.mCurrentView].startAnimation((Animation)this.outLeft);
            this.mChildren[this.mCurrentView].setVisibility(8);
            ++this.mCurrentView;
            this.mPreviousMove = 1;
        }
    }

    void moveRight() {
        if (this.mCurrentView > 0 && this.mPreviousMove != 2) {
            this.mChildren[this.mCurrentView - 1].setVisibility(0);
            this.mChildren[this.mCurrentView - 1].startAnimation((Animation)this.inRight);
            this.mChildren[this.mCurrentView].startAnimation((Animation)this.outRight);
            this.mChildren[this.mCurrentView].setVisibility(8);
            --this.mCurrentView;
            this.mPreviousMove = 2;
        }
    }

    int getCurrentIndex() {
        return this.mCurrentView;
    }
}

