/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import android.content.Context;
import android.view.KeyEvent;
import android.widget.Button;
import android.widget.EditText;
import com.android.calculator2.CalculatorDisplay;
import com.android.calculator2.History;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;
import org.javia.arity.Util;

class Logic {
    private CalculatorDisplay mDisplay;
    private Symbols mSymbols = new Symbols();
    private History mHistory;
    private String mResult = "";
    private boolean mIsError = false;
    private int mLineLength = 0;
    private static final String INFINITY_UNICODE = "\u221e";
    private static final String INFINITY = "Infinity";
    private static final String NAN = "NaN";
    static final char MINUS = '\u2212';
    private final String mErrorString;
    private static final int ROUND_DIGITS = 1;

    Logic(Context context, History history, CalculatorDisplay display, Button equalButton) {
        this.mErrorString = context.getResources().getString(2131034113);
        this.mHistory = history;
        this.mDisplay = display;
        this.mDisplay.setLogic(this);
        this.clearWithHistory(false);
    }

    void setLineLength(int nDigits) {
        this.mLineLength = nDigits;
    }

    boolean eatHorizontalMove(boolean toLeft) {
        EditText editText = this.mDisplay.getEditText();
        int cursorPos = editText.getSelectionStart();
        return toLeft ? cursorPos == 0 : cursorPos >= editText.length();
    }

    private String getText() {
        return this.mDisplay.getText().toString();
    }

    void insert(String delta) {
        this.mDisplay.insert(delta);
    }

    private void setText(CharSequence text) {
        this.mDisplay.setText(text, CalculatorDisplay.Scroll.UP);
    }

    private void clearWithHistory(boolean scroll) {
        this.mDisplay.setText(this.mHistory.getText(), scroll ? CalculatorDisplay.Scroll.UP : CalculatorDisplay.Scroll.NONE);
        this.mResult = "";
        this.mIsError = false;
    }

    private void clear(boolean scroll) {
        this.mDisplay.setText("", scroll ? CalculatorDisplay.Scroll.UP : CalculatorDisplay.Scroll.NONE);
        this.cleared();
    }

    void cleared() {
        this.mResult = "";
        this.mIsError = false;
        this.updateHistory();
    }

    boolean acceptInsert(String delta) {
        String text = this.getText();
        return !this.mIsError && (!this.mResult.equals(text) || Logic.isOperator(delta) || this.mDisplay.getSelectionStart() != text.length());
    }

    void onDelete() {
        if (this.getText().equals(this.mResult) || this.mIsError) {
            this.clear(false);
        } else {
            this.mDisplay.dispatchKeyEvent(new KeyEvent(0, 67));
            this.mResult = "";
        }
    }

    void onClear() {
        this.clear(false);
    }

    void onEnter() {
        String text = this.getText();
        if (text.equals(this.mResult)) {
            this.clearWithHistory(false);
        } else {
            this.mHistory.enter(text);
            try {
                this.mResult = this.evaluate(text);
            }
            catch (SyntaxException e) {
                this.mIsError = true;
                this.mResult = this.mErrorString;
            }
            if (text.equals(this.mResult)) {
                this.clearWithHistory(true);
            } else {
                this.setText(this.mResult);
            }
        }
    }

    void onUp() {
        String text = this.getText();
        if (!text.equals(this.mResult)) {
            this.mHistory.update(text);
        }
        if (this.mHistory.moveToPrevious()) {
            this.mDisplay.setText(this.mHistory.getText(), CalculatorDisplay.Scroll.DOWN);
        }
    }

    void onDown() {
        String text = this.getText();
        if (!text.equals(this.mResult)) {
            this.mHistory.update(text);
        }
        if (this.mHistory.moveToNext()) {
            this.mDisplay.setText(this.mHistory.getText(), CalculatorDisplay.Scroll.UP);
        }
    }

    void updateHistory() {
        this.mHistory.update(this.getText());
    }

    String evaluate(String input) throws SyntaxException {
        if (input.trim().equals("")) {
            return "";
        }
        for (int size = input.length(); size > 0 && Logic.isOperator(input.charAt(size - 1)); --size) {
            input = input.substring(0, size - 1);
        }
        String result = Util.doubleToString(this.mSymbols.eval(input), this.mLineLength, 1);
        if (result.equals(NAN)) {
            this.mIsError = true;
            return this.mErrorString;
        }
        return result.replace('-', '\u2212').replace(INFINITY, INFINITY_UNICODE);
    }

    static boolean isOperator(String text) {
        return text.length() == 1 && Logic.isOperator(text.charAt(0));
    }

    static boolean isOperator(char c) {
        return "+\u2212\u00d7\u00f7/*".indexOf(c) != -1;
    }
}

