/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

class HistoryEntry {
    private static final int VERSION_1 = 1;
    private String mBase;
    private String mEdited;

    HistoryEntry(String str) {
        this.mBase = str;
        this.clearEdited();
    }

    HistoryEntry(int version, DataInput in) throws IOException {
        if (version < 1) {
            throw new IOException("invalid version " + version);
        }
        this.mBase = in.readUTF();
        this.mEdited = in.readUTF();
    }

    void write(DataOutput out) throws IOException {
        out.writeUTF(this.mBase);
        out.writeUTF(this.mEdited);
    }

    public String toString() {
        return this.mBase;
    }

    void clearEdited() {
        this.mEdited = this.mBase;
    }

    String getEdited() {
        return this.mEdited;
    }

    void setEdited(String edited) {
        this.mEdited = edited;
    }

    String getBase() {
        return this.mBase;
    }
}

