/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.android.calculator2.History;
import com.android.calculator2.HistoryEntry;
import com.android.calculator2.Logic;
import java.util.Vector;
import org.javia.arity.SyntaxException;

class HistoryAdapter
extends BaseAdapter {
    private Vector<HistoryEntry> mEntries;
    private LayoutInflater mInflater;
    private Logic mEval;

    HistoryAdapter(Context context, History history, Logic evaluator) {
        this.mEntries = history.mEntries;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mEval = evaluator;
    }

    public int getCount() {
        return this.mEntries.size() - 1;
    }

    public Object getItem(int position) {
        return this.mEntries.elementAt(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public boolean hasStableIds() {
        return true;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        View view = convertView == null ? this.mInflater.inflate(2130903040, parent, false) : convertView;
        TextView expr = (TextView)view.findViewById(0x7F070000);
        TextView result = (TextView)view.findViewById(2131165185);
        HistoryEntry entry = this.mEntries.elementAt(position);
        String base = entry.getBase();
        expr.setText((CharSequence)entry.getBase());
        try {
            String res = this.mEval.evaluate(base);
            result.setText((CharSequence)("= " + res));
        }
        catch (SyntaxException e) {
            result.setText((CharSequence)"");
        }
        return view;
    }
}

