/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import android.widget.BaseAdapter;
import com.android.calculator2.HistoryEntry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

class History {
    private static final int VERSION_1 = 1;
    private static final int MAX_ENTRIES = 100;
    Vector<HistoryEntry> mEntries = new Vector();
    int mPos;
    BaseAdapter mObserver;

    History() {
        this.clear();
    }

    History(int version, DataInput in) throws IOException {
        if (version >= 1) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                this.mEntries.add(new HistoryEntry(version, in));
            }
        } else {
            throw new IOException("invalid version " + version);
        }
        this.mPos = in.readInt();
    }

    void setObserver(BaseAdapter observer) {
        this.mObserver = observer;
    }

    private void notifyChanged() {
        if (this.mObserver != null) {
            this.mObserver.notifyDataSetChanged();
        }
    }

    void clear() {
        this.mEntries.clear();
        this.mEntries.add(new HistoryEntry(""));
        this.mPos = 0;
        this.notifyChanged();
    }

    void write(DataOutput out) throws IOException {
        out.writeInt(this.mEntries.size());
        for (HistoryEntry entry : this.mEntries) {
            entry.write(out);
        }
        out.writeInt(this.mPos);
    }

    void update(String text) {
        this.current().setEdited(text);
    }

    boolean moveToPrevious() {
        if (this.mPos > 0) {
            --this.mPos;
            return true;
        }
        return false;
    }

    boolean moveToNext() {
        if (this.mPos < this.mEntries.size() - 1) {
            ++this.mPos;
            return true;
        }
        return false;
    }

    void enter(String text) {
        this.current().clearEdited();
        if (this.mEntries.size() >= 100) {
            this.mEntries.remove(0);
        }
        if (this.mEntries.size() < 2 || !text.equals(this.mEntries.elementAt(this.mEntries.size() - 2).getBase())) {
            this.mEntries.insertElementAt(new HistoryEntry(text), this.mEntries.size() - 1);
        }
        this.mPos = this.mEntries.size() - 1;
        this.notifyChanged();
    }

    HistoryEntry current() {
        return this.mEntries.elementAt(this.mPos);
    }

    String getText() {
        return this.current().getEdited();
    }

    String getBase() {
        return this.current().getBase();
    }
}

