/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.android.calculator2.Calculator;

class ColorButton
extends Button
implements View.OnClickListener {
    int CLICK_FEEDBACK_COLOR;
    static final int CLICK_FEEDBACK_INTERVAL = 10;
    static final int CLICK_FEEDBACK_DURATION = 350;
    float mTextX;
    float mTextY;
    long mAnimStart;
    View.OnClickListener mListener;
    Paint mFeedbackPaint;

    public ColorButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        Calculator calc = (Calculator)context;
        this.init(calc);
        this.mListener = calc.mListener;
        this.setOnClickListener(this);
    }

    public void onClick(View view) {
        this.mListener.onClick((View)this);
    }

    private void init(Calculator calc) {
        Resources res = this.getResources();
        this.CLICK_FEEDBACK_COLOR = res.getColor(2130968576);
        this.mFeedbackPaint = new Paint();
        this.mFeedbackPaint.setStyle(Paint.Style.STROKE);
        this.mFeedbackPaint.setStrokeWidth(2.0f);
        this.getPaint().setColor(res.getColor(2130968577));
        this.mAnimStart = -1L;
        calc.adjustFontSize((TextView)this);
    }

    public void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.measureText();
    }

    private void measureText() {
        TextPaint paint = this.getPaint();
        this.mTextX = ((float)this.getWidth() - paint.measureText(((Object)this.getText()).toString())) / 2.0f;
        this.mTextY = ((float)this.getHeight() - paint.ascent() - paint.descent()) / 2.0f;
    }

    protected void onTextChanged(CharSequence text, int start, int before, int after) {
        this.measureText();
    }

    private void drawMagicFlame(int duration, Canvas canvas) {
        int alpha = 255 - 255 * duration / 350;
        int color2 = this.CLICK_FEEDBACK_COLOR | alpha << 24;
        this.mFeedbackPaint.setColor(color2);
        canvas.drawRect(1.0f, 1.0f, (float)(this.getWidth() - 1), (float)(this.getHeight() - 1), this.mFeedbackPaint);
    }

    public void onDraw(Canvas canvas) {
        if (this.mAnimStart != -1L) {
            int animDuration = (int)(System.currentTimeMillis() - this.mAnimStart);
            if (animDuration >= 350) {
                this.mAnimStart = -1L;
            } else {
                this.drawMagicFlame(animDuration, canvas);
                this.postInvalidateDelayed(10L);
            }
        } else if (this.isPressed()) {
            this.drawMagicFlame(0, canvas);
        }
        CharSequence text = this.getText();
        canvas.drawText(text, 0, text.length(), this.mTextX, this.mTextY, (Paint)this.getPaint());
    }

    public void animateClickFeedback() {
        this.mAnimStart = System.currentTimeMillis();
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = super.onTouchEvent(event);
        switch (event.getAction()) {
            case 1: {
                this.animateClickFeedback();
                break;
            }
            case 0: 
            case 3: {
                this.invalidate();
            }
        }
        return result;
    }
}

