/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import com.android.calculator2.Logic;

class CalculatorEditable
extends SpannableStringBuilder {
    private static final char[] ORIGINALS = new char[]{'-', '*', '/'};
    private static final char[] REPLACEMENTS = new char[]{'\u2212', '\u00d7', '\u00f7'};
    private boolean isInsideReplace = false;
    private Logic mLogic;

    private CalculatorEditable(CharSequence source, Logic logic) {
        super(source);
        this.mLogic = logic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpannableStringBuilder replace(int start, int end, CharSequence tb, int tbstart, int tbend) {
        if (this.isInsideReplace) {
            return super.replace(start, end, tb, tbstart, tbend);
        }
        this.isInsideReplace = true;
        try {
            String delta = ((Object)tb.subSequence(tbstart, tbend)).toString();
            SpannableStringBuilder spannableStringBuilder = this.internalReplace(start, end, delta);
            return spannableStringBuilder;
        }
        finally {
            this.isInsideReplace = false;
        }
    }

    private SpannableStringBuilder internalReplace(int start, int end, String delta) {
        if (!this.mLogic.acceptInsert(delta)) {
            this.mLogic.cleared();
            start = 0;
            end = this.length();
        }
        for (int i = ORIGINALS.length - 1; i >= 0; --i) {
            delta = delta.replace(ORIGINALS[i], REPLACEMENTS[i]);
        }
        int length = delta.length();
        if (length == 1) {
            char prevChar;
            char text = delta.charAt(0);
            if (text == '.') {
                int p;
                for (p = start - 1; p >= 0 && Character.isDigit(this.charAt(p)); --p) {
                }
                if (p >= 0 && this.charAt(p) == '.') {
                    return super.replace(start, end, (CharSequence)"");
                }
            }
            char c = prevChar = start > 0 ? this.charAt(start - 1) : (char)'\u0000';
            if (text == '\u2212' && prevChar == '\u2212') {
                return super.replace(start, end, (CharSequence)"");
            }
            if (Logic.isOperator(text)) {
                while (Logic.isOperator(prevChar) && (text != '\u2212' || prevChar == '+')) {
                    prevChar = --start > 0 ? this.charAt(start - 1) : (char)'\u0000';
                }
            }
            if (start == 0 && Logic.isOperator(text) && text != '\u2212') {
                return super.replace(start, end, (CharSequence)"");
            }
        }
        return super.replace(start, end, (CharSequence)delta);
    }

    public static class Factory
    extends Editable.Factory {
        private Logic mLogic;

        public Factory(Logic logic) {
            this.mLogic = logic;
        }

        public Editable newEditable(CharSequence source) {
            return new CalculatorEditable(source, this.mLogic);
        }
    }
}

