/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import android.content.Context;
import android.graphics.Rect;
import android.text.Editable;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.method.KeyListener;
import android.text.method.NumberKeyListener;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.ViewSwitcher;
import com.android.calculator2.Calculator;
import com.android.calculator2.CalculatorEditable;
import com.android.calculator2.Logic;

class CalculatorDisplay
extends ViewSwitcher {
    private static final char[] ACCEPTED_CHARS = "0123456789.+-*/\u2212\u00d7\u00f7()!%^".toCharArray();
    private static final int ANIM_DURATION = 500;
    TranslateAnimation inAnimUp;
    TranslateAnimation outAnimUp;
    TranslateAnimation inAnimDown;
    TranslateAnimation outAnimDown;
    private Logic mLogic;
    private boolean mComputedLineLength = false;

    public CalculatorDisplay(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        Calculator calc = (Calculator)this.getContext();
        calc.adjustFontSize((TextView)this.getChildAt(0));
        calc.adjustFontSize((TextView)this.getChildAt(1));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mComputedLineLength) {
            this.mLogic.setLineLength(this.getNumberFittingDigits((TextView)this.getCurrentView()));
            this.mComputedLineLength = true;
        }
    }

    private int getNumberFittingDigits(TextView display) {
        int available = display.getWidth() - display.getTotalPaddingLeft() - display.getTotalPaddingRight();
        TextPaint paint = display.getPaint();
        float digitWidth = paint.measureText("2222222222") / 10.0f;
        return (int)((float)available / digitWidth);
    }

    protected void setLogic(Logic logic) {
        this.mLogic = logic;
        NumberKeyListener calculatorKeyListener = new NumberKeyListener(){

            public int getInputType() {
                return 0;
            }

            protected char[] getAcceptedChars() {
                return ACCEPTED_CHARS;
            }

            public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
                return null;
            }
        };
        CalculatorEditable.Factory factory = new CalculatorEditable.Factory(logic);
        for (int i = 0; i < 2; ++i) {
            EditText text = (EditText)this.getChildAt(i);
            text.setBackgroundDrawable(null);
            text.setEditableFactory((Editable.Factory)factory);
            text.setKeyListener((KeyListener)calculatorKeyListener);
        }
    }

    public void setOnKeyListener(View.OnKeyListener l) {
        this.getChildAt(0).setOnKeyListener(l);
        this.getChildAt(1).setOnKeyListener(l);
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        this.inAnimUp = new TranslateAnimation(0.0f, 0.0f, (float)h, 0.0f);
        this.inAnimUp.setDuration(500L);
        this.outAnimUp = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-h));
        this.outAnimUp.setDuration(500L);
        this.inAnimDown = new TranslateAnimation(0.0f, 0.0f, (float)(-h), 0.0f);
        this.inAnimDown.setDuration(500L);
        this.outAnimDown = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)h);
        this.outAnimDown.setDuration(500L);
    }

    void insert(String delta) {
        EditText editor = (EditText)this.getCurrentView();
        int cursor = editor.getSelectionStart();
        editor.getText().insert(cursor, (CharSequence)delta);
    }

    EditText getEditText() {
        return (EditText)this.getCurrentView();
    }

    Editable getText() {
        EditText text = (EditText)this.getCurrentView();
        return text.getText();
    }

    void setText(CharSequence text, Scroll dir) {
        if (this.getText().length() == 0) {
            dir = Scroll.NONE;
        }
        if (dir == Scroll.UP) {
            this.setInAnimation((Animation)this.inAnimUp);
            this.setOutAnimation((Animation)this.outAnimUp);
        } else if (dir == Scroll.DOWN) {
            this.setInAnimation((Animation)this.inAnimDown);
            this.setOutAnimation((Animation)this.outAnimDown);
        } else {
            this.setInAnimation(null);
            this.setOutAnimation(null);
        }
        EditText editText = (EditText)this.getNextView();
        editText.setText(text);
        editText.setSelection(text.length());
        this.showNext();
    }

    void setSelection(int i) {
        EditText text = (EditText)this.getCurrentView();
        text.setSelection(i);
    }

    int getSelectionStart() {
        EditText text = (EditText)this.getCurrentView();
        return text.getSelectionStart();
    }

    protected void onFocusChanged(boolean gain, int direction, Rect prev) {
        if (!gain) {
            this.requestFocus();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Scroll {
        UP,
        DOWN,
        NONE;

    }
}

