/*
 * Decompiled with CFR 0.152.
 */
package com.android.calculator2;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.android.calculator2.CalculatorDisplay;
import com.android.calculator2.EventListener;
import com.android.calculator2.History;
import com.android.calculator2.HistoryAdapter;
import com.android.calculator2.Logic;
import com.android.calculator2.PanelSwitcher;
import com.android.calculator2.Persist;

public class Calculator
extends Activity {
    EventListener mListener = new EventListener();
    private CalculatorDisplay mDisplay;
    private Persist mPersist;
    private History mHistory;
    private Logic mLogic;
    private PanelSwitcher mPanelSwitcher;
    private static final int CMD_CLEAR_HISTORY = 1;
    private static final int CMD_BASIC_PANEL = 2;
    private static final int CMD_ADVANCED_PANEL = 3;
    private static final int HVGA_WIDTH_PIXELS = 320;
    static final int BASIC_PANEL = 0;
    static final int ADVANCED_PANEL = 1;
    private static final String LOG_TAG = "Calculator";
    private static final boolean DEBUG = false;
    private static final boolean LOG_ENABLED = false;
    private static final String STATE_CURRENT_VIEW = "state-current-view";

    public void onCreate(Bundle state) {
        super.onCreate(state);
        this.setContentView(2130903041);
        this.mPersist = new Persist((Context)this);
        this.mHistory = this.mPersist.history;
        this.mDisplay = (CalculatorDisplay)this.findViewById(2131165186);
        this.mLogic = new Logic((Context)this, this.mHistory, this.mDisplay, (Button)this.findViewById(2131165206));
        HistoryAdapter historyAdapter = new HistoryAdapter((Context)this, this.mHistory, this.mLogic);
        this.mHistory.setObserver(historyAdapter);
        this.mPanelSwitcher = (PanelSwitcher)this.findViewById(2131165188);
        this.mPanelSwitcher.setCurrentIndex(state == null ? 0 : state.getInt(STATE_CURRENT_VIEW, 0));
        this.mListener.setHandler(this.mLogic, this.mPanelSwitcher);
        this.mDisplay.setOnKeyListener(this.mListener);
        View view = this.findViewById(2131165187);
        if (view != null) {
            view.setOnLongClickListener((View.OnLongClickListener)this.mListener);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        MenuItem item = menu.add(0, 1, 0, 2131034147);
        item.setIcon(2130837507);
        item = menu.add(0, 3, 0, 2131034146);
        item.setIcon(2130837504);
        item = menu.add(0, 2, 0, 2131034145);
        item.setIcon(2130837509);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        menu.findItem(2).setVisible(this.mPanelSwitcher != null && this.mPanelSwitcher.getCurrentIndex() == 1);
        menu.findItem(3).setVisible(this.mPanelSwitcher != null && this.mPanelSwitcher.getCurrentIndex() == 0);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 1: {
                this.mHistory.clear();
                break;
            }
            case 2: {
                if (this.mPanelSwitcher == null || this.mPanelSwitcher.getCurrentIndex() != 1) break;
                this.mPanelSwitcher.moveRight();
                break;
            }
            case 3: {
                if (this.mPanelSwitcher == null || this.mPanelSwitcher.getCurrentIndex() != 0) break;
                this.mPanelSwitcher.moveLeft();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onSaveInstanceState(Bundle state) {
        super.onSaveInstanceState(state);
        state.putInt(STATE_CURRENT_VIEW, this.mPanelSwitcher.getCurrentIndex());
    }

    public void onPause() {
        super.onPause();
        this.mLogic.updateHistory();
        this.mPersist.save();
    }

    public boolean onKeyDown(int keyCode, KeyEvent keyEvent) {
        if (keyCode == 4 && this.mPanelSwitcher.getCurrentIndex() == 1) {
            this.mPanelSwitcher.moveRight();
            return true;
        }
        return super.onKeyDown(keyCode, keyEvent);
    }

    static void log(String message) {
    }

    public void adjustFontSize(TextView view) {
        float fontPixelSize = view.getTextSize();
        Display display = this.getWindowManager().getDefaultDisplay();
        int h = Math.min(display.getWidth(), display.getHeight());
        float ratio = (float)h / 320.0f;
        view.setTextSize(0, fontPixelSize * ratio);
    }
}

