/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser.search;

import android.content.Context;
import android.preference.ListPreference;
import android.util.AttributeSet;
import com.android.browser.search.SearchEngine;
import com.android.browser.search.SearchEngineInfo;
import com.android.browser.search.SearchEngines;
import java.util.ArrayList;

class SearchEnginePreference
extends ListPreference {
    private static final String TAG = "SearchEnginePreference";

    public SearchEnginePreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        ArrayList<String> entryValues = new ArrayList<String>();
        ArrayList<CharSequence> entries = new ArrayList<CharSequence>();
        SearchEngine defaultSearchEngine = SearchEngines.getDefaultSearchEngine(context);
        String defaultSearchEngineName = null;
        if (defaultSearchEngine != null) {
            defaultSearchEngineName = defaultSearchEngine.getName();
            entryValues.add(defaultSearchEngineName);
            entries.add(defaultSearchEngine.getLabel());
        }
        for (SearchEngineInfo searchEngineInfo : SearchEngines.getSearchEngineInfos(context)) {
            String name = searchEngineInfo.getName();
            if (name.equals(defaultSearchEngineName)) continue;
            entryValues.add(name);
            entries.add(searchEngineInfo.getLabel());
        }
        this.setEntryValues(entryValues.toArray(new CharSequence[entryValues.size()]));
        this.setEntries(entries.toArray(new CharSequence[entries.size()]));
    }
}

