/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser.search;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.Log;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Locale;

public class SearchEngineInfo {
    private static String TAG = "SearchEngineInfo";
    private static final int FIELD_LABEL = 0;
    private static final int FIELD_KEYWORD = 1;
    private static final int FIELD_FAVICON_URI = 2;
    private static final int FIELD_SEARCH_URI = 3;
    private static final int FIELD_ENCODING = 4;
    private static final int FIELD_SUGGEST_URI = 5;
    private static final int NUM_FIELDS = 6;
    private static final String PARAMETER_LANGUAGE = "{language}";
    private static final String PARAMETER_SEARCH_TERMS = "{searchTerms}";
    private static final String PARAMETER_INPUT_ENCODING = "{inputEncoding}";
    private final String mName;
    private final String[] mSearchEngineData;

    public SearchEngineInfo(Context context, String name) throws IllegalArgumentException {
        this.mName = name;
        Resources res = context.getResources();
        int id_data = res.getIdentifier(name, "array", context.getPackageName());
        this.mSearchEngineData = res.getStringArray(id_data);
        if (this.mSearchEngineData == null) {
            throw new IllegalArgumentException("No data found for " + name);
        }
        if (this.mSearchEngineData.length != 6) {
            throw new IllegalArgumentException(name + " has invalid number of fields - " + this.mSearchEngineData.length);
        }
        if (TextUtils.isEmpty((CharSequence)this.mSearchEngineData[3])) {
            throw new IllegalArgumentException(name + " has an empty search URI");
        }
        Locale locale = context.getResources().getConfiguration().locale;
        StringBuilder language = new StringBuilder(locale.getLanguage());
        if (!TextUtils.isEmpty((CharSequence)locale.getCountry())) {
            language.append('-');
            language.append(locale.getCountry());
        }
        String language_str = language.toString();
        this.mSearchEngineData[3] = this.mSearchEngineData[3].replace(PARAMETER_LANGUAGE, language_str);
        this.mSearchEngineData[5] = this.mSearchEngineData[5].replace(PARAMETER_LANGUAGE, language_str);
        String enc = this.mSearchEngineData[4];
        if (TextUtils.isEmpty((CharSequence)enc)) {
            this.mSearchEngineData[4] = enc = "UTF-8";
        }
        this.mSearchEngineData[3] = this.mSearchEngineData[3].replace(PARAMETER_INPUT_ENCODING, enc);
        this.mSearchEngineData[5] = this.mSearchEngineData[5].replace(PARAMETER_INPUT_ENCODING, enc);
    }

    public String getName() {
        return this.mName;
    }

    public String getLabel() {
        return this.mSearchEngineData[0];
    }

    public String getSearchUriForQuery(String query) {
        return this.getFormattedUri(this.searchUri(), query);
    }

    public String getSuggestUriForQuery(String query) {
        return this.getFormattedUri(this.suggestUri(), query);
    }

    public boolean supportsSuggestions() {
        return !TextUtils.isEmpty((CharSequence)this.suggestUri());
    }

    public String faviconUri() {
        return this.mSearchEngineData[2];
    }

    private String suggestUri() {
        return this.mSearchEngineData[5];
    }

    private String searchUri() {
        return this.mSearchEngineData[3];
    }

    private String getFormattedUri(String templateUri, String query) {
        if (TextUtils.isEmpty((CharSequence)templateUri)) {
            return null;
        }
        String enc = this.mSearchEngineData[4];
        try {
            return templateUri.replace(PARAMETER_SEARCH_TERMS, URLEncoder.encode(query, enc));
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)TAG, (String)("Exception occured when encoding query " + query + " to " + enc));
            return null;
        }
    }

    public String toString() {
        return "SearchEngineInfo{" + Arrays.toString(this.mSearchEngineData) + "}";
    }
}

