/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser.search;

import android.content.Context;
import android.content.Intent;
import android.database.AbstractCursor;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.http.AndroidHttpClient;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.android.browser.search.SearchEngine;
import com.android.browser.search.SearchEngineInfo;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;

public class OpenSearchSearchEngine
implements SearchEngine {
    private static final String TAG = "OpenSearchSearchEngine";
    private static final String USER_AGENT = "Android/1.0";
    private static final int HTTP_TIMEOUT_MS = 1000;
    private static final String HTTP_TIMEOUT = "http.connection-manager.timeout";
    private static final int COLUMN_INDEX_ID = 0;
    private static final int COLUMN_INDEX_QUERY = 1;
    private static final int COLUMN_INDEX_ICON = 2;
    private static final int COLUMN_INDEX_TEXT_1 = 3;
    private static final int COLUMN_INDEX_TEXT_2 = 4;
    private static final String[] COLUMNS = new String[]{"_id", "suggest_intent_query", "suggest_icon_1", "suggest_text_1", "suggest_text_2"};
    private static final String[] COLUMNS_WITHOUT_DESCRIPTION = new String[]{"_id", "suggest_intent_query", "suggest_icon_1", "suggest_text_1"};
    private final SearchEngineInfo mSearchEngineInfo;
    private final AndroidHttpClient mHttpClient;

    public OpenSearchSearchEngine(Context context, SearchEngineInfo searchEngineInfo) {
        this.mSearchEngineInfo = searchEngineInfo;
        this.mHttpClient = AndroidHttpClient.newInstance((String)USER_AGENT);
        HttpParams params = this.mHttpClient.getParams();
        params.setLongParameter(HTTP_TIMEOUT, 1000L);
    }

    public String getName() {
        return this.mSearchEngineInfo.getName();
    }

    public CharSequence getLabel() {
        return this.mSearchEngineInfo.getLabel();
    }

    public void startSearch(Context context, String query, Bundle appData, String extraData) {
        String uri = this.mSearchEngineInfo.getSearchUriForQuery(query);
        if (uri == null) {
            Log.e((String)TAG, (String)("Unable to get search URI for " + this.mSearchEngineInfo));
        } else {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri));
            intent.setPackage(context.getPackageName());
            intent.addCategory("android.intent.category.DEFAULT");
            intent.putExtra("query", query);
            if (appData != null) {
                intent.putExtra("app_data", appData);
            }
            if (extraData != null) {
                intent.putExtra("intent_extra_data_key", extraData);
            }
            intent.putExtra("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
        }
    }

    public Cursor getSuggestions(Context context, String query) {
        if (TextUtils.isEmpty((CharSequence)query)) {
            return null;
        }
        if (!this.isNetworkConnected(context)) {
            Log.i((String)TAG, (String)"Not connected to network.");
            return null;
        }
        String suggestUri = this.mSearchEngineInfo.getSuggestUriForQuery(query);
        if (TextUtils.isEmpty((CharSequence)suggestUri)) {
            return null;
        }
        try {
            String content = this.readUrl(suggestUri);
            if (content == null) {
                return null;
            }
            JSONArray results = new JSONArray(content);
            JSONArray suggestions = results.getJSONArray(1);
            JSONArray descriptions = null;
            if (results.length() > 2 && (descriptions = results.getJSONArray(2)).length() == 0) {
                descriptions = null;
            }
            return new SuggestionsCursor(suggestions, descriptions);
        }
        catch (JSONException e) {
            Log.w((String)TAG, (String)"Error", (Throwable)e);
            return null;
        }
    }

    public String readUrl(String url) {
        try {
            HttpGet method = new HttpGet(url);
            HttpResponse response = this.mHttpClient.execute((HttpUriRequest)method);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString((HttpEntity)response.getEntity());
            }
            Log.i((String)TAG, (String)"Suggestion request failed");
            return null;
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Error", (Throwable)e);
            return null;
        }
    }

    public boolean supportsSuggestions() {
        return this.mSearchEngineInfo.supportsSuggestions();
    }

    public void close() {
        this.mHttpClient.close();
    }

    public boolean supportsVoiceSearch() {
        return this.getName().equals("google");
    }

    private boolean isNetworkConnected(Context context) {
        NetworkInfo networkInfo = this.getActiveNetworkInfo(context);
        return networkInfo != null && networkInfo.isConnected();
    }

    private NetworkInfo getActiveNetworkInfo(Context context) {
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity == null) {
            return null;
        }
        return connectivity.getActiveNetworkInfo();
    }

    public String toString() {
        return "OpenSearchSearchEngine{" + this.mSearchEngineInfo + "}";
    }

    private static class SuggestionsCursor
    extends AbstractCursor {
        private final JSONArray mSuggestions;
        private final JSONArray mDescriptions;

        public SuggestionsCursor(JSONArray suggestions, JSONArray descriptions) {
            this.mSuggestions = suggestions;
            this.mDescriptions = descriptions;
        }

        public int getCount() {
            return this.mSuggestions.length();
        }

        public String[] getColumnNames() {
            return this.mDescriptions != null ? COLUMNS : COLUMNS_WITHOUT_DESCRIPTION;
        }

        public String getString(int column) {
            if (this.mPos != -1) {
                if (column == 1 || column == 3) {
                    try {
                        return this.mSuggestions.getString(this.mPos);
                    }
                    catch (JSONException e) {
                        Log.w((String)OpenSearchSearchEngine.TAG, (String)"Error", (Throwable)e);
                    }
                } else if (column == 4) {
                    try {
                        return this.mDescriptions.getString(this.mPos);
                    }
                    catch (JSONException e) {
                        Log.w((String)OpenSearchSearchEngine.TAG, (String)"Error", (Throwable)e);
                    }
                } else if (column == 2) {
                    return String.valueOf(2130837558);
                }
            }
            return null;
        }

        public double getDouble(int column) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(int column) {
            throw new UnsupportedOperationException();
        }

        public int getInt(int column) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int column) {
            if (column == 0) {
                return this.mPos;
            }
            throw new UnsupportedOperationException();
        }

        public short getShort(int column) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int column) {
            throw new UnsupportedOperationException();
        }
    }
}

