/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Bundle;
import android.provider.Browser;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.GeolocationPermissions;
import android.webkit.ValueCallback;
import android.webkit.WebStorage;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.android.browser.WebStorageSizeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebsiteSettingsActivity
extends ListActivity {
    private String LOGTAG = "WebsiteSettingsActivity";
    private static String sMBStored = null;
    private SiteAdapter mAdapter = null;

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 4 && event.getAction() == 0 && this.mAdapter != null && this.mAdapter.backKeyPressed()) {
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        if (sMBStored == null) {
            sMBStored = this.getString(2131230957);
        }
        this.mAdapter = new SiteAdapter((Context)this, 2130903066);
        this.setListAdapter((ListAdapter)this.mAdapter);
        this.getListView().setOnItemClickListener((AdapterView.OnItemClickListener)this.mAdapter);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131427339, menu2);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        return this.mAdapter.currentSite() == null && this.mAdapter.getCount() > 0;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131493028: {
                new AlertDialog.Builder((Context)this).setTitle(2131230973).setMessage(2131230974).setPositiveButton(2131230975, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dlg, int which) {
                        WebStorage.getInstance().deleteAllData();
                        GeolocationPermissions.getInstance().clearAll();
                        WebStorageSizeManager.resetLastOutOfSpaceNotificationTime();
                        WebsiteSettingsActivity.this.mAdapter.askForOrigins();
                        WebsiteSettingsActivity.this.finish();
                    }
                }).setNegativeButton(2131230976, null).setIcon(17301543).show();
                return true;
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SiteAdapter
    extends ArrayAdapter<Site>
    implements AdapterView.OnItemClickListener {
        private int mResource;
        private LayoutInflater mInflater;
        private Bitmap mDefaultIcon;
        private Bitmap mUsageEmptyIcon;
        private Bitmap mUsageLowIcon;
        private Bitmap mUsageHighIcon;
        private Bitmap mLocationAllowedIcon;
        private Bitmap mLocationDisallowedIcon;
        private Site mCurrentSite;

        public SiteAdapter(Context context, int rsc) {
            super(context, rsc);
            this.mResource = rsc;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.mDefaultIcon = BitmapFactory.decodeResource((Resources)WebsiteSettingsActivity.this.getResources(), (int)2130837504);
            this.mUsageEmptyIcon = BitmapFactory.decodeResource((Resources)WebsiteSettingsActivity.this.getResources(), (int)2130837537);
            this.mUsageLowIcon = BitmapFactory.decodeResource((Resources)WebsiteSettingsActivity.this.getResources(), (int)2130837538);
            this.mUsageHighIcon = BitmapFactory.decodeResource((Resources)WebsiteSettingsActivity.this.getResources(), (int)2130837536);
            this.mLocationAllowedIcon = BitmapFactory.decodeResource((Resources)WebsiteSettingsActivity.this.getResources(), (int)2130837540);
            this.mLocationDisallowedIcon = BitmapFactory.decodeResource((Resources)WebsiteSettingsActivity.this.getResources(), (int)2130837539);
            this.askForOrigins();
        }

        private void addFeatureToSite(Map<String, Site> sites, String origin, int feature) {
            Site site = null;
            if (sites.containsKey(origin)) {
                site = sites.get(origin);
            } else {
                site = new Site(origin);
                sites.put(origin, site);
            }
            site.addFeature(feature);
        }

        public void askForOrigins() {
            WebStorage.getInstance().getOrigins((ValueCallback)new ValueCallback<Map>(){

                public void onReceiveValue(Map origins) {
                    HashMap<String, Site> sites = new HashMap<String, Site>();
                    if (origins != null) {
                        Iterator iter = origins.keySet().iterator();
                        while (iter.hasNext()) {
                            SiteAdapter.this.addFeatureToSite(sites, (String)iter.next(), 0);
                        }
                    }
                    SiteAdapter.this.askForGeolocation(sites);
                }
            });
        }

        public void askForGeolocation(final Map<String, Site> sites) {
            GeolocationPermissions.getInstance().getOrigins((ValueCallback)new ValueCallback<Set<String>>(){

                public void onReceiveValue(Set<String> origins) {
                    if (origins != null) {
                        Iterator<String> iter = origins.iterator();
                        while (iter.hasNext()) {
                            SiteAdapter.this.addFeatureToSite(sites, iter.next(), 1);
                        }
                    }
                    SiteAdapter.this.populateIcons(sites);
                    SiteAdapter.this.populateOrigins(sites);
                }
            });
        }

        public void populateIcons(Map<String, Site> sites) {
            HashMap hosts = new HashMap();
            Set<Map.Entry<String, Site>> elements = sites.entrySet();
            for (Map.Entry<String, Site> entry : elements) {
                Site site = entry.getValue();
                String host = Uri.parse((String)entry.getKey()).getHost();
                Set<Site> hostSites = null;
                if (hosts.containsKey(host)) {
                    hostSites = (Set)hosts.get(host);
                } else {
                    hostSites = new HashSet();
                    hosts.put(host, hostSites);
                }
                hostSites.add(site);
            }
            Cursor c = this.getContext().getContentResolver().query(Browser.BOOKMARKS_URI, new String[]{"url", "title", "favicon"}, "bookmark = 1", null, null);
            if (c != null) {
                if (c.moveToFirst()) {
                    int urlIndex = c.getColumnIndex("url");
                    int titleIndex = c.getColumnIndex("title");
                    int faviconIndex = c.getColumnIndex("favicon");
                    do {
                        String url;
                        String host;
                        if (!hosts.containsKey(host = Uri.parse((String)(url = c.getString(urlIndex))).getHost())) continue;
                        String title = c.getString(titleIndex);
                        Bitmap bmp = null;
                        byte[] data = c.getBlob(faviconIndex);
                        if (data != null) {
                            bmp = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                        }
                        Set matchingSites = (Set)hosts.get(host);
                        for (Site site : matchingSites) {
                            if (url.equals(site.getOrigin()) || new String(site.getOrigin() + "/").equals(url)) {
                                site.setTitle(title);
                            }
                            if (bmp == null) continue;
                            site.setIcon(bmp);
                        }
                    } while (c.moveToNext());
                }
                c.close();
            }
        }

        public void populateOrigins(Map<String, Site> sites) {
            this.clear();
            Set<Map.Entry<String, Site>> elements = sites.entrySet();
            for (Map.Entry<String, Site> entry : elements) {
                Site site = entry.getValue();
                this.add(site);
            }
            this.notifyDataSetChanged();
            if (this.getCount() == 0) {
                WebsiteSettingsActivity.this.finish();
            }
        }

        public int getCount() {
            if (this.mCurrentSite == null) {
                return super.getCount();
            }
            return this.mCurrentSite.getFeatureCount();
        }

        public String sizeValueToString(long bytes) {
            if (bytes <= 0L) {
                Log.e((String)WebsiteSettingsActivity.this.LOGTAG, (String)("sizeValueToString called with non-positive value: " + bytes));
                return "0";
            }
            float megabytes = (float)bytes / 1048576.0f;
            int truncated = (int)Math.ceil(megabytes * 10.0f);
            float result = (float)truncated / 10.0f;
            return String.valueOf(result);
        }

        public boolean backKeyPressed() {
            if (this.mCurrentSite != null) {
                this.mCurrentSite = null;
                this.askForOrigins();
                return true;
            }
            return false;
        }

        public void setIconForUsage(ImageView usageIcon, long usageInBytes) {
            float usageInMegabytes = (float)usageInBytes / 1048576.0f;
            if ((double)usageInMegabytes <= 0.1) {
                usageIcon.setImageBitmap(this.mUsageEmptyIcon);
            } else if ((double)usageInMegabytes > 0.1 && usageInMegabytes <= 5.0f) {
                usageIcon.setImageBitmap(this.mUsageLowIcon);
            } else if (usageInMegabytes > 5.0f) {
                usageIcon.setImageBitmap(this.mUsageHighIcon);
            }
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View view = convertView == null ? this.mInflater.inflate(this.mResource, parent, false) : convertView;
            final TextView title = (TextView)view.findViewById(2131492866);
            final TextView subtitle = (TextView)view.findViewById(2131492954);
            ImageView icon = (ImageView)view.findViewById(2131492949);
            final ImageView featureIcon = (ImageView)view.findViewById(2131492953);
            final ImageView usageIcon = (ImageView)view.findViewById(2131492952);
            final ImageView locationIcon = (ImageView)view.findViewById(2131492951);
            usageIcon.setVisibility(8);
            locationIcon.setVisibility(8);
            if (this.mCurrentSite == null) {
                WebsiteSettingsActivity.this.setTitle(WebsiteSettingsActivity.this.getString(2131230874));
                Site site = (Site)this.getItem(position);
                title.setText((CharSequence)site.getPrettyTitle());
                String subtitleText = site.getPrettyOrigin();
                if (subtitleText != null) {
                    title.setMaxLines(1);
                    title.setSingleLine(true);
                    subtitle.setVisibility(0);
                    subtitle.setText((CharSequence)subtitleText);
                } else {
                    subtitle.setVisibility(8);
                    title.setMaxLines(2);
                    title.setSingleLine(false);
                }
                icon.setVisibility(0);
                usageIcon.setVisibility(4);
                locationIcon.setVisibility(4);
                featureIcon.setVisibility(8);
                Bitmap bmp = site.getIcon();
                if (bmp == null) {
                    bmp = this.mDefaultIcon;
                }
                icon.setImageBitmap(bmp);
                view.setTag((Object)site);
                String origin = site.getOrigin();
                if (site.hasFeature(0)) {
                    WebStorage.getInstance().getUsageForOrigin(origin, (ValueCallback)new ValueCallback<Long>(){

                        public void onReceiveValue(Long value) {
                            if (value != null) {
                                SiteAdapter.this.setIconForUsage(usageIcon, value);
                                usageIcon.setVisibility(0);
                            }
                        }
                    });
                }
                if (site.hasFeature(1)) {
                    locationIcon.setVisibility(0);
                    GeolocationPermissions.getInstance().getAllowed(origin, (ValueCallback)new ValueCallback<Boolean>(){

                        public void onReceiveValue(Boolean allowed) {
                            if (allowed != null) {
                                if (allowed.booleanValue()) {
                                    locationIcon.setImageBitmap(SiteAdapter.this.mLocationAllowedIcon);
                                } else {
                                    locationIcon.setImageBitmap(SiteAdapter.this.mLocationDisallowedIcon);
                                }
                            }
                        }
                    });
                }
            } else {
                icon.setVisibility(8);
                locationIcon.setVisibility(8);
                usageIcon.setVisibility(8);
                featureIcon.setVisibility(0);
                WebsiteSettingsActivity.this.setTitle(this.mCurrentSite.getPrettyTitle());
                String origin = this.mCurrentSite.getOrigin();
                switch (this.mCurrentSite.getFeatureByIndex(position)) {
                    case 0: {
                        WebStorage.getInstance().getUsageForOrigin(origin, (ValueCallback)new ValueCallback<Long>(){

                            public void onReceiveValue(Long value) {
                                if (value != null) {
                                    String usage = SiteAdapter.this.sizeValueToString(value) + " " + sMBStored;
                                    title.setText(2131230952);
                                    subtitle.setText((CharSequence)usage);
                                    subtitle.setVisibility(0);
                                    SiteAdapter.this.setIconForUsage(featureIcon, value);
                                }
                            }
                        });
                        break;
                    }
                    case 1: {
                        title.setText(2131230965);
                        GeolocationPermissions.getInstance().getAllowed(origin, (ValueCallback)new ValueCallback<Boolean>(){

                            public void onReceiveValue(Boolean allowed) {
                                if (allowed != null) {
                                    if (allowed.booleanValue()) {
                                        subtitle.setText(2131230966);
                                        featureIcon.setImageBitmap(SiteAdapter.this.mLocationAllowedIcon);
                                    } else {
                                        subtitle.setText(2131230967);
                                        featureIcon.setImageBitmap(SiteAdapter.this.mLocationDisallowedIcon);
                                    }
                                    subtitle.setVisibility(0);
                                }
                            }
                        });
                    }
                }
            }
            return view;
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            if (this.mCurrentSite != null) {
                switch (this.mCurrentSite.getFeatureByIndex(position)) {
                    case 0: {
                        new AlertDialog.Builder(this.getContext()).setTitle(2131230953).setMessage(2131230954).setPositiveButton(2131230955, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dlg, int which) {
                                WebStorage.getInstance().deleteOrigin(SiteAdapter.this.mCurrentSite.getOrigin());
                                SiteAdapter.this.mCurrentSite.removeFeature(0);
                                if (SiteAdapter.this.mCurrentSite.getFeatureCount() == 0) {
                                    SiteAdapter.this.mCurrentSite = null;
                                }
                                SiteAdapter.this.askForOrigins();
                                SiteAdapter.this.notifyDataSetChanged();
                            }
                        }).setNegativeButton(2131230956, null).setIcon(17301543).show();
                        break;
                    }
                    case 1: {
                        new AlertDialog.Builder(this.getContext()).setTitle(2131230968).setMessage(2131230969).setPositiveButton(2131230970, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dlg, int which) {
                                GeolocationPermissions.getInstance().clear(SiteAdapter.this.mCurrentSite.getOrigin());
                                SiteAdapter.this.mCurrentSite.removeFeature(1);
                                if (SiteAdapter.this.mCurrentSite.getFeatureCount() == 0) {
                                    SiteAdapter.this.mCurrentSite = null;
                                }
                                SiteAdapter.this.askForOrigins();
                                SiteAdapter.this.notifyDataSetChanged();
                            }
                        }).setNegativeButton(2131230971, null).setIcon(17301543).show();
                    }
                }
            } else {
                this.mCurrentSite = (Site)view.getTag();
                this.notifyDataSetChanged();
            }
        }

        public Site currentSite() {
            return this.mCurrentSite;
        }
    }

    static class Site {
        private String mOrigin;
        private String mTitle;
        private Bitmap mIcon;
        private int mFeatures;
        private static final int FEATURE_WEB_STORAGE = 0;
        private static final int FEATURE_GEOLOCATION = 1;
        private static final int FEATURE_COUNT = 2;

        public Site(String origin) {
            this.mOrigin = origin;
            this.mTitle = null;
            this.mIcon = null;
            this.mFeatures = 0;
        }

        public void addFeature(int feature) {
            this.mFeatures |= 1 << feature;
        }

        public void removeFeature(int feature) {
            this.mFeatures &= ~(1 << feature);
        }

        public boolean hasFeature(int feature) {
            return (this.mFeatures & 1 << feature) != 0;
        }

        public int getFeatureCount() {
            int count = 0;
            for (int i = 0; i < 2; ++i) {
                count += this.hasFeature(i) ? 1 : 0;
            }
            return count;
        }

        public int getFeatureByIndex(int n) {
            int j = -1;
            for (int i = 0; i < 2; ++i) {
                if ((j += this.hasFeature(i) ? 1 : 0) != n) continue;
                return i;
            }
            return -1;
        }

        public String getOrigin() {
            return this.mOrigin;
        }

        public void setTitle(String title) {
            this.mTitle = title;
        }

        public void setIcon(Bitmap icon) {
            this.mIcon = icon;
        }

        public Bitmap getIcon() {
            return this.mIcon;
        }

        public String getPrettyOrigin() {
            return this.mTitle == null ? null : this.hideHttp(this.mOrigin);
        }

        public String getPrettyTitle() {
            return this.mTitle == null ? this.hideHttp(this.mOrigin) : this.mTitle;
        }

        private String hideHttp(String str) {
            Uri uri = Uri.parse((String)str);
            return "http".equals(uri.getScheme()) ? str.substring(7) : str;
        }
    }
}

