/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.webkit.WebBackForwardList;
import android.webkit.WebView;
import com.android.browser.BrowserActivity;
import com.android.browser.BrowserSettings;
import com.android.browser.Tab;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TabControl {
    private static final String LOGTAG = "TabControl";
    private static final int MAX_TABS = 8;
    private ArrayList<Tab> mTabs = new ArrayList(8);
    private ArrayList<Tab> mTabQueue = new ArrayList(8);
    private int mCurrentTab = -1;
    private final BrowserActivity mActivity;
    private final File mThumbnailDir;

    TabControl(BrowserActivity activity) {
        this.mActivity = activity;
        this.mThumbnailDir = activity.getDir("thumbnails", 0);
    }

    File getThumbnailDir() {
        return this.mThumbnailDir;
    }

    BrowserActivity getBrowserActivity() {
        return this.mActivity;
    }

    WebView getCurrentWebView() {
        Tab t = this.getTab(this.mCurrentTab);
        if (t == null) {
            return null;
        }
        return t.getWebView();
    }

    WebView getCurrentTopWebView() {
        Tab t = this.getTab(this.mCurrentTab);
        if (t == null) {
            return null;
        }
        return t.getTopWindow();
    }

    WebView getCurrentSubWindow() {
        Tab t = this.getTab(this.mCurrentTab);
        if (t == null) {
            return null;
        }
        return t.getSubWebView();
    }

    Tab getTab(int index) {
        if (index >= 0 && index < this.mTabs.size()) {
            return this.mTabs.get(index);
        }
        return null;
    }

    Tab getCurrentTab() {
        return this.getTab(this.mCurrentTab);
    }

    int getCurrentIndex() {
        return this.mCurrentTab;
    }

    int getTabIndex(Tab tab) {
        if (tab == null) {
            return -1;
        }
        return this.mTabs.indexOf(tab);
    }

    boolean canCreateNewTab() {
        return 8 != this.mTabs.size();
    }

    Tab createNewTab(boolean closeOnExit, String appId, String url) {
        int size = this.mTabs.size();
        if (8 == size) {
            return null;
        }
        WebView w = this.createNewWebView();
        Tab t = new Tab(this.mActivity, w, closeOnExit, appId, url);
        this.mTabs.add(t);
        t.putInBackground();
        return t;
    }

    Tab createNewTab() {
        return this.createNewTab(false, null, null);
    }

    void removeParentChildRelationShips() {
        for (Tab tab : this.mTabs) {
            tab.removeFromTree();
        }
    }

    boolean removeTab(Tab t) {
        if (t == null) {
            return false;
        }
        Tab current = this.getCurrentTab();
        this.mTabs.remove(t);
        if (current == t) {
            t.putInBackground();
            this.mCurrentTab = -1;
        } else {
            this.mCurrentTab = this.getTabIndex(current);
        }
        t.destroy();
        t.removeFromTree();
        for (Tab tab : this.mTabs) {
            Vector<Tab> children = tab.getChildTabs();
            if (children == null) continue;
            for (Tab child : children) {
                child.setParentTab(tab);
            }
        }
        this.mTabQueue.remove(t);
        return true;
    }

    void destroy() {
        for (Tab t : this.mTabs) {
            t.destroy();
        }
        this.mTabs.clear();
        this.mTabQueue.clear();
    }

    int getTabCount() {
        return this.mTabs.size();
    }

    void saveState(Bundle outState) {
        int numTabs = this.getTabCount();
        outState.putInt("numTabs", numTabs);
        int index = this.getCurrentIndex();
        outState.putInt("currentTab", index >= 0 && index < numTabs ? index : 0);
        for (int i = 0; i < numTabs; ++i) {
            Tab t = this.getTab(i);
            if (!t.saveState()) continue;
            outState.putBundle("webview" + i, t.getSavedState());
        }
    }

    boolean restoreState(Bundle inState) {
        int i;
        int numTabs;
        int n = numTabs = inState == null ? -1 : inState.getInt("numTabs", -1);
        if (numTabs == -1) {
            return false;
        }
        int currentTab = inState.getInt("currentTab", -1);
        for (i = 0; i < numTabs; ++i) {
            Tab t;
            if (i == currentTab) {
                t = this.createNewTab();
                this.setCurrentTab(t);
                if (t.restoreState(inState.getBundle("webview" + i))) continue;
                Log.w((String)LOGTAG, (String)"Fail in restoreState, load home page.");
                t.getWebView().loadUrl(BrowserSettings.getInstance().getHomePage());
                continue;
            }
            t = new Tab(this.mActivity, null, false, null, null);
            Bundle state = inState.getBundle("webview" + i);
            if (state != null) {
                t.setSavedState(state);
                t.populatePickerDataFromSavedState();
                t.setAppId(state.getString("appid"));
                t.setOriginalUrl(state.getString("originalUrl"));
            }
            this.mTabs.add(t);
            this.mTabQueue.add(0, t);
        }
        for (i = 0; i < numTabs; ++i) {
            Tab parent;
            int parentIndex;
            Bundle b = inState.getBundle("webview" + i);
            Tab t = this.getTab(i);
            if (b == null || t == null || (parentIndex = b.getInt("parentTab", -1)) == -1 || (parent = this.getTab(parentIndex)) == null) continue;
            parent.addChildTab(t);
        }
        return true;
    }

    void freeMemory() {
        if (this.getTabCount() == 0) {
            return;
        }
        Vector<Tab> tabs = this.getHalfLeastUsedTabs(this.getCurrentTab());
        if (tabs.size() > 0) {
            Log.w((String)LOGTAG, (String)("Free " + tabs.size() + " tabs in the browser"));
            for (Tab t : tabs) {
                t.saveState();
                t.destroy();
            }
            return;
        }
        Log.w((String)LOGTAG, (String)"Free WebView's unused memory and cache");
        WebView view = this.getCurrentWebView();
        if (view != null) {
            view.freeMemory();
        }
    }

    private Vector<Tab> getHalfLeastUsedTabs(Tab current) {
        Vector<Tab> tabsToGo = new Vector<Tab>();
        if (this.getTabCount() == 1 || current == null) {
            return tabsToGo;
        }
        if (this.mTabQueue.size() == 0) {
            return tabsToGo;
        }
        int openTabCount = 0;
        for (Tab t : this.mTabQueue) {
            if (t == null || t.getWebView() == null) continue;
            ++openTabCount;
            if (t == current || t == current.getParentTab()) continue;
            tabsToGo.add(t);
        }
        if (tabsToGo.size() > (openTabCount /= 2)) {
            tabsToGo.setSize(openTabCount);
        }
        return tabsToGo;
    }

    Tab getTabFromView(WebView view) {
        int size = this.getTabCount();
        for (int i = 0; i < size; ++i) {
            Tab t = this.getTab(i);
            if (t.getSubWebView() != view && t.getWebView() != view) continue;
            return t;
        }
        return null;
    }

    Tab getTabFromId(String id2) {
        if (id2 == null) {
            return null;
        }
        int size = this.getTabCount();
        for (int i = 0; i < size; ++i) {
            Tab t = this.getTab(i);
            if (!id2.equals(t.getAppId())) continue;
            return t;
        }
        return null;
    }

    void stopAllLoading() {
        int size = this.getTabCount();
        for (int i = 0; i < size; ++i) {
            WebView subview;
            Tab t = this.getTab(i);
            WebView webview = t.getWebView();
            if (webview != null) {
                webview.stopLoading();
            }
            if ((subview = t.getSubWebView()) == null) continue;
            webview.stopLoading();
        }
    }

    private boolean tabMatchesUrl(Tab t, String url) {
        if (t.getAppId() != null) {
            return false;
        }
        WebView webview = t.getWebView();
        if (webview == null) {
            return false;
        }
        return url.equals(webview.getUrl()) || url.equals(webview.getOriginalUrl());
    }

    Tab findUnusedTabWithUrl(String url) {
        if (url == null) {
            return null;
        }
        Tab t = this.getCurrentTab();
        if (t != null && this.tabMatchesUrl(t, url)) {
            return t;
        }
        int size = this.getTabCount();
        for (int i = 0; i < size; ++i) {
            t = this.getTab(i);
            if (!this.tabMatchesUrl(t, url)) continue;
            return t;
        }
        return null;
    }

    boolean recreateWebView(Tab t, BrowserActivity.UrlData urlData) {
        String url = urlData.mUrl;
        WebView w = t.getWebView();
        if (w != null) {
            WebBackForwardList list;
            if (url != null && url.equals(t.getOriginalUrl()) && urlData.mVoiceIntent == null && (list = w.copyBackForwardList()) != null) {
                w.goBackOrForward(-list.getCurrentIndex());
                w.clearHistory();
                return false;
            }
            t.destroy();
        }
        t.setWebView(this.createNewWebView());
        if (this.getCurrentTab() == t) {
            this.setCurrentTab(t, true);
        }
        t.setSavedState(null);
        t.clearPickerData();
        t.setOriginalUrl(url);
        return true;
    }

    private WebView createNewWebView() {
        WebView w = new WebView((Context)this.mActivity);
        w.setScrollbarFadingEnabled(true);
        w.setScrollBarStyle(0x2000000);
        w.setMapTrackballToArrowKeys(false);
        w.getSettings().setBuiltInZoomControls(true);
        BrowserSettings s = BrowserSettings.getInstance();
        s.addObserver(w.getSettings()).update(s, null);
        return w;
    }

    boolean setCurrentTab(Tab newTab) {
        return this.setCurrentTab(newTab, false);
    }

    void pauseCurrentTab() {
        Tab t = this.getCurrentTab();
        if (t != null) {
            t.pause();
        }
    }

    void resumeCurrentTab() {
        Tab t = this.getCurrentTab();
        if (t != null) {
            t.resume();
        }
    }

    private boolean setCurrentTab(Tab newTab, boolean force) {
        boolean needRestore;
        Tab current = this.getTab(this.mCurrentTab);
        if (current == newTab && !force) {
            return true;
        }
        if (current != null) {
            current.putInBackground();
            this.mCurrentTab = -1;
        }
        if (newTab == null) {
            return false;
        }
        int index = this.mTabQueue.indexOf(newTab);
        if (index != -1) {
            this.mTabQueue.remove(index);
        }
        this.mTabQueue.add(newTab);
        this.mCurrentTab = this.mTabs.indexOf(newTab);
        WebView mainView = newTab.getWebView();
        boolean bl = needRestore = mainView == null;
        if (needRestore) {
            mainView = this.createNewWebView();
            newTab.setWebView(mainView);
        }
        newTab.putInForeground();
        if (needRestore && !newTab.restoreState(newTab.getSavedState())) {
            mainView.loadUrl(BrowserSettings.getInstance().getHomePage());
        }
        return true;
    }
}

