/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.webkit.GeolocationPermissions;
import android.webkit.ValueCallback;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SystemAllowGeolocationOrigins {
    private static final String LAST_READ_ALLOW_GEOLOCATION_ORIGINS = "last_read_allow_geolocation_origins";
    private final Context mContext;
    private final SettingObserver mSettingObserver;

    public SystemAllowGeolocationOrigins(Context context) {
        this.mContext = context;
        this.mSettingObserver = new SettingObserver();
    }

    public void start() {
        Uri uri = Settings.Secure.getUriFor((String)"allowed_geolocation_origins");
        this.mContext.getContentResolver().registerContentObserver(uri, false, (ContentObserver)this.mSettingObserver);
        this.maybeApplySettingAsync();
    }

    public void stop() {
        this.mContext.getContentResolver().unregisterContentObserver((ContentObserver)this.mSettingObserver);
    }

    void maybeApplySettingAsync() {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                SystemAllowGeolocationOrigins.this.maybeApplySetting();
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    private void maybeApplySetting() {
        String newSetting = this.getSystemSetting();
        SharedPreferences preferences = PreferenceManager.getDefaultSharedPreferences((Context)this.mContext);
        String lastReadSetting = preferences.getString(LAST_READ_ALLOW_GEOLOCATION_ORIGINS, "");
        if (TextUtils.equals((CharSequence)lastReadSetting, (CharSequence)newSetting)) {
            return;
        }
        preferences.edit().putString(LAST_READ_ALLOW_GEOLOCATION_ORIGINS, newSetting).apply();
        HashSet<String> oldOrigins = SystemAllowGeolocationOrigins.parseAllowGeolocationOrigins(lastReadSetting);
        HashSet<String> newOrigins = SystemAllowGeolocationOrigins.parseAllowGeolocationOrigins(newSetting);
        Set<String> addedOrigins = this.setMinus(newOrigins, oldOrigins);
        Set<String> removedOrigins = this.setMinus(oldOrigins, newOrigins);
        this.removeOrigins(removedOrigins);
        this.addOrigins(addedOrigins);
    }

    private static HashSet<String> parseAllowGeolocationOrigins(String setting) {
        HashSet<String> origins = new HashSet<String>();
        if (!TextUtils.isEmpty((CharSequence)setting)) {
            for (String origin : setting.split("\\s+")) {
                if (TextUtils.isEmpty((CharSequence)origin)) continue;
                origins.add(origin);
            }
        }
        return origins;
    }

    private <A> Set<A> setMinus(Set<A> x, Set<A> y) {
        HashSet<A> z = new HashSet<A>(x.size());
        for (A a : x) {
            if (y.contains(a)) continue;
            z.add(a);
        }
        return z;
    }

    private String getSystemSetting() {
        String value = Settings.Secure.getString((ContentResolver)this.mContext.getContentResolver(), (String)"allowed_geolocation_origins");
        return value == null ? "" : value;
    }

    private void addOrigins(Set<String> origins) {
        for (String origin : origins) {
            GeolocationPermissions.getInstance().allow(origin);
        }
    }

    private void removeOrigins(Set<String> origins) {
        for (final String origin : origins) {
            GeolocationPermissions.getInstance().getAllowed(origin, (ValueCallback)new ValueCallback<Boolean>(){

                public void onReceiveValue(Boolean value) {
                    if (value != null && value.booleanValue()) {
                        GeolocationPermissions.getInstance().clear(origin);
                    }
                }
            });
        }
    }

    private class SettingObserver
    extends ContentObserver {
        SettingObserver() {
            super(new Handler());
        }

        public void onChange(boolean selfChange) {
            SystemAllowGeolocationOrigins.this.maybeApplySettingAsync();
        }
    }
}

