/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.provider.Browser;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.android.browser.BrowserActivity;
import com.android.browser.WebDialog;

class SelectDialog
extends WebDialog {
    private View mCopyButton;
    private View mSelectAllButton;
    private View mShareButton;
    private View mFindButton;
    private View.OnClickListener mCopyListener = new View.OnClickListener(){

        public void onClick(View v) {
            SelectDialog.this.mWebView.copySelection();
            SelectDialog.this.mBrowserActivity.closeDialogs();
        }
    };
    private View.OnClickListener mSelectAllListener = new View.OnClickListener(){

        public void onClick(View v) {
            SelectDialog.this.mWebView.selectAll();
        }
    };
    private View.OnClickListener mShareListener = new View.OnClickListener(){

        public void onClick(View v) {
            String selection = SelectDialog.this.mWebView.getSelection();
            Browser.sendString((Context)SelectDialog.this.mBrowserActivity, (String)selection);
            SelectDialog.this.mBrowserActivity.closeDialogs();
        }
    };
    private View.OnClickListener mFindListener = new View.OnClickListener(){

        public void onClick(View v) {
            String selection = SelectDialog.this.mWebView.getSelection();
            SelectDialog.this.mBrowserActivity.closeDialogs();
            SelectDialog.this.mBrowserActivity.showFindDialog();
            SelectDialog.this.mBrowserActivity.setFindDialogText(selection);
        }
    };

    SelectDialog(BrowserActivity context) {
        super(context);
        LayoutInflater factory = LayoutInflater.from((Context)context);
        factory.inflate(2130903046, (ViewGroup)this);
        this.addCancel();
        this.mCopyButton = this.findViewById(2131492887);
        this.mCopyButton.setOnClickListener(this.mCopyListener);
        this.mSelectAllButton = this.findViewById(2131492889);
        this.mSelectAllButton.setOnClickListener(this.mSelectAllListener);
        this.mShareButton = this.findViewById(2131492888);
        this.mShareButton.setOnClickListener(this.mShareListener);
        this.mFindButton = this.findViewById(2131492890);
        this.mFindButton.setOnClickListener(this.mFindListener);
    }

    public void dismiss() {
        super.dismiss();
        this.mWebView.notifySelectDialogDismissed();
    }
}

