/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.utils.BoundaryPatch;
import android.webkit.WebView;

class MeshTracker
extends WebView.DragTracker {
    private Mesh mMesh;
    private Bitmap mBitmap;
    private int mWhich;
    private Paint mBGPaint;

    public MeshTracker(int which) {
        this.mWhich = which;
    }

    public void setBGPaint(Paint paint) {
        this.mBGPaint = paint;
    }

    public void onStartDrag(float x, float y) {
        this.mMesh = new Mesh(this.mWhich, 16, 16);
    }

    public void onBitmapChange(Bitmap bm) {
        this.mBitmap = bm;
        this.mMesh.setBitmap(bm);
    }

    public boolean onStretchChange(float sx, float sy) {
        this.mMesh.setStretch(-sx, -sy);
        return true;
    }

    public void onStopDrag() {
        this.mMesh = null;
    }

    public void onDraw(Canvas canvas) {
        if (this.mWhich == 2) {
            if (this.mBGPaint != null) {
                canvas.drawPaint(this.mBGPaint);
            } else {
                canvas.drawColor(-16777216);
            }
        }
        this.mMesh.draw(canvas);
    }

    private static class Mesh {
        private int mWhich;
        private int mRows;
        private int mCols;
        private BoundaryPatch mPatch = new BoundaryPatch();
        private float[] mCubics = new float[24];
        private float[] mOrig = new float[24];
        private float mStretchX;
        private float mStretchY;

        Mesh(int which, int rows, int cols) {
            this.mWhich = which;
            this.mRows = rows;
            this.mCols = cols;
        }

        private void rebuildPatch() {
            this.mPatch.setCubicBoundary(this.mCubics, 0, this.mRows, this.mCols);
        }

        private void setSize(float w, float h) {
            float[] pts = this.mCubics;
            float x1 = w * 0.3333f;
            float y1 = h * 0.3333f;
            float x2 = w * 0.6667f;
            float y2 = h * 0.6667f;
            pts[0] = 0.0f;
            pts[1] = 0.0f;
            pts[2] = x1;
            pts[3] = 0.0f;
            pts[4] = x2;
            pts[5] = 0.0f;
            pts[6] = w;
            pts[7] = 0.0f;
            pts[8] = w;
            pts[9] = y1;
            pts[10] = w;
            pts[11] = y2;
            pts[12] = w;
            pts[13] = h;
            pts[14] = x2;
            pts[15] = h;
            pts[16] = x1;
            pts[17] = h;
            pts[18] = 0.0f;
            pts[19] = h;
            pts[20] = 0.0f;
            pts[21] = y2;
            pts[22] = 0.0f;
            pts[23] = y1;
            System.arraycopy(pts, 0, this.mOrig, 0, 24);
            this.setStretch(this.mStretchX, this.mStretchY);
        }

        public void setBitmap(Bitmap bm) {
            this.mPatch.setTexture(bm);
            this.setSize(bm.getWidth(), bm.getHeight());
        }

        private void doit1(float dx, float dy) {
            float scale = 0.75f;
            int index = (dx *= 0.75f) < 0.0f ? 10 : 4;
            this.mCubics[index * 2 + 0] = this.mOrig[index * 2 + 0] + dx;
            this.mCubics[index * 2 + 2] = this.mOrig[index * 2 + 2] + dx;
            index = (dy *= 0.75f) < 0.0f ? 1 : 7;
            this.mCubics[index * 2 + 1] = this.mOrig[index * 2 + 1] + dy;
            this.mCubics[index * 2 + 3] = this.mOrig[index * 2 + 3] + dy;
        }

        private void doit2(float dx, float dy) {
            float scale = 0.35f;
            dy *= 0.35f;
            float cornerScale = 0.25f;
            int index = (dx *= 0.35f) < 0.0f ? 4 : 10;
            this.mCubics[index * 2 + 0] = this.mOrig[index * 2 + 0] + dx;
            this.mCubics[index * 2 + 2] = this.mOrig[index * 2 + 2] + dx;
            this.mCubics[--index * 2 + 0] = this.mOrig[index * 2 + 0] + dx * 0.25f;
            index = (index + 3) % 12;
            this.mCubics[index * 2 + 0] = this.mOrig[index * 2 + 0] + dx * 0.25f;
            index = dy < 0.0f ? 7 : 1;
            this.mCubics[index * 2 + 1] = this.mOrig[index * 2 + 1] + dy;
            this.mCubics[index * 2 + 3] = this.mOrig[index * 2 + 3] + dy;
            this.mCubics[--index * 2 + 1] = this.mOrig[index * 2 + 1] + dy * 0.25f;
            index = (index + 3) % 12;
            this.mCubics[index * 2 + 1] = this.mOrig[index * 2 + 1] + dy * 0.25f;
        }

        public void setStretch(float dx, float dy) {
            this.mStretchX = dx;
            this.mStretchY = dy;
            switch (this.mWhich) {
                case 1: {
                    this.doit1(dx, dy);
                    break;
                }
                case 2: {
                    this.doit2(dx, dy);
                }
            }
            this.rebuildPatch();
        }

        public void draw(Canvas canvas) {
            this.mPatch.draw(canvas);
        }
    }
}

