/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.webkit.GeolocationPermissions;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

public class GeolocationPermissionsPrompt
extends LinearLayout {
    private LinearLayout mInner;
    private TextView mMessage;
    private Button mShareButton;
    private Button mDontShareButton;
    private CheckBox mRemember;
    private GeolocationPermissions.Callback mCallback;
    private String mOrigin;

    public GeolocationPermissionsPrompt(Context context) {
        this(context, null);
    }

    public GeolocationPermissionsPrompt(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    void init() {
        this.mInner = (LinearLayout)this.findViewById(2131492905);
        this.mMessage = (TextView)this.findViewById(2131492906);
        this.mShareButton = (Button)this.findViewById(2131492908);
        this.mDontShareButton = (Button)this.findViewById(2131492909);
        this.mRemember = (CheckBox)this.findViewById(2131492907);
        final GeolocationPermissionsPrompt me = this;
        this.mShareButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                me.handleButtonClick(true);
            }
        });
        this.mDontShareButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                me.handleButtonClick(false);
            }
        });
    }

    public void show(String origin, GeolocationPermissions.Callback callback) {
        this.mOrigin = origin;
        this.mCallback = callback;
        Uri uri = Uri.parse((String)this.mOrigin);
        this.setMessage("http".equals(uri.getScheme()) ? this.mOrigin.substring(7) : this.mOrigin);
        this.mRemember.setChecked(true);
        this.showDialog(true);
    }

    public void hide() {
        this.showDialog(false);
    }

    private void handleButtonClick(boolean allow) {
        this.showDialog(false);
        boolean remember = this.mRemember.isChecked();
        if (remember) {
            Toast toast = Toast.makeText((Context)this.getContext(), (int)(allow ? 2131230963 : 2131230964), (int)1);
            toast.setGravity(80, 0, 0);
            toast.show();
        }
        this.mCallback.invoke(this.mOrigin, allow, remember);
    }

    private void setMessage(CharSequence origin) {
        this.mMessage.setText((CharSequence)String.format(this.getResources().getString(2131230959), origin));
    }

    private void showDialog(boolean shown) {
        this.mInner.setVisibility(shown ? 0 : 8);
    }
}

