/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import android.provider.Browser;
import android.webkit.WebView;
import com.android.browser.BrowserBookmarksAdapter;
import com.android.browser.Tab;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DownloadTouchIcon
extends AsyncTask<String, Void, Void> {
    private final ContentResolver mContentResolver;
    private Cursor mCursor;
    private final String mOriginalUrl;
    private final String mUrl;
    private final String mUserAgent;
    Tab mTab;

    public DownloadTouchIcon(Tab tab, ContentResolver cr, WebView view) {
        this.mTab = tab;
        this.mContentResolver = cr;
        this.mOriginalUrl = view.getOriginalUrl();
        this.mUrl = view.getUrl();
        this.mUserAgent = view.getSettings().getUserAgentString();
    }

    public DownloadTouchIcon(ContentResolver cr, String url) {
        this.mTab = null;
        this.mContentResolver = cr;
        this.mOriginalUrl = null;
        this.mUrl = url;
        this.mUserAgent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void doInBackground(String ... values) {
        this.mCursor = BrowserBookmarksAdapter.queryBookmarksForUrl(this.mContentResolver, this.mOriginalUrl, this.mUrl, true);
        if (this.mCursor != null && this.mCursor.getCount() > 0) {
            String url = values[0];
            AndroidHttpClient client = AndroidHttpClient.newInstance((String)this.mUserAgent);
            HttpGet request = new HttpGet(url);
            HttpClientParams.setRedirecting((HttpParams)client.getParams(), (boolean)true);
            try {
                InputStream content;
                HttpEntity entity;
                HttpResponse response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null && (content = entity.getContent()) != null) {
                    Bitmap icon = BitmapFactory.decodeStream((InputStream)content, null, null);
                    this.storeIcon(icon);
                }
            }
            catch (IllegalArgumentException ex) {
                request.abort();
            }
            catch (IOException ex) {
                request.abort();
            }
            finally {
                client.close();
            }
        }
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        return null;
    }

    protected void onCancelled() {
        if (this.mCursor != null) {
            this.mCursor.close();
        }
    }

    private void storeIcon(Bitmap icon) {
        if (this.mTab != null) {
            this.mTab.mTouchIconLoader = null;
        }
        if (icon == null || this.mCursor == null || this.isCancelled()) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        icon.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
        ContentValues values = new ContentValues();
        values.put("touch_icon", os.toByteArray());
        if (this.mCursor.moveToFirst()) {
            do {
                this.mContentResolver.update(ContentUris.withAppendedId((Uri)Browser.BOOKMARKS_URI, (long)this.mCursor.getInt(0)), values, null, null);
            } while (this.mCursor.moveToNext());
        }
    }
}

