/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;

class Dots
extends LinearLayout {
    private static final int MAX_DOTS = 8;
    private int mSelected = -1;

    public Dots(Context context) {
        this(context, null);
    }

    public Dots(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setGravity(17);
        this.setPadding(0, 4, 0, 4);
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        for (int i = 0; i < 8; ++i) {
            ImageView dotView = new ImageView(this.mContext);
            dotView.setImageResource(2130837560);
            this.addView((View)dotView, (ViewGroup.LayoutParams)lp);
        }
    }

    public void setDotCount(int dotCount) {
        if (dotCount > 1 && dotCount <= 8) {
            this.setVisibility(0);
            for (int i = 0; i < 8; ++i) {
                this.getChildAt(i).setVisibility(i < dotCount ? 0 : 8);
            }
        } else {
            this.setVisibility(8);
        }
    }

    public void setSelected(int index) {
        if (index < 0 || index >= 8) {
            return;
        }
        if (this.mSelected >= 0) {
            ((ImageView)this.getChildAt(this.mSelected)).setImageResource(2130837560);
        }
        ((ImageView)this.getChildAt(index)).setImageResource(2130837559);
        this.mSelected = index;
    }
}

