/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.DateSorter;
import android.widget.ExpandableListAdapter;
import android.widget.ExpandableListView;
import android.widget.TextView;
import java.util.Vector;

public class DateSortedExpandableListAdapter
implements ExpandableListAdapter {
    private int[] mItemMap;
    private int mNumberOfBins;
    private Vector<DataSetObserver> mObservers;
    private Cursor mCursor;
    private DateSorter mDateSorter;
    private int mDateIndex;
    private int mIdIndex;
    private Context mContext;

    public DateSortedExpandableListAdapter(Context context, Cursor cursor, int dateIndex) {
        this.mContext = context;
        this.mDateSorter = new DateSorter(context);
        this.mObservers = new Vector();
        this.mCursor = cursor;
        this.mIdIndex = cursor.getColumnIndexOrThrow("_id");
        cursor.registerContentObserver((ContentObserver)new ChangeObserver());
        this.mDateIndex = dateIndex;
        this.buildMap();
    }

    private void buildMap() {
        int[] array2 = new int[5];
        for (int j = 0; j < 5; ++j) {
            array2[j] = 0;
        }
        this.mNumberOfBins = 0;
        int dateIndex = -1;
        if (this.mCursor.moveToFirst() && this.mCursor.getCount() > 0) {
            while (!this.mCursor.isAfterLast()) {
                long date = this.getLong(this.mDateIndex);
                int index = this.mDateSorter.getIndex(date);
                if (index > dateIndex) {
                    ++this.mNumberOfBins;
                    if (index == 4) {
                        array2[index] = this.mCursor.getCount() - this.mCursor.getPosition();
                        break;
                    }
                    dateIndex = index;
                }
                int n = dateIndex;
                array2[n] = array2[n] + 1;
                this.mCursor.moveToNext();
            }
        }
        this.mItemMap = array2;
    }

    byte[] getBlob(int cursorIndex) {
        return this.mCursor.getBlob(cursorIndex);
    }

    Context getContext() {
        return this.mContext;
    }

    int getInt(int cursorIndex) {
        return this.mCursor.getInt(cursorIndex);
    }

    long getLong(int cursorIndex) {
        return this.mCursor.getLong(cursorIndex);
    }

    String getString(int cursorIndex) {
        return this.mCursor.getString(cursorIndex);
    }

    int groupFromChildId(long childId) {
        int group = -1;
        this.mCursor.moveToFirst();
        while (!this.mCursor.isAfterLast()) {
            if (this.getLong(this.mIdIndex) == childId) {
                int bin = this.mDateSorter.getIndex(this.getLong(this.mDateIndex));
                if (5 == this.mNumberOfBins) {
                    return bin;
                }
                group = 0;
                for (int i = 0; i < bin; ++i) {
                    if (this.mItemMap[i] == 0) continue;
                    ++group;
                }
                break;
            }
            this.mCursor.moveToNext();
        }
        return group;
    }

    private int groupPositionToBin(int groupPosition) {
        if (groupPosition < 0 || groupPosition >= 5) {
            throw new AssertionError((Object)"group position out of range");
        }
        if (5 == this.mNumberOfBins || 0 == this.mNumberOfBins) {
            return groupPosition;
        }
        int arrayPosition = -1;
        while (groupPosition > -1) {
            if (this.mItemMap[++arrayPosition] == 0) continue;
            --groupPosition;
        }
        return arrayPosition;
    }

    boolean moveCursorToPackedChildPosition(long packedPosition) {
        if (ExpandableListView.getPackedPositionType((long)packedPosition) != 1) {
            return false;
        }
        int groupPosition = ExpandableListView.getPackedPositionGroup((long)packedPosition);
        int childPosition = ExpandableListView.getPackedPositionChild((long)packedPosition);
        return this.moveCursorToChildPosition(groupPosition, childPosition);
    }

    boolean moveCursorToChildPosition(int groupPosition, int childPosition) {
        if (this.mCursor.isClosed()) {
            return false;
        }
        groupPosition = this.groupPositionToBin(groupPosition);
        int index = childPosition;
        for (int i = 0; i < groupPosition; ++i) {
            index += this.mItemMap[i];
        }
        return this.mCursor.moveToPosition(index);
    }

    void refreshData() {
        if (this.mCursor.isClosed()) {
            return;
        }
        this.mCursor.requery();
        this.buildMap();
        for (DataSetObserver o : this.mObservers) {
            o.onChanged();
        }
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        TextView item;
        if (null == convertView || !(convertView instanceof TextView)) {
            LayoutInflater factory = LayoutInflater.from((Context)this.mContext);
            item = (TextView)factory.inflate(2130903052, null);
        } else {
            item = (TextView)convertView;
        }
        String label = this.mDateSorter.getLabel(this.groupPositionToBin(groupPosition));
        item.setText((CharSequence)label);
        return item;
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        return null;
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return true;
    }

    public int getGroupCount() {
        return this.mNumberOfBins;
    }

    public int getChildrenCount(int groupPosition) {
        return this.mItemMap[this.groupPositionToBin(groupPosition)];
    }

    public Object getGroup(int groupPosition) {
        return null;
    }

    public Object getChild(int groupPosition, int childPosition) {
        return null;
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public long getChildId(int groupPosition, int childPosition) {
        if (this.moveCursorToChildPosition(groupPosition, childPosition)) {
            return this.getLong(this.mIdIndex);
        }
        return 0L;
    }

    public boolean hasStableIds() {
        return true;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mObservers.add(observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mObservers.remove(observer);
    }

    public void onGroupExpanded(int groupPosition) {
    }

    public void onGroupCollapsed(int groupPosition) {
    }

    public long getCombinedChildId(long groupId, long childId) {
        return childId;
    }

    public long getCombinedGroupId(long groupId) {
        return groupId;
    }

    public boolean isEmpty() {
        return this.mCursor.isClosed() || this.mCursor.getCount() == 0;
    }

    private class ChangeObserver
    extends ContentObserver {
        public ChangeObserver() {
            super(new Handler());
        }

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            DateSortedExpandableListAdapter.this.refreshData();
        }
    }
}

