/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceScreen;
import android.webkit.GeolocationPermissions;
import android.webkit.ValueCallback;
import android.webkit.WebStorage;
import com.android.browser.BrowserHomepagePreference;
import com.android.browser.BrowserSettings;
import com.android.browser.WebsiteSettingsActivity;
import java.util.Map;
import java.util.Set;

public class BrowserPreferencesPage
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener {
    private String LOGTAG = "BrowserPreferencesPage";
    static final String CURRENT_PAGE = "currentPage";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2131034114);
        Preference e = this.findPreference("homepage");
        e.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        e.setSummary((CharSequence)this.getPreferenceScreen().getSharedPreferences().getString("homepage", null));
        ((BrowserHomepagePreference)e).setCurrentPage(this.getIntent().getStringExtra(CURRENT_PAGE));
        e = this.findPreference("reset_default_preferences");
        e.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        e = this.findPreference("text_size");
        e.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        e.setSummary(this.getVisualTextSizeName(this.getPreferenceScreen().getSharedPreferences().getString("text_size", null)));
        e = this.findPreference("default_zoom");
        e.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        e.setSummary(this.getVisualDefaultZoomName(this.getPreferenceScreen().getSharedPreferences().getString("default_zoom", null)));
        e = this.findPreference("default_text_encoding");
        e.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        e = this.findPreference("privacy_clear_history");
        e.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        if (BrowserSettings.getInstance().showDebugSettings()) {
            this.addPreferencesFromResource(2131034115);
        }
        PreferenceScreen websiteSettings = (PreferenceScreen)this.findPreference("website_settings");
        Intent intent = new Intent((Context)this, WebsiteSettingsActivity.class);
        websiteSettings.setIntent(intent);
    }

    protected void onResume() {
        super.onResume();
        final PreferenceScreen websiteSettings = (PreferenceScreen)this.findPreference("website_settings");
        websiteSettings.setEnabled(false);
        WebStorage.getInstance().getOrigins((ValueCallback)new ValueCallback<Map>(){

            public void onReceiveValue(Map webStorageOrigins) {
                if (webStorageOrigins != null && !webStorageOrigins.isEmpty()) {
                    websiteSettings.setEnabled(true);
                }
            }
        });
        GeolocationPermissions.getInstance().getOrigins((ValueCallback)new ValueCallback<Set<String>>(){

            public void onReceiveValue(Set<String> geolocationOrigins) {
                if (geolocationOrigins != null && !geolocationOrigins.isEmpty()) {
                    websiteSettings.setEnabled(true);
                }
            }
        });
    }

    protected void onPause() {
        super.onPause();
        BrowserSettings.getInstance().syncSharedPreferences(this.getApplicationContext(), this.getPreferenceScreen().getSharedPreferences());
    }

    public boolean onPreferenceChange(Preference pref, Object objValue) {
        if (pref.getKey().equals("reset_default_preferences")) {
            Boolean value = (Boolean)objValue;
            if (value.booleanValue()) {
                this.finish();
            }
        } else {
            if (pref.getKey().equals("homepage")) {
                boolean needUpdate;
                String value = (String)objValue;
                boolean bl = needUpdate = value.indexOf(32) != -1;
                if (needUpdate) {
                    value = value.trim().replace(" ", "%20");
                }
                if (value.length() != 0 && Uri.parse((String)value).getScheme() == null) {
                    value = "http://" + value;
                    needUpdate = true;
                }
                pref.setSummary((CharSequence)value);
                if (needUpdate) {
                    ((EditTextPreference)pref).setText(value);
                    return false;
                }
                return true;
            }
            if (pref.getKey().equals("text_size")) {
                pref.setSummary(this.getVisualTextSizeName((String)objValue));
                return true;
            }
            if (pref.getKey().equals("default_zoom")) {
                pref.setSummary(this.getVisualDefaultZoomName((String)objValue));
                return true;
            }
            if (pref.getKey().equals("default_text_encoding")) {
                pref.setSummary((CharSequence)((String)objValue));
                return true;
            }
            if (pref.getKey().equals("privacy_clear_history") && ((Boolean)objValue).booleanValue()) {
                this.setResult(-1, new Intent().putExtra("android.intent.extra.TEXT", pref.getKey()));
                return true;
            }
        }
        return false;
    }

    private CharSequence getVisualTextSizeName(String enumName) {
        CharSequence[] enumNames;
        CharSequence[] visualNames = this.getResources().getTextArray(2131099740);
        if (visualNames.length != (enumNames = this.getResources().getTextArray(2131099741)).length) {
            return "";
        }
        for (int i = 0; i < enumNames.length; ++i) {
            if (!enumNames[i].equals(enumName)) continue;
            return visualNames[i];
        }
        return "";
    }

    private CharSequence getVisualDefaultZoomName(String enumName) {
        CharSequence[] enumNames;
        CharSequence[] visualNames = this.getResources().getTextArray(2131099742);
        if (visualNames.length != (enumNames = this.getResources().getTextArray(2131099743)).length) {
            return "";
        }
        for (int i = 0; i < enumNames.length; ++i) {
            if (!enumNames[i].equals(enumName)) continue;
            return visualNames[i];
        }
        return "";
    }
}

