/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.DataSetObserver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.provider.Browser;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebIconDatabase;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.browser.AddNewBookmark;
import com.android.browser.BookmarkItem;
import com.android.browser.BookmarkViewMode;
import com.android.browser.Bookmarks;
import com.android.browser.BrowserBookmarksPage;
import com.android.browser.CombinedBookmarkHistoryActivity;
import com.android.browser.HistoryItem;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

class BrowserBookmarksAdapter
extends BaseAdapter {
    private String mCurrentPage;
    private String mCurrentTitle;
    private Bitmap mCurrentThumbnail;
    private Cursor mCursor;
    private int mCount;
    private BrowserBookmarksPage mBookmarksPage;
    private ContentResolver mContentResolver;
    private boolean mDataValid;
    private BookmarkViewMode mViewMode;
    private boolean mMostVisited;
    private boolean mNeedsOffset;
    private int mExtraOffset;

    public BrowserBookmarksAdapter(BrowserBookmarksPage b, String curPage, String curTitle, Bitmap curThumbnail, boolean createShortcut, boolean mostVisited) {
        this.mNeedsOffset = !createShortcut && !mostVisited;
        this.mMostVisited = mostVisited;
        this.mExtraOffset = this.mNeedsOffset ? 1 : 0;
        this.mBookmarksPage = b;
        this.mCurrentPage = b.getResources().getString(2131230788) + curPage;
        this.mCurrentTitle = curTitle;
        this.mCurrentThumbnail = curThumbnail;
        this.mContentResolver = b.getContentResolver();
        this.mViewMode = BookmarkViewMode.LIST;
        String orderBy = "visits DESC";
        String whereClause = mostVisited ? "visits != 0" : "bookmark = 1";
        this.mCursor = b.managedQuery(Browser.BOOKMARKS_URI, Browser.HISTORY_PROJECTION, whereClause, null, orderBy);
        this.mCursor.registerContentObserver((ContentObserver)new ChangeObserver());
        this.mCursor.registerDataSetObserver((DataSetObserver)new MyDataSetObserver());
        this.mDataValid = true;
        this.notifyDataSetChanged();
        this.mCount = this.mCursor.getCount() + this.mExtraOffset;
    }

    public Bundle getRow(int position) {
        Bundle map = new Bundle();
        if (position < this.mExtraOffset || position >= this.mCount) {
            return map;
        }
        this.mCursor.moveToPosition(position - this.mExtraOffset);
        String url = this.mCursor.getString(1);
        map.putString("title", this.mCursor.getString(5));
        map.putString("url", url);
        byte[] data = this.mCursor.getBlob(6);
        if (data != null) {
            map.putParcelable("favicon", (Parcelable)BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length));
        }
        map.putInt("id", this.mCursor.getInt(0));
        return map;
    }

    public void updateRow(Bundle map) {
        String url;
        int id2 = map.getInt("id");
        int position = -1;
        this.mCursor.moveToFirst();
        while (!this.mCursor.isAfterLast()) {
            if (this.mCursor.getInt(0) == id2) {
                position = this.mCursor.getPosition();
                break;
            }
            this.mCursor.moveToNext();
        }
        if (position < 0) {
            return;
        }
        this.mCursor.moveToPosition(position);
        ContentValues values = new ContentValues();
        String title = map.getString("title");
        if (!title.equals(this.mCursor.getString(5))) {
            values.put("title", title);
        }
        if (!(url = map.getString("url")).equals(this.mCursor.getString(1))) {
            values.put("url", url);
        }
        if (map.getBoolean("invalidateThumbnail")) {
            values.put("thumbnail", new byte[0]);
        }
        if (values.size() > 0 && this.mContentResolver.update(Browser.BOOKMARKS_URI, values, "_id = " + id2, null) != -1) {
            this.refreshList();
        }
    }

    public void deleteRow(int position) {
        if (position < this.mExtraOffset || position >= this.getCount()) {
            return;
        }
        this.mCursor.moveToPosition(position - this.mExtraOffset);
        String url = this.mCursor.getString(1);
        String title = this.mCursor.getString(5);
        Bookmarks.removeFromBookmarks(null, this.mContentResolver, url, title);
        this.refreshList();
    }

    public void deleteAllRows() {
        StringBuilder deleteIds = null;
        StringBuilder convertIds = null;
        this.mCursor.moveToFirst();
        while (!this.mCursor.isAfterLast()) {
            String url = this.mCursor.getString(1);
            WebIconDatabase.getInstance().releaseIconForPageUrl(url);
            int id2 = this.mCursor.getInt(0);
            int numVisits = this.mCursor.getInt(2);
            if (0 == numVisits) {
                if (deleteIds == null) {
                    deleteIds = new StringBuilder();
                    deleteIds.append("( ");
                } else {
                    deleteIds.append(" OR ( ");
                }
                deleteIds.append("_id");
                deleteIds.append(" = ");
                deleteIds.append(id2);
                deleteIds.append(" )");
            } else {
                if (convertIds == null) {
                    convertIds = new StringBuilder();
                    convertIds.append("( ");
                } else {
                    convertIds.append(" OR ( ");
                }
                convertIds.append("_id");
                convertIds.append(" = ");
                convertIds.append(id2);
                convertIds.append(" )");
            }
            this.mCursor.moveToNext();
        }
        if (deleteIds != null) {
            this.mContentResolver.delete(Browser.BOOKMARKS_URI, deleteIds.toString(), null);
        }
        if (convertIds != null) {
            ContentValues values = new ContentValues();
            values.put("bookmark", Integer.valueOf(0));
            this.mContentResolver.update(Browser.BOOKMARKS_URI, values, convertIds.toString(), null);
        }
        this.refreshList();
    }

    public void refreshList() {
        this.mCursor.requery();
        this.mCount = this.mCursor.getCount() + this.mExtraOffset;
        this.notifyDataSetChanged();
    }

    static void updateBookmarkFavicon(final ContentResolver cr, final String originalUrl, final String url, final Bitmap favicon) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... unused) {
                Cursor c = BrowserBookmarksAdapter.queryBookmarksForUrl(cr, originalUrl, url, true);
                if (c == null) {
                    return null;
                }
                if (c.moveToFirst()) {
                    ContentValues values = new ContentValues();
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    favicon.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
                    values.put("favicon", os.toByteArray());
                    do {
                        cr.update(ContentUris.withAppendedId((Uri)Browser.BOOKMARKS_URI, (long)c.getInt(0)), values, null, null);
                    } while (c.moveToNext());
                }
                c.close();
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    static Cursor queryBookmarksForUrl(ContentResolver cr, String originalUrl, String url, boolean onlyBookmarks) {
        if (cr == null || url == null) {
            return null;
        }
        if (originalUrl == null) {
            originalUrl = url;
        }
        String originalUrlNoQuery = BrowserBookmarksAdapter.removeQuery(originalUrl);
        String urlNoQuery = BrowserBookmarksAdapter.removeQuery(url);
        originalUrl = originalUrlNoQuery + '?';
        url = urlNoQuery + '?';
        String[] selArgs = new String[]{originalUrlNoQuery, urlNoQuery, originalUrl, url};
        String where = "url == ? OR url == ? OR url LIKE ? || '%' OR url LIKE ? || '%'";
        if (onlyBookmarks) {
            where = "(" + where + ") AND " + "bookmark" + " == 1";
        }
        String[] projection = new String[]{"_id"};
        return cr.query(Browser.BOOKMARKS_URI, projection, where, selArgs, null);
    }

    private static String removeQuery(String url) {
        if (url == null) {
            return null;
        }
        int query = url.indexOf(63);
        String noQuery = url;
        if (query != -1) {
            noQuery = url.substring(0, query);
        }
        return noQuery;
    }

    public int getCount() {
        if (this.mDataValid) {
            return this.mCount;
        }
        return 0;
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int position) {
        return true;
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    void switchViewMode(BookmarkViewMode viewMode) {
        this.mViewMode = viewMode;
    }

    void populateBookmarkItem(BookmarkItem b, int position) {
        this.mCursor.moveToPosition(position - this.mExtraOffset);
        String url = this.mCursor.getString(1);
        b.setUrl(url);
        b.setName(this.mCursor.getString(5));
        byte[] data = this.mCursor.getBlob(6);
        Bitmap bitmap = null;
        bitmap = data == null ? CombinedBookmarkHistoryActivity.getIconListenerSet().getFavicon(url) : BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        b.setFavicon(bitmap);
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (!this.mDataValid) {
            throw new IllegalStateException("this should only be called when the cursor is valid");
        }
        if (position < 0 || position > this.mCount) {
            throw new AssertionError((Object)"BrowserBookmarksAdapter tried to get a view out of range");
        }
        if (this.mViewMode == BookmarkViewMode.GRID) {
            if (convertView == null || convertView instanceof AddNewBookmark || convertView instanceof BookmarkItem) {
                LayoutInflater factory = LayoutInflater.from((Context)this.mBookmarksPage);
                convertView = factory.inflate(2130903042, null);
            }
            View holder = convertView.findViewById(2131492869);
            ImageView thumb = (ImageView)convertView.findViewById(2131492868);
            TextView tv = (TextView)convertView.findViewById(2131492870);
            if (0 == position && this.mNeedsOffset) {
                holder.setVisibility(0);
                tv.setText((CharSequence)this.mCurrentTitle);
                if (this.mCurrentThumbnail != null) {
                    thumb.setImageBitmap(this.mCurrentThumbnail);
                } else {
                    thumb.setImageResource(2130837510);
                }
                return convertView;
            }
            holder.setVisibility(8);
            this.mCursor.moveToPosition(position - this.mExtraOffset);
            tv.setText((CharSequence)this.mCursor.getString(5));
            Bitmap thumbnail = this.getScreenshot(position);
            if (thumbnail == null) {
                thumb.setImageResource(2130837510);
            } else {
                thumb.setImageBitmap(thumbnail);
            }
            return convertView;
        }
        if (position == 0 && this.mNeedsOffset) {
            AddNewBookmark b = convertView instanceof AddNewBookmark ? (AddNewBookmark)((Object)convertView) : new AddNewBookmark((Context)this.mBookmarksPage);
            b.setUrl(this.mCurrentPage);
            return b;
        }
        if (this.mMostVisited) {
            if (convertView == null || !(convertView instanceof HistoryItem)) {
                convertView = new HistoryItem((Context)this.mBookmarksPage);
            }
        } else if (convertView == null || !(convertView instanceof BookmarkItem)) {
            convertView = new BookmarkItem((Context)this.mBookmarksPage);
        }
        this.bind((BookmarkItem)((Object)convertView), position);
        if (this.mMostVisited) {
            ((HistoryItem)((Object)convertView)).setIsBookmark(this.getIsBookmark(position));
        }
        return convertView;
    }

    public String getTitle(int position) {
        return this.getString(5, position);
    }

    public String getUrl(int position) {
        return this.getString(1, position);
    }

    public Bitmap getScreenshot(int position) {
        return this.getBitmap(7, position);
    }

    public Bitmap getFavicon(int position) {
        return this.getBitmap(6, position);
    }

    public Bitmap getTouchIcon(int position) {
        return this.getBitmap(8, position);
    }

    private Bitmap getBitmap(int cursorIndex, int position) {
        if (position < this.mExtraOffset || position > this.mCount) {
            return null;
        }
        this.mCursor.moveToPosition(position - this.mExtraOffset);
        byte[] data = this.mCursor.getBlob(cursorIndex);
        if (data == null) {
            return null;
        }
        return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
    }

    public boolean getIsBookmark(int position) {
        if (position < this.mExtraOffset || position > this.mCount) {
            return false;
        }
        this.mCursor.moveToPosition(position - this.mExtraOffset);
        return 1 == this.mCursor.getInt(4);
    }

    private String getString(int cursorIndex, int position) {
        if (position < this.mExtraOffset || position > this.mCount) {
            return "";
        }
        this.mCursor.moveToPosition(position - this.mExtraOffset);
        return this.mCursor.getString(cursorIndex);
    }

    private void bind(BookmarkItem b, int position) {
        this.mCursor.moveToPosition(position - this.mExtraOffset);
        b.setName(this.mCursor.getString(5));
        String url = this.mCursor.getString(1);
        b.setUrl(url);
        byte[] data = this.mCursor.getBlob(6);
        if (data != null) {
            b.setFavicon(BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length));
        } else {
            b.setFavicon(CombinedBookmarkHistoryActivity.getIconListenerSet().getFavicon(url));
        }
    }

    private class MyDataSetObserver
    extends DataSetObserver {
        private MyDataSetObserver() {
        }

        public void onChanged() {
            BrowserBookmarksAdapter.this.mDataValid = true;
            BrowserBookmarksAdapter.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            BrowserBookmarksAdapter.this.mDataValid = false;
            BrowserBookmarksAdapter.this.notifyDataSetInvalidated();
        }
    }

    private class ChangeObserver
    extends ContentObserver {
        public ChangeObserver() {
            super(new Handler(Looper.getMainLooper()));
        }

        public boolean deliverSelfNotifications() {
            return true;
        }

        public void onChange(boolean selfChange) {
            BrowserBookmarksAdapter.this.refreshList();
        }
    }
}

