/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.app.SearchManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.ParseException;
import android.net.Uri;
import android.net.WebAddress;
import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Browser;
import android.provider.Downloads;
import android.text.IClipboard;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.Log;
import android.util.Patterns;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.DownloadListener;
import android.webkit.HttpAuthHandler;
import android.webkit.PluginManager;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebIconDatabase;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.android.browser.ActiveTabsPage;
import com.android.browser.AddBookmarkPage;
import com.android.browser.Bookmarks;
import com.android.browser.BrowserBookmarksAdapter;
import com.android.browser.BrowserPreferencesPage;
import com.android.browser.BrowserProvider;
import com.android.browser.BrowserSettings;
import com.android.browser.CombinedBookmarkHistoryActivity;
import com.android.browser.ErrorConsoleView;
import com.android.browser.FetchUrlMimeType;
import com.android.browser.FindDialog;
import com.android.browser.MeshTracker;
import com.android.browser.OpenDownloadReceiver;
import com.android.browser.SelectDialog;
import com.android.browser.SystemAllowGeolocationOrigins;
import com.android.browser.Tab;
import com.android.browser.TabControl;
import com.android.browser.TitleBar;
import com.android.browser.UrlUtils;
import com.android.browser.WebDialog;
import com.android.browser.search.SearchEngine;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserActivity
extends Activity
implements View.OnCreateContextMenuListener,
DownloadListener {
    private static final boolean DEBUG = false;
    private static final boolean LOGV_ENABLED = false;
    private static final boolean LOGD_ENABLED = true;
    private FrameLayout mBrowserFrameLayout;
    private TitleBar mFakeTitleBar;
    private boolean mOptionsMenuOpen;
    private boolean mConfigChanged;
    private boolean mIconView;
    private ActiveTabsPage mActiveTabsPage;
    public static final int LOAD_URL = 1001;
    public static final int STOP_LOAD = 1002;
    private static final int FOCUS_NODE_HREF = 102;
    private static final int RELEASE_WAKELOCK = 107;
    static final int UPDATE_BOOKMARK_THUMBNAIL = 108;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 102: {
                    String url = (String)msg.getData().get("url");
                    String title = (String)msg.getData().get("title");
                    if (url == null || url.length() == 0) break;
                    HashMap focusNodeMap = (HashMap)msg.obj;
                    WebView view = (WebView)focusNodeMap.get("webview");
                    if (BrowserActivity.this.getTopWindow() != view) break;
                    switch (msg.arg1) {
                        case 2131492959: 
                        case 2131493017: {
                            BrowserActivity.this.loadUrlFromContext(BrowserActivity.this.getTopWindow(), url);
                            break;
                        }
                        case 2131493011: {
                            Tab parent = BrowserActivity.this.mTabControl.getCurrentTab();
                            Tab newTab = BrowserActivity.this.openTab(url);
                            if (newTab == parent) break;
                            parent.addChildTab(newTab);
                            break;
                        }
                        case 2131493012: {
                            Intent intent = new Intent((Context)BrowserActivity.this, AddBookmarkPage.class);
                            intent.putExtra("url", url);
                            intent.putExtra("title", title);
                            BrowserActivity.this.startActivity(intent);
                            break;
                        }
                        case 2131492963: {
                            StringBuilder sb = new StringBuilder("url = ");
                            DatabaseUtils.appendEscapedSQLString((StringBuilder)sb, (String)url);
                            Cursor c = BrowserActivity.this.mResolver.query(Browser.BOOKMARKS_URI, Browser.HISTORY_PROJECTION, sb.toString(), null, null);
                            if (c.moveToFirst()) {
                                Bitmap favicon = null;
                                Bitmap thumbnail = null;
                                String linkTitle = c.getString(5);
                                byte[] data = c.getBlob(6);
                                if (data != null) {
                                    favicon = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                                }
                                if ((data = c.getBlob(7)) != null) {
                                    thumbnail = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
                                }
                                BrowserActivity.sharePage((Context)BrowserActivity.this, linkTitle, url, favicon, thumbnail);
                                break;
                            }
                            Browser.sendString((Context)BrowserActivity.this, (String)url, (String)BrowserActivity.this.getString(2131230816));
                            break;
                        }
                        case 2131493014: {
                            BrowserActivity.this.copy(url);
                            break;
                        }
                        case 2131493013: 
                        case 2131493016: {
                            BrowserActivity.this.onDownloadStartNoStream(url, null, null, null, -1L);
                        }
                    }
                    break;
                }
                case 1001: {
                    BrowserActivity.this.loadUrlFromContext(BrowserActivity.this.getTopWindow(), (String)msg.obj);
                    break;
                }
                case 1002: {
                    BrowserActivity.this.stopLoading();
                    break;
                }
                case 107: {
                    if (!BrowserActivity.this.mWakeLock.isHeld()) break;
                    BrowserActivity.this.mWakeLock.release();
                    BrowserActivity.this.mTabControl.stopAllLoading();
                    break;
                }
                case 108: {
                    WebView view = (WebView)msg.obj;
                    if (view == null) break;
                    BrowserActivity.this.updateScreenshot(view);
                }
            }
        }
    };
    private static int THUMBNAIL_WIDTH = 0;
    private static int THUMBNAIL_HEIGHT = 0;
    static final String SCHEME_WTAI = "wtai://wp/";
    static final String SCHEME_WTAI_MC = "wtai://wp/mc;";
    static final String SCHEME_WTAI_SD = "wtai://wp/sd;";
    static final String SCHEME_WTAI_AP = "wtai://wp/ap;";
    private static final int INITIAL_PROGRESS = 10;
    private ValueCallback<Uri> mUploadMessage;
    protected static final Pattern ACCEPTED_URI_SCHEMA = Pattern.compile("(?i)((?:http|https|file):\\/\\/|(?:inline|data|about|javascript):)(.*)");
    static final int LOCK_ICON_UNSECURE = 0;
    static final int LOCK_ICON_SECURE = 1;
    static final int LOCK_ICON_MIXED = 2;
    private BrowserSettings mSettings;
    private TabControl mTabControl;
    private ContentResolver mResolver;
    private FrameLayout mContentView;
    private View mCustomView;
    private FrameLayout mCustomViewContainer;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private int mCurrentMenuState = 0;
    private int mMenuState = 2131492967;
    private int mOldMenuState = -1;
    private static final int EMPTY_MENU = -1;
    private Menu mMenu;
    private FindDialog mFindDialog;
    private SelectDialog mSelectDialog;
    boolean mCanChord;
    private boolean mInLoad;
    private boolean mIsNetworkUp;
    private boolean mDidStopLoad;
    boolean mActivityInPause = true;
    private boolean mMenuIsDown;
    private static boolean mInTrace;
    private static final int[] SYSTEM_CPU_FORMAT;
    private long mStart;
    private long mProcessStart;
    private long mUserStart;
    private long mSystemStart;
    private long mIdleStart;
    private long mIrqStart;
    private long mUiStart;
    private Drawable mMixLockIcon;
    private Drawable mSecLockIcon;
    private AlertDialog mAlertDialog;
    private String mUrl;
    private String mTitle;
    private AlertDialog mPageInfoDialog;
    private Tab mPageInfoView;
    private boolean mPageInfoFromShowSSLCertificateOnError;
    private AlertDialog mSSLCertificateOnErrorDialog;
    private WebView mSSLCertificateOnErrorView;
    private SslErrorHandler mSSLCertificateOnErrorHandler;
    private SslError mSSLCertificateOnErrorError;
    private AlertDialog mSSLCertificateDialog;
    private Tab mSSLCertificateView;
    private AlertDialog mHttpAuthenticationDialog;
    private HttpAuthHandler mHttpAuthHandler;
    static final FrameLayout.LayoutParams COVER_SCREEN_PARAMS;
    static final FrameLayout.LayoutParams COVER_SCREEN_GRAVITY_CENTER;
    static final String QuickSearch_G = "http://www.google.com/m?q=%s";
    static final String QUERY_PLACE_HOLDER = "%s";
    static final String GOOGLE_SEARCH_SOURCE_SEARCHKEY = "browser-key";
    static final String GOOGLE_SEARCH_SOURCE_GOTO = "browser-goto";
    static final String GOOGLE_SEARCH_SOURCE_TYPE = "browser-type";
    static final String GOOGLE_SEARCH_SOURCE_SUGGEST = "browser-suggest";
    static final String GOOGLE_SEARCH_SOURCE_UNKNOWN = "unknown";
    private static final String LOGTAG = "browser";
    private String mLastEnteredUrl;
    private PowerManager.WakeLock mWakeLock;
    private static final int WAKELOCK_TIMEOUT = 300000;
    private Toast mStopToast;
    private TitleBar mTitleBar;
    private LinearLayout mErrorConsoleContainer = null;
    private boolean mShouldShowErrorConsole = false;
    private static final int[] WINDOW_SHORTCUT_ID_ARRAY;
    private IntentFilter mNetworkStateChangedFilter;
    private BroadcastReceiver mNetworkStateIntentReceiver;
    private BroadcastReceiver mPackageInstallationReceiver;
    private SystemAllowGeolocationOrigins mSystemAllowGeolocationOrigins;
    static final int COMBO_PAGE = 1;
    static final int PREFERENCES_PAGE = 3;
    static final int FILE_SELECTED = 4;
    private Bitmap mDefaultVideoPoster;
    private View mVideoProgressView;
    private static Set<String> sGoogleApps;
    static final UrlData EMPTY_URL_DATA;

    public void onCreate(Bundle icicle) {
        String jsFlags;
        super.onCreate(icicle);
        this.setDefaultKeyMode(3);
        this.mResolver = this.getContentResolver();
        this.mSettings = BrowserSettings.getInstance();
        this.mSettings.updateRlzValues((Context)this);
        if (this.handleWebSearchIntent(this.getIntent())) {
            this.finish();
            return;
        }
        this.mSecLockIcon = Resources.getSystem().getDrawable(17301601);
        this.mMixLockIcon = Resources.getSystem().getDrawable(17301596);
        FrameLayout frameLayout = (FrameLayout)this.getWindow().getDecorView().findViewById(0x1020002);
        this.mBrowserFrameLayout = (FrameLayout)LayoutInflater.from((Context)this).inflate(2130903048, null);
        this.mContentView = (FrameLayout)this.mBrowserFrameLayout.findViewById(2131492897);
        this.mErrorConsoleContainer = (LinearLayout)this.mBrowserFrameLayout.findViewById(2131492896);
        this.mCustomViewContainer = (FrameLayout)this.mBrowserFrameLayout.findViewById(2131492895);
        frameLayout.addView((View)this.mBrowserFrameLayout, (ViewGroup.LayoutParams)COVER_SCREEN_PARAMS);
        this.mTitleBar = new TitleBar(this);
        this.mTitleBar.setProgress(100);
        this.mFakeTitleBar = new TitleBar(this);
        this.mTabControl = new TabControl(this);
        this.retainIconsOnStartup();
        this.mSettings.setTabControl(this.mTabControl);
        PowerManager pm = (PowerManager)this.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "Browser");
        ConnectivityManager cm = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo info = cm.getActiveNetworkInfo();
        if (info != null) {
            this.mIsNetworkUp = info.isAvailable();
        }
        this.mNetworkStateChangedFilter = new IntentFilter();
        this.mNetworkStateChangedFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mNetworkStateIntentReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                    NetworkInfo info = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    String typeName = info.getTypeName();
                    String subtypeName = info.getSubtypeName();
                    BrowserActivity.this.sendNetworkType(typeName.toLowerCase(), subtypeName != null ? subtypeName.toLowerCase() : "");
                    BrowserActivity.this.onNetworkToggle(info.isAvailable());
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addDataScheme("package");
        this.mPackageInstallationReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                String packageName = intent.getData().getSchemeSpecificPart();
                boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                if ("android.intent.action.PACKAGE_REMOVED".equals(action) && replacing) {
                    return;
                }
                if (sGoogleApps.contains(packageName)) {
                    BrowserActivity.this.packageChanged(packageName, "android.intent.action.PACKAGE_ADDED".equals(action));
                }
                PackageManager pm = BrowserActivity.this.getPackageManager();
                PackageInfo pkgInfo = null;
                try {
                    pkgInfo = pm.getPackageInfo(packageName, 4096);
                }
                catch (PackageManager.NameNotFoundException e) {
                    return;
                }
                if (pkgInfo != null) {
                    String[] permissions = pkgInfo.requestedPermissions;
                    if (permissions == null) {
                        return;
                    }
                    boolean permissionOk = false;
                    for (String permit : permissions) {
                        if (!"android.webkit.permission.PLUGIN".equals(permit)) continue;
                        permissionOk = true;
                        break;
                    }
                    if (permissionOk) {
                        PluginManager.getInstance((Context)BrowserActivity.this).refreshPlugins("android.intent.action.PACKAGE_ADDED".equals(action));
                    }
                }
            }
        };
        this.registerReceiver(this.mPackageInstallationReceiver, filter);
        if (!this.mTabControl.restoreState(icicle)) {
            int scale;
            new ClearThumbnails().execute(this.mTabControl.getThumbnailDir().listFiles());
            CookieManager.getInstance().removeSessionCookie();
            Intent intent = this.getIntent();
            Bundle extra = intent.getExtras();
            UrlData urlData = this.getUrlDataFromIntent(intent);
            String action = intent.getAction();
            Tab t = this.mTabControl.createNewTab("android.intent.action.VIEW".equals(action) && intent.getData() != null || "android.speech.action.VOICE_SEARCH_RESULTS".equals(action), intent.getStringExtra("com.android.browser.application_id"), urlData.mUrl);
            this.mTabControl.setCurrentTab(t);
            this.attachTabToContentView(t);
            WebView webView = t.getWebView();
            if (extra != null && (scale = extra.getInt("browser.initialZoomLevel", 0)) > 0 && scale <= 1000) {
                webView.setInitialScale(scale);
            }
            if (urlData.isEmpty()) {
                this.loadUrl(webView, this.mSettings.getHomePage());
            } else {
                this.loadUrlDataIn(t, urlData);
            }
        } else {
            this.attachTabToContentView(this.mTabControl.getCurrentTab());
        }
        File dir = this.mTabControl.getThumbnailDir();
        if (dir.exists()) {
            for (String child : dir.list()) {
                File f = new File(dir, child);
                f.delete();
            }
        }
        if ((jsFlags = this.mSettings.getJsFlags()).trim().length() != 0) {
            this.mTabControl.getCurrentWebView().setJsFlags(jsFlags);
        }
        this.getInstalledPackages();
        this.mSystemAllowGeolocationOrigins = new SystemAllowGeolocationOrigins(this.getApplicationContext());
        this.mSystemAllowGeolocationOrigins.start();
    }

    void showVoiceSearchResults(String result) {
        ContentProviderClient client = this.mResolver.acquireContentProviderClient(Browser.BOOKMARKS_URI);
        ContentProvider prov = client.getLocalContentProvider();
        BrowserProvider bp = (BrowserProvider)prov;
        bp.setQueryResults(this.mTabControl.getCurrentTab().getVoiceSearchResults());
        client.release();
        Bundle bundle = this.createGoogleSearchSourceBundle(GOOGLE_SEARCH_SOURCE_SEARCHKEY);
        bundle.putBoolean("android.search.CONTEXT_IS_VOICE", true);
        this.startSearch(result, false, bundle, false);
    }

    protected void onNewIntent(Intent intent) {
        Tab current = this.mTabControl.getCurrentTab();
        if (current == null) {
            current = this.mTabControl.getTab(0);
            if (current == null) {
                return;
            }
            this.mTabControl.setCurrentTab(current);
            this.attachTabToContentView(current);
            this.resetTitleAndIcon(current.getWebView());
        }
        String action = intent.getAction();
        int flags = intent.getFlags();
        if ("android.intent.action.MAIN".equals(action) || (flags & 0x100000) != 0) {
            return;
        }
        ((SearchManager)this.getSystemService("search")).stopSearch();
        boolean activateVoiceSearch = "android.speech.action.VOICE_SEARCH_RESULTS".equals(action);
        if ("android.intent.action.VIEW".equals(action) || "android.intent.action.SEARCH".equals(action) || "android.intent.action.MEDIA_SEARCH".equals(action) || "android.intent.action.WEB_SEARCH".equals(action) || activateVoiceSearch) {
            if (current.isInVoiceSearchMode()) {
                String title = current.getVoiceDisplayTitle();
                if (title != null && title.equals(intent.getStringExtra("query"))) {
                    return;
                }
                if ("android.intent.action.SEARCH".equals(action) && current.voiceSearchSourceIsGoogle()) {
                    Intent logIntent = new Intent("com.android.common.speech.LOG_EVENT");
                    logIntent.putExtra("extra_event", 3);
                    logIntent.putExtra("value", intent.getDataString());
                    this.sendBroadcast(logIntent);
                }
            }
            if (this.handleWebSearchIntent(intent)) {
                return;
            }
            UrlData urlData = this.getUrlDataFromIntent(intent);
            if (urlData.isEmpty()) {
                urlData = new UrlData(this.mSettings.getHomePage());
            }
            String appId = intent.getStringExtra("com.android.browser.application_id");
            if (!TextUtils.isEmpty((CharSequence)urlData.mUrl) && urlData.mUrl.startsWith("javascript:")) {
                this.openTabAndShow(urlData, true, appId);
                return;
            }
            if (("android.intent.action.VIEW".equals(action) || activateVoiceSearch && appId != null) && !this.getPackageName().equals(appId) && (flags & 0x400000) != 0) {
                Tab appTab = this.mTabControl.getTabFromId(appId);
                if (appTab != null) {
                    Log.i((String)LOGTAG, (String)("Reusing tab for " + appId));
                    this.dismissSubWindow(appTab);
                    this.removeTabFromContentView(appTab);
                    boolean needsLoad = this.mTabControl.recreateWebView(appTab, urlData);
                    if (current != appTab) {
                        this.switchToTab(this.mTabControl.getTabIndex(appTab));
                        if (needsLoad) {
                            this.loadUrlDataIn(appTab, urlData);
                        }
                    } else {
                        this.attachTabToContentView(appTab);
                        if (needsLoad) {
                            this.loadUrlDataIn(appTab, urlData);
                        }
                    }
                    return;
                }
                appTab = this.mTabControl.findUnusedTabWithUrl(urlData.mUrl);
                if (appTab != null) {
                    if (current != appTab) {
                        this.switchToTab(this.mTabControl.getTabIndex(appTab));
                    }
                } else {
                    this.openTabAndShow(urlData, true, appId);
                }
            } else {
                if (!urlData.isEmpty() && urlData.mUrl.startsWith("about:debug")) {
                    if ("about:debug.dom".equals(urlData.mUrl)) {
                        current.getWebView().dumpDomTree(false);
                    } else if ("about:debug.dom.file".equals(urlData.mUrl)) {
                        current.getWebView().dumpDomTree(true);
                    } else if ("about:debug.render".equals(urlData.mUrl)) {
                        current.getWebView().dumpRenderTree(false);
                    } else if ("about:debug.render.file".equals(urlData.mUrl)) {
                        current.getWebView().dumpRenderTree(true);
                    } else if ("about:debug.display".equals(urlData.mUrl)) {
                        current.getWebView().dumpDisplayTree();
                    } else if (urlData.mUrl.startsWith("about:debug.drag")) {
                        int index = urlData.mUrl.codePointAt(16) - 48;
                        if (index <= 0 || index > 9) {
                            current.getWebView().setDragTracker(null);
                        } else {
                            current.getWebView().setDragTracker((WebView.DragTracker)new MeshTracker(index));
                        }
                    } else {
                        this.mSettings.toggleDebugSettings();
                    }
                    return;
                }
                this.dismissSubWindow(current);
                current.setAppId(null);
                this.loadUrlDataIn(current, urlData);
            }
        }
    }

    private boolean handleWebSearchIntent(Intent intent) {
        if (intent == null) {
            return false;
        }
        String url = null;
        String action = intent.getAction();
        if ("android.speech.action.VOICE_SEARCH_RESULTS".equals(action)) {
            return false;
        }
        if ("android.intent.action.VIEW".equals(action)) {
            Uri data = intent.getData();
            if (data != null) {
                url = data.toString();
            }
        } else if ("android.intent.action.SEARCH".equals(action) || "android.intent.action.MEDIA_SEARCH".equals(action) || "android.intent.action.WEB_SEARCH".equals(action)) {
            url = intent.getStringExtra("query");
        }
        return this.handleWebSearchRequest(url, intent.getBundleExtra("app_data"), intent.getStringExtra("intent_extra_data_key"));
    }

    private boolean handleWebSearchRequest(String inUrl, Bundle appData, String extraData) {
        if (inUrl == null) {
            return false;
        }
        String url = BrowserActivity.fixUrl(inUrl).trim();
        if (Patterns.WEB_URL.matcher(url).matches() || ACCEPTED_URI_SCHEMA.matcher(url).matches()) {
            return false;
        }
        final ContentResolver cr = this.mResolver;
        final String newUrl = url;
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... unused) {
                Browser.updateVisitedHistory((ContentResolver)cr, (String)newUrl, (boolean)false);
                Browser.addSearchUrl((ContentResolver)cr, (String)newUrl);
                return null;
            }
        }.execute((Object[])new Void[0]);
        SearchEngine searchEngine = this.mSettings.getSearchEngine();
        if (searchEngine == null) {
            return false;
        }
        searchEngine.startSearch((Context)this, url, appData, extraData);
        return true;
    }

    private UrlData getUrlDataFromIntent(Intent intent) {
        String url = "";
        HashMap<String, String> headers = null;
        if (intent != null) {
            String action = intent.getAction();
            if ("android.intent.action.VIEW".equals(action)) {
                url = this.smartUrlFilter(intent.getData());
                if (url != null && url.startsWith("http")) {
                    Bundle pairs = intent.getBundleExtra("com.android.browser.headers");
                    if (pairs != null && !pairs.isEmpty()) {
                        Iterator iter = pairs.keySet().iterator();
                        headers = new HashMap<String, String>();
                        while (iter.hasNext()) {
                            String key = (String)iter.next();
                            headers.put(key, pairs.getString(key));
                        }
                    }
                    String appId = intent.getStringExtra("com.android.browser.application_id");
                    if (this.getPackageName().equals(appId)) {
                        String rlz = this.mSettings.getRlzValue();
                        Uri uri = Uri.parse((String)url);
                        if (!rlz.isEmpty() && BrowserActivity.needsRlz(uri)) {
                            Uri rlzUri = BrowserActivity.addRlzParameter(uri, rlz);
                            url = rlzUri.toString();
                        }
                    }
                }
            } else if (("android.intent.action.SEARCH".equals(action) || "android.intent.action.MEDIA_SEARCH".equals(action) || "android.intent.action.WEB_SEARCH".equals(action)) && (url = intent.getStringExtra("query")) != null) {
                this.mLastEnteredUrl = url;
                url = BrowserActivity.fixUrl(url);
                url = this.smartUrlFilter(url);
                final ContentResolver cr = this.mResolver;
                final String newUrl = url;
                new AsyncTask<Void, Void, Void>(){

                    protected Void doInBackground(Void ... unused) {
                        Browser.updateVisitedHistory((ContentResolver)cr, (String)newUrl, (boolean)false);
                        return null;
                    }
                }.execute((Object[])new Void[0]);
                String searchSource = "&source=android-browser-suggest&";
                if (url.contains(searchSource)) {
                    String source = null;
                    Bundle appData = intent.getBundleExtra("app_data");
                    if (appData != null) {
                        source = appData.getString("source");
                    }
                    if (TextUtils.isEmpty(source)) {
                        source = GOOGLE_SEARCH_SOURCE_UNKNOWN;
                    }
                    url = url.replace(searchSource, "&source=android-" + source + "&");
                }
            }
        }
        return new UrlData(url, headers, intent);
    }

    void showVoiceTitleBar(String title) {
        this.mTitleBar.setInVoiceMode(true);
        this.mFakeTitleBar.setInVoiceMode(true);
        this.mTitleBar.setDisplayTitle(title);
        this.mFakeTitleBar.setDisplayTitle(title);
    }

    void revertVoiceTitleBar() {
        this.mTitleBar.setInVoiceMode(false);
        this.mFakeTitleBar.setInVoiceMode(false);
        this.mTitleBar.setDisplayTitle(this.mUrl);
        this.mFakeTitleBar.setDisplayTitle(this.mUrl);
    }

    static String fixUrl(String inUrl) {
        char ch;
        int colon = inUrl.indexOf(58);
        boolean allLower = true;
        for (int index = 0; index < colon && Character.isLetter(ch = inUrl.charAt(index)); ++index) {
            if (index != colon - 1 || (allLower &= Character.isLowerCase(ch))) continue;
            inUrl = inUrl.substring(0, colon).toLowerCase() + inUrl.substring(colon);
        }
        if (inUrl.startsWith("http://") || inUrl.startsWith("https://")) {
            return inUrl;
        }
        if (inUrl.startsWith("http:") || inUrl.startsWith("https:")) {
            inUrl = inUrl.startsWith("http:/") || inUrl.startsWith("https:/") ? inUrl.replaceFirst("/", "//") : inUrl.replaceFirst(":", "://");
        }
        return inUrl;
    }

    protected void onResume() {
        super.onResume();
        if (!this.mActivityInPause) {
            Log.e((String)LOGTAG, (String)"BrowserActivity is already resumed.");
            return;
        }
        this.mTabControl.resumeCurrentTab();
        this.mActivityInPause = false;
        this.resumeWebViewTimers();
        if (this.mWakeLock.isHeld()) {
            this.mHandler.removeMessages(107);
            this.mWakeLock.release();
        }
        this.registerReceiver(this.mNetworkStateIntentReceiver, this.mNetworkStateChangedFilter);
        WebView.enablePlatformNotifications();
    }

    public boolean onMenuOpened(int featureId, Menu menu2) {
        if (0 == featureId) {
            if (this.mOptionsMenuOpen) {
                if (this.mConfigChanged) {
                    this.mConfigChanged = false;
                } else if (this.mIconView) {
                    this.hideFakeTitleBar();
                    this.mIconView = false;
                } else {
                    this.showFakeTitleBar();
                    this.mIconView = true;
                }
            } else {
                this.showFakeTitleBar();
                this.mOptionsMenuOpen = true;
                this.mConfigChanged = false;
                this.mIconView = true;
            }
        }
        return true;
    }

    private void showFakeTitleBar() {
        if (this.mFakeTitleBar.getParent() == null && this.mActiveTabsPage == null && !this.mActivityInPause) {
            WebView mainView = this.mTabControl.getCurrentWebView();
            if (mainView == null) {
                return;
            }
            if (this.dialogIsUp()) {
                return;
            }
            WindowManager manager = (WindowManager)this.getSystemService("window");
            WindowManager.LayoutParams params = new WindowManager.LayoutParams(-1, -2, 2, 8, -3);
            params.gravity = 48;
            boolean atTop = mainView.getScrollY() == 0;
            params.windowAnimations = atTop ? 0 : 2131361794;
            manager.addView((View)this.mFakeTitleBar, (ViewGroup.LayoutParams)params);
        }
    }

    public void onOptionsMenuClosed(Menu menu2) {
        this.mOptionsMenuOpen = false;
        if (!this.mInLoad) {
            this.hideFakeTitleBar();
        } else if (!this.mIconView) {
            this.showFakeTitleBar();
        }
    }

    private void hideFakeTitleBar() {
        if (this.mFakeTitleBar.getParent() == null) {
            return;
        }
        WindowManager.LayoutParams params = (WindowManager.LayoutParams)this.mFakeTitleBar.getLayoutParams();
        WebView mainView = this.mTabControl.getCurrentWebView();
        params.windowAnimations = mainView != null && mainView.getScrollY() == 0 ? 0 : 2131361794;
        WindowManager manager = (WindowManager)this.getSystemService("window");
        manager.updateViewLayout((View)this.mFakeTitleBar, (ViewGroup.LayoutParams)params);
        manager.removeView((View)this.mFakeTitleBar);
    }

    void showTitleBarContextMenu() {
        if (null == this.mTitleBar.getParent()) {
            return;
        }
        this.openContextMenu((View)this.mTitleBar);
    }

    public void onContextMenuClosed(Menu menu2) {
        super.onContextMenuClosed(menu2);
        if (this.mInLoad) {
            this.showFakeTitleBar();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        this.mTabControl.saveState(outState);
    }

    protected void onPause() {
        super.onPause();
        if (this.mActivityInPause) {
            Log.e((String)LOGTAG, (String)"BrowserActivity is already paused.");
            return;
        }
        this.mTabControl.pauseCurrentTab();
        this.mActivityInPause = true;
        if (this.mTabControl.getCurrentIndex() >= 0 && !this.pauseWebViewTimers()) {
            this.mWakeLock.acquire();
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(107), 300000L);
        }
        if (this.mActiveTabsPage != null) {
            this.removeActiveTabPage(true);
        }
        this.cancelStopToast();
        this.unregisterReceiver(this.mNetworkStateIntentReceiver);
        WebView.disablePlatformNotifications();
        if (this.mCustomView != null) {
            this.mTabControl.getCurrentWebView().getWebChromeClient().onHideCustomView();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mUploadMessage != null) {
            this.mUploadMessage.onReceiveValue(null);
            this.mUploadMessage = null;
        }
        if (this.mTabControl == null) {
            return;
        }
        this.hideFakeTitleBar();
        Tab t = this.mTabControl.getCurrentTab();
        if (t != null) {
            this.dismissSubWindow(t);
            this.removeTabFromContentView(t);
        }
        this.mTabControl.destroy();
        WebIconDatabase.getInstance().close();
        this.unregisterReceiver(this.mPackageInstallationReceiver);
        this.mSystemAllowGeolocationOrigins.stop();
        this.mSystemAllowGeolocationOrigins = null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.mConfigChanged = true;
        super.onConfigurationChanged(newConfig);
        if (this.mPageInfoDialog != null) {
            this.mPageInfoDialog.dismiss();
            this.showPageInfo(this.mPageInfoView, this.mPageInfoFromShowSSLCertificateOnError);
        }
        if (this.mSSLCertificateDialog != null) {
            this.mSSLCertificateDialog.dismiss();
            this.showSSLCertificate(this.mSSLCertificateView);
        }
        if (this.mSSLCertificateOnErrorDialog != null) {
            this.mSSLCertificateOnErrorDialog.dismiss();
            this.showSSLCertificateOnError(this.mSSLCertificateOnErrorView, this.mSSLCertificateOnErrorHandler, this.mSSLCertificateOnErrorError);
        }
        if (this.mHttpAuthenticationDialog != null) {
            String title = ((Object)((TextView)this.mHttpAuthenticationDialog.findViewById(16908669)).getText()).toString();
            String name = ((Object)((TextView)this.mHttpAuthenticationDialog.findViewById(2131492912)).getText()).toString();
            String password = ((Object)((TextView)this.mHttpAuthenticationDialog.findViewById(2131492914)).getText()).toString();
            int focusId = this.mHttpAuthenticationDialog.getCurrentFocus().getId();
            this.mHttpAuthenticationDialog.dismiss();
            this.showHttpAuthentication(this.mHttpAuthHandler, null, null, title, name, password, focusId);
        }
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.mTabControl.freeMemory();
    }

    private void resumeWebViewTimers() {
        Tab tab = this.mTabControl.getCurrentTab();
        if (tab == null) {
            return;
        }
        boolean inLoad = tab.inLoad();
        if (!this.mActivityInPause && !inLoad || this.mActivityInPause && inLoad) {
            CookieSyncManager.getInstance().startSync();
            WebView w = tab.getWebView();
            if (w != null) {
                w.resumeTimers();
            }
        }
    }

    private boolean pauseWebViewTimers() {
        Tab tab = this.mTabControl.getCurrentTab();
        boolean inLoad = tab.inLoad();
        if (this.mActivityInPause && !inLoad) {
            CookieSyncManager.getInstance().stopSync();
            WebView w = this.mTabControl.getCurrentWebView();
            if (w != null) {
                w.pauseTimers();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retainIconsOnStartup() {
        WebIconDatabase db = WebIconDatabase.getInstance();
        db.open(this.getDir("icons", 0).getPath());
        Cursor c = null;
        try {
            c = Browser.getAllBookmarks((ContentResolver)this.mResolver);
            if (c.moveToFirst()) {
                int urlIndex = c.getColumnIndex("url");
                do {
                    String url = c.getString(urlIndex);
                    db.retainIconForPageUrl(url);
                } while (c.moveToNext());
            }
        }
        catch (IllegalStateException e) {
            Log.e((String)LOGTAG, (String)"retainIconsOnStartup", (Throwable)e);
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    WebView getTopWindow() {
        return this.mTabControl.getCurrentTopWebView();
    }

    TabControl getTabControl() {
        return this.mTabControl;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131427330, menu2);
        this.mMenu = menu2;
        this.updateInLoadMenuItems();
        return true;
    }

    private void updateInLoadMenuItems() {
        if (this.mMenu == null) {
            return;
        }
        MenuItem src = this.mInLoad ? this.mMenu.findItem(2131492998) : this.mMenu.findItem(2131492999);
        MenuItem dest = this.mMenu.findItem(2131492971);
        dest.setIcon(src.getIcon());
        dest.setTitle(src.getTitle());
    }

    public boolean onContextItemSelected(MenuItem item) {
        this.mCanChord = true;
        int id2 = item.getItemId();
        boolean result = true;
        switch (id2) {
            case 2131493027: {
                Tab currentTab = this.mTabControl.getCurrentTab();
                if (null == currentTab) {
                    result = false;
                    break;
                }
                WebView mainView = currentTab.getWebView();
                if (null == mainView) {
                    result = false;
                    break;
                }
                this.copy(mainView.getUrl());
                break;
            }
            case 2131492959: 
            case 2131492963: 
            case 2131493011: 
            case 2131493012: 
            case 2131493013: 
            case 2131493014: {
                WebView webView = this.getTopWindow();
                if (null == webView) {
                    result = false;
                    break;
                }
                HashMap<String, WebView> hrefMap = new HashMap<String, WebView>();
                hrefMap.put("webview", webView);
                Message msg = this.mHandler.obtainMessage(102, id2, 0, hrefMap);
                webView.requestFocusNodeHref(msg);
                break;
            }
            default: {
                result = this.onOptionsItemSelected(item);
            }
        }
        this.mCanChord = false;
        return result;
    }

    private Bundle createGoogleSearchSourceBundle(String source) {
        Bundle bundle = new Bundle();
        bundle.putString("source", source);
        return bundle;
    }

    void editUrl() {
        if (this.mOptionsMenuOpen) {
            this.closeOptionsMenu();
        }
        String url = this.getTopWindow() == null ? null : this.getTopWindow().getUrl();
        this.startSearch(this.mSettings.getHomePage().equals(url) ? null : url, true, null, false);
    }

    public void startSearch(String initialQuery, boolean selectInitialQuery, Bundle appSearchData, boolean globalSearch) {
        SearchEngine searchEngine;
        if (appSearchData == null) {
            appSearchData = this.createGoogleSearchSourceBundle(GOOGLE_SEARCH_SOURCE_TYPE);
        }
        if ((searchEngine = this.mSettings.getSearchEngine()) != null && !searchEngine.supportsVoiceSearch()) {
            appSearchData.putBoolean("android.search.DISABLE_VOICE_SEARCH", true);
        }
        super.startSearch(initialQuery, selectInitialQuery, appSearchData, globalSearch);
    }

    boolean switchToTab(int index) {
        Tab tab = this.mTabControl.getTab(index);
        Tab currentTab = this.mTabControl.getCurrentTab();
        if (tab == null || tab == currentTab) {
            return false;
        }
        if (currentTab != null) {
            this.removeTabFromContentView(currentTab);
        }
        this.mTabControl.setCurrentTab(tab);
        this.attachTabToContentView(tab);
        this.resetTitleIconAndProgress();
        this.updateLockIconToLatest();
        return true;
    }

    Tab openTabToHomePage() {
        return this.openTabAndShow(this.mSettings.getHomePage(), false, null);
    }

    void closeCurrentWindow() {
        Tab current = this.mTabControl.getCurrentTab();
        if (this.mTabControl.getTabCount() == 1) {
            this.openTabToHomePage();
            this.closeTab(current);
            return;
        }
        Tab parent = current.getParentTab();
        int indexToShow = -1;
        if (parent != null) {
            indexToShow = this.mTabControl.getTabIndex(parent);
        } else {
            int currentIndex = this.mTabControl.getCurrentIndex();
            indexToShow = currentIndex + 1;
            if (indexToShow > this.mTabControl.getTabCount() - 1) {
                indexToShow = currentIndex - 1;
            }
        }
        if (this.switchToTab(indexToShow)) {
            this.closeTab(current);
        }
    }

    void removeActiveTabPage(boolean needToAttach) {
        this.mContentView.removeView((View)this.mActiveTabsPage);
        this.mActiveTabsPage = null;
        this.mMenuState = 2131492967;
        if (needToAttach) {
            this.attachTabToContentView(this.mTabControl.getCurrentTab());
        }
        this.getTopWindow().requestFocus();
    }

    private WebView showDialog(WebDialog dialog) {
        WebView mainView;
        Tab tab = this.mTabControl.getCurrentTab();
        if (tab.getSubWebView() == null && (mainView = tab.getWebView()) != null) {
            mainView.setEmbeddedTitleBar(null);
        }
        this.hideFakeTitleBar();
        this.mMenuState = -1;
        return tab.showDialog(dialog);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (!this.mCanChord) {
            return false;
        }
        if (null == this.getTopWindow()) {
            return false;
        }
        if (this.mMenuIsDown) {
            this.mMenuIsDown = false;
        }
        block0 : switch (item.getItemId()) {
            case 2131492968: {
                this.openTabToHomePage();
                break;
            }
            case 2131492996: {
                this.editUrl();
                break;
            }
            case 2131492969: {
                this.bookmarksOrHistoryPicker(false);
                break;
            }
            case 2131492970: {
                this.mActiveTabsPage = new ActiveTabsPage(this, this.mTabControl);
                this.removeTabFromContentView(this.mTabControl.getCurrentTab());
                this.hideFakeTitleBar();
                this.mContentView.addView((View)this.mActiveTabsPage, (ViewGroup.LayoutParams)COVER_SCREEN_PARAMS);
                this.mActiveTabsPage.requestFocus();
                this.mMenuState = -1;
                break;
            }
            case 2131492973: {
                Intent i = new Intent((Context)this, AddBookmarkPage.class);
                WebView w = this.getTopWindow();
                i.putExtra("url", w.getUrl());
                i.putExtra("title", w.getTitle());
                i.putExtra("touch_icon_url", w.getTouchIconUrl());
                i.putExtra("thumbnail", (Parcelable)this.createScreenshot(w));
                this.startActivity(i);
                break;
            }
            case 2131492971: {
                if (this.mInLoad) {
                    this.stopLoading();
                    break;
                }
                this.getTopWindow().reload();
                break;
            }
            case 2131492995: {
                this.getTopWindow().goBack();
                break;
            }
            case 2131492972: {
                this.getTopWindow().goForward();
                break;
            }
            case 2131492997: {
                if (this.mTabControl.getCurrentSubWindow() != null) {
                    this.dismissSubWindow(this.mTabControl.getCurrentTab());
                    break;
                }
                this.closeCurrentWindow();
                break;
            }
            case 2131492983: {
                Tab current = this.mTabControl.getCurrentTab();
                if (current == null) break;
                this.dismissSubWindow(current);
                this.loadUrl(current.getWebView(), this.mSettings.getHomePage());
                break;
            }
            case 2131492979: {
                Intent intent = new Intent((Context)this, BrowserPreferencesPage.class);
                intent.putExtra("currentPage", this.getTopWindow().getUrl());
                this.startActivityForResult(intent, 3);
                break;
            }
            case 2131492974: {
                this.showFindDialog();
                break;
            }
            case 2131492975: {
                Tab currentTab = this.mTabControl.getCurrentTab();
                if (currentTab == null) break;
                currentTab.getWebView().setUpSelect();
                break;
            }
            case 2131492976: {
                this.showPageInfo(this.mTabControl.getCurrentTab(), false);
                break;
            }
            case 2131492984: {
                this.bookmarksOrHistoryPicker(true);
                break;
            }
            case 2131492977: 
            case 2131493026: {
                Tab currentTab = this.mTabControl.getCurrentTab();
                if (null == currentTab) {
                    this.mCanChord = false;
                    return false;
                }
                currentTab.populatePickerData();
                BrowserActivity.sharePage((Context)this, currentTab.getTitle(), currentTab.getUrl(), currentTab.getFavicon(), this.createScreenshot(currentTab.getWebView()));
                break;
            }
            case 2131492980: {
                this.getTopWindow().debugDump();
                break;
            }
            case 2131492981: {
                this.getTopWindow().dumpV8Counters();
                break;
            }
            case 2131492985: {
                this.getTopWindow().zoomIn();
                break;
            }
            case 2131492986: {
                this.getTopWindow().zoomOut();
                break;
            }
            case 2131492978: {
                this.viewDownloads();
                break;
            }
            case 2131492987: 
            case 2131492988: 
            case 2131492989: 
            case 2131492990: 
            case 2131492991: 
            case 2131492992: 
            case 2131492993: 
            case 2131492994: {
                int menuid = item.getItemId();
                for (int id2 = 0; id2 < WINDOW_SHORTCUT_ID_ARRAY.length; ++id2) {
                    if (WINDOW_SHORTCUT_ID_ARRAY[id2] != menuid) continue;
                    Tab desiredTab = this.mTabControl.getTab(id2);
                    if (desiredTab == null || desiredTab == this.mTabControl.getCurrentTab()) break block0;
                    this.switchToTab(id2);
                    break block0;
                }
                break;
            }
            default: {
                if (super.onOptionsItemSelected(item)) break;
                return false;
            }
        }
        this.mCanChord = false;
        return true;
    }

    private boolean dialogIsUp() {
        return null != this.mFindDialog && this.mFindDialog.isVisible() || null != this.mSelectDialog && this.mSelectDialog.isVisible();
    }

    private boolean closeDialog(WebDialog dialog) {
        if (null == dialog || !dialog.isVisible()) {
            return false;
        }
        Tab currentTab = this.mTabControl.getCurrentTab();
        currentTab.closeDialog(dialog);
        dialog.dismiss();
        return true;
    }

    public void closeDialogs() {
        WebView mainView;
        if (!this.closeDialog(this.mFindDialog) && !this.closeDialog(this.mSelectDialog)) {
            return;
        }
        Tab currentTab = this.mTabControl.getCurrentTab();
        if (currentTab.getSubWebView() == null && (mainView = currentTab.getWebView()) != null) {
            mainView.setEmbeddedTitleBar((View)this.mTitleBar);
        }
        this.mMenuState = 2131492967;
        if (this.mInLoad) {
            this.showFakeTitleBar();
        }
    }

    public void showFindDialog() {
        if (null == this.mFindDialog) {
            this.mFindDialog = new FindDialog(this);
        }
        this.showDialog(this.mFindDialog).setFindIsUp(true);
    }

    public void setFindDialogText(String text) {
        this.mFindDialog.setText(text);
    }

    public void showSelectDialog() {
        if (null == this.mSelectDialog) {
            this.mSelectDialog = new SelectDialog(this);
        }
        this.showDialog(this.mSelectDialog).setUpSelect();
        this.mSelectDialog.hideSoftInput();
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        this.mCanChord = true;
        super.onPrepareOptionsMenu(menu2);
        switch (this.mMenuState) {
            case -1: {
                if (this.mCurrentMenuState == this.mMenuState) break;
                menu2.setGroupVisible(2131492967, false);
                menu2.setGroupEnabled(2131492967, false);
                menu2.setGroupEnabled(2131492982, false);
                break;
            }
            default: {
                if (this.mCurrentMenuState != this.mMenuState) {
                    menu2.setGroupVisible(2131492967, true);
                    menu2.setGroupEnabled(2131492967, true);
                    menu2.setGroupEnabled(2131492982, true);
                }
                WebView w = this.getTopWindow();
                boolean canGoBack = false;
                boolean canGoForward = false;
                boolean isHome = false;
                if (w != null) {
                    canGoBack = w.canGoBack();
                    canGoForward = w.canGoForward();
                    isHome = this.mSettings.getHomePage().equals(w.getUrl());
                }
                MenuItem back = menu2.findItem(2131492995);
                back.setEnabled(canGoBack);
                MenuItem home = menu2.findItem(2131492983);
                home.setEnabled(!isHome);
                menu2.findItem(2131492972).setEnabled(canGoForward);
                menu2.findItem(2131492968).setEnabled(this.mTabControl.canCreateNewTab());
                PackageManager pm = this.getPackageManager();
                Intent send = new Intent("android.intent.action.SEND");
                send.setType("text/plain");
                ResolveInfo ri = pm.resolveActivity(send, 65536);
                menu2.findItem(2131492977).setVisible(ri != null);
                boolean isNavDump = this.mSettings.isNavDump();
                MenuItem nav = menu2.findItem(2131492980);
                nav.setVisible(isNavDump);
                nav.setEnabled(isNavDump);
                boolean showDebugSettings = this.mSettings.showDebugSettings();
                MenuItem counter = menu2.findItem(2131492981);
                counter.setVisible(showDebugSettings);
                counter.setEnabled(showDebugSettings);
            }
        }
        this.mCurrentMenuState = this.mMenuState;
        return true;
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        if (v instanceof TitleBar) {
            return;
        }
        WebView webview = (WebView)v;
        WebView.HitTestResult result = webview.getHitTestResult();
        if (result == null) {
            return;
        }
        int type = result.getType();
        if (type == 0) {
            Log.w((String)LOGTAG, (String)"We should not show context menu when nothing is touched");
            return;
        }
        if (type == 9) {
            return;
        }
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131427331, (Menu)menu2);
        String extra = result.getExtra();
        menu2.setGroupVisible(2131493000, type == 2);
        menu2.setGroupVisible(2131493004, type == 4);
        menu2.setGroupVisible(2131493007, type == 3);
        menu2.setGroupVisible(2131493015, type == 5 || type == 8);
        menu2.setGroupVisible(2131493010, type == 7 || type == 8);
        switch (type) {
            case 2: {
                menu2.setHeaderTitle((CharSequence)Uri.decode((String)extra));
                menu2.findItem(2131493001).setIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)("tel:" + extra))));
                Intent addIntent = new Intent("android.intent.action.INSERT_OR_EDIT");
                addIntent.putExtra("phone", Uri.decode((String)extra));
                addIntent.setType("vnd.android.cursor.item/contact");
                menu2.findItem(2131493002).setIntent(addIntent);
                menu2.findItem(2131493003).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)new Copy(extra));
                break;
            }
            case 4: {
                menu2.setHeaderTitle((CharSequence)extra);
                menu2.findItem(2131493005).setIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)("mailto:" + extra))));
                menu2.findItem(2131493006).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)new Copy(extra));
                break;
            }
            case 3: {
                menu2.setHeaderTitle((CharSequence)extra);
                menu2.findItem(2131493008).setIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)("geo:0,0?q=" + URLEncoder.encode(extra)))));
                menu2.findItem(2131493009).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)new Copy(extra));
                break;
            }
            case 7: 
            case 8: {
                TextView titleView = (TextView)LayoutInflater.from((Context)this).inflate(17367054, null);
                titleView.setText((CharSequence)extra);
                menu2.setHeaderView((View)titleView);
                menu2.findItem(2131493011).setVisible(this.mTabControl.canCreateNewTab());
                menu2.findItem(2131493012).setVisible(Bookmarks.urlHasAcceptableScheme(extra));
                PackageManager pm = this.getPackageManager();
                Intent send = new Intent("android.intent.action.SEND");
                send.setType("text/plain");
                ResolveInfo ri = pm.resolveActivity(send, 65536);
                menu2.findItem(2131492963).setVisible(ri != null);
                if (type == 7) break;
            }
            case 5: {
                if (type == 5) {
                    menu2.setHeaderTitle((CharSequence)extra);
                }
                menu2.findItem(2131493017).setIntent(new Intent("android.intent.action.VIEW", Uri.parse((String)extra)));
                menu2.findItem(2131493016).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)new Download(extra));
                menu2.findItem(2131493018).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)new SetAsWallpaper(extra));
                break;
            }
            default: {
                Log.w((String)LOGTAG, (String)"We should not get here.");
            }
        }
        this.hideFakeTitleBar();
    }

    private void attachTabToContentView(Tab t) {
        t.attachTabToContentView((ViewGroup)this.mContentView);
        if (this.mShouldShowErrorConsole) {
            ErrorConsoleView errorConsole = t.getErrorConsole(true);
            if (errorConsole.numberOfErrors() == 0) {
                errorConsole.showConsole(2);
            } else {
                errorConsole.showConsole(0);
            }
            this.mErrorConsoleContainer.addView((View)errorConsole, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        }
        WebView view = t.getWebView();
        view.setEmbeddedTitleBar((View)this.mTitleBar);
        if (t.isInVoiceSearchMode()) {
            this.showVoiceTitleBar(t.getVoiceDisplayTitle());
        } else {
            this.revertVoiceTitleBar();
        }
        t.getTopWindow().requestFocus();
    }

    void attachSubWindow(Tab t) {
        t.attachSubWindow((ViewGroup)this.mContentView);
        this.getTopWindow().requestFocus();
    }

    private void removeTabFromContentView(Tab t) {
        WebView view;
        t.removeTabFromContentView((ViewGroup)this.mContentView);
        ErrorConsoleView errorConsole = t.getErrorConsole(false);
        if (errorConsole != null) {
            this.mErrorConsoleContainer.removeView((View)errorConsole);
        }
        if ((view = t.getWebView()) != null) {
            view.setEmbeddedTitleBar(null);
        }
    }

    void dismissSubWindow(Tab t) {
        t.removeSubWindow((ViewGroup)this.mContentView);
        t.dismissSubWindow();
        this.getTopWindow().requestFocus();
    }

    private Tab openTabAndShow(String url, boolean closeOnExit, String appId) {
        return this.openTabAndShow(new UrlData(url), closeOnExit, appId);
    }

    Tab openTabAndShow(UrlData urlData, boolean closeOnExit, String appId) {
        Tab currentTab = this.mTabControl.getCurrentTab();
        if (!this.mTabControl.canCreateNewTab()) {
            Tab closeTab = this.mTabControl.getTab(0);
            this.closeTab(closeTab);
            if (closeTab == currentTab) {
                currentTab = null;
            }
        }
        Tab tab = this.mTabControl.createNewTab(closeOnExit, appId, urlData.mUrl);
        WebView webview = tab.getWebView();
        if (currentTab != null) {
            this.removeTabFromContentView(currentTab);
        }
        this.mTabControl.setCurrentTab(tab);
        this.attachTabToContentView(tab);
        if (!urlData.isEmpty()) {
            this.loadUrlDataIn(tab, urlData);
        }
        return tab;
    }

    private Tab openTab(String url) {
        if (this.mSettings.openInBackground()) {
            Tab t = this.mTabControl.createNewTab();
            if (t != null) {
                WebView view = t.getWebView();
                this.loadUrl(view, url);
            }
            return t;
        }
        return this.openTabAndShow(url, false, null);
    }

    private void copy(CharSequence text) {
        try {
            IClipboard clip = IClipboard.Stub.asInterface((IBinder)ServiceManager.getService((String)"clipboard"));
            if (clip != null) {
                clip.setClipboardText(text);
            }
        }
        catch (RemoteException e) {
            Log.e((String)LOGTAG, (String)"Copy failed", (Throwable)e);
        }
    }

    void resetTitleAndRevertLockIcon() {
        this.mTabControl.getCurrentTab().revertLockIcon();
        this.updateLockIconToLatest();
        this.resetTitleIconAndProgress();
    }

    private void resetTitleIconAndProgress() {
        WebView current = this.mTabControl.getCurrentWebView();
        if (current == null) {
            return;
        }
        this.resetTitleAndIcon(current);
        int progress = current.getProgress();
        current.getWebChromeClient().onProgressChanged(current, progress);
    }

    private void resetTitleAndIcon(WebView view) {
        WebHistoryItem item = view.copyBackForwardList().getCurrentItem();
        if (item != null) {
            this.setUrlTitle(item.getUrl(), item.getTitle());
            this.setFavicon(item.getFavicon());
        } else {
            this.setUrlTitle(null, null);
            this.setFavicon(null);
        }
    }

    void setUrlTitle(String url, String title) {
        this.mUrl = url;
        this.mTitle = title;
        if (this.mTabControl.getCurrentTab().isInVoiceSearchMode()) {
            return;
        }
        this.mTitleBar.setDisplayTitle(url);
        this.mFakeTitleBar.setDisplayTitle(url);
    }

    static String buildTitleUrl(String url) {
        String titleUrl = null;
        if (url != null) {
            try {
                URL urlObj = new URL(url);
                if (urlObj != null) {
                    titleUrl = "";
                    String protocol = urlObj.getProtocol();
                    String host = urlObj.getHost();
                    if (host != null && 0 < host.length()) {
                        titleUrl = host;
                        if (protocol != null && protocol.equalsIgnoreCase("https")) {
                            titleUrl = protocol + "://" + host;
                        }
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return titleUrl;
    }

    void setFavicon(Bitmap icon) {
        this.mTitleBar.setFavicon(icon);
        this.mFakeTitleBar.setFavicon(icon);
    }

    void closeTab(Tab t) {
        int currentIndex = this.mTabControl.getCurrentIndex();
        int removeIndex = this.mTabControl.getTabIndex(t);
        this.mTabControl.removeTab(t);
        if (currentIndex >= removeIndex && currentIndex != 0) {
            --currentIndex;
        }
        this.mTabControl.setCurrentTab(this.mTabControl.getTab(currentIndex));
        this.resetTitleIconAndProgress();
    }

    void goBackOnePageOrQuit() {
        Tab current = this.mTabControl.getCurrentTab();
        if (current == null) {
            this.moveTaskToBack(true);
            return;
        }
        WebView w = current.getWebView();
        if (w.canGoBack()) {
            w.goBack();
        } else {
            Tab parent = current.getParentTab();
            if (parent != null) {
                this.switchToTab(this.mTabControl.getTabIndex(parent));
                this.closeTab(current);
            } else {
                if (current.closeOnExit()) {
                    this.mTabControl.getCurrentTab().clearInLoad();
                    if (this.mTabControl.getTabCount() == 1) {
                        this.finish();
                        return;
                    }
                    boolean savedState = this.mActivityInPause;
                    if (savedState) {
                        Log.e((String)LOGTAG, (String)"BrowserActivity is already paused while handing goBackOnePageOrQuit.");
                    }
                    this.mActivityInPause = true;
                    this.pauseWebViewTimers();
                    this.mActivityInPause = savedState;
                    this.removeTabFromContentView(current);
                    this.mTabControl.removeTab(current);
                }
                this.moveTaskToBack(true);
            }
        }
    }

    boolean isMenuDown() {
        return this.mMenuIsDown;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (82 == keyCode) {
            this.mMenuIsDown = true;
            return super.onKeyDown(keyCode, event);
        }
        if (this.mMenuIsDown) {
            return true;
        }
        switch (keyCode) {
            case 62: {
                if (event.isShiftPressed()) {
                    this.getTopWindow().pageUp(false);
                } else {
                    this.getTopWindow().pageDown(false);
                }
                return true;
            }
            case 4: {
                if (event.getRepeatCount() == 0) {
                    event.startTracking();
                    return true;
                }
                if (this.mCustomView != null || this.mActiveTabsPage != null || !event.isLongPress()) break;
                this.bookmarksOrHistoryPicker(true);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 82: {
                this.mMenuIsDown = false;
                break;
            }
            case 4: {
                if (!event.isTracking() || event.isCanceled()) break;
                if (this.mCustomView != null) {
                    this.mTabControl.getCurrentWebView().getWebChromeClient().onHideCustomView();
                } else if (this.mActiveTabsPage != null) {
                    this.removeActiveTabPage(true);
                } else {
                    WebView subwindow = this.mTabControl.getCurrentSubWindow();
                    if (subwindow != null) {
                        if (subwindow.canGoBack()) {
                            subwindow.goBack();
                        } else {
                            this.dismissSubWindow(this.mTabControl.getCurrentTab());
                        }
                    } else {
                        this.goBackOnePageOrQuit();
                    }
                }
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    void stopLoading() {
        this.mDidStopLoad = true;
        this.resetTitleAndRevertLockIcon();
        WebView w = this.getTopWindow();
        w.stopLoading();
        this.mTabControl.getCurrentWebView().getWebViewClient().onPageFinished(w, w.getUrl());
        this.cancelStopToast();
        this.mStopToast = Toast.makeText((Context)this, (int)2131230759, (int)0);
        this.mStopToast.show();
    }

    boolean didUserStopLoading() {
        return this.mDidStopLoad;
    }

    private void cancelStopToast() {
        if (this.mStopToast != null) {
            this.mStopToast.cancel();
            this.mStopToast = null;
        }
    }

    public void postMessage(int what, int arg1, int arg2, Object obj, long delayMillis) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(what, arg1, arg2, obj), delayMillis);
    }

    void removeMessages(int what, Object object) {
        this.mHandler.removeMessages(what, object);
    }

    public static final void sharePage(Context c, String title, String url, Bitmap favicon, Bitmap screenshot) {
        Intent send = new Intent("android.intent.action.SEND");
        send.setType("text/plain");
        send.putExtra("android.intent.extra.TEXT", url);
        send.putExtra("android.intent.extra.SUBJECT", title);
        send.putExtra("share_favicon", (Parcelable)favicon);
        send.putExtra("share_screenshot", (Parcelable)screenshot);
        try {
            c.startActivity(Intent.createChooser((Intent)send, (CharSequence)c.getString(2131230816)));
        }
        catch (ActivityNotFoundException ex) {
            // empty catch block
        }
    }

    private void updateScreenshot(WebView view) {
        final Bitmap bm = this.createScreenshot(view);
        if (bm == null) {
            return;
        }
        final ContentResolver cr = this.getContentResolver();
        final String url = view.getUrl();
        final String originalUrl = view.getOriginalUrl();
        new AsyncTask<Void, Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... unused) {
                Cursor c = null;
                try {
                    c = BrowserBookmarksAdapter.queryBookmarksForUrl(cr, originalUrl, url, true);
                    if (c != null && c.moveToFirst()) {
                        ContentValues values = new ContentValues();
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
                        values.put("thumbnail", os.toByteArray());
                        do {
                            cr.update(ContentUris.withAppendedId((Uri)Browser.BOOKMARKS_URI, (long)c.getInt(0)), values, null, null);
                        } while (c.moveToNext());
                    }
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    if (c != null) {
                        c.close();
                    }
                }
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    static int getDesiredThumbnailWidth(Context context) {
        if (THUMBNAIL_WIDTH == 0) {
            float density = context.getResources().getDisplayMetrics().density;
            THUMBNAIL_WIDTH = (int)(90.0f * density);
            THUMBNAIL_HEIGHT = (int)(80.0f * density);
        }
        return THUMBNAIL_WIDTH;
    }

    static int getDesiredThumbnailHeight(Context context) {
        BrowserActivity.getDesiredThumbnailWidth(context);
        return THUMBNAIL_HEIGHT;
    }

    private Bitmap createScreenshot(WebView view) {
        Picture thumbnail = view.capturePicture();
        if (thumbnail == null) {
            return null;
        }
        Bitmap bm = Bitmap.createBitmap((int)BrowserActivity.getDesiredThumbnailWidth((Context)this), (int)BrowserActivity.getDesiredThumbnailHeight((Context)this), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bm);
        int thumbnailWidth = thumbnail.getWidth();
        int thumbnailHeight = thumbnail.getHeight();
        float scaleFactorX = 1.0f;
        float scaleFactorY = 1.0f;
        if (thumbnailWidth <= 0) {
            return null;
        }
        scaleFactorX = (float)BrowserActivity.getDesiredThumbnailWidth((Context)this) / (float)thumbnailWidth;
        scaleFactorY = view.getWidth() > view.getHeight() && thumbnailHeight < view.getHeight() && thumbnailHeight > 0 ? (float)BrowserActivity.getDesiredThumbnailHeight((Context)this) / (float)thumbnailHeight : scaleFactorX;
        canvas.scale(scaleFactorX, scaleFactorY);
        thumbnail.draw(canvas);
        return bm;
    }

    void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (this.mActivityInPause) {
            this.resumeWebViewTimers();
        }
        this.resetLockIcon(url);
        this.setUrlTitle(url, null);
        this.setFavicon(favicon);
        this.onProgressChanged(view, 10);
        this.mDidStopLoad = false;
        if (!this.mIsNetworkUp) {
            this.createAndShowNetworkDialog();
        }
        this.closeDialogs();
        if (this.mSettings.isTracing()) {
            String host;
            try {
                WebAddress uri = new WebAddress(url);
                host = uri.mHost;
            }
            catch (ParseException ex) {
                host = LOGTAG;
            }
            host = host.replace('.', '_');
            host = host + ".trace";
            mInTrace = true;
            Debug.startMethodTracing((String)host, (int)0x1400000);
        }
    }

    void onPageFinished(WebView view, String url) {
        this.resetTitleAndIcon(view);
        this.updateLockIconToLatest();
        if (this.mActivityInPause && this.pauseWebViewTimers() && this.mWakeLock.isHeld()) {
            this.mHandler.removeMessages(107);
            this.mWakeLock.release();
        }
        if (mInTrace) {
            mInTrace = false;
            Debug.stopMethodTracing();
        }
    }

    boolean shouldOverrideUrlLoading(WebView view, String url) {
        Intent intent;
        if (url.startsWith(SCHEME_WTAI)) {
            if (url.startsWith(SCHEME_WTAI_MC)) {
                Intent intent2 = new Intent("android.intent.action.VIEW", Uri.parse((String)("tel:" + url.substring(SCHEME_WTAI_MC.length()))));
                this.startActivity(intent2);
                return true;
            }
            if (url.startsWith(SCHEME_WTAI_SD)) {
                return false;
            }
            if (url.startsWith(SCHEME_WTAI_AP)) {
                return false;
            }
        }
        if (url.startsWith("about:") || url.startsWith("javascript:")) {
            return false;
        }
        try {
            intent = Intent.parseUri((String)url, (int)1);
        }
        catch (URISyntaxException ex) {
            Log.w((String)"Browser", (String)("Bad URI " + url + ": " + ex.getMessage()));
            return false;
        }
        if (this.getPackageManager().resolveActivity(intent, 0) == null) {
            String packagename = intent.getPackage();
            if (packagename != null) {
                intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("market://search?q=pname:" + packagename)));
                intent.addCategory("android.intent.category.BROWSABLE");
                this.startActivity(intent);
                return true;
            }
            return false;
        }
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setComponent(null);
        try {
            if (this.startActivityIfNeeded(intent, -1)) {
                return true;
            }
        }
        catch (ActivityNotFoundException ex) {
            // empty catch block
        }
        if (this.mMenuIsDown) {
            this.openTab(url);
            this.closeOptionsMenu();
            return true;
        }
        return false;
    }

    void onProgressChanged(WebView view, int newProgress) {
        this.mFakeTitleBar.setProgress(newProgress);
        if (newProgress == 100) {
            if (this.mInLoad) {
                this.mInLoad = false;
                this.updateInLoadMenuItems();
                if (!this.mOptionsMenuOpen || !this.mIconView) {
                    this.hideFakeTitleBar();
                }
            }
        } else {
            if (!this.mInLoad) {
                this.mInLoad = true;
                this.updateInLoadMenuItems();
            }
            if (!this.mOptionsMenuOpen || this.mIconView) {
                this.showFakeTitleBar();
            }
        }
    }

    void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        if (this.mCustomView != null) {
            callback.onCustomViewHidden();
            return;
        }
        this.mCustomViewContainer.addView(view, (ViewGroup.LayoutParams)COVER_SCREEN_GRAVITY_CENTER);
        this.mCustomView = view;
        this.mCustomViewCallback = callback;
        this.mOldMenuState = this.mMenuState;
        this.mMenuState = -1;
        this.mContentView.setVisibility(8);
        this.setStatusBarVisibility(false);
        this.mCustomViewContainer.setVisibility(0);
        this.mCustomViewContainer.bringToFront();
    }

    void onHideCustomView() {
        if (this.mCustomView == null) {
            return;
        }
        this.mCustomView.setVisibility(8);
        this.mCustomViewContainer.removeView(this.mCustomView);
        this.mCustomView = null;
        this.mMenuState = this.mOldMenuState;
        this.mOldMenuState = -1;
        this.mCustomViewContainer.setVisibility(8);
        this.mCustomViewCallback.onCustomViewHidden();
        this.setStatusBarVisibility(true);
        this.mContentView.setVisibility(0);
    }

    Bitmap getDefaultVideoPoster() {
        if (this.mDefaultVideoPoster == null) {
            this.mDefaultVideoPoster = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837515);
        }
        return this.mDefaultVideoPoster;
    }

    View getVideoLoadingProgressView() {
        if (this.mVideoProgressView == null) {
            LayoutInflater inflater = LayoutInflater.from((Context)this);
            this.mVideoProgressView = inflater.inflate(2130903065, null);
        }
        return this.mVideoProgressView;
    }

    void openFileChooser(ValueCallback<Uri> uploadMsg) {
        if (this.mUploadMessage != null) {
            return;
        }
        this.mUploadMessage = uploadMsg;
        Intent i = new Intent("android.intent.action.GET_CONTENT");
        i.addCategory("android.intent.category.OPENABLE");
        i.setType("*/*");
        this.startActivityForResult(Intent.createChooser((Intent)i, (CharSequence)this.getString(2131230722)), 4);
    }

    public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        if (contentDisposition == null || !contentDisposition.regionMatches(true, 0, "attachment", 0, 10)) {
            ComponentName myName;
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)url), mimetype);
            ResolveInfo info = this.getPackageManager().resolveActivity(intent, 65536);
            if (!(info == null || (myName = this.getComponentName()).getPackageName().equals(info.activityInfo.packageName) && myName.getClassName().equals(info.activityInfo.name))) {
                try {
                    this.startActivity(intent);
                    return;
                }
                catch (ActivityNotFoundException ex) {
                    Log.d((String)LOGTAG, (String)("activity not found for " + mimetype + " over " + Uri.parse((String)url).getScheme()), (Throwable)ex);
                }
            }
        }
        this.onDownloadStartNoStream(url, userAgent, contentDisposition, mimetype, contentLength);
    }

    private static String encodePath(String path) {
        char[] chars = path.toCharArray();
        boolean needed = false;
        for (char c : chars) {
            if (c != '[' && c != ']') continue;
            needed = true;
            break;
        }
        if (!needed) {
            return path;
        }
        StringBuilder sb = new StringBuilder("");
        for (char c : chars) {
            if (c == '[' || c == ']') {
                sb.append('%');
                sb.append(Integer.toHexString(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    void onDownloadStartNoStream(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
        WebAddress webAddress;
        String filename = URLUtil.guessFileName((String)url, (String)contentDisposition, (String)mimetype);
        String status = Environment.getExternalStorageState();
        if (!status.equals("mounted")) {
            int title;
            String msg;
            if (status.equals("shared")) {
                msg = this.getString(2131230930);
                title = 2131230929;
            } else {
                msg = this.getString(2131230928, new Object[]{filename});
                title = 2131230927;
            }
            new AlertDialog.Builder((Context)this).setTitle(title).setIcon(17301543).setMessage((CharSequence)msg).setPositiveButton(2131230736, null).show();
            return;
        }
        try {
            webAddress = new WebAddress(url);
            webAddress.mPath = BrowserActivity.encodePath(webAddress.mPath);
        }
        catch (Exception e) {
            Log.e((String)LOGTAG, (String)("Exception trying to parse url:" + url));
            return;
        }
        String cookies = CookieManager.getInstance().getCookie(url);
        ContentValues values = new ContentValues();
        values.put("uri", webAddress.toString());
        values.put("cookiedata", cookies);
        values.put("useragent", userAgent);
        values.put("notificationpackage", this.getPackageName());
        values.put("notificationclass", OpenDownloadReceiver.class.getCanonicalName());
        values.put("visibility", Integer.valueOf(1));
        values.put("mimetype", mimetype);
        values.put("hint", filename);
        values.put("description", webAddress.mHost);
        if (contentLength > 0L) {
            values.put("total_bytes", Long.valueOf(contentLength));
        }
        if (mimetype == null) {
            new FetchUrlMimeType(this).execute(new ContentValues[]{values});
        } else {
            Uri contentUri = this.getContentResolver().insert(Downloads.Impl.CONTENT_URI, values);
        }
        Toast.makeText((Context)this, (int)2131230937, (int)0).show();
    }

    private void resetLockIcon(String url) {
        this.mTabControl.getCurrentTab().resetLockIcon(url);
        this.updateLockIconImage(0);
    }

    private void updateLockIconToLatest() {
        this.updateLockIconImage(this.mTabControl.getCurrentTab().getLockIconType());
    }

    private void updateLockIconImage(int lockIconType) {
        Drawable d = null;
        if (lockIconType == 1) {
            d = this.mSecLockIcon;
        } else if (lockIconType == 2) {
            d = this.mMixLockIcon;
        }
        this.mTitleBar.setLock(d);
        this.mFakeTitleBar.setLock(d);
    }

    private void showPageInfo(final Tab tab, final boolean fromShowSSLCertificateOnError) {
        LayoutInflater factory = LayoutInflater.from((Context)this);
        View pageInfoView = factory.inflate(2130903055, null);
        final WebView view = tab.getWebView();
        String url = null;
        String title = null;
        if (view == null) {
            url = tab.getUrl();
            title = tab.getTitle();
        } else if (view == this.mTabControl.getCurrentWebView()) {
            url = this.mUrl;
            title = this.mTitle;
        } else {
            url = view.getUrl();
            title = view.getTitle();
        }
        if (url == null) {
            url = "";
        }
        if (title == null) {
            title = "";
        }
        ((TextView)pageInfoView.findViewById(2131492878)).setText((CharSequence)url);
        ((TextView)pageInfoView.findViewById(2131492866)).setText((CharSequence)title);
        this.mPageInfoView = tab;
        this.mPageInfoFromShowSSLCertificateOnError = fromShowSSLCertificateOnError;
        AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder((Context)this).setTitle(2131230738).setIcon(17301659).setView(pageInfoView).setPositiveButton(2131230736, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                BrowserActivity.this.mPageInfoDialog = null;
                BrowserActivity.this.mPageInfoView = null;
                if (fromShowSSLCertificateOnError) {
                    BrowserActivity.this.showSSLCertificateOnError(BrowserActivity.this.mSSLCertificateOnErrorView, BrowserActivity.this.mSSLCertificateOnErrorHandler, BrowserActivity.this.mSSLCertificateOnErrorError);
                }
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                BrowserActivity.this.mPageInfoDialog = null;
                BrowserActivity.this.mPageInfoView = null;
                if (fromShowSSLCertificateOnError) {
                    BrowserActivity.this.showSSLCertificateOnError(BrowserActivity.this.mSSLCertificateOnErrorView, BrowserActivity.this.mSSLCertificateOnErrorHandler, BrowserActivity.this.mSSLCertificateOnErrorError);
                }
            }
        });
        if (fromShowSSLCertificateOnError || view != null && view.getCertificate() != null) {
            alertDialogBuilder.setNeutralButton(2131230744, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    BrowserActivity.this.mPageInfoDialog = null;
                    BrowserActivity.this.mPageInfoView = null;
                    if (fromShowSSLCertificateOnError) {
                        BrowserActivity.this.showSSLCertificateOnError(BrowserActivity.this.mSSLCertificateOnErrorView, BrowserActivity.this.mSSLCertificateOnErrorHandler, BrowserActivity.this.mSSLCertificateOnErrorError);
                    } else if (view.getCertificate() != null) {
                        BrowserActivity.this.showSSLCertificate(tab);
                    }
                }
            });
        }
        this.mPageInfoDialog = alertDialogBuilder.show();
    }

    private void showSSLCertificate(final Tab tab) {
        View certificateView = this.inflateCertificateView(tab.getWebView().getCertificate());
        if (certificateView == null) {
            return;
        }
        LayoutInflater factory = LayoutInflater.from((Context)this);
        LinearLayout placeholder = (LinearLayout)certificateView.findViewById(2131492916);
        LinearLayout ll = (LinearLayout)factory.inflate(2130903057, (ViewGroup)placeholder);
        ((TextView)ll.findViewById(2131492936)).setText(2131230750);
        this.mSSLCertificateView = tab;
        this.mSSLCertificateDialog = new AlertDialog.Builder((Context)this).setTitle(2131230749).setIcon(2130837528).setView(certificateView).setPositiveButton(2131230736, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                BrowserActivity.this.mSSLCertificateDialog = null;
                BrowserActivity.this.mSSLCertificateView = null;
                BrowserActivity.this.showPageInfo(tab, false);
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                BrowserActivity.this.mSSLCertificateDialog = null;
                BrowserActivity.this.mSSLCertificateView = null;
                BrowserActivity.this.showPageInfo(tab, false);
            }
        }).show();
    }

    void showSSLCertificateOnError(final WebView view, final SslErrorHandler handler, final SslError error) {
        LinearLayout ll;
        View certificateView = this.inflateCertificateView(error.getCertificate());
        if (certificateView == null) {
            return;
        }
        LayoutInflater factory = LayoutInflater.from((Context)this);
        LinearLayout placeholder = (LinearLayout)certificateView.findViewById(2131492916);
        if (error.hasError(3)) {
            ll = (LinearLayout)factory.inflate(2130903058, (ViewGroup)placeholder);
            ((TextView)ll.findViewById(2131492937)).setText(2131230745);
        }
        if (error.hasError(2)) {
            ll = (LinearLayout)factory.inflate(2130903058, (ViewGroup)placeholder);
            ((TextView)ll.findViewById(2131492937)).setText(2131230746);
        }
        if (error.hasError(1)) {
            ll = (LinearLayout)factory.inflate(2130903058, (ViewGroup)placeholder);
            ((TextView)ll.findViewById(2131492937)).setText(2131230747);
        }
        if (error.hasError(0)) {
            ll = (LinearLayout)factory.inflate(2130903058, (ViewGroup)placeholder);
            ((TextView)ll.findViewById(2131492937)).setText(2131230748);
        }
        this.mSSLCertificateOnErrorHandler = handler;
        this.mSSLCertificateOnErrorView = view;
        this.mSSLCertificateOnErrorError = error;
        this.mSSLCertificateOnErrorDialog = new AlertDialog.Builder((Context)this).setTitle(2131230749).setIcon(2130837527).setView(certificateView).setPositiveButton(2131230736, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                BrowserActivity.this.mSSLCertificateOnErrorDialog = null;
                BrowserActivity.this.mSSLCertificateOnErrorView = null;
                BrowserActivity.this.mSSLCertificateOnErrorHandler = null;
                BrowserActivity.this.mSSLCertificateOnErrorError = null;
                view.getWebViewClient().onReceivedSslError(view, handler, error);
            }
        }).setNeutralButton(2131230739, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                BrowserActivity.this.mSSLCertificateOnErrorDialog = null;
                BrowserActivity.this.showPageInfo(BrowserActivity.this.mTabControl.getTabFromView(view), true);
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                BrowserActivity.this.mSSLCertificateOnErrorDialog = null;
                BrowserActivity.this.mSSLCertificateOnErrorView = null;
                BrowserActivity.this.mSSLCertificateOnErrorHandler = null;
                BrowserActivity.this.mSSLCertificateOnErrorError = null;
                view.getWebViewClient().onReceivedSslError(view, handler, error);
            }
        }).show();
    }

    private View inflateCertificateView(SslCertificate certificate) {
        SslCertificate.DName issuedBy;
        if (certificate == null) {
            return null;
        }
        LayoutInflater factory = LayoutInflater.from((Context)this);
        View certificateView = factory.inflate(2130903056, null);
        SslCertificate.DName issuedTo = certificate.getIssuedTo();
        if (issuedTo != null) {
            ((TextView)certificateView.findViewById(2131492920)).setText((CharSequence)issuedTo.getCName());
            ((TextView)certificateView.findViewById(2131492922)).setText((CharSequence)issuedTo.getOName());
            ((TextView)certificateView.findViewById(2131492924)).setText((CharSequence)issuedTo.getUName());
        }
        if ((issuedBy = certificate.getIssuedBy()) != null) {
            ((TextView)certificateView.findViewById(2131492926)).setText((CharSequence)issuedBy.getCName());
            ((TextView)certificateView.findViewById(2131492928)).setText((CharSequence)issuedBy.getOName());
            ((TextView)certificateView.findViewById(2131492930)).setText((CharSequence)issuedBy.getUName());
        }
        String issuedOn = this.formatCertificateDate(certificate.getValidNotBeforeDate());
        ((TextView)certificateView.findViewById(2131492933)).setText((CharSequence)issuedOn);
        String expiresOn = this.formatCertificateDate(certificate.getValidNotAfterDate());
        ((TextView)certificateView.findViewById(2131492935)).setText((CharSequence)expiresOn);
        return certificateView;
    }

    private String formatCertificateDate(Date certificateDate) {
        if (certificateDate == null) {
            return "";
        }
        String formattedDate = DateFormat.getDateFormat((Context)this).format(certificateDate);
        if (formattedDate == null) {
            return "";
        }
        return formattedDate;
    }

    void showHttpAuthentication(final HttpAuthHandler handler, final String host, final String realm, String title, String name, String password, int focusId) {
        String titleText;
        LayoutInflater factory = LayoutInflater.from((Context)this);
        final View v = factory.inflate(2130903054, null);
        if (name != null) {
            ((EditText)v.findViewById(2131492912)).setText((CharSequence)name);
        }
        if (password != null) {
            ((EditText)v.findViewById(2131492914)).setText((CharSequence)password);
        }
        if ((titleText = title) == null) {
            titleText = ((Object)this.getText(2131230730)).toString().replace("%s1", host).replace("%s2", realm);
        }
        this.mHttpAuthHandler = handler;
        AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)titleText).setIcon(17301543).setView(v).setPositiveButton(2131230733, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                String nm = ((EditText)v.findViewById(2131492912)).getText().toString();
                String pw = ((EditText)v.findViewById(2131492914)).getText().toString();
                BrowserActivity.this.setHttpAuthUsernamePassword(host, realm, nm, pw);
                handler.proceed(nm, pw);
                BrowserActivity.this.mHttpAuthenticationDialog = null;
                BrowserActivity.this.mHttpAuthHandler = null;
            }
        }).setNegativeButton(2131230735, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                handler.cancel();
                BrowserActivity.this.resetTitleAndRevertLockIcon();
                BrowserActivity.this.mHttpAuthenticationDialog = null;
                BrowserActivity.this.mHttpAuthHandler = null;
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                handler.cancel();
                BrowserActivity.this.resetTitleAndRevertLockIcon();
                BrowserActivity.this.mHttpAuthenticationDialog = null;
                BrowserActivity.this.mHttpAuthHandler = null;
            }
        }).create();
        dialog.getWindow().setSoftInputMode(4);
        dialog.show();
        if (focusId != 0) {
            dialog.findViewById(focusId).requestFocus();
        } else {
            v.findViewById(2131492912).requestFocus();
        }
        this.mHttpAuthenticationDialog = dialog;
    }

    public int getProgress() {
        WebView w = this.mTabControl.getCurrentWebView();
        if (w != null) {
            return w.getProgress();
        }
        return 100;
    }

    public void setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        WebView w = this.getTopWindow();
        if (w != null) {
            w.setHttpAuthUsernamePassword(host, realm, username, password);
        }
    }

    public void onNetworkToggle(boolean up) {
        WebView w;
        if (up == this.mIsNetworkUp) {
            return;
        }
        if (up) {
            this.mIsNetworkUp = true;
            if (this.mAlertDialog != null) {
                this.mAlertDialog.cancel();
                this.mAlertDialog = null;
            }
        } else {
            this.mIsNetworkUp = false;
            if (this.mInLoad) {
                this.createAndShowNetworkDialog();
            }
        }
        if ((w = this.mTabControl.getCurrentWebView()) != null) {
            w.setNetworkAvailable(up);
        }
    }

    boolean isNetworkUp() {
        return this.mIsNetworkUp;
    }

    private void createAndShowNetworkDialog() {
        if (this.mAlertDialog == null) {
            this.mAlertDialog = new AlertDialog.Builder((Context)this).setTitle(2131230895).setMessage(2131230896).setPositiveButton(2131230736, null).show();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (this.getTopWindow() == null) {
            return;
        }
        switch (requestCode) {
            case 1: {
                if (resultCode != -1 || intent == null) ** GOTO lbl16
                data = intent.getAction();
                extras = intent.getExtras();
                if (extras == null || !extras.getBoolean("new_window", false)) ** GOTO lbl12
                this.openTab(data);
                ** GOTO lbl16
lbl12:
                // 1 sources

                currentTab = this.mTabControl.getCurrentTab();
                this.dismissSubWindow(currentTab);
                if (data != null && data.length() != 0) {
                    this.loadUrl(this.getTopWindow(), data);
                }
            }
lbl16:
            // 6 sources

            case 3: {
                if (resultCode != -1 || intent == null || !"privacy_clear_history".equals(action = intent.getStringExtra("android.intent.extra.TEXT"))) break;
                this.mTabControl.removeParentChildRelationShips();
                break;
            }
            case 4: {
                if (null == this.mUploadMessage) break;
                result = intent == null || resultCode != -1 ? null : intent.getData();
                this.mUploadMessage.onReceiveValue((Object)result);
                this.mUploadMessage = null;
                break;
            }
        }
        this.getTopWindow().requestFocus();
    }

    private void viewDownloads() {
        Intent intent = new Intent("android.intent.action.VIEW_DOWNLOADS");
        this.startActivity(intent);
    }

    void bookmarksOrHistoryPicker(boolean startWithHistory) {
        WebView current = this.mTabControl.getCurrentWebView();
        if (current == null) {
            return;
        }
        Intent intent = new Intent((Context)this, CombinedBookmarkHistoryActivity.class);
        String title = current.getTitle();
        String url = current.getUrl();
        Bitmap thumbnail = this.createScreenshot(current);
        if (null == url && null == (url = this.mLastEnteredUrl)) {
            url = this.mSettings.getHomePage();
        }
        if (title == null) {
            title = url;
        }
        intent.putExtra("title", title);
        intent.putExtra("url", url);
        intent.putExtra("thumbnail", (Parcelable)thumbnail);
        intent.putExtra("disable_new_window", !this.mTabControl.canCreateNewTab());
        intent.putExtra("touch_icon_url", current.getTouchIconUrl());
        if (startWithHistory) {
            intent.putExtra(CombinedBookmarkHistoryActivity.STARTING_TAB, CombinedBookmarkHistoryActivity.HISTORY_TAB);
        }
        this.startActivityForResult(intent, 1);
    }

    private void loadUrlFromContext(WebView view, String url) {
        if (url != null && url.length() != 0 && view != null) {
            url = this.smartUrlFilter(url);
            if (!view.getWebViewClient().shouldOverrideUrlLoading(view, url)) {
                this.loadUrl(view, url);
            }
        }
    }

    private void loadUrl(WebView view, String url) {
        this.updateTitleBarForNewLoad(view, url);
        view.loadUrl(url);
    }

    private void loadUrlDataIn(Tab t, UrlData data) {
        this.updateTitleBarForNewLoad(t.getWebView(), data.mUrl);
        data.loadIn(t);
    }

    private void updateTitleBarForNewLoad(WebView view, String url) {
        if (view == this.getTopWindow()) {
            this.setUrlTitle(url, null);
            this.setFavicon(null);
            this.onProgressChanged(view, 10);
        }
    }

    private String smartUrlFilter(Uri inUri) {
        if (inUri != null) {
            return this.smartUrlFilter(inUri.toString());
        }
        return null;
    }

    String smartUrlFilter(String url) {
        String inUrl = url.trim();
        boolean hasSpace = inUrl.indexOf(32) != -1;
        Matcher matcher = ACCEPTED_URI_SCHEMA.matcher(inUrl);
        if (matcher.matches()) {
            String scheme = matcher.group(1);
            String lcScheme = scheme.toLowerCase();
            if (!lcScheme.equals(scheme)) {
                inUrl = lcScheme + matcher.group(2);
            }
            if (hasSpace) {
                inUrl = inUrl.replace(" ", "%20");
            }
            return inUrl;
        }
        if (!hasSpace && Patterns.WEB_URL.matcher(inUrl).matches()) {
            return URLUtil.guessUrl((String)inUrl);
        }
        Browser.addSearchUrl((ContentResolver)this.mResolver, (String)inUrl);
        return URLUtil.composeSearchUrl((String)inUrl, (String)QuickSearch_G, (String)QUERY_PLACE_HOLDER);
    }

    void setShouldShowErrorConsole(boolean flag) {
        if (flag == this.mShouldShowErrorConsole) {
            return;
        }
        Tab t = this.mTabControl.getCurrentTab();
        if (t == null) {
            return;
        }
        this.mShouldShowErrorConsole = flag;
        ErrorConsoleView errorConsole = t.getErrorConsole(true);
        if (flag) {
            if (errorConsole.numberOfErrors() > 0) {
                errorConsole.showConsole(0);
            } else {
                errorConsole.showConsole(2);
            }
            this.mErrorConsoleContainer.addView((View)errorConsole, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        } else {
            this.mErrorConsoleContainer.removeView((View)errorConsole);
        }
    }

    boolean shouldShowErrorConsole() {
        return this.mShouldShowErrorConsole;
    }

    private void setStatusBarVisibility(boolean visible) {
        int flag = visible ? 0 : 1024;
        this.getWindow().setFlags(flag, 1024);
    }

    private void sendNetworkType(String type, String subtype) {
        WebView w = this.mTabControl.getCurrentWebView();
        if (w != null) {
            w.setNetworkType(type, subtype);
        }
    }

    private void packageChanged(String packageName, boolean wasAdded) {
        WebView w = this.mTabControl.getCurrentWebView();
        if (w == null) {
            return;
        }
        if (wasAdded) {
            w.addPackageName(packageName);
        } else {
            w.removePackageName(packageName);
        }
    }

    private void addPackageNames(Set<String> packageNames) {
        WebView w = this.mTabControl.getCurrentWebView();
        if (w == null) {
            return;
        }
        w.addPackageNames(packageNames);
    }

    private void getInstalledPackages() {
        AsyncTask<Void, Void, Set<String>> task = new AsyncTask<Void, Void, Set<String>>(){

            protected Set<String> doInBackground(Void ... unused) {
                HashSet<String> installedPackages = new HashSet<String>();
                PackageManager pm = BrowserActivity.this.getPackageManager();
                if (pm != null) {
                    List packages = pm.getInstalledPackages(0);
                    for (PackageInfo p : packages) {
                        18 v0 = this;
                        if (!sGoogleApps.contains(p.packageName)) continue;
                        installedPackages.add(p.packageName);
                    }
                }
                return installedPackages;
            }

            protected void onPostExecute(Set<String> installedPackages) {
                BrowserActivity.this.addPackageNames(installedPackages);
            }
        };
        task.execute((Object[])new Void[0]);
    }

    private static boolean needsRlz(Uri uri) {
        return uri.getQueryParameter("rlz") == null && uri.getQueryParameter("q") != null && UrlUtils.isGoogleUri(uri);
    }

    private static Uri addRlzParameter(Uri uri, String rlz) {
        if (rlz.isEmpty()) {
            return uri;
        }
        return uri.buildUpon().appendQueryParameter("rlz", rlz).build();
    }

    static {
        SYSTEM_CPU_FORMAT = new int[]{288, 8224, 8224, 8224, 8224, 8224, 8224, 8224};
        COVER_SCREEN_PARAMS = new FrameLayout.LayoutParams(-1, -1);
        COVER_SCREEN_GRAVITY_CENTER = new FrameLayout.LayoutParams(-1, -1, 17);
        WINDOW_SHORTCUT_ID_ARRAY = new int[]{2131492987, 2131492988, 2131492989, 2131492990, 2131492991, 2131492992, 2131492993, 2131492994};
        sGoogleApps = new HashSet<String>();
        sGoogleApps.add("com.google.android.youtube");
        EMPTY_URL_DATA = new UrlData(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UrlData {
        final String mUrl;
        final Map<String, String> mHeaders;
        final Intent mVoiceIntent;

        UrlData(String url) {
            this.mUrl = url;
            this.mHeaders = null;
            this.mVoiceIntent = null;
        }

        UrlData(String url, Map<String, String> headers, Intent intent) {
            this.mUrl = url;
            this.mHeaders = headers;
            this.mVoiceIntent = "android.speech.action.VOICE_SEARCH_RESULTS".equals(intent.getAction()) ? intent : null;
        }

        boolean isEmpty() {
            return this.mVoiceIntent == null && (this.mUrl == null || this.mUrl.length() == 0);
        }

        public void loadIn(Tab t) {
            if (this.mVoiceIntent != null) {
                t.activateVoiceSearchMode(this.mVoiceIntent);
            } else {
                t.getWebView().loadUrl(this.mUrl, this.mHeaders);
            }
        }
    }

    private class SetAsWallpaper
    extends Thread
    implements MenuItem.OnMenuItemClickListener,
    DialogInterface.OnCancelListener {
        private URL mUrl;
        private ProgressDialog mWallpaperProgress;
        private boolean mCanceled = false;

        public SetAsWallpaper(String url) {
            try {
                this.mUrl = new URL(url);
            }
            catch (MalformedURLException e) {
                this.mUrl = null;
            }
        }

        public void onCancel(DialogInterface dialog) {
            this.mCanceled = true;
        }

        public boolean onMenuItemClick(MenuItem item) {
            if (this.mUrl != null) {
                this.mWallpaperProgress = new ProgressDialog((Context)BrowserActivity.this);
                this.mWallpaperProgress.setIndeterminate(true);
                this.mWallpaperProgress.setMessage(BrowserActivity.this.getText(2131230977));
                this.mWallpaperProgress.setCancelable(true);
                this.mWallpaperProgress.setOnCancelListener((DialogInterface.OnCancelListener)this);
                this.mWallpaperProgress.show();
                this.start();
            }
            return true;
        }

        public void run() {
            Drawable oldWallpaper = BrowserActivity.this.getWallpaper();
            try {
                InputStream inputstream = this.mUrl.openStream();
                if (inputstream != null) {
                    BrowserActivity.this.setWallpaper(inputstream);
                }
            }
            catch (IOException e) {
                Log.e((String)BrowserActivity.LOGTAG, (String)"Unable to set new wallpaper");
                this.mCanceled = true;
            }
            if (this.mCanceled) {
                int width = oldWallpaper.getIntrinsicWidth();
                int height = oldWallpaper.getIntrinsicHeight();
                Bitmap bm = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
                Canvas canvas = new Canvas(bm);
                oldWallpaper.setBounds(0, 0, width, height);
                oldWallpaper.draw(canvas);
                try {
                    BrowserActivity.this.setWallpaper(bm);
                }
                catch (IOException e) {
                    Log.e((String)BrowserActivity.LOGTAG, (String)"Unable to restore old wallpaper.");
                }
                this.mCanceled = false;
            }
            if (this.mWallpaperProgress.isShowing()) {
                this.mWallpaperProgress.dismiss();
            }
        }
    }

    private class Download
    implements MenuItem.OnMenuItemClickListener {
        private String mText;

        public boolean onMenuItemClick(MenuItem item) {
            BrowserActivity.this.onDownloadStartNoStream(this.mText, null, null, null, -1L);
            return true;
        }

        public Download(String toDownload) {
            this.mText = toDownload;
        }
    }

    private class Copy
    implements MenuItem.OnMenuItemClickListener {
        private CharSequence mText;

        public boolean onMenuItemClick(MenuItem item) {
            BrowserActivity.this.copy(this.mText);
            return true;
        }

        public Copy(CharSequence toCopy) {
            this.mText = toCopy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClearThumbnails
    extends AsyncTask<File, Void, Void> {
        private ClearThumbnails() {
        }

        public Void doInBackground(File ... files) {
            if (files != null) {
                for (File f : files) {
                    if (f.delete()) continue;
                    Log.e((String)BrowserActivity.LOGTAG, (String)(f.getPath() + " was not deleted"));
                }
            }
            return null;
        }
    }
}

