/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

class BookmarkItem
extends LinearLayout {
    protected TextView mTextView;
    protected TextView mUrlText;
    protected ImageView mImageView;
    protected String mUrl;
    protected String mTitle;

    BookmarkItem(Context context) {
        super(context);
        LayoutInflater factory = LayoutInflater.from((Context)context);
        factory.inflate(2130903053, (ViewGroup)this);
        this.mTextView = (TextView)this.findViewById(2131492866);
        this.mUrlText = (TextView)this.findViewById(2131492867);
        this.mImageView = (ImageView)this.findViewById(2131492865);
        View star = this.findViewById(2131492910);
        star.setVisibility(8);
    }

    void copyTo(BookmarkItem item) {
        item.mTextView.setText(this.mTextView.getText());
        item.mUrlText.setText(this.mUrlText.getText());
        item.mImageView.setImageDrawable(this.mImageView.getDrawable());
    }

    String getName() {
        return this.mTitle;
    }

    TextView getNameTextView() {
        return this.mTextView;
    }

    String getUrl() {
        return this.mUrl;
    }

    void setFavicon(Bitmap b) {
        if (b != null) {
            this.mImageView.setImageBitmap(b);
        } else {
            this.mImageView.setImageResource(2130837504);
        }
    }

    void setName(String name) {
        if (name == null) {
            return;
        }
        this.mTitle = name;
        if (name.length() > 80) {
            name = name.substring(0, 80);
        }
        this.mTextView.setText((CharSequence)name);
    }

    void setUrl(String url) {
        if (url == null) {
            return;
        }
        this.mUrl = url;
        if (url.length() > 80) {
            url = url.substring(0, 80);
        }
        this.mUrlText.setText((CharSequence)url);
    }
}

