/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.android.browser.BrowserActivity;
import com.android.browser.Tab;
import com.android.browser.TabControl;

public class ActiveTabsPage
extends LinearLayout {
    private final BrowserActivity mBrowserActivity;
    private final LayoutInflater mFactory;
    private final TabControl mControl;
    private final TabsListAdapter mAdapter;
    private final ListView mListView;

    public ActiveTabsPage(BrowserActivity context, TabControl control) {
        super((Context)context);
        this.mBrowserActivity = context;
        this.mControl = control;
        this.mFactory = LayoutInflater.from((Context)context);
        this.mFactory.inflate(2130903040, (ViewGroup)this);
        this.mListView = (ListView)this.findViewById(2131492864);
        this.mAdapter = new TabsListAdapter();
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (ActiveTabsPage.this.mControl.canCreateNewTab()) {
                    --position;
                }
                boolean needToAttach = false;
                if (position == -1) {
                    ActiveTabsPage.this.mBrowserActivity.openTabToHomePage();
                } else {
                    needToAttach = !ActiveTabsPage.this.mBrowserActivity.switchToTab(position);
                }
                ActiveTabsPage.this.mBrowserActivity.removeActiveTabPage(needToAttach);
            }
        });
    }

    private class TabsListAdapter
    extends BaseAdapter {
        private boolean mNotified = true;
        private int mReturnedCount;
        private Handler mHandler = new Handler();

        private TabsListAdapter() {
        }

        public int getCount() {
            int count = ActiveTabsPage.this.mControl.getTabCount();
            if (ActiveTabsPage.this.mControl.canCreateNewTab()) {
                ++count;
            }
            if (!this.mNotified && count != this.mReturnedCount) {
                this.notifyChange();
                return this.mReturnedCount;
            }
            this.mReturnedCount = count;
            this.mNotified = false;
            return count;
        }

        public Object getItem(int position) {
            return null;
        }

        public long getItemId(int position) {
            return position;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public int getItemViewType(int position) {
            if (ActiveTabsPage.this.mControl.canCreateNewTab()) {
                --position;
            }
            return position == -1 ? -1 : 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            final int tabCount = ActiveTabsPage.this.mControl.getTabCount();
            if (ActiveTabsPage.this.mControl.canCreateNewTab()) {
                --position;
            }
            if (convertView == null) {
                convertView = ActiveTabsPage.this.mFactory.inflate(position == -1 ? 2130903062 : 2130903061, null);
            }
            if (position != -1) {
                TextView title = (TextView)convertView.findViewById(2131492866);
                TextView url = (TextView)convertView.findViewById(2131492867);
                ImageView favicon = (ImageView)convertView.findViewById(2131492865);
                View close = convertView.findViewById(2131492942);
                Tab tab = ActiveTabsPage.this.mControl.getTab(position);
                tab.populatePickerData();
                title.setText((CharSequence)tab.getTitle());
                url.setText((CharSequence)tab.getUrl());
                Bitmap icon = tab.getFavicon();
                if (icon != null) {
                    favicon.setImageBitmap(icon);
                } else {
                    favicon.setImageResource(2130837504);
                }
                final int closePosition = position;
                close.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ActiveTabsPage.this.mBrowserActivity.closeTab(ActiveTabsPage.this.mControl.getTab(closePosition));
                        if (tabCount == 1) {
                            ActiveTabsPage.this.mBrowserActivity.openTabToHomePage();
                            ActiveTabsPage.this.mBrowserActivity.removeActiveTabPage(false);
                        } else {
                            TabsListAdapter.this.mNotified = true;
                            TabsListAdapter.this.notifyDataSetChanged();
                        }
                    }
                });
            }
            return convertView;
        }

        void notifyChange() {
            this.mHandler.post(new Runnable(){

                public void run() {
                    TabsListAdapter.this.mNotified = true;
                    TabsListAdapter.this.notifyDataSetChanged();
                }
            });
        }
    }

    private static class CloseHolder
    extends ImageView {
        public CloseHolder(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public void setPressed(boolean pressed) {
            if (pressed && ((View)this.getParent()).isPressed()) {
                return;
            }
            super.setPressed(pressed);
        }
    }
}

