/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser.widget;

import android.app.PendingIntent;
import android.app.Service;
import android.appwidget.AppWidgetManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.provider.Browser;
import android.service.urlrenderer.UrlRenderer;
import android.util.Log;
import android.widget.RemoteViews;
import com.android.browser.widget.BookmarkWidgetProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class BookmarkWidgetService
extends Service
implements UrlRenderer.Callback {
    private static final String TAG = "BookmarkWidgetService";
    public static final String UPDATE = "com.android.browser.widget.UPDATE";
    private static final String NEXT = "com.android.browser.widget.NEXT";
    private static final String PREV = "com.android.browser.widget.PREV";
    private static final String EXTRA_ID = "com.android.browser.widget.extra.ID";
    private static final int WIDTH = 306;
    private static final int HEIGHT = 386;
    private static final int MAX_SERVICE_RETRY_COUNT = 5;
    private static final int NO_ID = -1;
    private static final int MSG_UPDATE = 0;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    if (BookmarkWidgetService.this.mRenderer != null) {
                        BookmarkWidgetService.this.queryCursorAndRender();
                        break;
                    }
                    if (++BookmarkWidgetService.this.mServiceRetryCount > 5) break;
                    BookmarkWidgetService.this.mHandler.sendEmptyMessageDelayed(0, 1000L);
                    break;
                }
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            BookmarkWidgetService.this.mRenderer = new UrlRenderer(service);
        }

        public void onServiceDisconnected(ComponentName className) {
            BookmarkWidgetService.this.mRenderer = null;
        }
    };
    private final HashMap<Integer, RenderResult> mIdsToResults = new HashMap();
    private final ArrayList<Integer> mIdList = new ArrayList();
    private final HashMap<String, Integer> mUrlsToIds = new HashMap();
    private int mCurrentId = -1;
    private UrlRenderer mRenderer;
    private int mServiceRetryCount;
    private static final String QUERY_WHERE = "bookmark == 1";
    private static final String[] PROJECTION = new String[]{"_id", "title", "url"};

    public void onCreate() {
        this.bindService(new Intent("android.service.urlrenderer.UrlRendererService"), this.mConnection, 1);
    }

    public void onDestroy() {
        this.unbindService(this.mConnection);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        String action = intent.getAction();
        if (UPDATE.equals(action)) {
            this.mHandler.sendEmptyMessage(0);
        } else if (PREV.equals(action) && this.mIdList.size() > 1) {
            int prev = this.getPreviousId(intent);
            if (prev == -1) {
                Log.d((String)TAG, (String)"Could not determine previous id");
                return 2;
            }
            RenderResult res = this.mIdsToResults.get(prev);
            if (res != null) {
                this.updateWidget(res);
            }
        } else if (NEXT.equals(action) && this.mIdList.size() > 1) {
            int next = this.getNextId(intent);
            if (next == -1) {
                Log.d((String)TAG, (String)"Could not determine next id");
                return 2;
            }
            RenderResult res = this.mIdsToResults.get(next);
            if (res != null) {
                this.updateWidget(res);
            }
        }
        return 1;
    }

    private int getPreviousId(Intent intent) {
        int id2;
        int listSize = this.mIdList.size();
        if (listSize <= 1) {
            return -1;
        }
        int curr = intent.getIntExtra(EXTRA_ID, -1);
        if (curr == -1) {
            return -1;
        }
        if (this.mIdList.get(0) == curr) {
            return this.mIdList.get(listSize - 1);
        }
        int prev = -1;
        Iterator<Integer> i$ = this.mIdList.iterator();
        while (i$.hasNext() && (id2 = i$.next().intValue()) != curr) {
            prev = id2;
        }
        return prev;
    }

    private int getNextId(Intent intent) {
        int id2;
        int listSize = this.mIdList.size();
        if (listSize <= 1) {
            return -1;
        }
        int curr = intent.getIntExtra(EXTRA_ID, -1);
        if (curr == -1) {
            return -1;
        }
        if (this.mIdList.get(listSize - 1) == curr) {
            return this.mIdList.get(0);
        }
        int i = 1;
        Iterator<Integer> i$ = this.mIdList.iterator();
        while (i$.hasNext() && (id2 = i$.next().intValue()) != curr) {
            ++i;
        }
        return this.mIdList.get(i);
    }

    private void updateWidget(RenderResult res) {
        RemoteViews views = new RemoteViews(this.getPackageName(), 2130903043);
        Intent prev = new Intent(PREV, null, (Context)this, BookmarkWidgetService.class);
        prev.putExtra(EXTRA_ID, res.mId);
        views.setOnClickPendingIntent(2131492871, PendingIntent.getService((Context)this, (int)0, (Intent)prev, (int)0x10000000));
        Intent next = new Intent(NEXT, null, (Context)this, BookmarkWidgetService.class);
        next.putExtra(EXTRA_ID, res.mId);
        views.setOnClickPendingIntent(2131492872, PendingIntent.getService((Context)this, (int)0, (Intent)next, (int)0x10000000));
        String displayTitle = res.mTitle;
        if (displayTitle == null) {
            displayTitle = res.mUrl;
        }
        views.setTextViewText(2131492866, (CharSequence)displayTitle);
        if (res.mBitmap != null) {
            views.setImageViewBitmap(2131492873, res.mBitmap);
            views.setViewVisibility(2131492873, 0);
            views.setViewVisibility(2131492874, 8);
        } else {
            views.setViewVisibility(2131492874, 0);
            views.setViewVisibility(2131492873, 8);
        }
        this.mCurrentId = res.mId;
        AppWidgetManager.getInstance((Context)this).updateAppWidget(new ComponentName((Context)this, BookmarkWidgetProvider.class), views);
    }

    private void queryCursorAndRender() {
        this.mIdList.clear();
        this.mIdsToResults.clear();
        Cursor c = this.getContentResolver().query(Browser.BOOKMARKS_URI, PROJECTION, QUERY_WHERE, null, null);
        if (c != null) {
            if (c.moveToFirst()) {
                ArrayList<String> urls = new ArrayList<String>(c.getCount());
                boolean sawCurrentId = false;
                do {
                    int id2 = c.getInt(0);
                    String title = c.getString(1);
                    String url = c.getString(2);
                    this.mIdList.add(id2);
                    this.mUrlsToIds.put(url, id2);
                    if (this.mCurrentId == id2) {
                        sawCurrentId = true;
                    }
                    RenderResult res = new RenderResult(id2, title, url);
                    this.mIdsToResults.put(id2, res);
                    urls.add(url);
                } while (c.moveToNext());
                this.mRenderer.render(urls, 306, 386, (UrlRenderer.Callback)this);
                if (!sawCurrentId) {
                    this.mCurrentId = this.mIdList.get(0);
                }
            }
            c.close();
        }
    }

    public void complete(String url, ParcelFileDescriptor result) {
        int id2 = this.mUrlsToIds.get(url);
        if (id2 == -1) {
            Log.d((String)TAG, (String)("No matching id found during completion of " + url));
            return;
        }
        RenderResult res = this.mIdsToResults.get(id2);
        if (res == null) {
            Log.d((String)TAG, (String)("No result found during completion of " + url));
            return;
        }
        if (result != null) {
            ParcelFileDescriptor.AutoCloseInputStream input = new ParcelFileDescriptor.AutoCloseInputStream(result);
            Bitmap orig = BitmapFactory.decodeStream((InputStream)input, null, null);
            res.mBitmap = Bitmap.createScaledBitmap((Bitmap)orig, (int)306, (int)386, (boolean)true);
            try {
                input.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.mCurrentId == id2) {
            this.updateWidget(res);
        }
    }

    private static class RenderResult {
        final int mId;
        final String mTitle;
        final String mUrl;
        Bitmap mBitmap;

        RenderResult(int id2, String title, String url) {
            this.mId = id2;
            this.mTitle = title;
            this.mUrl = url;
        }
    }
}

