/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser.search;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.Log;
import com.android.browser.search.DefaultSearchEngine;
import com.android.browser.search.OpenSearchSearchEngine;
import com.android.browser.search.SearchEngine;
import com.android.browser.search.SearchEngineInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchEngines {
    private static final String TAG = "SearchEngines";

    public static SearchEngine getDefaultSearchEngine(Context context) {
        return DefaultSearchEngine.create(context);
    }

    public static List<SearchEngineInfo> getSearchEngineInfos(Context context) {
        ArrayList<SearchEngineInfo> searchEngineInfos = new ArrayList<SearchEngineInfo>();
        Resources res = context.getResources();
        String[] searchEngines = res.getStringArray(2131099737);
        for (int i = 0; i < searchEngines.length; ++i) {
            String name = searchEngines[i];
            SearchEngineInfo info = new SearchEngineInfo(context, name);
            searchEngineInfos.add(info);
        }
        return searchEngineInfos;
    }

    public static SearchEngine get(Context context, String name) {
        SearchEngine defaultSearchEngine = SearchEngines.getDefaultSearchEngine(context);
        if (TextUtils.isEmpty((CharSequence)name) || defaultSearchEngine != null && name.equals(defaultSearchEngine.getName())) {
            return defaultSearchEngine;
        }
        SearchEngineInfo searchEngineInfo = SearchEngines.getSearchEngineInfo(context, name);
        if (searchEngineInfo == null) {
            return defaultSearchEngine;
        }
        return new OpenSearchSearchEngine(context, searchEngineInfo);
    }

    private static SearchEngineInfo getSearchEngineInfo(Context context, String name) {
        try {
            return new SearchEngineInfo(context, name);
        }
        catch (IllegalArgumentException exception) {
            Log.e((String)TAG, (String)("Cannot load search engine " + name), (Throwable)exception);
            return null;
        }
    }
}

