/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser.search;

import android.app.SearchManager;
import android.app.SearchableInfo;
import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.android.browser.search.SearchEngine;

public class DefaultSearchEngine
implements SearchEngine {
    private static final String TAG = "DefaultSearchEngine";
    private final SearchableInfo mSearchable;
    private final CharSequence mLabel;

    private DefaultSearchEngine(Context context, SearchableInfo searchable) {
        this.mSearchable = searchable;
        this.mLabel = this.loadLabel(context, this.mSearchable.getSearchActivity());
    }

    public static DefaultSearchEngine create(Context context) {
        SearchManager searchManager = (SearchManager)context.getSystemService("search");
        ComponentName name = searchManager.getWebSearchActivity();
        if (name == null) {
            return null;
        }
        SearchableInfo searchable = searchManager.getSearchableInfo(name);
        if (searchable == null) {
            return null;
        }
        return new DefaultSearchEngine(context, searchable);
    }

    private CharSequence loadLabel(Context context, ComponentName activityName) {
        PackageManager pm = context.getPackageManager();
        try {
            ActivityInfo ai = pm.getActivityInfo(activityName, 0);
            return ai.loadLabel(pm);
        }
        catch (PackageManager.NameNotFoundException ex) {
            Log.e((String)TAG, (String)("Web search activity not found: " + activityName));
            return null;
        }
    }

    public String getName() {
        String packageName = this.mSearchable.getSearchActivity().getPackageName();
        if ("com.google.android.googlequicksearchbox".equals(packageName)) {
            return "google";
        }
        if ("com.android.quicksearchbox".equals(packageName)) {
            return "google";
        }
        return packageName;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public void startSearch(Context context, String query, Bundle appData, String extraData) {
        try {
            Intent intent = new Intent("android.intent.action.WEB_SEARCH");
            intent.setComponent(this.mSearchable.getSearchActivity());
            intent.addCategory("android.intent.category.DEFAULT");
            intent.putExtra("query", query);
            if (appData != null) {
                intent.putExtra("app_data", appData);
            }
            if (extraData != null) {
                intent.putExtra("intent_extra_data_key", extraData);
            }
            intent.putExtra("com.android.browser.application_id", context.getPackageName());
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException ex) {
            Log.e((String)TAG, (String)("Web search activity not found: " + this.mSearchable.getSearchActivity()));
        }
    }

    public Cursor getSuggestions(Context context, String query) {
        SearchManager searchManager = (SearchManager)context.getSystemService("search");
        return searchManager.getSuggestions(this.mSearchable, query);
    }

    public boolean supportsSuggestions() {
        return !TextUtils.isEmpty((CharSequence)this.mSearchable.getSuggestAuthority());
    }

    public void close() {
    }

    public boolean supportsVoiceSearch() {
        return this.getName().equals("google");
    }

    public String toString() {
        return "ActivitySearchEngine{" + this.mSearchable + "}";
    }
}

