/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.StatFs;
import android.webkit.WebStorage;
import com.android.browser.WebsiteSettingsActivity;
import java.io.File;

class WebStorageSizeManager {
    private static final boolean LOGV_ENABLED = false;
    private static final boolean LOGD_ENABLED = true;
    private static final String LOGTAG = "browser";
    public static final long ORIGIN_DEFAULT_QUOTA = 0x300000L;
    public static final long QUOTA_INCREASE_STEP = 0x100000L;
    public static final long APPCACHE_MAXSIZE_PADDING = 524288L;
    private static final int OUT_OF_SPACE_ID = 1;
    private static long mLastOutOfSpaceNotificationTime = -1L;
    private static final long NOTIFICATION_INTERVAL = 300000L;
    private static final long RESET_NOTIFICATION_INTERVAL = 3000L;
    private final Context mContext;
    private final long mGlobalLimit;
    private long mAppCacheMaxSize;
    private DiskInfo mDiskInfo;

    public WebStorageSizeManager(Context ctx, DiskInfo diskInfo, AppCacheInfo appCacheInfo) {
        this.mContext = ctx;
        this.mDiskInfo = diskInfo;
        this.mGlobalLimit = this.getGlobalLimit();
        this.mAppCacheMaxSize = Math.max(this.mGlobalLimit / 4L, appCacheInfo.getAppCacheSizeBytes());
    }

    public long getAppCacheMaxSize() {
        return this.mAppCacheMaxSize;
    }

    public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        long totalUnusedQuota = this.mGlobalLimit - totalUsedQuota - this.mAppCacheMaxSize;
        if (totalUnusedQuota <= 0L) {
            if (totalUsedQuota > 0L) {
                this.scheduleOutOfSpaceNotification();
            }
            quotaUpdater.updateQuota(currentQuota);
            return;
        }
        long newOriginQuota = currentQuota;
        if (newOriginQuota == 0L) {
            newOriginQuota = totalUnusedQuota >= estimatedSize ? estimatedSize : 0L;
        } else {
            long quotaIncrease = estimatedSize == 0L ? Math.min(0x100000L, totalUnusedQuota) : estimatedSize;
            newOriginQuota += quotaIncrease;
            if (quotaIncrease > totalUnusedQuota) {
                newOriginQuota = currentQuota;
            }
        }
        quotaUpdater.updateQuota(newOriginQuota);
    }

    public void onReachedMaxAppCacheSize(long spaceNeeded, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
        long totalUnusedQuota = this.mGlobalLimit - totalUsedQuota - this.mAppCacheMaxSize;
        if (totalUnusedQuota < spaceNeeded + 524288L) {
            if (totalUsedQuota > 0L) {
                this.scheduleOutOfSpaceNotification();
            }
            quotaUpdater.updateQuota(0L);
            return;
        }
        this.mAppCacheMaxSize += spaceNeeded + 524288L;
        quotaUpdater.updateQuota(this.mAppCacheMaxSize);
    }

    static void resetLastOutOfSpaceNotificationTime() {
        mLastOutOfSpaceNotificationTime = System.currentTimeMillis() - 300000L + 3000L;
    }

    private long getGlobalLimit() {
        long freeSpace = this.mDiskInfo.getFreeSpaceSizeBytes();
        long fileSystemSize = this.mDiskInfo.getTotalSizeBytes();
        return WebStorageSizeManager.calculateGlobalLimit(fileSystemSize, freeSpace);
    }

    static long calculateGlobalLimit(long fileSystemSizeBytes, long freeSpaceBytes) {
        long maxSizeStepBytes;
        if (fileSystemSizeBytes <= 0L || freeSpaceBytes <= 0L || freeSpaceBytes > fileSystemSizeBytes) {
            return 0L;
        }
        long fileSystemSizeRatio = 2 << (int)Math.floor(Math.log10(fileSystemSizeBytes / 0x100000L));
        long maxSizeBytes = (long)Math.min(Math.floor(fileSystemSizeBytes / fileSystemSizeRatio), Math.floor(freeSpaceBytes / 2L));
        if (maxSizeBytes < (maxSizeStepBytes = 0x100000L)) {
            return 0L;
        }
        long roundingExtra = maxSizeBytes % maxSizeStepBytes == 0L ? 0L : 1L;
        return maxSizeStepBytes * (maxSizeBytes / maxSizeStepBytes + roundingExtra);
    }

    private void scheduleOutOfSpaceNotification() {
        if (this.mContext == null) {
            return;
        }
        if (mLastOutOfSpaceNotificationTime == -1L || System.currentTimeMillis() - mLastOutOfSpaceNotificationTime > 300000L) {
            int icon = 17301642;
            String title = this.mContext.getString(2131230950);
            String text = this.mContext.getString(2131230951);
            long when = System.currentTimeMillis();
            Intent intent = new Intent(this.mContext, WebsiteSettingsActivity.class);
            PendingIntent contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)intent, (int)0);
            Notification notification = new Notification(icon, (CharSequence)title, when);
            notification.setLatestEventInfo(this.mContext, (CharSequence)title, (CharSequence)text, contentIntent);
            notification.flags |= 0x10;
            String ns = "notification";
            NotificationManager mgr = (NotificationManager)this.mContext.getSystemService(ns);
            if (mgr != null) {
                mLastOutOfSpaceNotificationTime = System.currentTimeMillis();
                mgr.notify(1, notification);
            }
        }
    }

    public static class WebKitAppCacheInfo
    implements AppCacheInfo {
        private static final String APPCACHE_FILE = "ApplicationCache.db";
        private String mAppCachePath;

        public WebKitAppCacheInfo(String path) {
            this.mAppCachePath = path;
        }

        public long getAppCacheSizeBytes() {
            File file = new File(this.mAppCachePath + File.separator + APPCACHE_FILE);
            return file.length();
        }
    }

    public static interface AppCacheInfo {
        public long getAppCacheSizeBytes();
    }

    public static class StatFsDiskInfo
    implements DiskInfo {
        private StatFs mFs;

        public StatFsDiskInfo(String path) {
            this.mFs = new StatFs(path);
        }

        public long getFreeSpaceSizeBytes() {
            return this.mFs.getAvailableBlocks() * this.mFs.getBlockSize();
        }

        public long getTotalSizeBytes() {
            return this.mFs.getBlockCount() * this.mFs.getBlockSize();
        }
    }

    public static interface DiskInfo {
        public long getFreeSpaceSizeBytes();

        public long getTotalSizeBytes();
    }
}

