/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.webkit.WebView;
import android.widget.LinearLayout;
import com.android.browser.BrowserActivity;

class WebDialog
extends LinearLayout {
    protected WebView mWebView;
    protected BrowserActivity mBrowserActivity;
    private boolean mIsVisible;
    private View.OnClickListener mCancelListener = new View.OnClickListener(){

        public void onClick(View v) {
            WebDialog.this.mBrowserActivity.closeDialogs();
        }
    };

    WebDialog(BrowserActivity context) {
        super((Context)context);
        this.mBrowserActivity = context;
    }

    protected void addCancel() {
        View button = this.findViewById(2131492885);
        if (button != null) {
            button.setOnClickListener(this.mCancelListener);
        }
    }

    protected void dismiss() {
        this.startAnimation(AnimationUtils.loadAnimation((Context)this.mBrowserActivity, (int)2130968577));
        this.mIsVisible = false;
    }

    protected void hideSoftInput() {
        InputMethodManager imm = (InputMethodManager)this.mBrowserActivity.getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.mWebView.getWindowToken(), 0);
    }

    protected boolean isVisible() {
        return this.mIsVisible;
    }

    void setWebView(WebView webview) {
        this.mWebView = webview;
    }

    protected void show() {
        this.startAnimation(AnimationUtils.loadAnimation((Context)this.mBrowserActivity, (int)2130968576));
        this.mIsVisible = true;
    }
}

