/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.PaintDrawable;
import android.os.Handler;
import android.os.Message;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ImageSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.android.browser.BrowserActivity;

public class TitleBar
extends LinearLayout {
    private TextView mTitle;
    private Drawable mCloseDrawable;
    private ImageView mRtButton;
    private Drawable mCircularProgress;
    private ProgressBar mHorizontalProgress;
    private ImageView mFavicon;
    private ImageView mLockIcon;
    private ImageView mStopButton;
    private Drawable mBookmarkDrawable;
    private Drawable mVoiceDrawable;
    private boolean mInLoad;
    private BrowserActivity mBrowserActivity;
    private Drawable mGenericFavicon;
    private int mIconDimension;
    private View mTitleBg;
    private MyHandler mHandler = new MyHandler();
    private Intent mVoiceSearchIntent;
    private boolean mInVoiceMode;
    private Drawable mVoiceModeBackground;
    private Drawable mNormalBackground;
    private Drawable mLoadingBackground;
    private ImageSpan mArcsSpan;
    private int mLeftMargin;
    private int mRightMargin;
    private static int LONG_PRESS = 1;

    public TitleBar(BrowserActivity context) {
        super((Context)context, null);
        LayoutInflater factory = LayoutInflater.from((Context)context);
        factory.inflate(2130903064, (ViewGroup)this);
        this.mBrowserActivity = context;
        this.mTitle = (TextView)this.findViewById(2131492866);
        this.mTitle.setCompoundDrawablePadding(5);
        this.mTitleBg = this.findViewById(2131492944);
        this.mLockIcon = (ImageView)this.findViewById(2131492945);
        this.mFavicon = (ImageView)this.findViewById(2131492865);
        this.mStopButton = (ImageView)this.findViewById(2131492946);
        this.mRtButton = (ImageView)this.findViewById(2131492947);
        Resources resources = context.getResources();
        this.mCircularProgress = resources.getDrawable(17302137);
        DisplayMetrics metrics = resources.getDisplayMetrics();
        this.mLeftMargin = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)metrics);
        this.mRightMargin = (int)TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)metrics);
        this.mIconDimension = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)metrics);
        this.mCircularProgress.setBounds(0, 0, this.mIconDimension, this.mIconDimension);
        this.mHorizontalProgress = (ProgressBar)this.findViewById(2131492943);
        this.mGenericFavicon = context.getResources().getDrawable(2130837504);
        this.mVoiceSearchIntent = new Intent("android.speech.action.WEB_SEARCH");
        this.mVoiceSearchIntent.putExtra("android.speech.extra.LANGUAGE_MODEL", "web_search");
        this.mVoiceSearchIntent.putExtra("android.speech.extras.SEND_APPLICATION_ID_EXTRA", false);
        PackageManager pm = context.getPackageManager();
        ResolveInfo ri = pm.resolveActivity(this.mVoiceSearchIntent, 65536);
        if (ri == null) {
            this.mVoiceSearchIntent = null;
        } else {
            this.mVoiceDrawable = resources.getDrawable(17301668);
        }
        this.mBookmarkDrawable = this.mRtButton.getDrawable();
        this.mVoiceModeBackground = resources.getDrawable(2130837568);
        this.mNormalBackground = this.mTitleBg.getBackground();
        this.mLoadingBackground = resources.getDrawable(2130837566);
        this.mArcsSpan = new ImageSpan((Context)context, 2130837506, 1);
    }

    public void createContextMenu(ContextMenu menu2) {
        MenuInflater inflater = this.mBrowserActivity.getMenuInflater();
        inflater.inflate(2131427338, (Menu)menu2);
        this.mBrowserActivity.onCreateContextMenu(menu2, (View)this, null);
    }

    public boolean onTouchEvent(MotionEvent event) {
        ImageView button = this.mInLoad ? this.mStopButton : this.mRtButton;
        switch (event.getAction()) {
            case 0: {
                if ((int)event.getX() > this.mTitleBg.getRight()) {
                    button.setPressed(true);
                    break;
                }
                this.mTitleBg.setPressed(true);
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(LONG_PRESS), ViewConfiguration.getLongPressTimeout());
                break;
            }
            case 2: {
                int slop = ViewConfiguration.get((Context)this.mBrowserActivity).getScaledTouchSlop();
                if ((int)event.getY() > this.getHeight() + slop) {
                    this.mTitleBg.setPressed(false);
                    button.setPressed(false);
                    this.mHandler.removeMessages(LONG_PRESS);
                    break;
                }
                int x = (int)event.getX();
                int titleRight = this.mTitleBg.getRight();
                if (this.mTitleBg.isPressed() && x > titleRight + slop) {
                    this.mTitleBg.setPressed(false);
                    this.mHandler.removeMessages(LONG_PRESS);
                    break;
                }
                if (!button.isPressed() || x >= titleRight - slop) break;
                button.setPressed(false);
                break;
            }
            case 3: {
                button.setPressed(false);
                this.mTitleBg.setPressed(false);
                this.mHandler.removeMessages(LONG_PRESS);
                break;
            }
            case 1: {
                if (button.isPressed()) {
                    if (this.mInVoiceMode) {
                        if (this.mBrowserActivity.getTabControl().getCurrentTab().voiceSearchSourceIsGoogle()) {
                            Intent i = new Intent("com.android.common.speech.LOG_EVENT");
                            i.putExtra("extra_event", 0);
                            this.mBrowserActivity.sendBroadcast(i);
                        }
                        this.mBrowserActivity.startActivity(this.mVoiceSearchIntent);
                    } else if (this.mInLoad) {
                        this.mBrowserActivity.stopLoading();
                    } else {
                        this.mBrowserActivity.bookmarksOrHistoryPicker(false);
                    }
                    button.setPressed(false);
                    break;
                }
                if (!this.mTitleBg.isPressed()) break;
                this.mHandler.removeMessages(LONG_PRESS);
                if (this.mInVoiceMode) {
                    if (this.mBrowserActivity.getTabControl().getCurrentTab().voiceSearchSourceIsGoogle()) {
                        Intent i = new Intent("com.android.common.speech.LOG_EVENT");
                        i.putExtra("extra_event", 1);
                        this.mBrowserActivity.sendBroadcast(i);
                    }
                    this.mBrowserActivity.showVoiceSearchResults(((Object)this.mTitle.getText()).toString().trim());
                } else {
                    this.mBrowserActivity.editUrl();
                }
                this.mTitleBg.setPressed(false);
                break;
            }
        }
        return true;
    }

    void setFavicon(Bitmap icon) {
        Drawable[] array2 = new Drawable[3];
        array2[0] = new PaintDrawable(-16777216);
        PaintDrawable p = new PaintDrawable(-1);
        array2[1] = p;
        array2[2] = icon == null ? this.mGenericFavicon : new BitmapDrawable(icon);
        LayerDrawable d = new LayerDrawable(array2);
        d.setLayerInset(1, 1, 1, 1, 1);
        d.setLayerInset(2, 2, 2, 2, 2);
        this.mFavicon.setImageDrawable((Drawable)d);
    }

    void setInVoiceMode(boolean inVoiceMode) {
        if (this.mInVoiceMode == inVoiceMode) {
            return;
        }
        boolean bl = this.mInVoiceMode = inVoiceMode && this.mVoiceSearchIntent != null;
        if (this.mInVoiceMode) {
            this.mRtButton.setImageDrawable(this.mVoiceDrawable);
            Drawable titleDrawable = this.mVoiceModeBackground;
            this.mTitle.setEllipsize(null);
            this.mRtButton.setVisibility(0);
            this.mStopButton.setVisibility(8);
            this.mTitleBg.setBackgroundDrawable(titleDrawable);
            this.mTitleBg.setPadding(this.mLeftMargin, this.mTitleBg.getPaddingTop(), this.mRightMargin, this.mTitleBg.getPaddingBottom());
        } else {
            Drawable titleDrawable;
            if (this.mInLoad) {
                titleDrawable = this.mLoadingBackground;
                this.mRtButton.setVisibility(8);
                this.mStopButton.setVisibility(0);
            } else {
                titleDrawable = this.mNormalBackground;
                this.mRtButton.setVisibility(0);
                this.mStopButton.setVisibility(8);
                this.mRtButton.setImageDrawable(this.mBookmarkDrawable);
            }
            this.mTitle.setEllipsize(TextUtils.TruncateAt.END);
            this.mTitleBg.setBackgroundDrawable(titleDrawable);
            this.mTitleBg.setPadding(this.mLeftMargin, 0, this.mRightMargin, 0);
        }
        this.mTitle.setSingleLine(!this.mInVoiceMode);
    }

    void setLock(Drawable d) {
        if (null == d) {
            this.mLockIcon.setVisibility(8);
        } else {
            this.mLockIcon.setImageDrawable(d);
            this.mLockIcon.setVisibility(0);
        }
    }

    void setProgress(int newProgress) {
        if (newProgress >= this.mHorizontalProgress.getMax()) {
            this.mTitle.setCompoundDrawables(null, null, null, null);
            ((Animatable)this.mCircularProgress).stop();
            this.mHorizontalProgress.setVisibility(4);
            if (!this.mInVoiceMode) {
                this.mRtButton.setImageDrawable(this.mBookmarkDrawable);
                this.mRtButton.setVisibility(0);
                this.mStopButton.setVisibility(8);
                this.mTitleBg.setBackgroundDrawable(this.mNormalBackground);
                this.mTitleBg.setPadding(this.mLeftMargin, 0, this.mRightMargin, 0);
            }
            this.mInLoad = false;
        } else {
            this.mHorizontalProgress.setProgress(newProgress);
            if (!this.mInLoad && this.getWindowToken() != null) {
                this.mTitle.setCompoundDrawables(null, null, this.mCircularProgress, null);
                ((Animatable)this.mCircularProgress).start();
                this.mHorizontalProgress.setVisibility(0);
                if (!this.mInVoiceMode) {
                    this.mTitleBg.setBackgroundDrawable(this.mLoadingBackground);
                    this.mTitleBg.setPadding(this.mLeftMargin, 0, this.mRightMargin, 0);
                    this.mRtButton.setVisibility(8);
                    this.mStopButton.setVisibility(0);
                }
                this.mInLoad = true;
            }
        }
    }

    void setDisplayTitle(String title) {
        if (title == null) {
            this.mTitle.setText(2131230737);
        } else if (this.mInVoiceMode) {
            SpannableString spannable = new SpannableString((CharSequence)(title + "  "));
            int end = spannable.length();
            spannable.setSpan((Object)this.mArcsSpan, end - 1, end, 18);
            this.mTitle.setText((CharSequence)spannable);
        } else {
            this.mTitle.setText((CharSequence)title);
        }
    }

    void setToTabPicker() {
        this.mTitle.setText(2131230794);
        this.setFavicon(null);
        this.setLock(null);
        this.mHorizontalProgress.setVisibility(8);
    }

    private class MyHandler
    extends Handler {
        private MyHandler() {
        }

        public void handleMessage(Message msg) {
            if (msg.what == LONG_PRESS) {
                TitleBar.this.mTitleBg.setPressed(false);
                TitleBar.this.mBrowserActivity.showTitleBarContextMenu();
            }
        }
    }
}

