/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Message;
import android.os.SystemClock;
import android.provider.Browser;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.ConsoleMessage;
import android.webkit.CookieSyncManager;
import android.webkit.DownloadListener;
import android.webkit.GeolocationPermissions;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebBackForwardList;
import android.webkit.WebBackForwardListClient;
import android.webkit.WebChromeClient;
import android.webkit.WebHistoryItem;
import android.webkit.WebIconDatabase;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.browser.BrowserActivity;
import com.android.browser.BrowserBookmarksAdapter;
import com.android.browser.BrowserSettings;
import com.android.browser.DownloadTouchIcon;
import com.android.browser.ErrorConsoleView;
import com.android.browser.GeolocationPermissionsPrompt;
import com.android.browser.LogTag;
import com.android.browser.WebDialog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Tab {
    private static final String LOGTAG = "Tab";
    private static final String CONSOLE_LOGTAG = "browser";
    private GeolocationPermissionsPrompt mGeolocationPermissionsPrompt;
    private LinearLayout mContainer;
    private WebView mMainView;
    private View mSubViewContainer;
    private WebView mSubView;
    private Bundle mSavedState;
    private PickerData mPickerData;
    private Tab mParentTab;
    private Vector<Tab> mChildTabs;
    private boolean mCloseOnExit;
    private boolean mInForeground;
    private boolean mInLoad;
    private long mLoadStartTime;
    private String mAppId;
    private String mOriginalUrl;
    private ErrorConsoleView mErrorConsole;
    private int mLockIconType;
    private int mPrevLockIconType;
    private final LayoutInflater mInflateService;
    private final BrowserActivity mActivity;
    private final DownloadListener mDownloadListener;
    private final WebBackForwardListClient mWebBackForwardListClient;
    DownloadTouchIcon mTouchIconLoader;
    static final String WEBVIEW = "webview";
    static final String NUMTABS = "numTabs";
    static final String CURRTAB = "currentTab";
    static final String CURRURL = "currentUrl";
    static final String CURRTITLE = "currentTitle";
    static final String CLOSEONEXIT = "closeonexit";
    static final String PARENTTAB = "parentTab";
    static final String APPID = "appid";
    static final String ORIGINALURL = "originalUrl";
    private VoiceSearchData mVoiceSearchData;
    private DialogInterface.OnDismissListener mDialogListener = new DialogInterface.OnDismissListener(){

        public void onDismiss(DialogInterface d) {
            Tab.this.processNextError();
        }
    };
    private LinkedList<ErrorDialog> mQueuedErrors;
    private final WebViewClient mWebViewClient = new WebViewClient(){
        private Message mDontResend;
        private Message mResend;

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            Tab.this.mInLoad = true;
            Tab.this.mLoadStartTime = SystemClock.uptimeMillis();
            if (Tab.this.mVoiceSearchData != null && !url.equals(((Tab)Tab.this).mVoiceSearchData.mLastVoiceSearchUrl)) {
                if (((Tab)Tab.this).mVoiceSearchData.mSourceIsGoogle) {
                    Intent i = new Intent("com.android.common.speech.LOG_EVENT");
                    i.putExtra("flush", true);
                    Tab.this.mActivity.sendBroadcast(i);
                }
                Tab.this.revertVoiceSearchMode();
            }
            Tab.this.mActivity.removeMessages(108, view);
            if (Tab.this.mTouchIconLoader != null) {
                Tab.this.mTouchIconLoader.mTab = null;
                Tab.this.mTouchIconLoader = null;
            }
            if (Tab.this.mErrorConsole != null) {
                Tab.this.mErrorConsole.clearErrorMessages();
                if (Tab.this.mActivity.shouldShowErrorConsole()) {
                    Tab.this.mErrorConsole.showConsole(2);
                }
            }
            if (favicon != null) {
                BrowserBookmarksAdapter.updateBookmarkFavicon(Tab.this.mActivity.getContentResolver(), null, url, favicon);
            }
            CookieSyncManager.getInstance().resetSync();
            if (!Tab.this.mActivity.isNetworkUp()) {
                view.setNetworkAvailable(false);
            }
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.onPageStarted(view, url, favicon);
            }
        }

        public void onPageFinished(WebView view, String url) {
            LogTag.logPageFinishedLoading(url, SystemClock.uptimeMillis() - Tab.this.mLoadStartTime);
            Tab.this.mInLoad = false;
            if (Tab.this.mInForeground && !Tab.this.mActivity.didUserStopLoading() || !Tab.this.mInForeground) {
                Tab.this.mActivity.postMessage(108, 0, 0, view, 500L);
            }
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.onPageFinished(view, url);
            }
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (Tab.this.voiceSearchSourceIsGoogle()) {
                Intent logIntent = new Intent("com.android.common.speech.LOG_EVENT");
                logIntent.putExtra("extra_event", 4);
                Tab.this.mActivity.sendBroadcast(logIntent);
            }
            if (Tab.this.mInForeground) {
                return Tab.this.mActivity.shouldOverrideUrlLoading(view, url);
            }
            return false;
        }

        public void onLoadResource(WebView view, String url) {
            if (!(url == null || url.length() <= 0 || Tab.this.mLockIconType != 1 || URLUtil.isHttpsUrl((String)url) || URLUtil.isDataUrl((String)url) || URLUtil.isAboutUrl((String)url))) {
                Tab.this.mLockIconType = 2;
            }
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            if (errorCode != -2 && errorCode != -6 && errorCode != -12 && errorCode != -10 && errorCode != -13) {
                Tab.this.queueError(errorCode, description);
            }
            Log.e((String)Tab.LOGTAG, (String)("onReceivedError " + errorCode + " " + failingUrl + " " + description));
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.resetTitleAndRevertLockIcon();
            }
        }

        public void onFormResubmission(WebView view, Message dontResend, Message resend) {
            if (!Tab.this.mInForeground) {
                dontResend.sendToTarget();
                return;
            }
            if (this.mDontResend != null) {
                Log.w((String)Tab.LOGTAG, (String)"onFormResubmission should not be called again while dialog is still up");
                dontResend.sendToTarget();
                return;
            }
            this.mDontResend = dontResend;
            this.mResend = resend;
            new AlertDialog.Builder((Context)Tab.this.mActivity).setTitle(2131230893).setMessage(2131230894).setPositiveButton(2131230736, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (mResend != null) {
                        mResend.sendToTarget();
                        mResend = null;
                        mDontResend = null;
                    }
                }
            }).setNegativeButton(2131230735, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (mDontResend != null) {
                        mDontResend.sendToTarget();
                        mResend = null;
                        mDontResend = null;
                    }
                }
            }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    if (mDontResend != null) {
                        mDontResend.sendToTarget();
                        mResend = null;
                        mDontResend = null;
                    }
                }
            }).show();
        }

        public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
            if (url.regionMatches(true, 0, "about:", 0, 6)) {
                return;
            }
            int index = url.indexOf("client=ms-");
            if (index > 0 && url.contains(".google.")) {
                int end = url.indexOf(38, index);
                url = end > 0 ? url.substring(0, index).concat(url.substring(end + 1)) : url.substring(0, index - 1);
            }
            final ContentResolver cr = Tab.this.mActivity.getContentResolver();
            final String newUrl = url;
            new AsyncTask<Void, Void, Void>(){

                protected Void doInBackground(Void ... unused) {
                    Browser.updateVisitedHistory((ContentResolver)cr, (String)newUrl, (boolean)true);
                    return null;
                }
            }.execute((Object[])new Void[0]);
            WebIconDatabase.getInstance().retainIconForPageUrl(url);
        }

        public void onReceivedSslError(final WebView view, final SslErrorHandler handler, final SslError error) {
            if (!Tab.this.mInForeground) {
                handler.cancel();
                return;
            }
            if (BrowserSettings.getInstance().showSecurityWarnings()) {
                LinearLayout ll;
                LayoutInflater factory = LayoutInflater.from((Context)Tab.this.mActivity);
                View warningsView = factory.inflate(2130903059, null);
                LinearLayout placeholder = (LinearLayout)warningsView.findViewById(2131492916);
                if (error.hasError(3)) {
                    ll = (LinearLayout)factory.inflate(2130903058, null);
                    ((TextView)ll.findViewById(2131492937)).setText(2131230745);
                    placeholder.addView((View)ll);
                }
                if (error.hasError(2)) {
                    ll = (LinearLayout)factory.inflate(2130903058, null);
                    ((TextView)ll.findViewById(2131492937)).setText(2131230746);
                    placeholder.addView((View)ll);
                }
                if (error.hasError(1)) {
                    ll = (LinearLayout)factory.inflate(2130903058, null);
                    ((TextView)ll.findViewById(2131492937)).setText(2131230747);
                    placeholder.addView((View)ll);
                }
                if (error.hasError(0)) {
                    ll = (LinearLayout)factory.inflate(2130903058, null);
                    ((TextView)ll.findViewById(2131492937)).setText(2131230748);
                    placeholder.addView((View)ll);
                }
                new AlertDialog.Builder((Context)Tab.this.mActivity).setTitle(2131230743).setIcon(17301543).setView(warningsView).setPositiveButton(2131230742, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        handler.proceed();
                    }
                }).setNeutralButton(2131230744, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        Tab.this.mActivity.showSSLCertificateOnError(view, handler, error);
                    }
                }).setNegativeButton(2131230735, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                        handler.cancel();
                        Tab.this.mActivity.resetTitleAndRevertLockIcon();
                    }
                }).setOnCancelListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        handler.cancel();
                        Tab.this.mActivity.resetTitleAndRevertLockIcon();
                    }
                }).show();
            } else {
                handler.proceed();
            }
        }

        public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
            String[] credentials;
            String username = null;
            String password = null;
            boolean reuseHttpAuthUsernamePassword = handler.useHttpAuthUsernamePassword();
            if (reuseHttpAuthUsernamePassword && view != null && (credentials = view.getHttpAuthUsernamePassword(host, realm)) != null && credentials.length == 2) {
                username = credentials[0];
                password = credentials[1];
            }
            if (username != null && password != null) {
                handler.proceed(username, password);
            } else if (Tab.this.mInForeground) {
                Tab.this.mActivity.showHttpAuthentication(handler, host, realm, null, null, null, 0);
            } else {
                handler.cancel();
            }
        }

        public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
            if (!Tab.this.mInForeground) {
                return false;
            }
            if (Tab.this.mActivity.isMenuDown()) {
                return Tab.this.mActivity.getWindow().isShortcutKey(event.getKeyCode(), event);
            }
            return false;
        }

        public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
            if (!Tab.this.mInForeground || ((Tab)Tab.this).mActivity.mActivityInPause) {
                return;
            }
            if (event.isDown()) {
                Tab.this.mActivity.onKeyDown(event.getKeyCode(), event);
            } else {
                Tab.this.mActivity.onKeyUp(event.getKeyCode(), event);
            }
        }
    };
    private final WebChromeClient mWebChromeClient = new WebChromeClient(){

        private void createWindow(boolean dialog, Message msg) {
            WebView.WebViewTransport transport = (WebView.WebViewTransport)msg.obj;
            if (dialog) {
                Tab.this.createSubWindow();
                Tab.this.mActivity.attachSubWindow(Tab.this);
                transport.setWebView(Tab.this.mSubView);
            } else {
                Tab newTab = Tab.this.mActivity.openTabAndShow(BrowserActivity.EMPTY_URL_DATA, false, null);
                if (newTab != Tab.this) {
                    Tab.this.addChildTab(newTab);
                }
                transport.setWebView(newTab.getWebView());
            }
            msg.sendToTarget();
        }

        public boolean onCreateWindow(WebView view, final boolean dialog, boolean userGesture, final Message resultMsg) {
            if (!Tab.this.mInForeground) {
                return false;
            }
            if (dialog && Tab.this.mSubView != null) {
                new AlertDialog.Builder((Context)Tab.this.mActivity).setTitle(2131230912).setIcon(17301543).setMessage(2131230913).setPositiveButton(2131230736, null).show();
                return false;
            }
            if (!Tab.this.mActivity.getTabControl().canCreateNewTab()) {
                new AlertDialog.Builder((Context)Tab.this.mActivity).setTitle(2131230910).setIcon(17301543).setMessage(2131230911).setPositiveButton(2131230736, null).show();
                return false;
            }
            if (userGesture) {
                this.createWindow(dialog, resultMsg);
                return true;
            }
            DialogInterface.OnClickListener allowListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface d, int which) {
                    this.createWindow(dialog, resultMsg);
                }
            };
            DialogInterface.OnClickListener blockListener = new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface d, int which) {
                    resultMsg.sendToTarget();
                }
            };
            AlertDialog d = new AlertDialog.Builder((Context)Tab.this.mActivity).setTitle(2131230906).setIcon(17301543).setMessage(2131230907).setPositiveButton(2131230908, allowListener).setNegativeButton(2131230909, blockListener).setCancelable(false).create();
            d.show();
            return true;
        }

        public void onRequestFocus(WebView view) {
            if (!Tab.this.mInForeground) {
                Tab.this.mActivity.switchToTab(Tab.this.mActivity.getTabControl().getTabIndex(Tab.this));
            }
        }

        public void onCloseWindow(WebView window) {
            if (Tab.this.mParentTab != null) {
                if (Tab.this.mInForeground) {
                    Tab.this.mActivity.switchToTab(Tab.this.mActivity.getTabControl().getTabIndex(Tab.this.mParentTab));
                }
                Tab.this.mActivity.closeTab(Tab.this);
            }
        }

        public void onProgressChanged(WebView view, int newProgress) {
            if (newProgress == 100) {
                CookieSyncManager.getInstance().sync();
            }
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.onProgressChanged(view, newProgress);
            }
        }

        public void onReceivedTitle(WebView view, final String title) {
            final String pageUrl = view.getUrl();
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.setUrlTitle(pageUrl, title);
            }
            if (pageUrl == null || pageUrl.length() >= 50000) {
                return;
            }
            new AsyncTask<Void, Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground(Void ... unused) {
                    String url = pageUrl;
                    if (url.startsWith("http://www.")) {
                        url = url.substring(11);
                    } else if (url.startsWith("http://")) {
                        url = url.substring(4);
                    }
                    url = url.replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_");
                    Cursor c = null;
                    try {
                        ContentResolver cr = Tab.this.mActivity.getContentResolver();
                        url = "%" + url;
                        String[] selArgs = new String[]{url};
                        String where = "url LIKE ? ESCAPE '\\' AND bookmark = 0";
                        c = cr.query(Browser.BOOKMARKS_URI, new String[]{"_id"}, where, selArgs, null);
                        if (c.moveToFirst()) {
                            ContentValues map = new ContentValues();
                            map.put("title", title);
                            String[] projection = new String[]{Integer.valueOf(c.getInt(0)).toString()};
                            cr.update(Browser.BOOKMARKS_URI, map, "_id = ?", projection);
                        }
                    }
                    catch (IllegalStateException e) {
                        Log.e((String)Tab.LOGTAG, (String)"Tab onReceived title", (Throwable)e);
                    }
                    catch (SQLiteException ex) {
                        Log.e((String)Tab.LOGTAG, (String)"onReceivedTitle() caught SQLiteException: ", (Throwable)ex);
                    }
                    finally {
                        if (c != null) {
                            c.close();
                        }
                    }
                    return null;
                }
            }.execute((Object[])new Void[0]);
        }

        public void onReceivedIcon(WebView view, Bitmap icon) {
            if (icon != null) {
                BrowserBookmarksAdapter.updateBookmarkFavicon(Tab.this.mActivity.getContentResolver(), view.getOriginalUrl(), view.getUrl(), icon);
            }
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.setFavicon(icon);
            }
        }

        public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
            ContentResolver cr = Tab.this.mActivity.getContentResolver();
            if (precomposed && Tab.this.mTouchIconLoader != null) {
                Tab.this.mTouchIconLoader.cancel(false);
                Tab.this.mTouchIconLoader = null;
            }
            if (Tab.this.mTouchIconLoader == null) {
                Tab.this.mTouchIconLoader = new DownloadTouchIcon(Tab.this, cr, view);
                Tab.this.mTouchIconLoader.execute(new String[]{url});
            }
        }

        public void onSelectionDone(WebView view) {
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.closeDialogs();
            }
        }

        public void onSelectionStart(WebView view) {
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.onShowCustomView(view, callback);
            }
        }

        public void onHideCustomView() {
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.onHideCustomView();
            }
        }

        public void onExceededDatabaseQuota(String url, String databaseIdentifier, long currentQuota, long estimatedSize, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
            BrowserSettings.getInstance().getWebStorageSizeManager().onExceededDatabaseQuota(url, databaseIdentifier, currentQuota, estimatedSize, totalUsedQuota, quotaUpdater);
        }

        public void onReachedMaxAppCacheSize(long spaceNeeded, long totalUsedQuota, WebStorage.QuotaUpdater quotaUpdater) {
            BrowserSettings.getInstance().getWebStorageSizeManager().onReachedMaxAppCacheSize(spaceNeeded, totalUsedQuota, quotaUpdater);
        }

        public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback callback) {
            if (Tab.this.mInForeground) {
                Tab.this.getGeolocationPermissionsPrompt().show(origin, callback);
            }
        }

        public void onGeolocationPermissionsHidePrompt() {
            if (Tab.this.mInForeground && Tab.this.mGeolocationPermissionsPrompt != null) {
                Tab.this.mGeolocationPermissionsPrompt.hide();
            }
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            if (Tab.this.mInForeground) {
                ErrorConsoleView errorConsole = Tab.this.getErrorConsole(true);
                errorConsole.addErrorMessage(consoleMessage);
                if (Tab.this.mActivity.shouldShowErrorConsole() && errorConsole.getShowState() != 1) {
                    errorConsole.showConsole(0);
                }
            }
            String message = "Console: " + consoleMessage.message() + " " + consoleMessage.sourceId() + ":" + consoleMessage.lineNumber();
            switch (consoleMessage.messageLevel()) {
                case TIP: {
                    Log.v((String)Tab.CONSOLE_LOGTAG, (String)message);
                    break;
                }
                case LOG: {
                    Log.i((String)Tab.CONSOLE_LOGTAG, (String)message);
                    break;
                }
                case WARNING: {
                    Log.w((String)Tab.CONSOLE_LOGTAG, (String)message);
                    break;
                }
                case ERROR: {
                    Log.e((String)Tab.CONSOLE_LOGTAG, (String)message);
                    break;
                }
                case DEBUG: {
                    Log.d((String)Tab.CONSOLE_LOGTAG, (String)message);
                }
            }
            return true;
        }

        public Bitmap getDefaultVideoPoster() {
            if (Tab.this.mInForeground) {
                return Tab.this.mActivity.getDefaultVideoPoster();
            }
            return null;
        }

        public View getVideoLoadingProgressView() {
            if (Tab.this.mInForeground) {
                return Tab.this.mActivity.getVideoLoadingProgressView();
            }
            return null;
        }

        public void openFileChooser(ValueCallback<Uri> uploadMsg) {
            if (Tab.this.mInForeground) {
                Tab.this.mActivity.openFileChooser(uploadMsg);
            } else {
                uploadMsg.onReceiveValue(null);
            }
        }

        public void getVisitedHistory(final ValueCallback<String[]> callback) {
            AsyncTask<Void, Void, String[]> task = new AsyncTask<Void, Void, String[]>(){

                public String[] doInBackground(Void ... unused) {
                    return Browser.getVisitedHistory((ContentResolver)Tab.this.mActivity.getContentResolver());
                }

                public void onPostExecute(String[] result) {
                    callback.onReceiveValue((Object)result);
                }
            };
            task.execute((Object[])new Void[0]);
        }
    };

    public void revertVoiceSearchMode() {
        if (this.mVoiceSearchData != null) {
            this.mVoiceSearchData = null;
            if (this.mInForeground) {
                this.mActivity.revertVoiceTitleBar();
            }
        }
    }

    public boolean isInVoiceSearchMode() {
        return this.mVoiceSearchData != null;
    }

    public boolean voiceSearchSourceIsGoogle() {
        return this.mVoiceSearchData != null && this.mVoiceSearchData.mSourceIsGoogle;
    }

    public String getVoiceDisplayTitle() {
        if (this.mVoiceSearchData == null) {
            return null;
        }
        return this.mVoiceSearchData.mLastVoiceSearchTitle;
    }

    public ArrayList<String> getVoiceSearchResults() {
        if (this.mVoiceSearchData == null) {
            return null;
        }
        return this.mVoiceSearchData.mVoiceSearchResults;
    }

    void activateVoiceSearchMode(Intent intent) {
        int bundleIndex;
        Bundle bundle;
        Uri dataUri;
        String uriString;
        String extraData;
        int index = 0;
        ArrayList results = intent.getStringArrayListExtra("android.speech.extras.VOICE_SEARCH_RESULT_STRINGS");
        if (results != null) {
            ArrayList urls = intent.getStringArrayListExtra("android.speech.extras.VOICE_SEARCH_RESULT_URLS");
            ArrayList htmls = intent.getStringArrayListExtra("android.speech.extras.VOICE_SEARCH_RESULT_HTML");
            ArrayList baseUrls = intent.getStringArrayListExtra("android.speech.extras.VOICE_SEARCH_RESULT_HTML_BASE_URLS");
            int size = results.size();
            if (urls == null || size != urls.size()) {
                throw new AssertionError((Object)"improper extras passed in Intent");
            }
            if (htmls == null || htmls.size() != size || baseUrls == null || baseUrls.size() != size && baseUrls.size() != 1) {
                htmls = null;
                baseUrls = null;
            }
            this.mVoiceSearchData = new VoiceSearchData(results, urls, htmls, baseUrls);
            this.mVoiceSearchData.mHeaders = intent.getParcelableArrayListExtra("android.speech.extras.EXTRA_VOICE_SEARCH_RESULT_HTTP_HEADERS");
            this.mVoiceSearchData.mSourceIsGoogle = intent.getBooleanExtra(VoiceSearchData.SOURCE_IS_GOOGLE, false);
            this.mVoiceSearchData.mVoiceSearchIntent = new Intent(intent);
        }
        if ((extraData = intent.getStringExtra("intent_extra_data_key")) != null) {
            index = Integer.parseInt(extraData);
            if (index >= this.mVoiceSearchData.mVoiceSearchResults.size()) {
                throw new AssertionError((Object)"index must be less than size of mVoiceSearchResults");
            }
            if (this.mVoiceSearchData.mSourceIsGoogle) {
                Intent logIntent = new Intent("com.android.common.speech.LOG_EVENT");
                logIntent.putExtra("extra_event", 2);
                logIntent.putExtra("index", index);
                this.mActivity.sendBroadcast(logIntent);
            }
            if (this.mVoiceSearchData.mVoiceSearchIntent != null) {
                Intent latest = new Intent(this.mVoiceSearchData.mVoiceSearchIntent);
                latest.putExtra("intent_extra_data_key", extraData);
                this.mVoiceSearchData.mVoiceSearchIntent = latest;
            }
        }
        this.mVoiceSearchData.mLastVoiceSearchTitle = this.mVoiceSearchData.mVoiceSearchResults.get(index);
        if (this.mInForeground) {
            this.mActivity.showVoiceTitleBar(this.mVoiceSearchData.mLastVoiceSearchTitle);
        }
        if (this.mVoiceSearchData.mVoiceSearchHtmls != null && (uriString = this.mVoiceSearchData.mVoiceSearchHtmls.get(index)) != null && "inline".equals((dataUri = Uri.parse((String)uriString)).getScheme())) {
            String baseUrl;
            this.mVoiceSearchData.mLastVoiceSearchUrl = baseUrl = this.mVoiceSearchData.mVoiceSearchBaseUrls.get(this.mVoiceSearchData.mVoiceSearchBaseUrls.size() > 1 ? index : 0);
            this.mMainView.loadDataWithBaseURL(baseUrl, uriString.substring("inline".length() + 1), "text/html", "utf-8", baseUrl);
            return;
        }
        this.mVoiceSearchData.mLastVoiceSearchUrl = this.mVoiceSearchData.mVoiceSearchUrls.get(index);
        if (null == this.mVoiceSearchData.mLastVoiceSearchUrl) {
            this.mVoiceSearchData.mLastVoiceSearchUrl = this.mActivity.smartUrlFilter(this.mVoiceSearchData.mLastVoiceSearchTitle);
        }
        HashMap<String, String> headers = null;
        if (this.mVoiceSearchData.mHeaders != null && (bundle = this.mVoiceSearchData.mHeaders.get(bundleIndex = this.mVoiceSearchData.mHeaders.size() == 1 ? 0 : index)) != null && !bundle.isEmpty()) {
            Iterator iter = bundle.keySet().iterator();
            headers = new HashMap<String, String>();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                headers.put(key, bundle.getString(key));
            }
        }
        this.mMainView.loadUrl(this.mVoiceSearchData.mLastVoiceSearchUrl, headers);
    }

    private void processNextError() {
        if (this.mQueuedErrors == null) {
            return;
        }
        this.mQueuedErrors.removeFirst();
        if (this.mQueuedErrors.size() == 0) {
            this.mQueuedErrors = null;
            return;
        }
        this.showError(this.mQueuedErrors.getFirst());
    }

    private void queueError(int err, String desc) {
        if (this.mQueuedErrors == null) {
            this.mQueuedErrors = new LinkedList();
        }
        for (ErrorDialog d : this.mQueuedErrors) {
            if (d.mError != err) continue;
            return;
        }
        ErrorDialog errDialog = new ErrorDialog(err == -14 ? 2131230892 : 2131230891, desc, err);
        this.mQueuedErrors.addLast(errDialog);
        if (this.mQueuedErrors.size() == 1 && this.mInForeground) {
            this.showError(errDialog);
        }
    }

    private void showError(ErrorDialog errDialog) {
        if (this.mInForeground) {
            AlertDialog d = new AlertDialog.Builder((Context)this.mActivity).setTitle(errDialog.mTitle).setMessage((CharSequence)errDialog.mDescription).setPositiveButton(2131230736, null).create();
            d.setOnDismissListener(this.mDialogListener);
            d.show();
        }
    }

    Tab(BrowserActivity activity, WebView w, boolean closeOnExit, String appId, String url) {
        this.mActivity = activity;
        this.mCloseOnExit = closeOnExit;
        this.mAppId = appId;
        this.mOriginalUrl = url;
        this.mLockIconType = 0;
        this.mPrevLockIconType = 0;
        this.mInLoad = false;
        this.mInForeground = false;
        this.mInflateService = LayoutInflater.from((Context)activity);
        this.mContainer = (LinearLayout)this.mInflateService.inflate(2130903060, null);
        this.mDownloadListener = new DownloadListener(){

            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                Tab.this.mActivity.onDownloadStart(url, userAgent, contentDisposition, mimetype, contentLength);
                if (Tab.this.mMainView.copyBackForwardList().getSize() == 0) {
                    if (Tab.this.mActivity.getTabControl().getCurrentWebView() == Tab.this.mMainView) {
                        Tab.this.mActivity.goBackOnePageOrQuit();
                    } else {
                        Tab.this.mActivity.closeTab(Tab.this);
                    }
                }
            }
        };
        this.mWebBackForwardListClient = new WebBackForwardListClient(){

            public void onNewHistoryItem(WebHistoryItem item) {
                if (Tab.this.isInVoiceSearchMode()) {
                    item.setCustomData((Object)((Tab)Tab.this).mVoiceSearchData.mVoiceSearchIntent);
                }
            }

            public void onIndexChanged(WebHistoryItem item, int index) {
                Object data = item.getCustomData();
                if (data != null && data instanceof Intent) {
                    Tab.this.activateVoiceSearchMode((Intent)data);
                }
            }
        };
        this.setWebView(w);
    }

    void setWebView(WebView w) {
        if (this.mMainView == w) {
            return;
        }
        if (this.mGeolocationPermissionsPrompt != null) {
            this.mGeolocationPermissionsPrompt.hide();
        }
        FrameLayout wrapper = (FrameLayout)this.mContainer.findViewById(2131492939);
        wrapper.removeView((View)this.mMainView);
        this.mMainView = w;
        if (this.mMainView != null) {
            this.mMainView.setWebViewClient(this.mWebViewClient);
            this.mMainView.setWebChromeClient(this.mWebChromeClient);
            this.mMainView.setDownloadListener(this.mDownloadListener);
            this.mMainView.setWebBackForwardListClient(this.mWebBackForwardListClient);
        }
    }

    void destroy() {
        if (this.mMainView != null) {
            this.dismissSubWindow();
            BrowserSettings.getInstance().deleteObserver(this.mMainView.getSettings());
            WebView webView = this.mMainView;
            this.setWebView(null);
            webView.destroy();
        }
    }

    void removeFromTree() {
        if (this.mChildTabs != null) {
            for (Tab t : this.mChildTabs) {
                t.setParentTab(null);
            }
        }
        if (this.mParentTab != null) {
            this.mParentTab.mChildTabs.remove(this);
        }
    }

    boolean createSubWindow() {
        if (this.mSubView == null) {
            this.mActivity.closeDialogs();
            this.mSubViewContainer = this.mInflateService.inflate(2130903047, null);
            this.mSubView = (WebView)this.mSubViewContainer.findViewById(2131492893);
            this.mSubView.setScrollBarStyle(0x2000000);
            this.mSubView.setMapTrackballToArrowKeys(false);
            this.mSubView.getSettings().setBuiltInZoomControls(true);
            this.mSubView.setWebViewClient((WebViewClient)new SubWindowClient(this.mWebViewClient, this.mActivity));
            this.mSubView.setWebChromeClient((WebChromeClient)new SubWindowChromeClient(this.mWebChromeClient));
            this.mSubView.setDownloadListener(new DownloadListener(){

                public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                    Tab.this.mActivity.onDownloadStart(url, userAgent, contentDisposition, mimetype, contentLength);
                    if (Tab.this.mSubView.copyBackForwardList().getSize() == 0) {
                        Tab.this.mActivity.dismissSubWindow(Tab.this);
                    }
                }
            });
            this.mSubView.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this.mActivity);
            BrowserSettings s = BrowserSettings.getInstance();
            s.addObserver(this.mSubView.getSettings()).update(s, null);
            ImageButton cancel = (ImageButton)this.mSubViewContainer.findViewById(2131492894);
            cancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Tab.this.mSubView.getWebChromeClient().onCloseWindow(Tab.this.mSubView);
                }
            });
            return true;
        }
        return false;
    }

    void dismissSubWindow() {
        if (this.mSubView != null) {
            this.mActivity.closeDialogs();
            BrowserSettings.getInstance().deleteObserver(this.mSubView.getSettings());
            this.mSubView.destroy();
            this.mSubView = null;
            this.mSubViewContainer = null;
        }
    }

    void attachSubWindow(ViewGroup content) {
        if (this.mSubView != null) {
            content.addView(this.mSubViewContainer, (ViewGroup.LayoutParams)BrowserActivity.COVER_SCREEN_PARAMS);
        }
    }

    void removeSubWindow(ViewGroup content) {
        if (this.mSubView != null) {
            content.removeView(this.mSubViewContainer);
            this.mActivity.closeDialogs();
        }
    }

    void attachTabToContentView(ViewGroup content) {
        if (this.mMainView == null) {
            return;
        }
        FrameLayout wrapper = (FrameLayout)this.mContainer.findViewById(2131492939);
        ViewGroup parent = (ViewGroup)this.mMainView.getParent();
        if (parent != wrapper) {
            if (parent != null) {
                Log.w((String)LOGTAG, (String)"mMainView already has a parent in attachTabToContentView!");
                parent.removeView((View)this.mMainView);
            }
            wrapper.addView((View)this.mMainView);
        } else {
            Log.w((String)LOGTAG, (String)"mMainView is already attached to wrapper in attachTabToContentView!");
        }
        parent = (ViewGroup)this.mContainer.getParent();
        if (parent != content) {
            if (parent != null) {
                Log.w((String)LOGTAG, (String)"mContainer already has a parent in attachTabToContentView!");
                parent.removeView((View)this.mContainer);
            }
            content.addView((View)this.mContainer, (ViewGroup.LayoutParams)BrowserActivity.COVER_SCREEN_PARAMS);
        } else {
            Log.w((String)LOGTAG, (String)"mContainer is already attached to content in attachTabToContentView!");
        }
        this.attachSubWindow(content);
    }

    void removeTabFromContentView(ViewGroup content) {
        if (this.mMainView == null) {
            return;
        }
        FrameLayout wrapper = (FrameLayout)this.mContainer.findViewById(2131492939);
        wrapper.removeView((View)this.mMainView);
        content.removeView((View)this.mContainer);
        this.mActivity.closeDialogs();
        this.removeSubWindow(content);
    }

    void setParentTab(Tab parent) {
        this.mParentTab = parent;
        if (this.mSavedState != null) {
            if (parent == null) {
                this.mSavedState.remove(PARENTTAB);
            } else {
                this.mSavedState.putInt(PARENTTAB, this.mActivity.getTabControl().getTabIndex(parent));
            }
        }
    }

    void addChildTab(Tab child) {
        if (this.mChildTabs == null) {
            this.mChildTabs = new Vector();
        }
        this.mChildTabs.add(child);
        child.setParentTab(this);
    }

    Vector<Tab> getChildTabs() {
        return this.mChildTabs;
    }

    void resume() {
        if (this.mMainView != null) {
            this.mMainView.onResume();
            if (this.mSubView != null) {
                this.mSubView.onResume();
            }
        }
    }

    void pause() {
        if (this.mMainView != null) {
            this.mMainView.onPause();
            if (this.mSubView != null) {
                this.mSubView.onPause();
            }
        }
    }

    void putInForeground() {
        this.mInForeground = true;
        this.resume();
        this.mMainView.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this.mActivity);
        if (this.mSubView != null) {
            this.mSubView.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this.mActivity);
        }
        if (this.mQueuedErrors != null && this.mQueuedErrors.size() > 0) {
            this.showError(this.mQueuedErrors.getFirst());
        }
    }

    void putInBackground() {
        this.mInForeground = false;
        this.pause();
        this.mMainView.setOnCreateContextMenuListener(null);
        if (this.mSubView != null) {
            this.mSubView.setOnCreateContextMenuListener(null);
        }
    }

    WebView getTopWindow() {
        if (this.mSubView != null) {
            return this.mSubView;
        }
        return this.mMainView;
    }

    WebView getWebView() {
        return this.mMainView;
    }

    WebView getSubWebView() {
        return this.mSubView;
    }

    GeolocationPermissionsPrompt getGeolocationPermissionsPrompt() {
        if (this.mGeolocationPermissionsPrompt == null) {
            ViewStub stub = (ViewStub)this.mContainer.findViewById(2131492940);
            this.mGeolocationPermissionsPrompt = (GeolocationPermissionsPrompt)stub.inflate();
            this.mGeolocationPermissionsPrompt.init();
        }
        return this.mGeolocationPermissionsPrompt;
    }

    String getAppId() {
        return this.mAppId;
    }

    void setAppId(String id2) {
        this.mAppId = id2;
    }

    String getOriginalUrl() {
        return this.mOriginalUrl;
    }

    void setOriginalUrl(String url) {
        this.mOriginalUrl = url;
    }

    String getUrl() {
        if (this.mPickerData != null) {
            return this.mPickerData.mUrl;
        }
        return null;
    }

    String getTitle() {
        if (this.mPickerData != null) {
            return this.mPickerData.mTitle;
        }
        return null;
    }

    Bitmap getFavicon() {
        if (this.mPickerData != null) {
            return this.mPickerData.mFavicon;
        }
        return null;
    }

    ErrorConsoleView getErrorConsole(boolean createIfNecessary) {
        if (createIfNecessary && this.mErrorConsole == null) {
            this.mErrorConsole = new ErrorConsoleView((Context)this.mActivity);
            this.mErrorConsole.setWebView(this.mMainView);
        }
        return this.mErrorConsole;
    }

    public Tab getParentTab() {
        return this.mParentTab;
    }

    boolean closeOnExit() {
        return this.mCloseOnExit;
    }

    void resetLockIcon(String url) {
        this.mPrevLockIconType = this.mLockIconType;
        this.mLockIconType = 0;
        if (URLUtil.isHttpsUrl((String)url)) {
            this.mLockIconType = 1;
        }
    }

    void revertLockIcon() {
        this.mLockIconType = this.mPrevLockIconType;
    }

    int getLockIconType() {
        return this.mLockIconType;
    }

    boolean inLoad() {
        return this.mInLoad;
    }

    void clearInLoad() {
        this.mInLoad = false;
    }

    void populatePickerData() {
        if (this.mMainView == null) {
            this.populatePickerDataFromSavedState();
            return;
        }
        WebBackForwardList list = this.mMainView.copyBackForwardList();
        WebHistoryItem item = list != null ? list.getCurrentItem() : null;
        this.populatePickerData(item);
    }

    private void populatePickerData(WebHistoryItem item) {
        if (item != null && !TextUtils.isEmpty((CharSequence)item.getUrl())) {
            this.mPickerData = new PickerData();
            this.mPickerData.mUrl = item.getUrl();
            this.mPickerData.mTitle = item.getTitle();
            this.mPickerData.mFavicon = item.getFavicon();
            if (this.mPickerData.mTitle == null) {
                this.mPickerData.mTitle = this.mPickerData.mUrl;
            }
        }
    }

    void populatePickerDataFromSavedState() {
        if (this.mSavedState == null) {
            return;
        }
        this.mPickerData = new PickerData();
        this.mPickerData.mUrl = this.mSavedState.getString(CURRURL);
        this.mPickerData.mTitle = this.mSavedState.getString(CURRTITLE);
    }

    void clearPickerData() {
        this.mPickerData = null;
    }

    Bundle getSavedState() {
        return this.mSavedState;
    }

    void setSavedState(Bundle state) {
        this.mSavedState = state;
    }

    boolean saveState() {
        if (this.mMainView == null) {
            return this.mSavedState != null;
        }
        this.mSavedState = new Bundle();
        WebBackForwardList list = this.mMainView.saveState(this.mSavedState);
        WebHistoryItem item = list != null ? list.getCurrentItem() : null;
        this.populatePickerData(item);
        if (this.mPickerData != null && this.mPickerData.mUrl != null) {
            this.mSavedState.putString(CURRURL, this.mPickerData.mUrl);
        }
        if (this.mPickerData != null && this.mPickerData.mTitle != null) {
            this.mSavedState.putString(CURRTITLE, this.mPickerData.mTitle);
        }
        this.mSavedState.putBoolean(CLOSEONEXIT, this.mCloseOnExit);
        if (this.mAppId != null) {
            this.mSavedState.putString(APPID, this.mAppId);
        }
        if (this.mOriginalUrl != null) {
            this.mSavedState.putString(ORIGINALURL, this.mOriginalUrl);
        }
        if (this.mParentTab != null) {
            this.mSavedState.putInt(PARENTTAB, this.mActivity.getTabControl().getTabIndex(this.mParentTab));
        }
        return true;
    }

    boolean restoreState(Bundle b) {
        if (b == null) {
            return false;
        }
        this.mSavedState = null;
        this.mCloseOnExit = b.getBoolean(CLOSEONEXIT);
        this.mAppId = b.getString(APPID);
        this.mOriginalUrl = b.getString(ORIGINALURL);
        WebBackForwardList list = this.mMainView.restoreState(b);
        return list != null;
    }

    WebView showDialog(WebDialog dialog) {
        LinearLayout container;
        WebView view;
        if (this.mSubView != null) {
            view = this.mSubView;
            container = (LinearLayout)this.mSubViewContainer.findViewById(2131492892);
        } else {
            view = this.mMainView;
            container = this.mContainer;
        }
        dialog.show();
        container.addView((View)dialog, 0, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        dialog.setWebView(view);
        return view;
    }

    void closeDialog(WebDialog dialog) {
        LinearLayout parent = (LinearLayout)dialog.getParent();
        if (parent != null) {
            parent.removeView((View)dialog);
        }
    }

    private class SubWindowChromeClient
    extends WebChromeClient {
        private final WebChromeClient mClient;

        SubWindowChromeClient(WebChromeClient client) {
            this.mClient = client;
        }

        public void onProgressChanged(WebView view, int newProgress) {
            this.mClient.onProgressChanged(view, newProgress);
        }

        public boolean onCreateWindow(WebView view, boolean dialog, boolean userGesture, Message resultMsg) {
            return this.mClient.onCreateWindow(view, dialog, userGesture, resultMsg);
        }

        public void onCloseWindow(WebView window) {
            if (window != Tab.this.mSubView) {
                Log.e((String)Tab.LOGTAG, (String)"Can't close the window");
            }
            Tab.this.mActivity.dismissSubWindow(Tab.this);
        }
    }

    private static class SubWindowClient
    extends WebViewClient {
        private final WebViewClient mClient;
        private final BrowserActivity mBrowserActivity;

        SubWindowClient(WebViewClient client, BrowserActivity activity) {
            this.mClient = client;
            this.mBrowserActivity = activity;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            this.mBrowserActivity.closeDialogs();
        }

        public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
            this.mClient.doUpdateVisitedHistory(view, url, isReload);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            return this.mClient.shouldOverrideUrlLoading(view, url);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            this.mClient.onReceivedSslError(view, handler, error);
        }

        public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
            this.mClient.onReceivedHttpAuthRequest(view, handler, host, realm);
        }

        public void onFormResubmission(WebView view, Message dontResend, Message resend) {
            this.mClient.onFormResubmission(view, dontResend, resend);
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            this.mClient.onReceivedError(view, errorCode, description, failingUrl);
        }

        public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
            return this.mClient.shouldOverrideKeyEvent(view, event);
        }

        public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
            this.mClient.onUnhandledKeyEvent(view, event);
        }
    }

    private class ErrorDialog {
        public final int mTitle;
        public final String mDescription;
        public final int mError;

        ErrorDialog(int title, String desc, int error) {
            this.mTitle = title;
            this.mDescription = desc;
            this.mError = error;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class VoiceSearchData {
        public ArrayList<String> mVoiceSearchResults;
        public ArrayList<String> mVoiceSearchUrls;
        public ArrayList<String> mVoiceSearchHtmls;
        public ArrayList<String> mVoiceSearchBaseUrls;
        public String mLastVoiceSearchUrl;
        public String mLastVoiceSearchTitle;
        public boolean mSourceIsGoogle;
        public ArrayList<Bundle> mHeaders;
        public Intent mVoiceSearchIntent;
        public static String SOURCE_IS_GOOGLE = "android.speech.extras.SOURCE_IS_GOOGLE";

        public VoiceSearchData(ArrayList<String> results, ArrayList<String> urls, ArrayList<String> htmls, ArrayList<String> baseUrls) {
            this.mVoiceSearchResults = results;
            this.mVoiceSearchUrls = urls;
            this.mVoiceSearchHtmls = htmls;
            this.mVoiceSearchBaseUrls = baseUrls;
        }
    }

    private static class PickerData {
        String mUrl;
        String mTitle;
        Bitmap mFavicon;

        private PickerData() {
        }
    }
}

