/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.Downloads;
import android.widget.Toast;
import java.io.File;

public class OpenDownloadReceiver
extends BroadcastReceiver {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        ContentResolver cr = context.getContentResolver();
        Uri data = intent.getData();
        Cursor cursor = null;
        try {
            cursor = cr.query(data, new String[]{"_id", "_data", "mimetype", "status"}, null, null, null);
            if (cursor.moveToFirst()) {
                String filename = cursor.getString(1);
                String mimetype = cursor.getString(2);
                String action = intent.getAction();
                if ("android.intent.action.DOWNLOAD_NOTIFICATION_CLICKED".equals(action)) {
                    int status = cursor.getInt(3);
                    if (Downloads.isStatusCompleted((int)status) && Downloads.isStatusSuccess((int)status)) {
                        Intent launchIntent = new Intent("android.intent.action.VIEW");
                        Uri path = Uri.parse((String)filename);
                        if (path.getScheme() == null) {
                            path = Uri.fromFile((File)new File(filename));
                        }
                        launchIntent.setDataAndType(path, mimetype);
                        launchIntent.setFlags(0x10000000);
                        try {
                            context.startActivity(launchIntent);
                        }
                        catch (ActivityNotFoundException ex) {
                            Toast.makeText((Context)context, (int)2131230931, (int)1).show();
                        }
                    } else {
                        Intent pageView = new Intent("android.intent.action.VIEW_DOWNLOADS");
                        pageView.setFlags(0x10000000);
                        context.startActivity(pageView);
                    }
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }
}

