/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.widget.CompoundButton;
import com.android.browser.BookmarkItem;
import com.android.browser.Bookmarks;
import com.android.browser.LogTag;

class HistoryItem
extends BookmarkItem {
    private CompoundButton mStar = (CompoundButton)this.findViewById(2131492910);
    private CompoundButton.OnCheckedChangeListener mListener;

    HistoryItem(Context context) {
        super(context);
        this.mStar.setVisibility(0);
        this.mListener = new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    Bookmarks.addBookmark(HistoryItem.this.mContext, HistoryItem.this.mContext.getContentResolver(), HistoryItem.this.mUrl, HistoryItem.this.getName(), null, true);
                    LogTag.logBookmarkAdded(HistoryItem.this.mUrl, "history");
                } else {
                    Bookmarks.removeFromBookmarks(HistoryItem.this.mContext, HistoryItem.this.mContext.getContentResolver(), HistoryItem.this.mUrl, HistoryItem.this.getName());
                }
            }
        };
    }

    void copyTo(HistoryItem item) {
        item.mTextView.setText(this.mTextView.getText());
        item.mUrlText.setText(this.mUrlText.getText());
        item.setIsBookmark(this.mStar.isChecked());
        item.mImageView.setImageDrawable(this.mImageView.getDrawable());
    }

    boolean isBookmark() {
        return this.mStar.isChecked();
    }

    void setIsBookmark(boolean isBookmark) {
        this.mStar.setOnCheckedChangeListener(null);
        this.mStar.setChecked(isBookmark);
        this.mStar.setOnCheckedChangeListener(this.mListener);
    }
}

