/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import com.android.browser.BrowserActivity;
import com.android.browser.WebDialog;

class FindDialog
extends WebDialog
implements TextWatcher {
    private TextView mMatches;
    private EditText mEditText;
    private View mNextButton;
    private View mPrevButton;
    private View mMatchesView;
    private boolean mMatchesFound;
    private int mNumberOfMatches;
    private View.OnClickListener mFindListener = new View.OnClickListener(){

        public void onClick(View v) {
            FindDialog.this.findNext();
        }
    };
    private View.OnClickListener mFindPreviousListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (FindDialog.this.mWebView == null) {
                throw new AssertionError((Object)"No WebView for FindDialog::onClick");
            }
            FindDialog.this.mWebView.findNext(false);
            FindDialog.this.updateMatchesString();
            FindDialog.this.hideSoftInput();
        }
    };

    private void disableButtons() {
        this.mPrevButton.setEnabled(false);
        this.mNextButton.setEnabled(false);
        this.mPrevButton.setFocusable(false);
        this.mNextButton.setFocusable(false);
    }

    FindDialog(BrowserActivity context) {
        super(context);
        LayoutInflater factory = LayoutInflater.from((Context)context);
        factory.inflate(2130903045, (ViewGroup)this);
        this.addCancel();
        this.mEditText = (EditText)this.findViewById(2131492882);
        View button = this.findViewById(2131492872);
        button.setOnClickListener(this.mFindListener);
        this.mNextButton = button;
        button = this.findViewById(2131492871);
        button.setOnClickListener(this.mFindPreviousListener);
        this.mPrevButton = button;
        this.mMatches = (TextView)this.findViewById(2131492884);
        this.mMatchesView = this.findViewById(2131492883);
        this.disableButtons();
    }

    public void dismiss() {
        super.dismiss();
        this.mWebView.notifyFindDialogDismissed();
        this.hideSoftInput();
    }

    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        KeyEvent.DispatcherState state;
        if (event.getKeyCode() == 4 && (state = this.getKeyDispatcherState()) != null) {
            int action = event.getAction();
            if (0 == action && event.getRepeatCount() == 0) {
                state.startTracking(event, (Object)this);
                return true;
            }
            if (1 == action && !event.isCanceled() && state.isTracking(event)) {
                this.mBrowserActivity.closeDialogs();
                return true;
            }
        }
        return super.dispatchKeyEventPreIme(event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        int keyCode = event.getKeyCode();
        if (event.getAction() == 1 && keyCode == 66 && this.mEditText.hasFocus()) {
            if (this.mMatchesFound) {
                this.findNext();
            } else {
                this.findAll();
                Editable span = this.mEditText.getText();
                Selection.setSelection((Spannable)span, (int)span.length());
            }
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    private void findNext() {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindDialog::findNext");
        }
        this.mWebView.findNext(true);
        this.updateMatchesString();
        this.hideSoftInput();
    }

    public void show() {
        super.show();
        this.mMatchesView.setVisibility(4);
        this.mMatchesFound = false;
        this.mMatches.setText((CharSequence)"0");
        this.mEditText.requestFocus();
        Editable span = this.mEditText.getText();
        int length = span.length();
        Selection.setSelection((Spannable)span, (int)0, (int)length);
        span.setSpan((Object)this, 0, length, 18);
        this.disableButtons();
        InputMethodManager imm = (InputMethodManager)this.mBrowserActivity.getSystemService("input_method");
        imm.showSoftInput((View)this.mEditText, 0);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
        this.findAll();
    }

    private void findAll() {
        if (this.mWebView == null) {
            throw new AssertionError((Object)"No WebView for FindDialog::findAll");
        }
        Editable find = this.mEditText.getText();
        if (0 == find.length()) {
            this.disableButtons();
            this.mWebView.clearMatches();
            this.mMatchesView.setVisibility(4);
        } else {
            this.mMatchesView.setVisibility(0);
            int found = this.mWebView.findAll(find.toString());
            this.mMatchesFound = true;
            this.setMatchesFound(found);
            if (found < 2) {
                this.disableButtons();
                if (found == 0) {
                    // empty if block
                }
            } else {
                this.mPrevButton.setFocusable(true);
                this.mNextButton.setFocusable(true);
                this.mPrevButton.setEnabled(true);
                this.mNextButton.setEnabled(true);
            }
        }
    }

    private void setMatchesFound(int found) {
        this.mNumberOfMatches = found;
        this.updateMatchesString();
    }

    public void setText(String text) {
        this.mEditText.setText((CharSequence)text);
        this.findAll();
    }

    private void updateMatchesString() {
        String template = this.mBrowserActivity.getResources().getQuantityString(2131296256, this.mNumberOfMatches, new Object[]{this.mWebView.findIndex() + 1, this.mNumberOfMatches});
        this.mMatches.setText((CharSequence)template);
    }

    public void afterTextChanged(Editable s) {
    }
}

