/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.ContentValues;
import android.net.Uri;
import android.net.http.AndroidHttpClient;
import android.os.AsyncTask;
import android.provider.Downloads;
import android.webkit.MimeTypeMap;
import android.webkit.URLUtil;
import com.android.browser.BrowserActivity;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FetchUrlMimeType
extends AsyncTask<ContentValues, String, String> {
    BrowserActivity mActivity;
    ContentValues mValues;

    public FetchUrlMimeType(BrowserActivity activity) {
        this.mActivity = activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doInBackground(ContentValues ... values) {
        String referer;
        this.mValues = values[0];
        String uri = this.mValues.getAsString("uri");
        if (uri == null || uri.length() == 0) {
            return null;
        }
        AndroidHttpClient client = AndroidHttpClient.newInstance((String)this.mValues.getAsString("useragent"));
        HttpHead request = new HttpHead(uri);
        String cookie = this.mValues.getAsString("cookiedata");
        if (cookie != null && cookie.length() > 0) {
            request.addHeader("Cookie", cookie);
        }
        if ((referer = this.mValues.getAsString("referer")) != null && referer.length() > 0) {
            request.addHeader("Referer", referer);
        }
        String mimeType = null;
        try {
            int semicolonIndex;
            Header header;
            HttpResponse response = client.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() == 200 && (header = response.getFirstHeader("Content-Type")) != null && (semicolonIndex = (mimeType = header.getValue()).indexOf(59)) != -1) {
                mimeType = mimeType.substring(0, semicolonIndex);
            }
        }
        catch (IllegalArgumentException ex) {
            request.abort();
        }
        catch (IOException ex) {
            request.abort();
        }
        finally {
            client.close();
        }
        return mimeType;
    }

    public void onPostExecute(String mimeType) {
        if (mimeType != null) {
            String newMimeType;
            String url = this.mValues.getAsString("uri");
            if ((mimeType.equalsIgnoreCase("text/plain") || mimeType.equalsIgnoreCase("application/octet-stream")) && (newMimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)url))) != null) {
                this.mValues.put("mimetype", newMimeType);
            }
            String filename = URLUtil.guessFileName((String)url, null, (String)mimeType);
            this.mValues.put("hint", filename);
        }
        Uri contentUri = this.mActivity.getContentResolver().insert(Downloads.Impl.CONTENT_URI, this.mValues);
    }
}

