/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.Context;
import android.graphics.Color;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.ConsoleMessage;
import android.webkit.WebView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.Vector;

class ErrorConsoleView
extends LinearLayout {
    public static final int SHOW_MINIMIZED = 0;
    public static final int SHOW_MAXIMIZED = 1;
    public static final int SHOW_NONE = 2;
    private TextView mConsoleHeader;
    private ErrorConsoleListView mErrorList;
    private LinearLayout mEvalJsViewGroup;
    private EditText mEvalEditText;
    private Button mEvalButton;
    private WebView mWebView;
    private int mCurrentShowState = 2;
    private boolean mSetupComplete = false;
    private Vector<ConsoleMessage> mErrorMessageCache;

    public ErrorConsoleView(Context context) {
        super(context);
    }

    public ErrorConsoleView(Context context, AttributeSet attributes) {
        super(context, attributes);
    }

    private void commonSetupIfNeeded() {
        if (this.mSetupComplete) {
            return;
        }
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(2130903050, (ViewGroup)this);
        this.mConsoleHeader = (TextView)this.findViewById(2131492900);
        this.mErrorList = (ErrorConsoleListView)this.findViewById(2131492901);
        this.mEvalJsViewGroup = (LinearLayout)this.findViewById(2131492902);
        this.mEvalEditText = (EditText)this.findViewById(2131492903);
        this.mEvalButton = (Button)this.findViewById(2131492904);
        this.mEvalButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ErrorConsoleView.this.mWebView != null) {
                    ErrorConsoleView.this.mWebView.loadUrl("javascript:" + ErrorConsoleView.this.mEvalEditText.getText());
                }
                ErrorConsoleView.this.mEvalEditText.setText((CharSequence)"");
            }
        });
        this.mConsoleHeader.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ErrorConsoleView.this.mCurrentShowState == 0) {
                    ErrorConsoleView.this.showConsole(1);
                } else {
                    ErrorConsoleView.this.showConsole(0);
                }
            }
        });
        if (this.mErrorMessageCache != null) {
            for (ConsoleMessage msg : this.mErrorMessageCache) {
                this.mErrorList.addErrorMessage(msg);
            }
            this.mErrorMessageCache.clear();
        }
        this.mSetupComplete = true;
    }

    public void addErrorMessage(ConsoleMessage consoleMessage) {
        if (this.mSetupComplete) {
            this.mErrorList.addErrorMessage(consoleMessage);
        } else {
            if (this.mErrorMessageCache == null) {
                this.mErrorMessageCache = new Vector();
            }
            this.mErrorMessageCache.add(consoleMessage);
        }
    }

    public void clearErrorMessages() {
        if (this.mSetupComplete) {
            this.mErrorList.clearErrorMessages();
        } else if (this.mErrorMessageCache != null) {
            this.mErrorMessageCache.clear();
        }
    }

    public int numberOfErrors() {
        if (this.mSetupComplete) {
            return this.mErrorList.getCount();
        }
        return this.mErrorMessageCache == null ? 0 : this.mErrorMessageCache.size();
    }

    public void setWebView(WebView webview) {
        this.mWebView = webview;
    }

    public void showConsole(int show_state) {
        this.commonSetupIfNeeded();
        switch (show_state) {
            case 0: {
                this.mConsoleHeader.setVisibility(0);
                this.mConsoleHeader.setText(2131230978);
                this.mErrorList.setVisibility(8);
                this.mEvalJsViewGroup.setVisibility(8);
                break;
            }
            case 1: {
                this.mConsoleHeader.setVisibility(0);
                this.mConsoleHeader.setText(2131230979);
                this.mErrorList.setVisibility(0);
                this.mEvalJsViewGroup.setVisibility(0);
                break;
            }
            case 2: {
                this.mConsoleHeader.setVisibility(8);
                this.mErrorList.setVisibility(8);
                this.mEvalJsViewGroup.setVisibility(8);
            }
        }
        this.mCurrentShowState = show_state;
    }

    public int getShowState() {
        if (this.mSetupComplete) {
            return this.mCurrentShowState;
        }
        return 2;
    }

    private static class ErrorConsoleListView
    extends ListView {
        private ErrorConsoleMessageList mConsoleMessages;

        public ErrorConsoleListView(Context context, AttributeSet attributes) {
            super(context, attributes);
            this.mConsoleMessages = new ErrorConsoleMessageList(context);
            this.setAdapter(this.mConsoleMessages);
        }

        public void addErrorMessage(ConsoleMessage consoleMessage) {
            this.mConsoleMessages.add(consoleMessage);
            this.setSelection(this.mConsoleMessages.getCount());
        }

        public void clearErrorMessages() {
            this.mConsoleMessages.clear();
        }

        private static class ErrorConsoleMessageList
        extends BaseAdapter
        implements ListAdapter {
            private Vector<ConsoleMessage> mMessages = new Vector();
            private LayoutInflater mInflater;

            public ErrorConsoleMessageList(Context context) {
                this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            }

            public void add(ConsoleMessage consoleMessage) {
                this.mMessages.add(consoleMessage);
                this.notifyDataSetChanged();
            }

            public void clear() {
                this.mMessages.clear();
                this.notifyDataSetChanged();
            }

            public boolean areAllItemsEnabled() {
                return false;
            }

            public boolean isEnabled(int position) {
                return false;
            }

            public long getItemId(int position) {
                return position;
            }

            public Object getItem(int position) {
                return this.mMessages.get(position);
            }

            public int getCount() {
                return this.mMessages.size();
            }

            public boolean hasStableIds() {
                return true;
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                ConsoleMessage error = this.mMessages.get(position);
                if (error == null) {
                    return null;
                }
                View view = convertView == null ? this.mInflater.inflate(17367053, parent, false) : convertView;
                TextView headline = (TextView)view.findViewById(16908308);
                TextView subText = (TextView)view.findViewById(16908309);
                headline.setText((CharSequence)(error.sourceId() + ":" + error.lineNumber()));
                subText.setText((CharSequence)error.message());
                switch (error.messageLevel()) {
                    case ERROR: {
                        subText.setTextColor(-65536);
                        break;
                    }
                    case WARNING: {
                        subText.setTextColor(Color.rgb((int)255, (int)192, (int)0));
                        break;
                    }
                    case TIP: {
                        subText.setTextColor(-16776961);
                        break;
                    }
                    default: {
                        subText.setTextColor(-3355444);
                    }
                }
                return view;
            }
        }
    }
}

