/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.Activity;
import android.app.TabActivity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.os.Bundle;
import android.provider.Browser;
import android.webkit.WebIconDatabase;
import android.widget.TabHost;
import com.android.browser.BrowserBookmarksPage;
import com.android.browser.BrowserHistoryPage;
import java.util.HashMap;
import java.util.Vector;

public class CombinedBookmarkHistoryActivity
extends TabActivity
implements TabHost.OnTabChangeListener {
    private String mExtraData;
    private Intent mResultData;
    private int mResultCode;
    static String BOOKMARKS_TAB = "bookmark";
    static String VISITED_TAB = "visited";
    static String HISTORY_TAB = "history";
    static String STARTING_TAB = "tab";
    private static IconListenerSet sIconListenerSet;

    static IconListenerSet getIconListenerSet() {
        if (null == sIconListenerSet) {
            sIconListenerSet = new IconListenerSet();
        }
        return sIconListenerSet;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2130903063);
        this.setDefaultKeyMode(3);
        this.getTabHost().setOnTabChangedListener((TabHost.OnTabChangeListener)this);
        Bundle extras = this.getIntent().getExtras();
        Intent bookmarksIntent = new Intent((Context)this, BrowserBookmarksPage.class);
        if (extras != null) {
            bookmarksIntent.putExtras(extras);
        }
        this.createTab(bookmarksIntent, 2131230725, 2130837508, BOOKMARKS_TAB);
        Intent visitedIntent = new Intent((Context)this, BrowserBookmarksPage.class);
        Bundle visitedExtras = extras == null ? new Bundle() : new Bundle(extras);
        visitedExtras.putBoolean("mostVisited", true);
        visitedIntent.putExtras(visitedExtras);
        this.createTab(visitedIntent, 2131230726, 2130837511, VISITED_TAB);
        Intent historyIntent = new Intent((Context)this, BrowserHistoryPage.class);
        String defaultTab = null;
        if (extras != null) {
            historyIntent.putExtras(extras);
            defaultTab = extras.getString(STARTING_TAB);
        }
        this.createTab(historyIntent, 2131230727, 2130837509, HISTORY_TAB);
        if (defaultTab != null) {
            this.getTabHost().setCurrentTab(2);
        }
        WebIconDatabase.getInstance();
        new AsyncTask<Void, Void, Void>(){

            public Void doInBackground(Void ... v) {
                Browser.requestAllIcons((ContentResolver)CombinedBookmarkHistoryActivity.this.getContentResolver(), (String)"favicon is NULL", (WebIconDatabase.IconListener)CombinedBookmarkHistoryActivity.getIconListenerSet());
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    private void createTab(Intent intent, int labelResId, int iconResId, String tab) {
        Resources resources = this.getResources();
        TabHost tabHost = this.getTabHost();
        tabHost.addTab(tabHost.newTabSpec(tab).setIndicator(resources.getText(labelResId), resources.getDrawable(iconResId)).setContent(intent));
    }

    public void onTabChanged(String tabId) {
        Activity activity = this.getLocalActivityManager().getActivity(tabId);
        if (activity != null) {
            activity.onWindowFocusChanged(true);
        }
    }

    void removeParentChildRelationShips() {
        this.mExtraData = "privacy_clear_history";
    }

    void setResultFromChild(int resultCode, Intent data) {
        this.mResultCode = resultCode;
        this.mResultData = data;
    }

    public void finish() {
        if (this.mExtraData != null) {
            this.mResultCode = -1;
            if (this.mResultData == null) {
                this.mResultData = new Intent();
            }
            this.mResultData.putExtra("android.intent.extra.TEXT", this.mExtraData);
        }
        this.setResult(this.mResultCode, this.mResultData);
        super.finish();
    }

    static class IconListenerSet
    implements WebIconDatabase.IconListener {
        private HashMap<String, Bitmap> mUrlsToIcons = new HashMap();
        private Vector<WebIconDatabase.IconListener> mListeners = new Vector();

        public void onReceivedIcon(String url, Bitmap icon) {
            this.mUrlsToIcons.put(url, icon);
            for (WebIconDatabase.IconListener listener : this.mListeners) {
                listener.onReceivedIcon(url, icon);
            }
        }

        public void addListener(WebIconDatabase.IconListener listener) {
            this.mListeners.add(listener);
        }

        public void removeListener(WebIconDatabase.IconListener listener) {
            this.mListeners.remove(listener);
        }

        public Bitmap getFavicon(String url) {
            return this.mUrlsToIcons.get(url);
        }
    }
}

