/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.AsyncTask;
import android.preference.PreferenceActivity;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import android.provider.Browser;
import android.util.Log;
import android.webkit.CookieManager;
import android.webkit.GeolocationPermissions;
import android.webkit.ValueCallback;
import android.webkit.WebIconDatabase;
import android.webkit.WebSettings;
import android.webkit.WebStorage;
import android.webkit.WebView;
import android.webkit.WebViewDatabase;
import com.android.browser.BrowserProvider;
import com.android.browser.TabControl;
import com.android.browser.UrlUtils;
import com.android.browser.WebStorageSizeManager;
import com.android.browser.search.SearchEngine;
import com.android.browser.search.SearchEngines;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Set;

class BrowserSettings
extends Observable {
    private boolean loadsImagesAutomatically;
    private boolean javaScriptEnabled;
    private WebSettings.PluginState pluginState;
    private boolean javaScriptCanOpenWindowsAutomatically;
    private boolean showSecurityWarnings;
    private boolean rememberPasswords;
    private boolean saveFormData;
    private boolean openInBackground;
    private String defaultTextEncodingName;
    private String homeUrl = "";
    private SearchEngine searchEngine;
    private boolean autoFitPage;
    private boolean landscapeOnly;
    private boolean loadsPageInOverviewMode;
    private boolean showDebugSettings;
    private boolean appCacheEnabled;
    private boolean databaseEnabled;
    private boolean domStorageEnabled;
    private boolean geolocationEnabled;
    private boolean workersEnabled;
    private long appCacheMaxSize = Long.MAX_VALUE;
    private String appCachePath;
    private String databasePath;
    private String geolocationDatabasePath;
    private WebStorageSizeManager webStorageSizeManager;
    private String jsFlags = "";
    private static final String TAG = "BrowserSettings";
    public WebSettings.LayoutAlgorithm layoutAlgorithm = WebSettings.LayoutAlgorithm.NARROW_COLUMNS;
    private boolean useWideViewPort = true;
    private int userAgent = 0;
    private boolean tracing = false;
    private boolean lightTouch = false;
    private boolean navDump = false;
    private boolean showConsole = true;
    private static int minimumFontSize = 8;
    private static int minimumLogicalFontSize = 8;
    private static int defaultFontSize = 16;
    private static int defaultFixedFontSize = 13;
    private static WebSettings.TextSize textSize = WebSettings.TextSize.NORMAL;
    private static WebSettings.ZoomDensity zoomDensity = WebSettings.ZoomDensity.MEDIUM;
    private static int pageCacheCapacity;
    public static final String PREF_CLEAR_CACHE = "privacy_clear_cache";
    public static final String PREF_CLEAR_COOKIES = "privacy_clear_cookies";
    public static final String PREF_CLEAR_HISTORY = "privacy_clear_history";
    public static final String PREF_HOMEPAGE = "homepage";
    public static final String PREF_SEARCH_ENGINE = "search_engine";
    public static final String PREF_CLEAR_FORM_DATA = "privacy_clear_form_data";
    public static final String PREF_CLEAR_PASSWORDS = "privacy_clear_passwords";
    public static final String PREF_EXTRAS_RESET_DEFAULTS = "reset_default_preferences";
    public static final String PREF_DEBUG_SETTINGS = "debug_menu";
    public static final String PREF_WEBSITE_SETTINGS = "website_settings";
    public static final String PREF_TEXT_SIZE = "text_size";
    public static final String PREF_DEFAULT_ZOOM = "default_zoom";
    public static final String PREF_DEFAULT_TEXT_ENCODING = "default_text_encoding";
    public static final String PREF_CLEAR_GEOLOCATION_ACCESS = "privacy_clear_geolocation_access";
    private static final String DESKTOP_USERAGENT = "Mozilla/5.0 (Macintosh; U; Intel Mac OS X 10_6_3; en-us) AppleWebKit/533.16 (KHTML, like Gecko) Version/5.0 Safari/533.16";
    private static final String IPHONE_USERAGENT = "Mozilla/5.0 (iPhone; U; CPU iPhone OS 4_0 like Mac OS X; en-us) AppleWebKit/532.9 (KHTML, like Gecko) Version/4.0.5 Mobile/8A293 Safari/6531.22.7";
    private static final String IPAD_USERAGENT = "Mozilla/5.0 (iPad; U; CPU OS 3_2 like Mac OS X; en-us) AppleWebKit/531.21.10 (KHTML, like Gecko) Version/4.0.4 Mobile/7B367 Safari/531.21.10";
    private static final String FROYO_USERAGENT = "Mozilla/5.0 (Linux; U; Android 2.2; en-us; Nexus One Build/FRF91) AppleWebKit/533.1 (KHTML, like Gecko) Version/4.0 Mobile Safari/533.1";
    public static final int MAX_TEXTVIEW_LEN = 80;
    public static final String RLZ_PROVIDER = "com.google.android.partnersetup.rlzappprovider";
    public static final Uri RLZ_PROVIDER_URI;
    private String mRlzValue = "";
    private TabControl mTabControl;
    private static BrowserSettings sSingleton;
    private HashMap<WebSettings, Observer> mWebSettingsToObservers = new HashMap();

    public void loadFromDb(Context ctx) {
        ActivityManager am;
        SharedPreferences p = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        this.appCachePath = ctx.getDir("appcache", 0).getPath();
        this.webStorageSizeManager = new WebStorageSizeManager(ctx, new WebStorageSizeManager.StatFsDiskInfo(this.appCachePath), new WebStorageSizeManager.WebKitAppCacheInfo(this.appCachePath));
        this.appCacheMaxSize = this.webStorageSizeManager.getAppCacheMaxSize();
        this.databasePath = ctx.getDir("databases", 0).getPath();
        this.geolocationDatabasePath = ctx.getDir("geolocation", 0).getPath();
        if (p.getString(PREF_HOMEPAGE, "") == "") {
            this.setHomePage(ctx, this.getFactoryResetHomeUrl(ctx));
        }
        pageCacheCapacity = (am = (ActivityManager)ctx.getSystemService("activity")).getMemoryClass() > 16 ? 5 : 1;
        this.syncSharedPreferences(ctx, p);
    }

    void syncSharedPreferences(Context ctx, SharedPreferences p) {
        this.homeUrl = p.getString(PREF_HOMEPAGE, this.homeUrl);
        String searchEngineName = p.getString(PREF_SEARCH_ENGINE, "google");
        if (this.searchEngine == null || !this.searchEngine.getName().equals(searchEngineName)) {
            if (this.searchEngine != null) {
                if (this.searchEngine.supportsVoiceSearch()) {
                    for (int i = 0; i < this.mTabControl.getTabCount(); ++i) {
                        this.mTabControl.getTab(i).revertVoiceSearchMode();
                    }
                }
                this.searchEngine.close();
            }
            this.searchEngine = SearchEngines.get(ctx, searchEngineName);
        }
        Log.i((String)TAG, (String)("Selected search engine: " + this.searchEngine));
        this.loadsImagesAutomatically = p.getBoolean("load_images", this.loadsImagesAutomatically);
        this.javaScriptEnabled = p.getBoolean("enable_javascript", this.javaScriptEnabled);
        this.pluginState = WebSettings.PluginState.valueOf((String)p.getString("plugin_state", this.pluginState.name()));
        this.javaScriptCanOpenWindowsAutomatically = !p.getBoolean("block_popup_windows", !this.javaScriptCanOpenWindowsAutomatically);
        this.showSecurityWarnings = p.getBoolean("show_security_warnings", this.showSecurityWarnings);
        this.rememberPasswords = p.getBoolean("remember_passwords", this.rememberPasswords);
        this.saveFormData = p.getBoolean("save_formdata", this.saveFormData);
        boolean accept_cookies = p.getBoolean("accept_cookies", CookieManager.getInstance().acceptCookie());
        CookieManager.getInstance().setAcceptCookie(accept_cookies);
        this.openInBackground = p.getBoolean("open_in_background", this.openInBackground);
        textSize = WebSettings.TextSize.valueOf((String)p.getString(PREF_TEXT_SIZE, textSize.name()));
        zoomDensity = WebSettings.ZoomDensity.valueOf((String)p.getString(PREF_DEFAULT_ZOOM, zoomDensity.name()));
        this.autoFitPage = p.getBoolean("autofit_pages", this.autoFitPage);
        this.loadsPageInOverviewMode = p.getBoolean("load_page", this.loadsPageInOverviewMode);
        boolean landscapeOnlyTemp = p.getBoolean("landscape_only", this.landscapeOnly);
        if (landscapeOnlyTemp != this.landscapeOnly) {
            this.landscapeOnly = landscapeOnlyTemp;
        }
        this.useWideViewPort = true;
        this.layoutAlgorithm = this.autoFitPage ? WebSettings.LayoutAlgorithm.NARROW_COLUMNS : WebSettings.LayoutAlgorithm.NORMAL;
        this.defaultTextEncodingName = p.getString(PREF_DEFAULT_TEXT_ENCODING, this.defaultTextEncodingName);
        this.showDebugSettings = p.getBoolean(PREF_DEBUG_SETTINGS, this.showDebugSettings);
        if (this.showDebugSettings) {
            boolean small_screen = p.getBoolean("small_screen", this.layoutAlgorithm == WebSettings.LayoutAlgorithm.SINGLE_COLUMN);
            if (small_screen) {
                this.layoutAlgorithm = WebSettings.LayoutAlgorithm.SINGLE_COLUMN;
            } else {
                boolean normal_layout = p.getBoolean("normal_layout", this.layoutAlgorithm == WebSettings.LayoutAlgorithm.NORMAL);
                this.layoutAlgorithm = normal_layout ? WebSettings.LayoutAlgorithm.NORMAL : WebSettings.LayoutAlgorithm.NARROW_COLUMNS;
            }
            this.useWideViewPort = p.getBoolean("wide_viewport", this.useWideViewPort);
            this.tracing = p.getBoolean("enable_tracing", this.tracing);
            this.lightTouch = p.getBoolean("enable_light_touch", this.lightTouch);
            this.navDump = p.getBoolean("enable_nav_dump", this.navDump);
            this.userAgent = Integer.parseInt(p.getString("user_agent", "0"));
        }
        this.jsFlags = p.getString("js_engine_flags", "");
        this.showConsole = p.getBoolean("javascript_console", this.showConsole);
        this.appCacheEnabled = p.getBoolean("enable_appcache", this.appCacheEnabled);
        this.databaseEnabled = p.getBoolean("enable_database", this.databaseEnabled);
        this.domStorageEnabled = p.getBoolean("enable_domstorage", this.domStorageEnabled);
        this.geolocationEnabled = p.getBoolean("enable_geolocation", this.geolocationEnabled);
        this.workersEnabled = p.getBoolean("enable_workers", this.workersEnabled);
        this.update();
    }

    public String getHomePage() {
        return this.homeUrl;
    }

    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    public String getJsFlags() {
        return this.jsFlags;
    }

    public WebStorageSizeManager getWebStorageSizeManager() {
        return this.webStorageSizeManager;
    }

    public void setHomePage(Context context, String url) {
        SharedPreferences.Editor ed = PreferenceManager.getDefaultSharedPreferences((Context)context).edit();
        ed.putString(PREF_HOMEPAGE, url);
        ed.apply();
        this.homeUrl = url;
    }

    public WebSettings.TextSize getTextSize() {
        return textSize;
    }

    public WebSettings.ZoomDensity getDefaultZoom() {
        return zoomDensity;
    }

    public boolean openInBackground() {
        return this.openInBackground;
    }

    public boolean showSecurityWarnings() {
        return this.showSecurityWarnings;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    public boolean isLightTouch() {
        return this.lightTouch;
    }

    public boolean isNavDump() {
        return this.navDump;
    }

    public boolean showDebugSettings() {
        return this.showDebugSettings;
    }

    public void toggleDebugSettings() {
        this.navDump = this.showDebugSettings = !this.showDebugSettings;
        this.update();
    }

    public Observer addObserver(WebSettings s) {
        Observer old = this.mWebSettingsToObservers.get(s);
        if (old != null) {
            super.deleteObserver(old);
        }
        Observer o = new Observer(s);
        this.mWebSettingsToObservers.put(s, o);
        super.addObserver(o);
        return o;
    }

    public void deleteObserver(WebSettings s) {
        Observer o = this.mWebSettingsToObservers.get(s);
        if (o != null) {
            this.mWebSettingsToObservers.remove(s);
            super.deleteObserver(o);
        }
    }

    static BrowserSettings getInstance() {
        if (sSingleton == null) {
            sSingleton = new BrowserSettings();
        }
        return sSingleton;
    }

    void setTabControl(TabControl tabControl) {
        this.mTabControl = tabControl;
        this.updateTabControlSettings();
    }

    void update() {
        this.setChanged();
        this.notifyObservers();
    }

    void clearCache(Context context) {
        WebView current;
        WebIconDatabase.getInstance().removeAllIcons();
        if (this.mTabControl != null && (current = this.mTabControl.getCurrentWebView()) != null) {
            current.clearCache(true);
        }
    }

    void clearCookies(Context context) {
        CookieManager.getInstance().removeAllCookie();
    }

    void clearHistory(Context context) {
        ContentResolver resolver = context.getContentResolver();
        Browser.clearHistory((ContentResolver)resolver);
        Browser.clearSearches((ContentResolver)resolver);
    }

    void clearFormData(Context context) {
        WebView currentTopView;
        WebViewDatabase.getInstance((Context)context).clearFormData();
        if (this.mTabControl != null && (currentTopView = this.mTabControl.getCurrentTopWebView()) != null) {
            currentTopView.clearFormData();
        }
    }

    void clearPasswords(Context context) {
        WebViewDatabase db = WebViewDatabase.getInstance((Context)context);
        db.clearUsernamePassword();
        db.clearHttpAuthUsernamePassword();
    }

    private void updateTabControlSettings() {
        this.mTabControl.getBrowserActivity().setShouldShowErrorConsole(this.showDebugSettings && this.showConsole);
        this.mTabControl.getBrowserActivity().setRequestedOrientation(this.landscapeOnly ? 0 : -1);
    }

    private void maybeDisableWebsiteSettings(Context context) {
        PreferenceActivity activity = (PreferenceActivity)context;
        final PreferenceScreen screen = (PreferenceScreen)activity.findPreference((CharSequence)PREF_WEBSITE_SETTINGS);
        screen.setEnabled(false);
        WebStorage.getInstance().getOrigins((ValueCallback)new ValueCallback<Map>(){

            public void onReceiveValue(Map webStorageOrigins) {
                if (webStorageOrigins != null && !webStorageOrigins.isEmpty()) {
                    screen.setEnabled(true);
                }
            }
        });
        GeolocationPermissions.getInstance().getOrigins((ValueCallback)new ValueCallback<Set<String>>(){

            public void onReceiveValue(Set<String> geolocationOrigins) {
                if (geolocationOrigins != null && !geolocationOrigins.isEmpty()) {
                    screen.setEnabled(true);
                }
            }
        });
    }

    void clearDatabases(Context context) {
        WebStorage.getInstance().deleteAllData();
        this.maybeDisableWebsiteSettings(context);
    }

    void clearLocationAccess(Context context) {
        GeolocationPermissions.getInstance().clearAll();
        this.maybeDisableWebsiteSettings(context);
    }

    void resetDefaultPreferences(Context ctx) {
        this.reset();
        SharedPreferences p = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        p.edit().clear().apply();
        PreferenceManager.setDefaultValues((Context)ctx, (int)2131034114, (boolean)true);
        this.setHomePage(ctx, this.getFactoryResetHomeUrl(ctx));
        this.appCacheMaxSize = this.webStorageSizeManager.getAppCacheMaxSize();
    }

    private String getFactoryResetHomeUrl(Context context) {
        String url = context.getResources().getString(2131230947);
        if (url.indexOf("{CID}") != -1) {
            url = url.replace("{CID}", BrowserProvider.getClientId(context.getContentResolver()));
        }
        return url;
    }

    private BrowserSettings() {
        this.reset();
    }

    private void reset() {
        this.loadsImagesAutomatically = true;
        this.javaScriptEnabled = true;
        this.pluginState = WebSettings.PluginState.ON;
        this.javaScriptCanOpenWindowsAutomatically = false;
        this.showSecurityWarnings = true;
        this.rememberPasswords = true;
        this.saveFormData = true;
        this.openInBackground = false;
        this.autoFitPage = true;
        this.landscapeOnly = false;
        this.loadsPageInOverviewMode = true;
        this.showDebugSettings = false;
        this.appCacheEnabled = true;
        this.databaseEnabled = true;
        this.domStorageEnabled = true;
        this.geolocationEnabled = true;
        this.workersEnabled = true;
    }

    String getRlzValue() {
        return this.mRlzValue;
    }

    void updateRlzValues(Context context) {
        new RlzUpdateTask(context).execute(new Void[0]);
    }

    private void updateHomePageRlzParameter(Context context) {
        String newHomeUrl;
        Uri uri = Uri.parse((String)this.homeUrl);
        if (uri.getQueryParameter("rlz") != null && UrlUtils.isGoogleUri(uri) && !this.homeUrl.equals(newHomeUrl = this.updateRlzParameter(this.homeUrl))) {
            this.setHomePage(context, newHomeUrl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBookmarksRlzParameter(Context context) {
        Cursor cur = null;
        try {
            cur = context.getContentResolver().query(Browser.BOOKMARKS_URI, new String[]{"_id", "url"}, "url LIKE '%rlz=%'", null, null);
            if (cur == null || cur.getCount() == 0) {
                return;
            }
            cur.moveToFirst();
            while (!cur.isAfterLast()) {
                String newUrl;
                Uri uri;
                long id2 = cur.getLong(0);
                String url = cur.getString(1);
                if (url != null && !url.isEmpty() && (uri = Uri.parse((String)url)).getQueryParameter("rlz") != null && UrlUtils.isGoogleUri(uri) && !url.equals(newUrl = this.updateRlzParameter(url))) {
                    ContentValues values = new ContentValues();
                    values.put("url", newUrl);
                    Uri bookmarkUri = ContentUris.withAppendedId((Uri)Browser.BOOKMARKS_URI, (long)id2);
                    context.getContentResolver().update(bookmarkUri, values, null, null);
                }
                cur.moveToNext();
            }
        }
        finally {
            if (cur != null) {
                cur.close();
            }
        }
    }

    private String updateRlzParameter(String url) {
        Uri uri = Uri.parse((String)url);
        String oldRlz = uri.getQueryParameter("rlz");
        if (oldRlz != null) {
            return url.replace("rlz=" + oldRlz, "rlz=" + this.mRlzValue);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String retrieveRlzValue(Context context) {
        String rlz = "";
        PackageManager pm = context.getPackageManager();
        if (pm.resolveContentProvider(RLZ_PROVIDER, 0) == null) {
            return rlz;
        }
        String ap = context.getResources().getString(2131230982);
        if (ap.isEmpty()) {
            return rlz;
        }
        Uri rlzUri = Uri.withAppendedPath((Uri)RLZ_PROVIDER_URI, (String)ap);
        Cursor cur = null;
        try {
            cur = context.getContentResolver().query(rlzUri, null, null, null, null);
            if (cur != null && cur.moveToFirst() && !cur.isNull(0)) {
                rlz = cur.getString(0);
            }
        }
        finally {
            if (cur != null) {
                cur.close();
            }
        }
        return rlz;
    }

    static {
        RLZ_PROVIDER_URI = Uri.parse((String)"content://com.google.android.partnersetup.rlzappprovider/");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RlzUpdateTask
    extends AsyncTask<Void, Void, Void> {
        private final Context context;

        public RlzUpdateTask(Context context) {
            this.context = context;
        }

        protected Void doInBackground(Void ... unused) {
            String rlz = BrowserSettings.retrieveRlzValue(this.context);
            if (!rlz.isEmpty()) {
                BrowserSettings.this.mRlzValue = rlz;
                BrowserSettings.this.updateHomePageRlzParameter(this.context);
                BrowserSettings.this.updateBookmarksRlzParameter(this.context);
            }
            return null;
        }
    }

    static class Observer
    implements java.util.Observer {
        private WebSettings mSettings;

        Observer(WebSettings w) {
            this.mSettings = w;
        }

        public void update(Observable o, Object arg) {
            BrowserSettings b = (BrowserSettings)o;
            WebSettings s = this.mSettings;
            s.setLayoutAlgorithm(b.layoutAlgorithm);
            if (b.userAgent == 0) {
                s.setUserAgentString(null);
            } else if (b.userAgent == 1) {
                s.setUserAgentString(BrowserSettings.DESKTOP_USERAGENT);
            } else if (b.userAgent == 2) {
                s.setUserAgentString(BrowserSettings.IPHONE_USERAGENT);
            } else if (b.userAgent == 3) {
                s.setUserAgentString(BrowserSettings.IPAD_USERAGENT);
            } else if (b.userAgent == 4) {
                s.setUserAgentString(BrowserSettings.FROYO_USERAGENT);
            }
            s.setUseWideViewPort(b.useWideViewPort);
            s.setLoadsImagesAutomatically(b.loadsImagesAutomatically);
            s.setJavaScriptEnabled(b.javaScriptEnabled);
            s.setPluginState(b.pluginState);
            s.setJavaScriptCanOpenWindowsAutomatically(b.javaScriptCanOpenWindowsAutomatically);
            s.setDefaultTextEncodingName(b.defaultTextEncodingName);
            s.setMinimumFontSize(minimumFontSize);
            s.setMinimumLogicalFontSize(minimumLogicalFontSize);
            s.setDefaultFontSize(defaultFontSize);
            s.setDefaultFixedFontSize(defaultFixedFontSize);
            s.setNavDump(b.navDump);
            s.setTextSize(textSize);
            s.setDefaultZoom(zoomDensity);
            s.setLightTouchEnabled(b.lightTouch);
            s.setSaveFormData(b.saveFormData);
            s.setSavePassword(b.rememberPasswords);
            s.setLoadWithOverviewMode(b.loadsPageInOverviewMode);
            s.setPageCacheCapacity(pageCacheCapacity);
            s.setNeedInitialFocus(false);
            s.setSupportMultipleWindows(true);
            s.setAllowContentAccess(false);
            s.setAppCacheEnabled(b.appCacheEnabled);
            s.setDatabaseEnabled(b.databaseEnabled);
            s.setDomStorageEnabled(b.domStorageEnabled);
            s.setWorkersEnabled(b.workersEnabled);
            s.setGeolocationEnabled(b.geolocationEnabled);
            s.setAppCacheMaxSize(b.appCacheMaxSize);
            s.setAppCachePath(b.appCachePath);
            s.setDatabasePath(b.databasePath);
            s.setGeolocationDatabasePath(b.geolocationDatabasePath);
            b.updateTabControlSettings();
        }
    }
}

