/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.backup.BackupManager;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.UriMatcher;
import android.database.AbstractCursor;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.os.Process;
import android.provider.Browser;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import com.android.browser.BrowserSettings;
import com.android.browser.search.SearchEngine;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserProvider
extends ContentProvider {
    private SQLiteOpenHelper mOpenHelper;
    private BackupManager mBackupManager;
    private static final String sDatabaseName = "browser.db";
    private static final String TAG = "BrowserProvider";
    private static final String ORDER_BY = "visits DESC, date DESC";
    private static final String PICASA_URL = "http://picasaweb.google.com/m/viewer?source=androidclient";
    private static final String[] TABLE_NAMES = new String[]{"bookmarks", "searches"};
    private static final String[] SUGGEST_PROJECTION = new String[]{"_id", "url", "title", "bookmark", "user_entered"};
    private static final String SUGGEST_SELECTION = "(url LIKE ? OR url LIKE ? OR url LIKE ? OR url LIKE ? OR title LIKE ?) AND (bookmark = 1 OR user_entered = 1)";
    private String[] SUGGEST_ARGS = new String[5];
    private static final int SUGGEST_COLUMN_INTENT_ACTION_ID = 1;
    private static final int SUGGEST_COLUMN_INTENT_DATA_ID = 2;
    private static final int SUGGEST_COLUMN_TEXT_1_ID = 3;
    private static final int SUGGEST_COLUMN_TEXT_2_ID = 4;
    private static final int SUGGEST_COLUMN_TEXT_2_URL_ID = 5;
    private static final int SUGGEST_COLUMN_ICON_1_ID = 6;
    private static final int SUGGEST_COLUMN_ICON_2_ID = 7;
    private static final int SUGGEST_COLUMN_QUERY_ID = 8;
    private static final int SUGGEST_COLUMN_INTENT_EXTRA_DATA = 9;
    private static final String[] COLUMNS = new String[]{"_id", "suggest_intent_action", "suggest_intent_data", "suggest_text_1", "suggest_text_2", "suggest_text_2_url", "suggest_icon_1", "suggest_icon_2", "suggest_intent_query", "suggest_intent_extra_data"};
    private static final int MAX_SUGGESTION_SHORT_ENTRIES = 3;
    private static final int MAX_SUGGESTION_LONG_ENTRIES = 6;
    private static final String MAX_SUGGESTION_LONG_ENTRIES_STRING = Integer.valueOf(6).toString();
    private static final int URI_MATCH_BOOKMARKS = 0;
    private static final int URI_MATCH_SEARCHES = 1;
    private static final int URI_MATCH_BOOKMARKS_ID = 10;
    private static final int URI_MATCH_SEARCHES_ID = 11;
    private static final int URI_MATCH_SUGGEST = 20;
    private static final int URI_MATCH_BOOKMARKS_SUGGEST = 21;
    private static final UriMatcher URI_MATCHER = new UriMatcher(-1);
    private static final int DATABASE_VERSION = 23;
    private static final Pattern STRIP_URL_PATTERN;
    private BrowserSettings mSettings;
    private ResultsCursor mResultsCursor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getClientId(ContentResolver cr) {
        String ret = "android-google";
        Cursor c = null;
        try {
            c = cr.query(Uri.parse((String)"content://com.google.settings/partner"), new String[]{"value"}, "name='client_id'", null, null);
            if (c != null && c.moveToNext()) {
                ret = c.getString(0);
            }
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
        return ret;
    }

    private static CharSequence replaceSystemPropertyInString(Context context, CharSequence srcString) {
        StringBuffer sb = new StringBuffer();
        int lastCharLoc = 0;
        String client_id = BrowserProvider.getClientId(context.getContentResolver());
        block0: for (int i = 0; i < srcString.length(); ++i) {
            char c = srcString.charAt(i);
            if (c != '{') continue;
            sb.append(srcString.subSequence(lastCharLoc, i));
            lastCharLoc = i;
            for (int j = i; j < srcString.length(); ++j) {
                char k = srcString.charAt(j);
                if (k != '}') continue;
                String propertyKeyValue = ((Object)srcString.subSequence(i + 1, j)).toString();
                if (propertyKeyValue.equals("CLIENT_ID")) {
                    sb.append(client_id);
                } else {
                    sb.append("unknown");
                }
                lastCharLoc = j + 1;
                i = j;
                continue block0;
            }
        }
        if (srcString.length() - lastCharLoc > 0) {
            sb.append(srcString.subSequence(lastCharLoc, srcString.length()));
        }
        return sb;
    }

    public boolean onCreate() {
        Context context = this.getContext();
        this.mOpenHelper = new DatabaseHelper(context);
        this.mBackupManager = new BackupManager(context);
        this.mSettings = BrowserSettings.getInstance();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixPicasaBookmark() {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        Cursor cursor = db.rawQuery("SELECT _id FROM bookmarks WHERE bookmark = 1 AND url = ?", new String[]{PICASA_URL});
        try {
            if (!cursor.moveToFirst()) {
                db.execSQL("INSERT INTO bookmarks (title, url, visits, date, created, bookmark) VALUES('" + this.getContext().getString(2131230948) + "', '" + PICASA_URL + "', 0, 0, " + new Date().getTime() + ", 1);");
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    void setQueryResults(ArrayList<String> results) {
        this.mResultsCursor = results == null ? null : new ResultsCursor(results);
    }

    public Cursor query(Uri url, String[] projectionIn, String selection, String[] selectionArgs, String sortOrder) throws IllegalStateException {
        int match = URI_MATCHER.match(url);
        if (match == -1) {
            throw new IllegalArgumentException("Unknown URL");
        }
        if (match == 20 && this.mResultsCursor != null) {
            ResultsCursor results = this.mResultsCursor;
            this.mResultsCursor = null;
            return results;
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        if (match == 20 || match == 21) {
            SearchEngine searchEngine;
            String[] myArgs;
            String suggestSelection;
            if (selectionArgs[0] == null || selectionArgs[0].equals("")) {
                suggestSelection = null;
                myArgs = null;
            } else {
                String like = selectionArgs[0] + "%";
                if (selectionArgs[0].startsWith("http") || selectionArgs[0].startsWith("file")) {
                    myArgs = new String[]{like};
                    suggestSelection = selection;
                } else {
                    this.SUGGEST_ARGS[0] = "http://" + like;
                    this.SUGGEST_ARGS[1] = "http://www." + like;
                    this.SUGGEST_ARGS[2] = "https://" + like;
                    this.SUGGEST_ARGS[3] = "https://www." + like;
                    this.SUGGEST_ARGS[4] = like;
                    myArgs = this.SUGGEST_ARGS;
                    suggestSelection = SUGGEST_SELECTION;
                }
            }
            Cursor c = db.query(TABLE_NAMES[0], SUGGEST_PROJECTION, suggestSelection, myArgs, null, null, ORDER_BY, MAX_SUGGESTION_LONG_ENTRIES_STRING);
            if (match == 21 || Patterns.WEB_URL.matcher(selectionArgs[0]).matches()) {
                return new MySuggestionCursor(c, null, "");
            }
            if (myArgs != null && myArgs.length > 1 && c.getCount() < 2 && (searchEngine = this.mSettings.getSearchEngine()) != null && searchEngine.supportsSuggestions()) {
                Cursor sc = searchEngine.getSuggestions(this.getContext(), selectionArgs[0]);
                return new MySuggestionCursor(c, sc, selectionArgs[0]);
            }
            return new MySuggestionCursor(c, null, selectionArgs[0]);
        }
        String[] projection = null;
        if (projectionIn != null && projectionIn.length > 0) {
            projection = new String[projectionIn.length + 1];
            System.arraycopy(projectionIn, 0, projection, 0, projectionIn.length);
            projection[projectionIn.length] = "_id AS _id";
        }
        StringBuilder whereClause = new StringBuilder(256);
        if (match == 10 || match == 11) {
            whereClause.append("(_id = ").append((String)url.getPathSegments().get(1)).append(")");
        }
        if (selection != null && selection.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append('(');
            whereClause.append(selection);
            whereClause.append(')');
        }
        Cursor c = db.query(TABLE_NAMES[match % 10], projection, whereClause.toString(), selectionArgs, null, null, sortOrder, null);
        c.setNotificationUri(this.getContext().getContentResolver(), url);
        return c;
    }

    public String getType(Uri url) {
        int match = URI_MATCHER.match(url);
        switch (match) {
            case 0: {
                return "vnd.android.cursor.dir/bookmark";
            }
            case 10: {
                return "vnd.android.cursor.item/bookmark";
            }
            case 1: {
                return "vnd.android.cursor.dir/searches";
            }
            case 11: {
                return "vnd.android.cursor.item/searches";
            }
            case 20: {
                return "vnd.android.cursor.dir/vnd.android.search.suggest";
            }
        }
        throw new IllegalArgumentException("Unknown URL");
    }

    public Uri insert(Uri url, ContentValues initialValues) {
        boolean isBookmarkTable = false;
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = URI_MATCHER.match(url);
        Uri uri = null;
        switch (match) {
            case 0: {
                long rowID = db.insert(TABLE_NAMES[0], "url", initialValues);
                if (rowID > 0L) {
                    uri = ContentUris.withAppendedId((Uri)Browser.BOOKMARKS_URI, (long)rowID);
                }
                isBookmarkTable = true;
                break;
            }
            case 1: {
                long rowID = db.insert(TABLE_NAMES[1], "url", initialValues);
                if (rowID <= 0L) break;
                uri = ContentUris.withAppendedId((Uri)Browser.SEARCHES_URI, (long)rowID);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URL");
            }
        }
        if (uri == null) {
            throw new IllegalArgumentException("Unknown URL");
        }
        this.getContext().getContentResolver().notifyChange(uri, null);
        if (isBookmarkTable && initialValues.containsKey("bookmark") && initialValues.getAsInteger("bookmark") != 0) {
            this.mBackupManager.dataChanged();
        }
        return uri;
    }

    public int delete(Uri url, String where, String[] whereArgs) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = URI_MATCHER.match(url);
        if (match == -1 || match == 20) {
            throw new IllegalArgumentException("Unknown URL");
        }
        boolean isBookmarkTable = match == 10;
        String id2 = null;
        if (isBookmarkTable || match == 11) {
            StringBuilder sb = new StringBuilder();
            if (where != null && where.length() > 0) {
                sb.append("( ");
                sb.append(where);
                sb.append(" ) AND ");
            }
            id2 = (String)url.getPathSegments().get(1);
            sb.append("_id = ");
            sb.append(id2);
            where = sb.toString();
        }
        ContentResolver cr = this.getContext().getContentResolver();
        if (isBookmarkTable) {
            Cursor cursor = cr.query(Browser.BOOKMARKS_URI, new String[]{"bookmark"}, "_id = " + id2, null, null);
            if (cursor.moveToNext() && cursor.getInt(0) != 0) {
                this.mBackupManager.dataChanged();
            }
            cursor.close();
        }
        int count = db.delete(TABLE_NAMES[match % 10], where, whereArgs);
        cr.notifyChange(url, null);
        return count;
    }

    public int update(Uri url, ContentValues values, String where, String[] whereArgs) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int match = URI_MATCHER.match(url);
        if (match == -1 || match == 20) {
            throw new IllegalArgumentException("Unknown URL");
        }
        if (match == 10 || match == 11) {
            StringBuilder sb = new StringBuilder();
            if (where != null && where.length() > 0) {
                sb.append("( ");
                sb.append(where);
                sb.append(" ) AND ");
            }
            String id2 = (String)url.getPathSegments().get(1);
            sb.append("_id = ");
            sb.append(id2);
            where = sb.toString();
        }
        ContentResolver cr = this.getContext().getContentResolver();
        if (match == 10 || match == 0) {
            boolean changingBookmarks = false;
            if (values.containsKey("bookmark")) {
                changingBookmarks = true;
            } else if ((values.containsKey("title") || values.containsKey("url")) && values.containsKey("_id")) {
                Cursor cursor = cr.query(Browser.BOOKMARKS_URI, new String[]{"bookmark"}, "_id = " + values.getAsString("_id"), null, null);
                if (cursor.moveToNext()) {
                    changingBookmarks = cursor.getInt(0) != 0;
                }
                cursor.close();
            }
            if (changingBookmarks) {
                this.mBackupManager.dataChanged();
            }
        }
        int ret = db.update(TABLE_NAMES[match % 10], values, where, whereArgs);
        cr.notifyChange(url, null);
        return ret;
    }

    private static String stripUrl(String url) {
        if (url == null) {
            return null;
        }
        Matcher m = STRIP_URL_PATTERN.matcher(url);
        if (m.matches() && m.groupCount() == 3) {
            return m.group(2);
        }
        return url;
    }

    static {
        URI_MATCHER.addURI("browser", TABLE_NAMES[0], 0);
        URI_MATCHER.addURI("browser", TABLE_NAMES[0] + "/#", 10);
        URI_MATCHER.addURI("browser", TABLE_NAMES[1], 1);
        URI_MATCHER.addURI("browser", TABLE_NAMES[1] + "/#", 11);
        URI_MATCHER.addURI("browser", "search_suggest_query", 20);
        URI_MATCHER.addURI("browser", TABLE_NAMES[0] + "/" + "search_suggest_query", 21);
        STRIP_URL_PATTERN = Pattern.compile("^(http://)(.*?)(/$)?");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResultsCursor
    extends AbstractCursor {
        private static final int RESULT_ACTION_ID = 1;
        private static final int RESULT_DATA_ID = 2;
        private static final int RESULT_TEXT_ID = 3;
        private static final int RESULT_ICON_ID = 4;
        private static final int RESULT_EXTRA_ID = 5;
        private static final String[] RESULTS_COLUMNS = new String[]{"_id", "suggest_intent_action", "suggest_intent_data", "suggest_text_1", "suggest_icon_1", "suggest_intent_extra_data"};
        private final ArrayList<String> mResults;

        public ResultsCursor(ArrayList<String> results) {
            this.mResults = results;
        }

        public int getCount() {
            return this.mResults.size();
        }

        public String[] getColumnNames() {
            return RESULTS_COLUMNS;
        }

        public String getString(int column) {
            switch (column) {
                case 1: {
                    return "android.speech.action.VOICE_SEARCH_RESULTS";
                }
                case 2: 
                case 3: {
                    return this.mResults.get(this.mPos);
                }
                case 5: {
                    return Integer.toString(this.mPos);
                }
                case 4: {
                    return Integer.valueOf(2130837558).toString();
                }
            }
            return null;
        }

        public short getShort(int column) {
            throw new UnsupportedOperationException();
        }

        public int getInt(int column) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int column) {
            if (this.mPos != -1 && column == 0) {
                return this.mPos;
            }
            throw new UnsupportedOperationException();
        }

        public float getFloat(int column) {
            throw new UnsupportedOperationException();
        }

        public double getDouble(int column) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int column) {
            throw new UnsupportedOperationException();
        }
    }

    private class MySuggestionCursor
    extends AbstractCursor {
        private Cursor mHistoryCursor;
        private Cursor mSuggestCursor;
        private int mHistoryCount;
        private int mSuggestionCount;
        private boolean mIncludeWebSearch;
        private String mString;
        private int mSuggestText1Id;
        private int mSuggestText2Id;
        private int mSuggestText2UrlId;
        private int mSuggestQueryId;
        private int mSuggestIntentExtraDataId;

        public MySuggestionCursor(Cursor hc, Cursor sc, String string2) {
            this.mHistoryCursor = hc;
            this.mSuggestCursor = sc;
            this.mHistoryCount = hc.getCount();
            int n = this.mSuggestionCount = sc != null ? sc.getCount() : 0;
            if (this.mSuggestionCount > 6 - this.mHistoryCount) {
                this.mSuggestionCount = 6 - this.mHistoryCount;
            }
            this.mString = string2;
            boolean bl = this.mIncludeWebSearch = string2.length() > 0;
            if (this.mSuggestCursor == null) {
                this.mSuggestText1Id = -1;
                this.mSuggestText2Id = -1;
                this.mSuggestText2UrlId = -1;
                this.mSuggestQueryId = -1;
                this.mSuggestIntentExtraDataId = -1;
            } else {
                this.mSuggestText1Id = this.mSuggestCursor.getColumnIndex("suggest_text_1");
                this.mSuggestText2Id = this.mSuggestCursor.getColumnIndex("suggest_text_2");
                this.mSuggestText2UrlId = this.mSuggestCursor.getColumnIndex("suggest_text_2_url");
                this.mSuggestQueryId = this.mSuggestCursor.getColumnIndex("suggest_intent_query");
                this.mSuggestIntentExtraDataId = this.mSuggestCursor.getColumnIndex("suggest_intent_extra_data");
            }
        }

        public boolean onMove(int oldPosition, int newPosition) {
            if (this.mHistoryCursor == null) {
                return false;
            }
            if (this.mIncludeWebSearch) {
                if (this.mHistoryCount == 0 && newPosition == 0) {
                    return true;
                }
                if (this.mHistoryCount > 0) {
                    if (newPosition == 0) {
                        this.mHistoryCursor.moveToPosition(0);
                        return true;
                    }
                    if (newPosition == 1) {
                        return true;
                    }
                }
                --newPosition;
            }
            if (this.mHistoryCount > newPosition) {
                this.mHistoryCursor.moveToPosition(newPosition);
            } else {
                this.mSuggestCursor.moveToPosition(newPosition - this.mHistoryCount);
            }
            return true;
        }

        public int getCount() {
            if (this.mIncludeWebSearch) {
                return this.mHistoryCount + this.mSuggestionCount + 1;
            }
            return this.mHistoryCount + this.mSuggestionCount;
        }

        public String[] getColumnNames() {
            return COLUMNS;
        }

        public String getString(int columnIndex) {
            if (this.mPos != -1 && this.mHistoryCursor != null) {
                int type = -1;
                if (this.mIncludeWebSearch) {
                    if (this.mHistoryCount == 0 && this.mPos == 0) {
                        type = 0;
                    } else if (this.mHistoryCount > 0) {
                        if (this.mPos == 0) {
                            type = 1;
                        } else if (this.mPos == 1) {
                            type = 0;
                        }
                    }
                    if (type == -1) {
                        type = this.mPos - 1 < this.mHistoryCount ? 1 : 2;
                    }
                } else {
                    type = this.mPos < this.mHistoryCount ? 1 : 2;
                }
                switch (columnIndex) {
                    case 1: {
                        if (type == 1) {
                            return "android.intent.action.VIEW";
                        }
                        return "android.intent.action.SEARCH";
                    }
                    case 2: {
                        if (type == 1) {
                            return this.mHistoryCursor.getString(1);
                        }
                        return null;
                    }
                    case 3: {
                        if (type == 0) {
                            return this.mString;
                        }
                        if (type == 1) {
                            return this.getHistoryTitle();
                        }
                        if (this.mSuggestText1Id == -1) {
                            return null;
                        }
                        return this.mSuggestCursor.getString(this.mSuggestText1Id);
                    }
                    case 4: {
                        if (type == 0) {
                            return BrowserProvider.this.getContext().getString(2131230949);
                        }
                        if (type == 1) {
                            return null;
                        }
                        if (this.mSuggestText2Id == -1) {
                            return null;
                        }
                        return this.mSuggestCursor.getString(this.mSuggestText2Id);
                    }
                    case 5: {
                        if (type == 0) {
                            return null;
                        }
                        if (type == 1) {
                            return this.getHistoryUrl();
                        }
                        if (this.mSuggestText2UrlId == -1) {
                            return null;
                        }
                        return this.mSuggestCursor.getString(this.mSuggestText2UrlId);
                    }
                    case 6: {
                        if (type == 1) {
                            if (this.mHistoryCursor.getInt(3) == 1) {
                                return Integer.valueOf(2130837548).toString();
                            }
                            return Integer.valueOf(2130837550).toString();
                        }
                        return Integer.valueOf(2130837551).toString();
                    }
                    case 7: {
                        return "0";
                    }
                    case 8: {
                        if (type == 0) {
                            return this.mString;
                        }
                        if (type == 1) {
                            return this.mHistoryCursor.getString(1);
                        }
                        if (this.mSuggestQueryId == -1) {
                            return null;
                        }
                        return this.mSuggestCursor.getString(this.mSuggestQueryId);
                    }
                    case 9: {
                        if (type == 0) {
                            return null;
                        }
                        if (type == 1) {
                            return null;
                        }
                        if (this.mSuggestIntentExtraDataId == -1) {
                            return null;
                        }
                        return this.mSuggestCursor.getString(this.mSuggestIntentExtraDataId);
                    }
                }
            }
            return null;
        }

        public double getDouble(int column) {
            throw new UnsupportedOperationException();
        }

        public float getFloat(int column) {
            throw new UnsupportedOperationException();
        }

        public int getInt(int column) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int column) {
            if (this.mPos != -1 && column == 0) {
                return this.mPos;
            }
            throw new UnsupportedOperationException();
        }

        public short getShort(int column) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int column) {
            throw new UnsupportedOperationException();
        }

        public void deactivate() {
            if (this.mHistoryCursor != null) {
                this.mHistoryCursor.deactivate();
            }
            if (this.mSuggestCursor != null) {
                this.mSuggestCursor.deactivate();
            }
            super.deactivate();
        }

        public boolean requery() {
            return (this.mHistoryCursor != null ? this.mHistoryCursor.requery() : false) | (this.mSuggestCursor != null ? this.mSuggestCursor.requery() : false);
        }

        public void close() {
            super.close();
            if (this.mHistoryCursor != null) {
                this.mHistoryCursor.close();
                this.mHistoryCursor = null;
            }
            if (this.mSuggestCursor != null) {
                this.mSuggestCursor.close();
                this.mSuggestCursor = null;
            }
        }

        private String getHistoryTitle() {
            String title = this.mHistoryCursor.getString(2);
            if (TextUtils.isEmpty((CharSequence)title) || TextUtils.getTrimmedLength((CharSequence)title) == 0) {
                title = BrowserProvider.stripUrl(this.mHistoryCursor.getString(1));
            }
            return title;
        }

        private String getHistoryUrl() {
            String title = this.mHistoryCursor.getString(2);
            if (TextUtils.isEmpty((CharSequence)title) || TextUtils.getTrimmedLength((CharSequence)title) == 0) {
                return null;
            }
            return BrowserProvider.stripUrl(this.mHistoryCursor.getString(1));
        }
    }

    private static class DatabaseHelper
    extends SQLiteOpenHelper {
        private Context mContext;

        public DatabaseHelper(Context context) {
            super(context, BrowserProvider.sDatabaseName, null, 23);
            this.mContext = context;
        }

        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE bookmarks (_id INTEGER PRIMARY KEY,title TEXT,url TEXT,visits INTEGER,date LONG,created LONG,description TEXT,bookmark INTEGER,favicon BLOB DEFAULT NULL,thumbnail BLOB DEFAULT NULL,touch_icon BLOB DEFAULT NULL,user_entered INTEGER);");
            CharSequence[] bookmarks = this.mContext.getResources().getTextArray(2131099748);
            int size = bookmarks.length;
            try {
                for (int i = 0; i < size; i += 2) {
                    CharSequence bookmarkDestination = BrowserProvider.replaceSystemPropertyInString(this.mContext, bookmarks[i + 1]);
                    db.execSQL("INSERT INTO bookmarks (title, url, visits, date, created, bookmark) VALUES('" + bookmarks[i] + "', '" + bookmarkDestination + "', 0, 0, 0, 1);");
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            db.execSQL("CREATE TABLE searches (_id INTEGER PRIMARY KEY,search TEXT,date LONG);");
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.w((String)BrowserProvider.TAG, (String)("Upgrading database from version " + oldVersion + " to " + newVersion));
            if (oldVersion == 18) {
                db.execSQL("DROP TABLE IF EXISTS labels");
            }
            if (oldVersion <= 19) {
                db.execSQL("ALTER TABLE bookmarks ADD COLUMN thumbnail BLOB DEFAULT NULL;");
            }
            if (oldVersion < 21) {
                db.execSQL("ALTER TABLE bookmarks ADD COLUMN touch_icon BLOB DEFAULT NULL;");
            }
            if (oldVersion < 22) {
                db.execSQL("DELETE FROM bookmarks WHERE (bookmark = 0 AND url LIKE \"%.google.%client=ms-%\")");
                this.removeGears();
            }
            if (oldVersion < 23) {
                db.execSQL("ALTER TABLE bookmarks ADD COLUMN user_entered INTEGER;");
            } else {
                db.execSQL("DROP TABLE IF EXISTS bookmarks");
                db.execSQL("DROP TABLE IF EXISTS searches");
                this.onCreate(db);
            }
        }

        private void removeGears() {
            new Thread(){

                public void run() {
                    Process.setThreadPriority((int)10);
                    String browserDataDirString = ((DatabaseHelper)DatabaseHelper.this).mContext.getApplicationInfo().dataDir;
                    String appPluginsDirString = "app_plugins";
                    String gearsPrefix = "gears";
                    File appPluginsDir = new File(browserDataDirString + File.separator + "app_plugins");
                    if (!appPluginsDir.exists()) {
                        return;
                    }
                    File[] gearsFiles = appPluginsDir.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String filename) {
                            return filename.startsWith("gears");
                        }
                    });
                    for (int i = 0; i < gearsFiles.length; ++i) {
                        if (gearsFiles[i].isDirectory()) {
                            this.deleteDirectory(gearsFiles[i]);
                            continue;
                        }
                        gearsFiles[i].delete();
                    }
                    File gearsDataDir = new File(browserDataDirString + File.separator + "gears");
                    if (!gearsDataDir.exists()) {
                        return;
                    }
                    this.deleteDirectory(gearsDataDir);
                }

                private void deleteDirectory(File currentDir) {
                    File[] files = currentDir.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        if (files[i].isDirectory()) {
                            this.deleteDirectory(files[i]);
                        }
                        files[i].delete();
                    }
                    currentDir.delete();
                }
            }.start();
        }
    }
}

