/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.AlertDialog;
import android.content.Context;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.android.browser.BrowserActivity;

public class BrowserHomepagePreference
extends EditTextPreference {
    private String mCurrentPage;

    public BrowserHomepagePreference(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public BrowserHomepagePreference(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public BrowserHomepagePreference(Context context) {
        super(context);
    }

    protected void onAddEditTextToDialogView(View dialogView, EditText editText) {
        super.onAddEditTextToDialogView(dialogView, editText);
        ViewGroup parent = (ViewGroup)editText.getParent();
        Button button = new Button(this.getContext());
        button.setText(2131230832);
        button.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                BrowserHomepagePreference.this.getEditText().setText((CharSequence)BrowserHomepagePreference.this.mCurrentPage);
            }
        });
        if (parent instanceof LinearLayout) {
            ((LinearLayout)parent).setGravity(1);
        }
        parent.addView((View)button, -2, -2);
    }

    protected void onDialogClosed(boolean positiveResult) {
        String url;
        if (positiveResult && (url = this.getEditText().getText().toString()).length() > 0 && !BrowserActivity.ACCEPTED_URI_SCHEMA.matcher(url).matches()) {
            int colon = url.indexOf(58);
            int space = url.indexOf(32);
            if (colon == -1 && space == -1) {
                this.getEditText().setText((CharSequence)("http://" + url));
            } else {
                new AlertDialog.Builder(this.getContext()).setMessage(2131230782).setPositiveButton(2131230736, null).show();
                positiveResult = false;
            }
        }
        super.onDialogClosed(positiveResult);
    }

    void setCurrentPage(String currentPage) {
        this.mCurrentPage = currentPage;
    }

    protected void showDialog(Bundle state) {
        super.showDialog(state);
        Window window = this.getDialog().getWindow();
        View decorView = window.getDecorView();
        WindowManager.LayoutParams params = (WindowManager.LayoutParams)decorView.getLayoutParams();
        params.width = -1;
        window.getWindowManager().updateViewLayout(decorView, (ViewGroup.LayoutParams)params);
    }
}

