/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.Activity;
import android.app.ExpandableListActivity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Browser;
import android.text.IClipboard;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.webkit.WebIconDatabase;
import android.widget.ExpandableListView;
import android.widget.Toast;
import com.android.browser.Bookmarks;
import com.android.browser.BrowserSettings;
import com.android.browser.CombinedBookmarkHistoryActivity;
import com.android.browser.DateSortedExpandableListAdapter;
import com.android.browser.HistoryItem;

public class BrowserHistoryPage
extends ExpandableListActivity {
    private HistoryAdapter mAdapter;
    private boolean mDisableNewWindow;
    private HistoryItem mContextHeader;
    private static final String LOGTAG = "browser";
    private final IconReceiver mIconReceiver = new IconReceiver();

    private void loadUrl(String url, boolean newWindow) {
        Intent intent = new Intent().setAction(url);
        if (newWindow) {
            Bundle b = new Bundle();
            b.putBoolean("new_window", true);
            intent.putExtras(b);
        }
        this.setResultToParent(-1, intent);
        this.finish();
    }

    private void copy(CharSequence text) {
        try {
            IClipboard clip = IClipboard.Stub.asInterface((IBinder)ServiceManager.getService((String)"clipboard"));
            if (clip != null) {
                clip.setClipboardText(text);
            }
        }
        catch (RemoteException e) {
            Log.e((String)LOGTAG, (String)"Copy failed", (Throwable)e);
        }
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setTitle(2131230898);
        String whereClause = "visits > 0 AND date > 0";
        String orderBy = "date DESC";
        Cursor cursor = this.managedQuery(Browser.BOOKMARKS_URI, Browser.HISTORY_PROJECTION, "visits > 0 AND date > 0", null, "date DESC");
        this.mAdapter = new HistoryAdapter((Context)this, cursor, 3);
        this.setListAdapter(this.mAdapter);
        final ExpandableListView list = this.getExpandableListView();
        list.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
        ViewStub v = new ViewStub((Context)this, 2130903049);
        this.addContentView((View)v, new ViewGroup.LayoutParams(-1, -1));
        list.setEmptyView((View)v);
        if (list.getExpandableListAdapter().getGroupCount() > 0) {
            list.post(new Runnable(){

                public void run() {
                    if (list.getExpandableListAdapter().getGroupCount() > 0) {
                        list.expandGroup(0);
                    }
                }
            });
        }
        this.mDisableNewWindow = this.getIntent().getBooleanExtra("disable_new_window", false);
        CombinedBookmarkHistoryActivity.getIconListenerSet().addListener(this.mIconReceiver);
        Activity parent = this.getParent();
        if (null == parent || !(parent instanceof CombinedBookmarkHistoryActivity)) {
            throw new AssertionError((Object)"history page can only be viewed as a tabin CombinedBookmarkHistoryActivity");
        }
        this.setResultToParent(0, null);
    }

    protected void onDestroy() {
        super.onDestroy();
        CombinedBookmarkHistoryActivity.getIconListenerSet().removeListener(this.mIconReceiver);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        super.onCreateOptionsMenu(menu2);
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131427336, menu2);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        menu2.findItem(2131493024).setVisible(Browser.canClearHistory((ContentResolver)this.getContentResolver()));
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131493024: {
                Browser.clearHistory((ContentResolver)this.getContentResolver());
                ((CombinedBookmarkHistoryActivity)this.getParent()).removeParentChildRelationShips();
                this.mAdapter.refreshData();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        ExpandableListView.ExpandableListContextMenuInfo i = (ExpandableListView.ExpandableListContextMenuInfo)menuInfo;
        if (!(i.targetView instanceof HistoryItem)) {
            return;
        }
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131427337, (Menu)menu2);
        HistoryItem historyItem = (HistoryItem)i.targetView;
        if (this.mContextHeader == null) {
            this.mContextHeader = new HistoryItem((Context)this);
        } else if (this.mContextHeader.getParent() != null) {
            ((ViewGroup)this.mContextHeader.getParent()).removeView((View)this.mContextHeader);
        }
        historyItem.copyTo(this.mContextHeader);
        menu2.setHeaderView((View)this.mContextHeader);
        if (this.mDisableNewWindow) {
            menu2.findItem(2131492960).setVisible(false);
        }
        if (historyItem.isBookmark()) {
            MenuItem item = menu2.findItem(2131493025);
            item.setTitle(2131230774);
        }
        PackageManager pm = this.getPackageManager();
        Intent send = new Intent("android.intent.action.SEND");
        send.setType("text/plain");
        ResolveInfo ri = pm.resolveActivity(send, 65536);
        menu2.findItem(2131492963).setVisible(ri != null);
        super.onCreateContextMenu(menu2, v, menuInfo);
    }

    public boolean onContextItemSelected(MenuItem item) {
        ExpandableListView.ExpandableListContextMenuInfo i = (ExpandableListView.ExpandableListContextMenuInfo)item.getMenuInfo();
        HistoryItem historyItem = (HistoryItem)i.targetView;
        String url = historyItem.getUrl();
        String title = historyItem.getName();
        switch (item.getItemId()) {
            case 2131492959: {
                this.loadUrl(url, false);
                return true;
            }
            case 2131492960: {
                this.loadUrl(url, true);
                return true;
            }
            case 2131493025: {
                if (historyItem.isBookmark()) {
                    Bookmarks.removeFromBookmarks((Context)this, this.getContentResolver(), url, title);
                } else {
                    Browser.saveBookmark((Context)this, (String)title, (String)url);
                }
                return true;
            }
            case 2131492963: {
                Browser.sendString((Context)this, (String)url, (String)((Object)this.getText(2131230816)).toString());
                return true;
            }
            case 2131492964: {
                this.copy(url);
                return true;
            }
            case 2131492965: {
                Browser.deleteFromHistory((ContentResolver)this.getContentResolver(), (String)url);
                this.mAdapter.refreshData();
                return true;
            }
            case 2131492966: {
                BrowserSettings.getInstance().setHomePage((Context)this, url);
                Toast.makeText((Context)this, (int)2131230779, (int)1).show();
                return true;
            }
        }
        return super.onContextItemSelected(item);
    }

    public boolean onChildClick(ExpandableListView parent, View v, int groupPosition, int childPosition, long id2) {
        if (v instanceof HistoryItem) {
            this.loadUrl(((HistoryItem)v).getUrl(), false);
            return true;
        }
        return false;
    }

    private void setResultToParent(int resultCode, Intent data) {
        ((CombinedBookmarkHistoryActivity)this.getParent()).setResultFromChild(resultCode, data);
    }

    private class HistoryAdapter
    extends DateSortedExpandableListAdapter {
        HistoryAdapter(Context context, Cursor cursor, int index) {
            super(context, cursor, index);
        }

        public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
            HistoryItem item;
            if (null == convertView || !(convertView instanceof HistoryItem)) {
                item = new HistoryItem((Context)BrowserHistoryPage.this);
                item.setPadding(item.getPaddingLeft() + 10, item.getPaddingTop(), item.getPaddingRight(), item.getPaddingBottom());
            } else {
                item = (HistoryItem)convertView;
            }
            if (!this.moveCursorToChildPosition(groupPosition, childPosition)) {
                return item;
            }
            item.setName(this.getString(5));
            String url = this.getString(1);
            item.setUrl(url);
            byte[] data = this.getBlob(6);
            if (data != null) {
                item.setFavicon(BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length));
            } else {
                item.setFavicon(CombinedBookmarkHistoryActivity.getIconListenerSet().getFavicon(url));
            }
            item.setIsBookmark(1 == this.getInt(4));
            return item;
        }
    }

    private class IconReceiver
    implements WebIconDatabase.IconListener {
        private IconReceiver() {
        }

        public void onReceivedIcon(String url, Bitmap icon) {
            BrowserHistoryPage.this.setListAdapter(BrowserHistoryPage.this.mAdapter);
        }
    }
}

