/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Browser;
import android.text.IClipboard;
import android.util.Log;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebIconDatabase;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import com.android.browser.AddBookmarkPage;
import com.android.browser.AddNewBookmark;
import com.android.browser.BookmarkItem;
import com.android.browser.BookmarkViewMode;
import com.android.browser.Bookmarks;
import com.android.browser.BrowserActivity;
import com.android.browser.BrowserBookmarksAdapter;
import com.android.browser.BrowserSettings;
import com.android.browser.CombinedBookmarkHistoryActivity;
import com.android.browser.HistoryItem;

public class BrowserBookmarksPage
extends Activity
implements View.OnCreateContextMenuListener {
    private BookmarkViewMode mViewMode = BookmarkViewMode.NONE;
    private GridView mGridPage;
    private ListView mVerticalList;
    private BrowserBookmarksAdapter mBookmarksAdapter;
    private static final int BOOKMARKS_SAVE = 1;
    private boolean mDisableNewWindow;
    private BookmarkItem mContextHeader;
    private AddNewBookmark mAddHeader;
    private boolean mCanceled = false;
    private boolean mCreateShortcut;
    private boolean mMostVisited;
    private View mEmptyView;
    private int mIconSize;
    private static final String INSTALL_SHORTCUT = "com.android.launcher.action.INSTALL_SHORTCUT";
    private static final String LOGTAG = "browser";
    private static final String PREF_BOOKMARK_VIEW_MODE = "pref_bookmark_view_mode";
    private static final String PREF_MOST_VISITED_VIEW_MODE = "pref_most_visited_view_mode";
    private static final ViewGroup.LayoutParams FULL_SCREEN_PARAMS = new ViewGroup.LayoutParams(-1, -1);
    private static final int SAVE_CURRENT_PAGE = 1000;
    private static final int ADAPTER_CREATED = 1001;
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1000: {
                    BrowserBookmarksPage.this.saveCurrentPage();
                    break;
                }
                case 1001: {
                    BrowserBookmarksPage.this.mBookmarksAdapter = (BrowserBookmarksAdapter)((Object)msg.obj);
                    BrowserBookmarksPage.this.mBookmarksAdapter.switchViewMode(BrowserBookmarksPage.this.mViewMode);
                    if (BrowserBookmarksPage.this.mGridPage != null) {
                        BrowserBookmarksPage.this.mGridPage.setAdapter((ListAdapter)BrowserBookmarksPage.this.mBookmarksAdapter);
                    }
                    if (BrowserBookmarksPage.this.mVerticalList != null) {
                        BrowserBookmarksPage.this.mVerticalList.setAdapter((ListAdapter)BrowserBookmarksPage.this.mBookmarksAdapter);
                    }
                    if (!BrowserBookmarksPage.this.mMostVisited) break;
                    WebIconDatabase.IconListener listener = new WebIconDatabase.IconListener(){

                        public void onReceivedIcon(String url, Bitmap icon) {
                            if (BrowserBookmarksPage.this.mGridPage != null) {
                                BrowserBookmarksPage.this.mGridPage.setAdapter((ListAdapter)BrowserBookmarksPage.this.mBookmarksAdapter);
                            }
                            if (BrowserBookmarksPage.this.mVerticalList != null) {
                                BrowserBookmarksPage.this.mVerticalList.setAdapter((ListAdapter)BrowserBookmarksPage.this.mBookmarksAdapter);
                            }
                        }
                    };
                    CombinedBookmarkHistoryActivity.getIconListenerSet().addListener(listener);
                }
            }
        }
    };
    private AdapterView.OnItemClickListener mListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView parent, View v, int position, long id2) {
            if (BrowserBookmarksPage.this.mCanceled) {
                Log.e((String)BrowserBookmarksPage.LOGTAG, (String)"item clicked when dismissing");
                return;
            }
            if (!BrowserBookmarksPage.this.mCreateShortcut) {
                if (0 == position && !BrowserBookmarksPage.this.mMostVisited) {
                    BrowserBookmarksPage.this.mHandler.sendEmptyMessage(1000);
                } else {
                    BrowserBookmarksPage.this.loadUrl(position);
                }
            } else {
                Intent intent = BrowserBookmarksPage.this.createShortcutIntent(position);
                BrowserBookmarksPage.this.setResultToParent(-1, intent);
                BrowserBookmarksPage.this.finish();
            }
        }
    };

    public boolean onContextItemSelected(MenuItem item) {
        if (this.mCanceled) {
            return true;
        }
        AdapterView.AdapterContextMenuInfo i = (AdapterView.AdapterContextMenuInfo)item.getMenuInfo();
        if (i == null) {
            return true;
        }
        switch (item.getItemId()) {
            case 2131492955: {
                this.saveCurrentPage();
                break;
            }
            case 2131492959: {
                this.loadUrl(i.position);
                break;
            }
            case 2131492961: {
                this.editBookmark(i.position);
                break;
            }
            case 2131492962: {
                Intent send = this.createShortcutIntent(i.position);
                send.setAction(INSTALL_SHORTCUT);
                this.sendBroadcast(send);
                break;
            }
            case 2131492965: {
                if (this.mMostVisited) {
                    Browser.deleteFromHistory((ContentResolver)this.getContentResolver(), (String)this.getUrl(i.position));
                    this.refreshList();
                    break;
                }
                this.displayRemoveBookmarkDialog(i.position);
                break;
            }
            case 2131492960: {
                this.openInNewWindow(i.position);
                break;
            }
            case 2131492963: {
                BrowserActivity.sharePage((Context)this, this.mBookmarksAdapter.getTitle(i.position), this.getUrl(i.position), this.getFavicon(i.position), this.mBookmarksAdapter.getScreenshot(i.position));
                break;
            }
            case 2131492964: {
                this.copy(this.getUrl(i.position));
                break;
            }
            case 2131492966: {
                BrowserSettings.getInstance().setHomePage((Context)this, this.getUrl(i.position));
                Toast.makeText((Context)this, (int)2131230779, (int)1).show();
                break;
            }
            case 2131493025: {
                String url;
                String name;
                boolean isBookmark;
                if (this.mViewMode == BookmarkViewMode.GRID) {
                    isBookmark = this.mBookmarksAdapter.getIsBookmark(i.position);
                    name = this.mBookmarksAdapter.getTitle(i.position);
                    url = this.mBookmarksAdapter.getUrl(i.position);
                } else {
                    HistoryItem historyItem = (HistoryItem)i.targetView;
                    isBookmark = historyItem.isBookmark();
                    name = historyItem.getName();
                    url = historyItem.getUrl();
                }
                if (isBookmark) {
                    Bookmarks.removeFromBookmarks((Context)this, this.getContentResolver(), url, name);
                    break;
                }
                Browser.saveBookmark((Context)this, (String)name, (String)url);
                break;
            }
            default: {
                return super.onContextItemSelected(item);
            }
        }
        return true;
    }

    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        AdapterView.AdapterContextMenuInfo i = (AdapterView.AdapterContextMenuInfo)menuInfo;
        MenuInflater inflater = this.getMenuInflater();
        if (this.mMostVisited) {
            inflater.inflate(2131427337, (Menu)menu2);
        } else {
            inflater.inflate(2131427329, (Menu)menu2);
        }
        if (0 == i.position && !this.mMostVisited) {
            menu2.setGroupVisible(2131492958, false);
            if (this.mAddHeader == null) {
                this.mAddHeader = new AddNewBookmark((Context)this);
            } else if (this.mAddHeader.getParent() != null) {
                ((ViewGroup)this.mAddHeader.getParent()).removeView((View)this.mAddHeader);
            }
            this.mAddHeader.setUrl(this.getIntent().getStringExtra("url"));
            menu2.setHeaderView((View)this.mAddHeader);
            return;
        }
        if (this.mMostVisited) {
            if (this.mViewMode == BookmarkViewMode.LIST && ((HistoryItem)i.targetView).isBookmark() || this.mBookmarksAdapter.getIsBookmark(i.position)) {
                MenuItem item = menu2.findItem(2131493025);
                item.setTitle(2131230774);
            }
        } else {
            menu2.setGroupVisible(2131492957, false);
        }
        if (this.mDisableNewWindow) {
            menu2.findItem(2131492960).setVisible(false);
        }
        if (this.mContextHeader == null) {
            this.mContextHeader = new BookmarkItem((Context)this);
        } else if (this.mContextHeader.getParent() != null) {
            ((ViewGroup)this.mContextHeader.getParent()).removeView((View)this.mContextHeader);
        }
        if (this.mViewMode == BookmarkViewMode.GRID) {
            this.mBookmarksAdapter.populateBookmarkItem(this.mContextHeader, i.position);
        } else {
            BookmarkItem b = (BookmarkItem)i.targetView;
            b.copyTo(this.mContextHeader);
        }
        menu2.setHeaderView((View)this.mContextHeader);
    }

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.mIconSize = this.getResources().getDimensionPixelSize(0x1050000);
        Intent intent = this.getIntent();
        if ("android.intent.action.CREATE_SHORTCUT".equals(intent.getAction())) {
            this.mCreateShortcut = true;
        }
        this.mDisableNewWindow = intent.getBooleanExtra("disable_new_window", false);
        this.mMostVisited = intent.getBooleanExtra("mostVisited", false);
        if (this.mCreateShortcut) {
            this.setTitle(2131230819);
        }
        this.setContentView(2130903049);
        this.mEmptyView = this.findViewById(2131492898);
        this.mEmptyView.setVisibility(8);
        SharedPreferences p = this.getPreferences(0);
        BookmarkViewMode preference = BookmarkViewMode.NONE;
        preference = this.mMostVisited ? BookmarkViewMode.LIST : BookmarkViewMode.values()[p.getInt(PREF_BOOKMARK_VIEW_MODE, BookmarkViewMode.GRID.ordinal())];
        this.switchViewMode(preference);
        final boolean createShortcut = this.mCreateShortcut;
        final boolean mostVisited = this.mMostVisited;
        final String url = intent.getStringExtra("url");
        final String title = intent.getStringExtra("title");
        final Bitmap thumbnail = (Bitmap)intent.getParcelableExtra("thumbnail");
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... unused) {
                BrowserBookmarksAdapter adapter = new BrowserBookmarksAdapter(BrowserBookmarksPage.this, url, title, thumbnail, createShortcut, mostVisited);
                BrowserBookmarksPage.this.mHandler.obtainMessage(1001, (Object)adapter).sendToTarget();
                return null;
            }
        }.execute((Object[])new Void[0]);
    }

    protected void onDestroy() {
        this.mHandler.removeCallbacksAndMessages(null);
        super.onDestroy();
    }

    private void switchViewMode(BookmarkViewMode viewMode) {
        if (this.mViewMode == viewMode) {
            return;
        }
        this.mViewMode = viewMode;
        SharedPreferences.Editor ed = this.getPreferences(0).edit();
        if (this.mMostVisited) {
            ed.putInt(PREF_MOST_VISITED_VIEW_MODE, this.mViewMode.ordinal());
        } else {
            ed.putInt(PREF_BOOKMARK_VIEW_MODE, this.mViewMode.ordinal());
        }
        ed.apply();
        if (this.mBookmarksAdapter != null) {
            this.mBookmarksAdapter.switchViewMode(viewMode);
        }
        if (this.mViewMode == BookmarkViewMode.GRID) {
            ViewGroup parent;
            if (this.mGridPage == null) {
                this.mGridPage = new GridView((Context)this);
                if (this.mBookmarksAdapter != null) {
                    this.mGridPage.setAdapter((ListAdapter)this.mBookmarksAdapter);
                }
                this.mGridPage.setOnItemClickListener(this.mListener);
                this.mGridPage.setNumColumns(-1);
                this.mGridPage.setColumnWidth(BrowserActivity.getDesiredThumbnailWidth((Context)this));
                this.mGridPage.setFocusable(true);
                this.mGridPage.setFocusableInTouchMode(true);
                this.mGridPage.setSelector(17301532);
                float density = this.getResources().getDisplayMetrics().density;
                this.mGridPage.setVerticalSpacing((int)(14.0f * density));
                this.mGridPage.setHorizontalSpacing((int)(8.0f * density));
                this.mGridPage.setStretchMode(1);
                this.mGridPage.setScrollBarStyle(0x1000000);
                this.mGridPage.setDrawSelectorOnTop(true);
                if (this.mMostVisited) {
                    this.mGridPage.setEmptyView(this.mEmptyView);
                }
                if (!this.mCreateShortcut) {
                    this.mGridPage.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
                }
            }
            this.addContentView((View)this.mGridPage, FULL_SCREEN_PARAMS);
            if (this.mVerticalList != null && (parent = (ViewGroup)this.mVerticalList.getParent()) != null) {
                parent.removeView((View)this.mVerticalList);
            }
        } else {
            ViewGroup parent;
            if (null == this.mVerticalList) {
                ListView listView = new ListView((Context)this);
                if (this.mBookmarksAdapter != null) {
                    listView.setAdapter((ListAdapter)this.mBookmarksAdapter);
                }
                listView.setDrawSelectorOnTop(false);
                listView.setVerticalScrollBarEnabled(true);
                listView.setOnItemClickListener(this.mListener);
                if (this.mMostVisited) {
                    listView.setEmptyView(this.mEmptyView);
                }
                if (!this.mCreateShortcut) {
                    listView.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
                }
                this.mVerticalList = listView;
            }
            this.addContentView((View)this.mVerticalList, FULL_SCREEN_PARAMS);
            if (this.mGridPage != null && (parent = (ViewGroup)this.mGridPage.getParent()) != null) {
                parent.removeView((View)this.mGridPage);
            }
        }
    }

    private Intent createShortcutIntent(int position) {
        String url = this.getUrl(position);
        String title = this.getBookmarkTitle(position);
        Bitmap touchIcon = this.getTouchIcon(position);
        Intent i = new Intent();
        Intent shortcutIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        long urlHash = url.hashCode();
        long uniqueId = urlHash << 32 | (long)shortcutIntent.hashCode();
        shortcutIntent.putExtra("com.android.browser.application_id", Long.toString(uniqueId));
        i.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)shortcutIntent);
        i.putExtra("android.intent.extra.shortcut.NAME", title);
        if (touchIcon != null) {
            Bitmap bm = Bitmap.createBitmap((int)this.mIconSize, (int)this.mIconSize, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bm);
            Rect src = new Rect(0, 0, touchIcon.getWidth(), touchIcon.getHeight());
            Rect dest = new Rect(0, 0, bm.getWidth(), bm.getHeight());
            Paint paint = new Paint(1);
            paint.setFilterBitmap(true);
            canvas.drawBitmap(touchIcon, src, dest, paint);
            Path path = new Path();
            path.setFillType(Path.FillType.INVERSE_WINDING);
            RectF rect = new RectF(0.0f, 0.0f, (float)bm.getWidth(), (float)bm.getHeight());
            rect.inset(1.0f, 1.0f);
            path.addRoundRect(rect, 8.0f, 8.0f, Path.Direction.CW);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
            canvas.drawPath(path, paint);
            i.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)bm);
        } else {
            Bitmap favicon = this.getFavicon(position);
            if (favicon == null) {
                i.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)this, (int)2130837533));
            } else {
                Bitmap icon = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837534);
                Bitmap copy = icon.copy(Bitmap.Config.ARGB_8888, true);
                Canvas canvas = new Canvas(copy);
                Paint p = new Paint(3);
                p.setStyle(Paint.Style.FILL_AND_STROKE);
                p.setColor(-1);
                float density = this.getResources().getDisplayMetrics().density;
                float iconSize = 16.0f * density;
                float padding = 2.0f * density;
                float rectSize = iconSize + 2.0f * padding;
                Rect iconBounds = new Rect(0, 0, icon.getWidth(), icon.getHeight());
                float x = iconBounds.exactCenterX() - rectSize / 2.0f;
                float y = iconBounds.exactCenterY() - rectSize / 2.0f - padding;
                RectF r = new RectF(x, y, x + rectSize, y + rectSize);
                canvas.drawRoundRect(r, 2.0f, 2.0f, p);
                r.inset(padding, padding);
                canvas.drawBitmap(favicon, null, r, p);
                i.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)copy);
            }
        }
        i.putExtra("duplicate", false);
        return i;
    }

    private void saveCurrentPage() {
        Intent i = new Intent((Context)this, AddBookmarkPage.class);
        i.putExtras(this.getIntent());
        this.startActivityForResult(i, 1);
    }

    private void loadUrl(int position) {
        Intent intent = new Intent().setAction(this.getUrl(position));
        this.setResultToParent(-1, intent);
        this.finish();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        boolean result = super.onCreateOptionsMenu(menu2);
        if (!this.mCreateShortcut && !this.mMostVisited) {
            MenuInflater inflater = this.getMenuInflater();
            inflater.inflate(2131427328, menu2);
            return true;
        }
        return result;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        int iconResId;
        int titleResId;
        boolean result = super.onPrepareOptionsMenu(menu2);
        if (this.mCreateShortcut || this.mMostVisited || this.mBookmarksAdapter == null || this.mBookmarksAdapter.getCount() == 0) {
            return result;
        }
        MenuItem switchItem = menu2.findItem(2131492956);
        if (this.mViewMode == BookmarkViewMode.GRID) {
            titleResId = 2131230787;
            iconResId = 2130837544;
        } else {
            titleResId = 2131230786;
            iconResId = 2130837546;
        }
        switchItem.setTitle(titleResId);
        switchItem.setIcon(iconResId);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131492955: {
                this.saveCurrentPage();
                break;
            }
            case 2131492956: {
                if (this.mViewMode == BookmarkViewMode.GRID) {
                    this.switchViewMode(BookmarkViewMode.LIST);
                    break;
                }
                this.switchViewMode(BookmarkViewMode.GRID);
                break;
            }
            default: {
                return super.onOptionsItemSelected(item);
            }
        }
        return true;
    }

    private void openInNewWindow(int position) {
        Bundle b = new Bundle();
        b.putBoolean("new_window", true);
        this.setResultToParent(-1, new Intent().setAction(this.getUrl(position)).putExtras(b));
        this.finish();
    }

    private void editBookmark(int position) {
        Intent intent = new Intent((Context)this, AddBookmarkPage.class);
        intent.putExtra("bookmark", this.getRow(position));
        this.startActivityForResult(intent, 1);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                Bundle extras;
                if (resultCode != -1) break;
                if (data != null && (extras = data.getExtras()) != null) {
                    String title = extras.getString("title");
                    String url = extras.getString("url");
                    if (title == null || url == null) break;
                    this.mBookmarksAdapter.updateRow(extras);
                    break;
                }
                this.refreshList();
                break;
            }
        }
    }

    private void displayRemoveBookmarkDialog(int position) {
        final int deletePos = position;
        new AlertDialog.Builder((Context)this).setTitle(2131230784).setIcon(17301543).setMessage((CharSequence)((Object)this.getText(2131230789)).toString().replace("%s", this.getBookmarkTitle(deletePos))).setPositiveButton(2131230736, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                BrowserBookmarksPage.this.deleteBookmark(deletePos);
            }
        }).setNegativeButton(2131230735, null).show();
    }

    private void refreshList() {
        if (this.mBookmarksAdapter == null) {
            return;
        }
        this.mBookmarksAdapter.refreshList();
    }

    public Bundle getRow(int position) {
        return this.mBookmarksAdapter == null ? null : this.mBookmarksAdapter.getRow(position);
    }

    public String getUrl(int position) {
        return this.mBookmarksAdapter == null ? null : this.mBookmarksAdapter.getUrl(position);
    }

    public Bitmap getFavicon(int position) {
        return this.mBookmarksAdapter == null ? null : this.mBookmarksAdapter.getFavicon(position);
    }

    private Bitmap getTouchIcon(int position) {
        return this.mBookmarksAdapter == null ? null : this.mBookmarksAdapter.getTouchIcon(position);
    }

    private void copy(CharSequence text) {
        try {
            IClipboard clip = IClipboard.Stub.asInterface((IBinder)ServiceManager.getService((String)"clipboard"));
            if (clip != null) {
                clip.setClipboardText(text);
            }
        }
        catch (RemoteException e) {
            Log.e((String)LOGTAG, (String)"Copy failed", (Throwable)e);
        }
    }

    public String getBookmarkTitle(int position) {
        return this.mBookmarksAdapter == null ? null : this.mBookmarksAdapter.getTitle(position);
    }

    public void deleteBookmark(int position) {
        if (this.mBookmarksAdapter == null) {
            return;
        }
        this.mBookmarksAdapter.deleteRow(position);
    }

    public void onBackPressed() {
        this.setResultToParent(0, null);
        this.mCanceled = true;
        super.onBackPressed();
    }

    private void setResultToParent(int resultCode, Intent data) {
        Activity parent = this.getParent();
        if (parent == null) {
            this.setResult(resultCode, data);
        } else {
            ((CombinedBookmarkHistoryActivity)parent).setResultFromChild(resultCode, data);
        }
    }
}

