/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.app.backup.BackupAgent;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.database.Cursor;
import android.os.ParcelFileDescriptor;
import android.provider.Browser;
import android.util.Log;
import com.android.browser.Bookmarks;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.CRC32;

public class BrowserBackupAgent
extends BackupAgent {
    static final String TAG = "BrowserBackupAgent";
    static final boolean DEBUG = false;
    static final String BOOKMARK_KEY = "_bookmarks_";
    static final int BACKUP_AGENT_VERSION = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) throws IOException {
        long savedFileSize = -1L;
        long savedCrc = -1L;
        int savedVersion = -1;
        DataInputStream in = new DataInputStream(new FileInputStream(oldState.getFileDescriptor()));
        try {
            savedFileSize = in.readLong();
            savedCrc = in.readLong();
            savedVersion = in.readInt();
        }
        catch (EOFException e) {
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        File tmpfile = File.createTempFile("bkp", null, this.getCacheDir());
        try {
            FileOutputStream outfstream = new FileOutputStream(tmpfile);
            long newCrc = this.buildBookmarkFile(outfstream);
            outfstream.close();
            if (savedVersion != 0 || newCrc != savedCrc || tmpfile.length() != savedFileSize) {
                this.copyFileToBackup(BOOKMARK_KEY, tmpfile, data);
            }
            this.writeBackupState(tmpfile.length(), newCrc, newState);
        }
        finally {
            tmpfile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRestore(BackupDataInput data, int appVersionCode, ParcelFileDescriptor newState) throws IOException {
        long crc = -1L;
        File tmpfile = File.createTempFile("rst", null, this.getFilesDir());
        try {
            while (data.readNextHeader()) {
                if (BOOKMARK_KEY.equals(data.getKey())) {
                    crc = this.copyBackupToFile(data, tmpfile, data.getDataSize());
                    FileInputStream infstream = new FileInputStream(tmpfile);
                    DataInputStream in = new DataInputStream(infstream);
                    try {
                        int count = in.readInt();
                        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>(count);
                        for (int i = 0; i < count; ++i) {
                            Bookmark mark = new Bookmark();
                            mark.url = in.readUTF();
                            mark.visits = in.readInt();
                            mark.date = in.readLong();
                            mark.created = in.readLong();
                            mark.title = in.readUTF();
                            bookmarks.add(mark);
                        }
                        int N = bookmarks.size();
                        int nUnique = 0;
                        String[] urlCol = new String[]{"url"};
                        for (int i = 0; i < N; ++i) {
                            Bookmark mark = (Bookmark)bookmarks.get(i);
                            Cursor cursor = this.getContentResolver().query(Browser.BOOKMARKS_URI, urlCol, "url == '" + mark.url + "' AND " + "bookmark" + " == 1 ", null, null);
                            if (cursor.getCount() <= 0) {
                                Bookmarks.addBookmark(null, this.getContentResolver(), mark.url, mark.title, null, false);
                                ++nUnique;
                            }
                            cursor.close();
                        }
                        Log.i((String)TAG, (String)("Restored " + nUnique + " of " + N + " bookmarks"));
                    }
                    catch (IOException ioe) {
                        Log.w((String)TAG, (String)"Bad backup data; not restoring");
                        crc = -1L;
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                    }
                }
                this.writeBackupState(tmpfile.length(), crc, newState);
            }
        }
        finally {
            tmpfile.delete();
        }
    }

    private long buildBookmarkFile(FileOutputStream outfstream) throws IOException {
        CRC32 crc = new CRC32();
        ByteArrayOutputStream bufstream = new ByteArrayOutputStream(512);
        DataOutputStream bout = new DataOutputStream(bufstream);
        Cursor cursor = this.getContentResolver().query(Browser.BOOKMARKS_URI, new String[]{"url", "visits", "date", "created", "title"}, "bookmark == 1 ", null, null);
        int count = cursor.getCount();
        bout.writeInt(count);
        byte[] record = bufstream.toByteArray();
        crc.update(record);
        outfstream.write(record);
        for (int i = 0; i < count; ++i) {
            cursor.moveToNext();
            String url = cursor.getString(0);
            int visits = cursor.getInt(1);
            long date = cursor.getLong(2);
            long created = cursor.getLong(3);
            String title = cursor.getString(4);
            bufstream.reset();
            bout.writeUTF(url);
            bout.writeInt(visits);
            bout.writeLong(date);
            bout.writeLong(created);
            bout.writeUTF(title);
            record = bufstream.toByteArray();
            crc.update(record);
            outfstream.write(record);
        }
        cursor.close();
        return crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFileToBackup(String key, File file, BackupDataOutput data) throws IOException {
        int toCopy;
        int CHUNK = 8192;
        byte[] buf = new byte[8192];
        data.writeEntityHeader(key, toCopy);
        FileInputStream in = new FileInputStream(file);
        try {
            int nRead;
            for (toCopy = (int)file.length(); toCopy > 0; toCopy -= nRead) {
                nRead = in.read(buf, 0, 8192);
                data.writeEntityData(buf, nRead);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyBackupToFile(BackupDataInput data, File file, int toRead) throws IOException {
        int CHUNK = 8192;
        byte[] buf = new byte[8192];
        CRC32 crc = new CRC32();
        FileOutputStream out = new FileOutputStream(file);
        try {
            while (toRead > 0) {
                int numRead = data.readEntityData(buf, 0, 8192);
                crc.update(buf, 0, numRead);
                out.write(buf, 0, numRead);
                toRead -= numRead;
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return crc.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackupState(long fileSize, long crc, ParcelFileDescriptor stateFile) throws IOException {
        DataOutputStream out = new DataOutputStream(new FileOutputStream(stateFile.getFileDescriptor()));
        try {
            out.writeLong(fileSize);
            out.writeLong(crc);
            out.writeInt(0);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    static class Bookmark {
        public String url;
        public int visits;
        public long date;
        public long created;
        public String title;

        Bookmark() {
        }
    }
}

