/*
 * Decompiled with CFR 0.152.
 */
package com.android.browser;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.provider.Browser;
import android.util.Log;
import android.webkit.WebIconDatabase;
import android.widget.Toast;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;

class Bookmarks {
    private static final String[] acceptableBookmarkSchemes = new String[]{"http:", "https:", "about:", "data:", "javascript:", "file:", "content:"};
    private static final String LOGTAG = "Bookmarks";

    Bookmarks() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addBookmark(Context context, ContentResolver cr, String url, String name, Bitmap thumbnail, boolean retainIcon) {
        long creationTime = new Date().getTime();
        ContentValues map = new ContentValues();
        Cursor cursor = null;
        try {
            cursor = Browser.getVisitedLike((ContentResolver)cr, (String)url);
            if (cursor.moveToFirst() && cursor.getInt(4) == 0) {
                map.put("created", Long.valueOf(creationTime));
                map.put("title", name);
                map.put("bookmark", Integer.valueOf(1));
                map.put("thumbnail", Bookmarks.bitmapToBytes(thumbnail));
                cr.update(Browser.BOOKMARKS_URI, map, "_id = " + cursor.getInt(0), null);
            } else {
                int count = cursor.getCount();
                boolean matchedTitle = false;
                for (int i = 0; i < count; ++i) {
                    cursor.moveToPosition(i);
                    if (!cursor.getString(5).equals(name)) continue;
                    map.put("created", Long.valueOf(creationTime));
                    cr.update(Browser.BOOKMARKS_URI, map, "_id = " + cursor.getInt(0), null);
                    matchedTitle = true;
                    break;
                }
                if (!matchedTitle) {
                    map.put("title", name);
                    map.put("url", url);
                    map.put("created", Long.valueOf(creationTime));
                    map.put("bookmark", Integer.valueOf(1));
                    map.put("date", Integer.valueOf(0));
                    map.put("thumbnail", Bookmarks.bitmapToBytes(thumbnail));
                    int visits = 0;
                    if (count > 0) {
                        visits = cursor.getInt(2);
                    }
                    map.put("visits", Integer.valueOf(visits + 3));
                    cr.insert(Browser.BOOKMARKS_URI, map);
                }
            }
        }
        catch (IllegalStateException e) {
            Log.e((String)LOGTAG, (String)"addBookmark", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        if (retainIcon) {
            WebIconDatabase.getInstance().retainIconForPageUrl(url);
        }
        if (context != null) {
            Toast.makeText((Context)context, (int)2131230728, (int)1).show();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeFromBookmarks(Context context, ContentResolver cr, String url, String title) {
        Cursor cursor = null;
        try {
            cursor = cr.query(Browser.BOOKMARKS_URI, Browser.HISTORY_PROJECTION, "url = ? AND title = ?", new String[]{url, title}, null);
            boolean first = cursor.moveToFirst();
            if (!first) {
                throw new AssertionError((Object)("URL is not in the database! " + url + " " + title));
            }
            WebIconDatabase.getInstance().releaseIconForPageUrl(url);
            Uri uri = ContentUris.withAppendedId((Uri)Browser.BOOKMARKS_URI, (long)cursor.getInt(0));
            int numVisits = cursor.getInt(2);
            if (0 == numVisits) {
                cr.delete(uri, null, null);
            } else {
                ContentValues values = new ContentValues();
                values.put("bookmark", Integer.valueOf(0));
                try {
                    cr.update(uri, values, null, null);
                }
                catch (IllegalStateException e) {
                    Log.e((String)"removeFromBookmarks", (String)"no database!");
                }
            }
            if (context != null) {
                Toast.makeText((Context)context, (int)2131230729, (int)1).show();
            }
        }
        catch (IllegalStateException e) {
            Log.e((String)LOGTAG, (String)"removeFromBookmarks", (Throwable)e);
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    private static byte[] bitmapToBytes(Bitmap bm) {
        if (bm == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)os);
        return os.toByteArray();
    }

    static boolean urlHasAcceptableScheme(String url) {
        if (url == null) {
            return false;
        }
        for (int i = 0; i < acceptableBookmarkSchemes.length; ++i) {
            if (!url.startsWith(acceptableBookmarkSchemes[i])) continue;
            return true;
        }
        return false;
    }
}

